/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.dialect.AuroraMysqlDialect;
import software.amazon.jdbc.dialect.AuroraPgDialect;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.dialect.DialectProvider;
import software.amazon.jdbc.dialect.MariaDbDialect;
import software.amazon.jdbc.dialect.MysqlDialect;
import software.amazon.jdbc.dialect.PgDialect;
import software.amazon.jdbc.dialect.RdsMysqlDialect;
import software.amazon.jdbc.dialect.RdsPgDialect;
import software.amazon.jdbc.dialect.UnknownDialect;
import software.amazon.jdbc.util.CacheMap;
import software.amazon.jdbc.util.ConnectionUrlParser;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUrlType;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.Utils;

public class DialectManager
implements DialectProvider {
    private static final Logger LOGGER = Logger.getLogger(DialectManager.class.getName());
    protected static Dialect customDialect;
    public static final AwsWrapperProperty DIALECT;
    protected static final Map<String, Dialect> knownDialectsByCode;
    protected static final long ENDPOINT_CACHE_EXPIRATION;
    protected static final CacheMap<String, String> knownEndpointDialects;
    private final RdsUtils rdsHelper = new RdsUtils();
    private final ConnectionUrlParser connectionUrlParser = new ConnectionUrlParser();
    private boolean canUpdate = false;
    private Dialect dialect = null;
    private String dialectCode;

    public static void setCustomDialect(@NonNull Dialect dialect) {
        customDialect = dialect;
    }

    public static void resetCustomDialect() {
        customDialect = null;
    }

    public static void resetEndpointCache() {
        knownEndpointDialects.clear();
    }

    @Override
    public Dialect getDialect(@NonNull String driverProtocol, @NonNull String url, @NonNull Properties props) throws SQLException {
        String dialectCode;
        this.canUpdate = false;
        this.dialect = null;
        if (customDialect != null) {
            this.dialectCode = "custom";
            this.dialect = customDialect;
            this.logCurrentDialect();
            return this.dialect;
        }
        String userDialectSetting = DIALECT.getString(props);
        String string = dialectCode = !StringUtils.isNullOrEmpty(userDialectSetting) ? userDialectSetting : knownEndpointDialects.get(url);
        if (!StringUtils.isNullOrEmpty(dialectCode)) {
            Dialect userDialect = knownDialectsByCode.get(dialectCode);
            if (userDialect != null) {
                this.dialectCode = dialectCode;
                this.dialect = userDialect;
                this.logCurrentDialect();
                return userDialect;
            }
            throw new SQLException(Messages.get("DialectManager.unknownDialectCode", new Object[]{dialectCode}));
        }
        if (StringUtils.isNullOrEmpty(driverProtocol)) {
            throw new IllegalArgumentException("protocol");
        }
        String host = url;
        List<HostSpec> hosts = this.connectionUrlParser.getHostsFromConnectionUrl(url, true);
        if (!Utils.isNullOrEmpty(hosts)) {
            host = hosts.get(0).getHost();
        }
        if (driverProtocol.contains("mysql")) {
            RdsUrlType type = this.rdsHelper.identifyRdsType(host);
            if (type.isRdsCluster()) {
                this.dialectCode = "aurora-mysql";
                this.dialect = knownDialectsByCode.get("aurora-mysql");
                return this.dialect;
            }
            if (type.isRds()) {
                this.canUpdate = true;
                this.dialectCode = "rds-mysql";
                this.dialect = knownDialectsByCode.get("rds-mysql");
                this.logCurrentDialect();
                return this.dialect;
            }
            this.canUpdate = true;
            this.dialectCode = "mysql";
            this.dialect = knownDialectsByCode.get("mysql");
            this.logCurrentDialect();
            return this.dialect;
        }
        if (driverProtocol.contains("postgresql")) {
            RdsUrlType type = this.rdsHelper.identifyRdsType(host);
            if (type.isRdsCluster()) {
                this.dialectCode = "aurora-pg";
                this.dialect = knownDialectsByCode.get("aurora-pg");
                return this.dialect;
            }
            if (type.isRds()) {
                this.canUpdate = true;
                this.dialectCode = "rds-pg";
                this.dialect = knownDialectsByCode.get("rds-pg");
                this.logCurrentDialect();
                return this.dialect;
            }
            this.canUpdate = true;
            this.dialectCode = "pg";
            this.dialect = knownDialectsByCode.get("pg");
            this.logCurrentDialect();
            return this.dialect;
        }
        if (driverProtocol.contains("mariadb")) {
            this.canUpdate = true;
            this.dialectCode = "mariadb";
            this.dialect = knownDialectsByCode.get("mariadb");
            this.logCurrentDialect();
            return this.dialect;
        }
        this.canUpdate = true;
        this.dialectCode = "unknown";
        this.dialect = knownDialectsByCode.get("unknown");
        this.logCurrentDialect();
        return this.dialect;
    }

    @Override
    public Dialect getDialect(@NonNull String originalUrl, @NonNull HostSpec hostSpec, @NonNull Connection connection) throws SQLException {
        if (!this.canUpdate) {
            this.logCurrentDialect();
            return this.dialect;
        }
        List<String> dialectCandidates = this.dialect.getDialectUpdateCandidates();
        if (dialectCandidates != null) {
            for (String dialectCandidateCode : dialectCandidates) {
                Dialect dialectCandidate = knownDialectsByCode.get(dialectCandidateCode);
                if (dialectCandidate == null) {
                    throw new SQLException(Messages.get("DialectManager.unknownDialectCode", new Object[]{dialectCandidateCode}));
                }
                boolean isDialect = dialectCandidate.isDialect(connection);
                if (!isDialect) continue;
                this.canUpdate = false;
                this.dialectCode = dialectCandidateCode;
                this.dialect = dialectCandidate;
                knownEndpointDialects.put(originalUrl, dialectCandidateCode, ENDPOINT_CACHE_EXPIRATION);
                knownEndpointDialects.put(hostSpec.getUrl(), dialectCandidateCode, ENDPOINT_CACHE_EXPIRATION);
                this.logCurrentDialect();
                return this.dialect;
            }
        }
        if ("unknown".equals(this.dialectCode)) {
            throw new SQLException(Messages.get("DialectManager.unknownDialect"));
        }
        this.canUpdate = false;
        knownEndpointDialects.put(originalUrl, this.dialectCode, ENDPOINT_CACHE_EXPIRATION);
        knownEndpointDialects.put(hostSpec.getUrl(), this.dialectCode, ENDPOINT_CACHE_EXPIRATION);
        this.logCurrentDialect();
        return this.dialect;
    }

    private void logCurrentDialect() {
        LOGGER.finest(() -> String.format("Current dialect: %s, %s, canUpdate: %b", this.dialectCode, this.dialect == null ? "<null>" : this.dialect.getClass().getName(), this.canUpdate));
    }

    static {
        DIALECT = new AwsWrapperProperty("wrapperDialect", "", "A unique identifier for the supported database dialect.");
        knownDialectsByCode = new HashMap<String, Dialect>(){
            {
                this.put("mysql", new MysqlDialect());
                this.put("pg", new PgDialect());
                this.put("mariadb", new MariaDbDialect());
                this.put("rds-mysql", new RdsMysqlDialect());
                this.put("rds-pg", new RdsPgDialect());
                this.put("aurora-mysql", new AuroraMysqlDialect());
                this.put("aurora-pg", new AuroraPgDialect());
                this.put("unknown", new UnknownDialect());
            }
        };
        ENDPOINT_CACHE_EXPIRATION = TimeUnit.MINUTES.toNanos(30L);
        knownEndpointDialects = new CacheMap();
    }
}

