/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HikariPoolConfigurator;
import software.amazon.jdbc.HikariPoolMapping;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PooledConnectionProvider;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.cleanup.CanReleaseResources;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.util.HikariCPSQLException;
import software.amazon.jdbc.util.RdsUrlType;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.StringUtils;

public class HikariPooledConnectionProvider
implements PooledConnectionProvider,
CanReleaseResources {
    private static final Logger LOGGER = Logger.getLogger(HikariPooledConnectionProvider.class.getName());
    private static final RdsUtils rdsUtils = new RdsUtils();
    private static final Map<String, HikariDataSource> databasePools = new ConcurrentHashMap<String, HikariDataSource>();
    private final HikariPoolConfigurator poolConfigurator;
    private final HikariPoolMapping poolMapping;
    protected int retries = 10;

    public HikariPooledConnectionProvider(HikariPoolConfigurator hikariPoolConfigurator) {
        this(hikariPoolConfigurator, (hostSpec, properties) -> hostSpec.getUrl());
    }

    public HikariPooledConnectionProvider(HikariPoolConfigurator hikariPoolConfigurator, HikariPoolMapping mapping) {
        this.poolConfigurator = hikariPoolConfigurator;
        this.poolMapping = mapping;
    }

    @Override
    public boolean acceptsUrl(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) {
        RdsUrlType urlType = rdsUtils.identifyRdsType(hostSpec.getHost());
        return RdsUrlType.RDS_INSTANCE.equals((Object)urlType);
    }

    @Override
    public boolean acceptsStrategy(@NonNull HostRole role, @NonNull String strategy) {
        return false;
    }

    @Override
    public HostSpec getHostSpecByStrategy(@NonNull List<HostSpec> hosts, @NonNull HostRole role, @NonNull String strategy) {
        return null;
    }

    @Override
    public Connection connect(@NonNull String protocol, @NonNull Dialect dialect, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        HikariDataSource ds = databasePools.computeIfAbsent(this.getPoolKey(hostSpec, props), url -> this.createHikariDataSource(protocol, hostSpec, props));
        ds.setPassword(props.getProperty(PropertyDefinition.PASSWORD.name));
        Connection conn = ds.getConnection();
        int count = 0;
        while (conn != null && count++ < this.retries && !conn.isValid(3)) {
            ds.evictConnection(conn);
            conn = ds.getConnection();
        }
        return conn;
    }

    @Override
    public Connection connect(@NonNull String url, @NonNull Properties props) throws SQLException {
        return null;
    }

    private String getPoolKey(HostSpec hostSpec, Properties props) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.poolMapping.getKey(hostSpec, props)).append(props.getProperty(PropertyDefinition.USER.name));
        return sb.toString();
    }

    @Override
    public void releaseResources() {
        databasePools.forEach((url, ds) -> ds.close());
        databasePools.clear();
    }

    protected void configurePool(HikariConfig config, String protocol, HostSpec hostSpec, Properties connectionProps) {
        StringBuilder urlBuilder = new StringBuilder().append(protocol).append(hostSpec.getUrl());
        String db = PropertyDefinition.DATABASE.getString(connectionProps);
        if (!StringUtils.isNullOrEmpty(db)) {
            urlBuilder.append(db);
        }
        StringJoiner propsJoiner = new StringJoiner("&");
        connectionProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            if (!PropertyDefinition.PASSWORD.name.equals(k) && !PropertyDefinition.USER.name.equals(k)) {
                propsJoiner.add(k + "=" + v);
            }
        }));
        urlBuilder.append("?").append(propsJoiner);
        config.setJdbcUrl(urlBuilder.toString());
        config.setExceptionOverrideClassName(HikariCPSQLException.class.getName());
        String user = connectionProps.getProperty(PropertyDefinition.USER.name);
        String password = connectionProps.getProperty(PropertyDefinition.PASSWORD.name);
        if (user != null) {
            config.setUsername(user);
        }
        if (password != null) {
            config.setPassword(password);
        }
    }

    public int getHostCount() {
        return databasePools.size();
    }

    public Set<String> getHosts() {
        return Collections.unmodifiableSet(databasePools.keySet());
    }

    public void logConnections() {
        LOGGER.finest(() -> {
            StringBuilder builder = new StringBuilder();
            databasePools.forEach((key, dataSource) -> {
                builder.append("\t[ ");
                builder.append((String)key).append(":");
                builder.append("\n\t {");
                builder.append("\n\t\t").append(dataSource);
                builder.append("\n\t }\n");
                builder.append("\t");
            });
            return String.format("Hikari Pooled Connection: \n[\n%s\n]", builder);
        });
    }

    HikariDataSource createHikariDataSource(String protocol, HostSpec hostSpec, Properties props) {
        HikariConfig config = this.poolConfigurator.configurePool(hostSpec, props);
        this.configurePool(config, protocol, hostSpec, props);
        return new HikariDataSource(config);
    }
}

