/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.cleanup.CanReleaseResources;

public class ConnectionProviderManager {
    private static final ReentrantReadWriteLock connProviderLock = new ReentrantReadWriteLock();
    private static ConnectionProvider connProvider = null;
    private final ConnectionProvider defaultProvider;

    public ConnectionProviderManager(ConnectionProvider defaultProvider) {
        this.defaultProvider = defaultProvider;
    }

    public static void setConnectionProvider(ConnectionProvider connProvider) {
        connProviderLock.writeLock().lock();
        try {
            ConnectionProviderManager.connProvider = connProvider;
        }
        finally {
            connProviderLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionProvider getConnectionProvider(String driverProtocol, HostSpec host, Properties props) {
        if (connProvider != null) {
            connProviderLock.readLock().lock();
            try {
                if (connProvider != null && connProvider.acceptsUrl(driverProtocol, host, props)) {
                    ConnectionProvider connectionProvider = connProvider;
                    return connectionProvider;
                }
            }
            finally {
                connProviderLock.readLock().unlock();
            }
        }
        return this.defaultProvider;
    }

    public ConnectionProvider getDefaultProvider() {
        return this.defaultProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acceptsStrategy(HostRole role, String strategy) {
        boolean acceptsStrategy = false;
        if (connProvider != null) {
            connProviderLock.readLock().lock();
            try {
                if (connProvider != null) {
                    acceptsStrategy = connProvider.acceptsStrategy(role, strategy);
                }
            }
            finally {
                connProviderLock.readLock().unlock();
            }
        }
        if (!acceptsStrategy) {
            acceptsStrategy = this.defaultProvider.acceptsStrategy(role, strategy);
        }
        return acceptsStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostSpec getHostSpecByStrategy(List<HostSpec> hosts, HostRole role, String strategy) throws SQLException, UnsupportedOperationException {
        HostSpec host = null;
        if (connProvider != null) {
            connProviderLock.readLock().lock();
            try {
                if (connProvider != null && connProvider.acceptsStrategy(role, strategy)) {
                    host = connProvider.getHostSpecByStrategy(hosts, role, strategy);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            finally {
                connProviderLock.readLock().unlock();
            }
        }
        if (host == null) {
            host = this.defaultProvider.getHostSpecByStrategy(hosts, role, strategy);
        }
        return host;
    }

    public static void resetProvider() {
        if (connProvider != null) {
            connProviderLock.writeLock().lock();
            connProvider = null;
            connProviderLock.writeLock().unlock();
        }
    }

    public static void releaseResources() {
        if (connProvider != null) {
            connProviderLock.writeLock().lock();
            try {
                if (connProvider instanceof CanReleaseResources) {
                    ((CanReleaseResources)((Object)connProvider)).releaseResources();
                }
            }
            finally {
                connProviderLock.writeLock().unlock();
            }
        }
    }
}

