/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import software.amazon.jdbc.plugin.efm.ExecutorServiceInitializer;
import software.amazon.jdbc.plugin.efm.Monitor;
import software.amazon.jdbc.util.Messages;

public class MonitorThreadContainer {
    private static MonitorThreadContainer singleton = null;
    private static final AtomicInteger CLASS_USAGE_COUNT = new AtomicInteger();
    private final Map<String, Monitor> monitorMap = new ConcurrentHashMap<String, Monitor>();
    private final Map<Monitor, Future<?>> tasksMap = new ConcurrentHashMap();
    private final Queue<Monitor> availableMonitors = new ConcurrentLinkedDeque<Monitor>();
    private final ExecutorService threadPool;
    private static final ReentrantLock LOCK_OBJECT = new ReentrantLock();

    public static MonitorThreadContainer getInstance() {
        return MonitorThreadContainer.getInstance(Executors::newCachedThreadPool);
    }

    static MonitorThreadContainer getInstance(ExecutorServiceInitializer executorServiceInitializer) {
        if (singleton == null) {
            LOCK_OBJECT.lock();
            try {
                if (singleton == null) {
                    singleton = new MonitorThreadContainer(executorServiceInitializer);
                    CLASS_USAGE_COUNT.set(0);
                }
            }
            finally {
                LOCK_OBJECT.unlock();
            }
        }
        CLASS_USAGE_COUNT.getAndIncrement();
        return singleton;
    }

    public static void releaseInstance() {
        if (singleton == null) {
            return;
        }
        if (CLASS_USAGE_COUNT.decrementAndGet() <= 0) {
            LOCK_OBJECT.lock();
            try {
                if (singleton != null) {
                    singleton.releaseResources();
                    singleton = null;
                    CLASS_USAGE_COUNT.set(0);
                }
            }
            finally {
                LOCK_OBJECT.unlock();
            }
        }
    }

    private MonitorThreadContainer(ExecutorServiceInitializer executorServiceInitializer) {
        this.threadPool = executorServiceInitializer.createExecutorService();
    }

    public Map<String, Monitor> getMonitorMap() {
        return this.monitorMap;
    }

    public Map<Monitor, Future<?>> getTasksMap() {
        return this.tasksMap;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    Monitor getMonitor(String node) {
        return this.monitorMap.get(node);
    }

    Monitor getOrCreateMonitor(Set<String> nodeKeys, Supplier<Monitor> monitorSupplier) {
        if (nodeKeys.isEmpty()) {
            throw new IllegalArgumentException(Messages.get("MonitorThreadContainer.emptyNodeKeys"));
        }
        Monitor monitor = null;
        String anyNodeKey = null;
        for (String nodeKey : nodeKeys) {
            monitor = this.monitorMap.get(nodeKey);
            anyNodeKey = nodeKey;
            if (monitor == null) continue;
            break;
        }
        if (monitor == null) {
            monitor = this.monitorMap.computeIfAbsent(anyNodeKey, k -> {
                if (!this.availableMonitors.isEmpty()) {
                    Monitor availableMonitor = this.availableMonitors.remove();
                    if (!availableMonitor.isStopped()) {
                        return availableMonitor;
                    }
                    this.tasksMap.computeIfPresent(availableMonitor, (key, v) -> {
                        v.cancel(true);
                        return null;
                    });
                }
                Monitor newMonitor = (Monitor)monitorSupplier.get();
                this.addTask(newMonitor);
                return newMonitor;
            });
        }
        this.populateMonitorMap(nodeKeys, monitor);
        return monitor;
    }

    private void populateMonitorMap(Set<String> nodeKeys, Monitor monitor) {
        for (String nodeKey : nodeKeys) {
            this.monitorMap.putIfAbsent(nodeKey, monitor);
        }
    }

    void addTask(Monitor monitor) {
        this.tasksMap.computeIfAbsent(monitor, k -> this.threadPool.submit(monitor));
    }

    public void resetResource(Monitor monitor) {
        if (monitor == null) {
            return;
        }
        this.monitorMap.entrySet().removeIf(e -> e.getValue() == monitor);
        this.availableMonitors.add(monitor);
    }

    public void releaseResource(Monitor monitor) {
        if (monitor == null) {
            return;
        }
        List<Monitor> monitorList = Collections.singletonList(monitor);
        this.monitorMap.values().removeAll(monitorList);
        this.tasksMap.computeIfPresent(monitor, (k, v) -> {
            v.cancel(true);
            return null;
        });
    }

    private void releaseResources() {
        this.monitorMap.clear();
        this.tasksMap.values().stream().filter(val -> !val.isDone() && !val.isCancelled()).forEach(val -> val.cancel(true));
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
    }
}

