/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.hostlistprovider.AuroraHostListProvider;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.plugin.OpenedConnectionTracker;
import software.amazon.jdbc.plugin.failover.FailoverSQLException;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.SubscribedMethodHelper;

public class AuroraConnectionTrackerPlugin
extends AbstractConnectionPlugin {
    static final String METHOD_ABORT = "Connection.abort";
    static final String METHOD_CLOSE = "Connection.close";
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.addAll(SubscribedMethodHelper.NETWORK_BOUND_METHODS);
            this.add("connect");
            this.add("forceConnect");
            this.add("notifyNodeListChanged");
        }
    });
    private final PluginService pluginService;
    private final Properties props;
    private final RdsUtils rdsHelper;
    private String clusterInstanceTemplate;
    private final OpenedConnectionTracker tracker;

    AuroraConnectionTrackerPlugin(PluginService pluginService, Properties props) {
        this(pluginService, props, new RdsUtils(), new OpenedConnectionTracker());
    }

    AuroraConnectionTrackerPlugin(PluginService pluginService, Properties props, RdsUtils rdsUtils, OpenedConnectionTracker tracker) {
        this.pluginService = pluginService;
        this.props = props;
        this.rdsHelper = rdsUtils;
        this.tracker = tracker;
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        return this.connectInternal(hostSpec, connectFunc);
    }

    public Connection connectInternal(HostSpec hostSpec, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        HostSpec currentHostSpec;
        Connection conn = connectFunc.call();
        HostSpec hostSpec2 = currentHostSpec = this.pluginService.getCurrentHostSpec() != null ? this.pluginService.getCurrentHostSpec() : hostSpec;
        if (conn != null && !this.rdsHelper.isRdsInstance(currentHostSpec.getHost())) {
            currentHostSpec.addAlias(this.getInstanceEndpoint(conn, currentHostSpec));
        }
        this.tracker.populateOpenedConnectionQueue(currentHostSpec, conn);
        this.tracker.logOpenedConnections();
        return conn;
    }

    @Override
    public Connection forceConnect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> forceConnectFunc) throws SQLException {
        return this.connectInternal(hostSpec, forceConnectFunc);
    }

    private String getInstanceEndpointPattern(String url) {
        if (StringUtils.isNullOrEmpty(this.clusterInstanceTemplate)) {
            this.clusterInstanceTemplate = AuroraHostListProvider.CLUSTER_INSTANCE_HOST_PATTERN.getString(this.props) == null ? this.rdsHelper.getRdsInstanceHostPattern(url) : AuroraHostListProvider.CLUSTER_INSTANCE_HOST_PATTERN.getString(this.props);
        }
        return this.clusterInstanceTemplate;
    }

    @Override
    public <T, E extends Exception> T execute(Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        HostSpec originalHost = this.pluginService.getCurrentHostSpec();
        try {
            T result = jdbcMethodFunc.call();
            if (methodName.equals(METHOD_CLOSE) || methodName.equals(METHOD_ABORT)) {
                this.tracker.invalidateCurrentConnection(originalHost, this.pluginService.getCurrentConnection());
            }
            return result;
        }
        catch (Exception e) {
            if (e instanceof FailoverSQLException) {
                this.tracker.invalidateAllConnections(originalHost);
                this.tracker.logOpenedConnections();
            }
            throw e;
        }
    }

    @Override
    public void notifyNodeListChanged(Map<String, EnumSet<NodeChangeOptions>> changes) {
        for (String node : changes.keySet()) {
            if (!this.isRoleChanged(changes.get(node))) continue;
            this.tracker.invalidateAllConnections(node);
        }
    }

    private boolean isRoleChanged(EnumSet<NodeChangeOptions> changes) {
        return changes.contains((Object)NodeChangeOptions.PROMOTED_TO_WRITER) || changes.contains((Object)NodeChangeOptions.PROMOTED_TO_READER);
    }

    /*
     * Exception decompiling
     */
    public String getInstanceEndpoint(Connection conn, HostSpec host) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

