/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.jdbc.HostAvailability;
import software.amazon.jdbc.HostRole;

public class HostSpec {
    public static final int NO_PORT = -1;
    private static final long DEFAULT_WEIGHT = 100L;
    protected final String host;
    protected final int port;
    protected volatile HostAvailability availability;
    protected HostRole role;
    protected Set<String> aliases = ConcurrentHashMap.newKeySet();
    protected Set<String> allAliases = ConcurrentHashMap.newKeySet();
    protected long weight;

    public HostSpec(String host) {
        this.host = host;
        this.port = -1;
        this.availability = HostAvailability.AVAILABLE;
        this.role = HostRole.WRITER;
        this.allAliases.add(this.asAlias());
        this.weight = 100L;
    }

    public HostSpec(String host, int port) {
        this.host = host;
        this.port = port;
        this.availability = HostAvailability.AVAILABLE;
        this.role = HostRole.WRITER;
        this.allAliases.add(this.asAlias());
        this.weight = 100L;
    }

    public HostSpec(String host, int port, HostRole role) {
        this.host = host;
        this.port = port;
        this.availability = HostAvailability.AVAILABLE;
        this.role = role;
        this.allAliases.add(this.asAlias());
        this.weight = 100L;
    }

    public HostSpec(String host, int port, HostRole role, HostAvailability availability) {
        this.host = host;
        this.port = port;
        this.availability = availability;
        this.role = role;
        this.allAliases.add(this.asAlias());
        this.weight = 100L;
    }

    public HostSpec(String host, int port, HostRole role, HostAvailability availability, long weight) {
        this.host = host;
        this.port = port;
        this.availability = availability;
        this.role = role;
        this.allAliases.add(this.asAlias());
        this.weight = weight;
    }

    public HostSpec(HostSpec copyHost, HostRole role) {
        this(copyHost.getHost(), copyHost.getPort(), role, copyHost.getAvailability());
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isPortSpecified() {
        return this.port != -1;
    }

    public HostRole getRole() {
        return this.role;
    }

    public HostAvailability getAvailability() {
        return this.availability;
    }

    public void setAvailability(HostAvailability availability) {
        this.availability = availability;
    }

    public Set<String> getAliases() {
        return Collections.unmodifiableSet(this.aliases);
    }

    public long getWeight() {
        return this.weight;
    }

    public void addAlias(String ... alias) {
        if (alias == null || alias.length < 1) {
            return;
        }
        Arrays.asList(alias).forEach(x -> {
            this.aliases.add((String)x);
            this.allAliases.add((String)x);
        });
    }

    public void removeAlias(String ... alias) {
        if (alias == null || alias.length < 1) {
            return;
        }
        Arrays.asList(alias).forEach(x -> {
            this.aliases.remove(x);
            this.allAliases.remove(x);
        });
    }

    public String getUrl() {
        String url;
        String string = url = this.isPortSpecified() ? this.host + ":" + this.port : this.host;
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    public String asAlias() {
        return this.isPortSpecified() ? this.host + ":" + this.port : this.host;
    }

    public Set<String> asAliases() {
        return Collections.unmodifiableSet(this.allAliases);
    }

    public String toString() {
        return String.format("HostSpec[host=%s, port=%d, %s, %s, weight=%d]", new Object[]{this.host, this.port, this.role, this.availability, this.weight});
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.host, this.port, this.availability, this.role, this.weight});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HostSpec)) {
            return false;
        }
        HostSpec spec = (HostSpec)obj;
        return Objects.equals(this.host, spec.host) && this.port == spec.port && this.availability == spec.availability && this.role == spec.role && this.weight == spec.weight;
    }
}

