/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSelector;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.RandomHostSelector;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.util.ConnectionUrlBuilder;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.SqlState;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.WrapperUtils;

public class DataSourceConnectionProvider
implements ConnectionProvider {
    private static final Logger LOGGER = Logger.getLogger(DataSourceConnectionProvider.class.getName());
    private static final Map<String, HostSelector> acceptedStrategies = Collections.unmodifiableMap(new HashMap<String, HostSelector>(){
        {
            this.put("random", new RandomHostSelector());
        }
    });
    private final @NonNull DataSource dataSource;
    private final @Nullable String serverPropertyName;
    private final @Nullable String portPropertyName;
    private final @Nullable String urlPropertyName;
    private final @Nullable String databasePropertyName;
    private final ReentrantLock lock = new ReentrantLock();

    public DataSourceConnectionProvider(@NonNull DataSource dataSource, @Nullable String serverPropertyName, @Nullable String portPropertyName, @Nullable String urlPropertyName, @Nullable String databasePropertyName) {
        this.dataSource = dataSource;
        this.serverPropertyName = serverPropertyName;
        this.portPropertyName = portPropertyName;
        this.urlPropertyName = urlPropertyName;
        this.databasePropertyName = databasePropertyName;
    }

    @Override
    public boolean acceptsUrl(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) {
        return true;
    }

    @Override
    public boolean acceptsStrategy(@NonNull HostRole role, @NonNull String strategy) {
        return acceptedStrategies.containsKey(strategy);
    }

    @Override
    public HostSpec getHostSpecByStrategy(@NonNull List<HostSpec> hosts, @NonNull HostRole role, @NonNull String strategy) throws SQLException {
        if (!acceptedStrategies.containsKey(strategy)) {
            throw new UnsupportedOperationException(Messages.get("ConnectionProvider.unsupportedHostSpecSelectorStrategy", new Object[]{strategy, DataSourceConnectionProvider.class}));
        }
        return acceptedStrategies.get(strategy).getHost(hosts, role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(@NonNull String protocol, @NonNull Dialect dialect, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        Connection conn;
        Properties copy = PropertyUtils.copyProperties(props);
        if (!StringUtils.isNullOrEmpty(this.serverPropertyName)) {
            copy.setProperty(this.serverPropertyName, hostSpec.getHost());
        }
        if (hostSpec.isPortSpecified() && !StringUtils.isNullOrEmpty(this.portPropertyName)) {
            copy.put(this.portPropertyName, (Object)hostSpec.getPort());
        }
        if (!StringUtils.isNullOrEmpty(this.databasePropertyName) && !StringUtils.isNullOrEmpty(PropertyDefinition.DATABASE.getString(props))) {
            copy.setProperty(this.databasePropertyName, PropertyDefinition.DATABASE.getString(props));
        }
        if (!StringUtils.isNullOrEmpty(this.urlPropertyName)) {
            Properties urlProperties = PropertyUtils.copyProperties(copy);
            if (!StringUtils.isNullOrEmpty(props.getProperty(this.urlPropertyName))) {
                urlProperties.remove(this.urlPropertyName);
            }
            String finalUrl = ConnectionUrlBuilder.buildUrl(protocol, hostSpec, this.serverPropertyName, this.portPropertyName, this.databasePropertyName, urlProperties);
            LOGGER.finest(() -> "Connecting to " + finalUrl);
            copy.setProperty(this.urlPropertyName, finalUrl);
        }
        PropertyDefinition.removeAllExceptCredentials(copy);
        LOGGER.finest(() -> PropertyUtils.logProperties(copy, "Connecting with properties: \n"));
        if (this.lock.isLocked()) {
            LOGGER.finest(() -> "Use a separate DataSource object to create a connection.");
            DataSource ds = this.createDataSource();
            PropertyUtils.applyProperties(ds, copy);
            conn = ds.getConnection();
        } else {
            this.lock.lock();
            LOGGER.finest(() -> "Use main DataSource object to create a connection.");
            try {
                PropertyUtils.applyProperties(this.dataSource, copy);
                conn = this.dataSource.getConnection();
            }
            finally {
                this.lock.unlock();
            }
        }
        return conn;
    }

    @Override
    public Connection connect(@NonNull String url, @NonNull Properties props) throws SQLException {
        Properties copy = PropertyUtils.copyProperties(props);
        if (!StringUtils.isNullOrEmpty(this.urlPropertyName)) {
            copy.setProperty(this.urlPropertyName, url);
        }
        if (!StringUtils.isNullOrEmpty(this.databasePropertyName) && !StringUtils.isNullOrEmpty(PropertyDefinition.DATABASE.getString(props))) {
            copy.put(this.databasePropertyName, PropertyDefinition.DATABASE.getString(props));
        }
        PropertyDefinition.removeAllExceptCredentials(copy);
        PropertyUtils.applyProperties(this.dataSource, copy);
        return this.dataSource.getConnection();
    }

    private DataSource createDataSource() throws SQLException {
        try {
            return WrapperUtils.createInstance(this.dataSource.getClass(), DataSource.class, null, new Object[0]);
        }
        catch (InstantiationException instEx) {
            throw new SQLException(instEx.getMessage(), SqlState.UNKNOWN_STATE.getState(), instEx);
        }
    }
}

