/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionPlugin;
import software.amazon.jdbc.ConnectionPluginFactory;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.OldConnectionSuggestedAction;
import software.amazon.jdbc.PluginManagerService;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.cleanup.CanReleaseResources;
import software.amazon.jdbc.plugin.AuroraConnectionTrackerPluginFactory;
import software.amazon.jdbc.plugin.AuroraHostListConnectionPluginFactory;
import software.amazon.jdbc.plugin.AwsSecretsManagerConnectionPluginFactory;
import software.amazon.jdbc.plugin.DataCacheConnectionPluginFactory;
import software.amazon.jdbc.plugin.DefaultConnectionPlugin;
import software.amazon.jdbc.plugin.DriverMetaDataConnectionPluginFactory;
import software.amazon.jdbc.plugin.ExecutionTimeConnectionPluginFactory;
import software.amazon.jdbc.plugin.IamAuthConnectionPluginFactory;
import software.amazon.jdbc.plugin.LogQueryConnectionPluginFactory;
import software.amazon.jdbc.plugin.efm.HostMonitoringConnectionPluginFactory;
import software.amazon.jdbc.plugin.failover.FailoverConnectionPluginFactory;
import software.amazon.jdbc.plugin.readwritesplitting.ReadWriteSplittingPluginFactory;
import software.amazon.jdbc.plugin.staledns.AuroraStaleDnsPluginFactory;
import software.amazon.jdbc.profile.DriverConfigurationProfiles;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.SqlMethodAnalyzer;
import software.amazon.jdbc.util.SqlState;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.WrapperUtils;
import software.amazon.jdbc.wrapper.ConnectionWrapper;

public class ConnectionPluginManager
implements CanReleaseResources {
    protected static final Map<String, Class<? extends ConnectionPluginFactory>> pluginFactoriesByCode = new HashMap<String, Class<? extends ConnectionPluginFactory>>(){
        {
            this.put("executionTime", ExecutionTimeConnectionPluginFactory.class);
            this.put("auroraHostList", AuroraHostListConnectionPluginFactory.class);
            this.put("logQuery", LogQueryConnectionPluginFactory.class);
            this.put("dataCache", DataCacheConnectionPluginFactory.class);
            this.put("efm", HostMonitoringConnectionPluginFactory.class);
            this.put("failover", FailoverConnectionPluginFactory.class);
            this.put("iam", IamAuthConnectionPluginFactory.class);
            this.put("awsSecretsManager", AwsSecretsManagerConnectionPluginFactory.class);
            this.put("auroraStaleDns", AuroraStaleDnsPluginFactory.class);
            this.put("readWriteSplitting", ReadWriteSplittingPluginFactory.class);
            this.put("auroraConnectionTracker", AuroraConnectionTrackerPluginFactory.class);
            this.put("driverMetaData", DriverMetaDataConnectionPluginFactory.class);
        }
    };
    protected static final String DEFAULT_PLUGINS = "auroraConnectionTracker,failover,efm";
    private static final Logger LOGGER = Logger.getLogger(ConnectionPluginManager.class.getName());
    private static final String ALL_METHODS = "*";
    private static final String CONNECT_METHOD = "connect";
    private static final String FORCE_CONNECT_METHOD = "forceConnect";
    private static final String ACCEPTS_STRATEGY_METHOD = "acceptsStrategy";
    private static final String GET_HOST_SPEC_BY_STRATEGY_METHOD = "getHostSpecByStrategy";
    private static final String INIT_HOST_PROVIDER_METHOD = "initHostProvider";
    private static final String NOTIFY_CONNECTION_CHANGED_METHOD = "notifyConnectionChanged";
    private static final String NOTIFY_NODE_LIST_CHANGED_METHOD = "notifyNodeListChanged";
    private static final SqlMethodAnalyzer sqlMethodAnalyzer = new SqlMethodAnalyzer();
    private final ReentrantLock lock = new ReentrantLock();
    protected Properties props = new Properties();
    protected List<ConnectionPlugin> plugins;
    protected final ConnectionProvider defaultConnProvider;
    protected final ConnectionWrapper connectionWrapper;
    protected PluginService pluginService;
    protected final Map<String, PluginChainJdbcCallable> pluginChainFuncMap = new HashMap<String, PluginChainJdbcCallable>();

    public ConnectionPluginManager(ConnectionProvider defaultConnProvider, ConnectionWrapper connectionWrapper) {
        this.defaultConnProvider = defaultConnProvider;
        this.connectionWrapper = connectionWrapper;
    }

    ConnectionPluginManager(ConnectionProvider defaultConnProvider, Properties props, ArrayList<ConnectionPlugin> plugins, ConnectionWrapper connectionWrapper, PluginService pluginService) {
        this(defaultConnProvider, props, plugins, connectionWrapper);
        this.pluginService = pluginService;
    }

    ConnectionPluginManager(ConnectionProvider defaultConnProvider, Properties props, ArrayList<ConnectionPlugin> plugins, ConnectionWrapper connectionWrapper) {
        this.defaultConnProvider = defaultConnProvider;
        this.props = props;
        this.plugins = plugins;
        this.connectionWrapper = connectionWrapper;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void init(PluginService pluginService, Properties props, PluginManagerService pluginManagerService) throws SQLException {
        List pluginFactories;
        this.props = props;
        this.pluginService = pluginService;
        String profileName = PropertyDefinition.PROFILE_NAME.getString(props);
        if (profileName != null) {
            if (!DriverConfigurationProfiles.contains(profileName)) {
                throw new SQLException(Messages.get("ConnectionPluginManager.configurationProfileNotFound", new Object[]{profileName}));
            }
            pluginFactories = DriverConfigurationProfiles.getPluginFactories(profileName);
        } else {
            String pluginCodes = PropertyDefinition.PLUGINS.getString(props);
            if (pluginCodes == null) {
                pluginCodes = DEFAULT_PLUGINS;
            }
            List<String> pluginCodeList = StringUtils.split(pluginCodes, ",", true);
            pluginFactories = new ArrayList(pluginCodeList.size());
            for (String pluginCode : pluginCodeList) {
                if (!pluginFactoriesByCode.containsKey(pluginCode)) {
                    throw new SQLException(Messages.get("ConnectionPluginManager.unknownPluginCode", new Object[]{pluginCode}));
                }
                pluginFactories.add(pluginFactoriesByCode.get(pluginCode));
            }
        }
        if (!pluginFactories.isEmpty()) {
            try {
                ConnectionPluginFactory[] factories = WrapperUtils.loadClasses(pluginFactories, ConnectionPluginFactory.class, "ConnectionPluginManager.unableToLoadPlugin").toArray(new ConnectionPluginFactory[0]);
                this.plugins = new ArrayList<ConnectionPlugin>(factories.length + 1);
                for (ConnectionPluginFactory factory : factories) {
                    this.plugins.add(factory.getInstance(this.pluginService, this.props));
                }
            }
            catch (InstantiationException instEx) {
                throw new SQLException(instEx.getMessage(), SqlState.UNKNOWN_STATE.getState(), instEx);
            }
        } else {
            this.plugins = new ArrayList<ConnectionPlugin>(1);
        }
        DefaultConnectionPlugin defaultPlugin = new DefaultConnectionPlugin(this.pluginService, this.defaultConnProvider, pluginManagerService);
        this.plugins.add(defaultPlugin);
    }

    protected <T, E extends Exception> T executeWithSubscribedPlugins(String methodName, PluginPipeline<T, E> pluginPipeline, JdbcCallable<T, E> jdbcMethodFunc) throws E {
        if (pluginPipeline == null) {
            throw new IllegalArgumentException("pluginPipeline");
        }
        if (jdbcMethodFunc == null) {
            throw new IllegalArgumentException("jdbcMethodFunc");
        }
        PluginChainJdbcCallable<T, E> pluginChainFunc = this.pluginChainFuncMap.get(methodName);
        if (pluginChainFunc == null) {
            pluginChainFunc = this.makePluginChainFunc(methodName);
            this.pluginChainFuncMap.put(methodName, pluginChainFunc);
        }
        if (pluginChainFunc == null) {
            throw new RuntimeException("Error processing this JDBC call.");
        }
        return pluginChainFunc.call(pluginPipeline, jdbcMethodFunc);
    }

    protected <T, E extends Exception> @Nullable PluginChainJdbcCallable<T, E> makePluginChainFunc(@NonNull String methodName) {
        PluginChainJdbcCallable pluginChainFunc = null;
        for (int i = this.plugins.size() - 1; i >= 0; --i) {
            boolean isSubscribed;
            ConnectionPlugin plugin = this.plugins.get(i);
            Set<String> pluginSubscribedMethods = plugin.getSubscribedMethods();
            boolean bl = isSubscribed = pluginSubscribedMethods.contains(ALL_METHODS) || pluginSubscribedMethods.contains(methodName);
            if (!isSubscribed) continue;
            if (pluginChainFunc == null) {
                pluginChainFunc = (pipelineFunc, jdbcFunc) -> pipelineFunc.call(plugin, jdbcFunc);
                continue;
            }
            PluginChainJdbcCallable finalPluginChainFunc = pluginChainFunc;
            pluginChainFunc = (pipelineFunc, jdbcFunc) -> pipelineFunc.call(plugin, () -> finalPluginChainFunc.call(pipelineFunc, jdbcFunc));
        }
        return pluginChainFunc;
    }

    protected <E extends Exception> void notifySubscribedPlugins(String methodName, PluginPipeline<Void, E> pluginPipeline, ConnectionPlugin skipNotificationForThisPlugin) throws E {
        if (pluginPipeline == null) {
            throw new IllegalArgumentException("pluginPipeline");
        }
        for (ConnectionPlugin plugin : this.plugins) {
            Set<String> pluginSubscribedMethods;
            boolean isSubscribed;
            if (plugin == skipNotificationForThisPlugin || !(isSubscribed = (pluginSubscribedMethods = plugin.getSubscribedMethods()).contains(ALL_METHODS) || pluginSubscribedMethods.contains(methodName))) continue;
            pluginPipeline.call(plugin, null);
        }
    }

    public ConnectionWrapper getConnectionWrapper() {
        return this.connectionWrapper;
    }

    public <T, E extends Exception> T execute(Class<T> resultType, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        Connection conn = WrapperUtils.getConnectionFromSqlObject(methodInvokeOn);
        if (conn != null && conn != this.pluginService.getCurrentConnection() && !sqlMethodAnalyzer.isMethodClosingSqlObject(methodName)) {
            SQLException e = new SQLException(Messages.get("ConnectionPluginManager.methodInvokedAgainstOldConnection", new Object[]{methodInvokeOn}));
            throw WrapperUtils.wrapExceptionIfNeeded(exceptionClass, e);
        }
        return (T)this.executeWithSubscribedPlugins(methodName, (plugin, func) -> plugin.execute(resultType, exceptionClass, methodInvokeOn, methodName, func, jdbcMethodArgs), jdbcMethodFunc);
    }

    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection) throws SQLException {
        try {
            return this.executeWithSubscribedPlugins(CONNECT_METHOD, (plugin, func) -> plugin.connect(driverProtocol, hostSpec, props, isInitialConnection, func), () -> {
                throw new SQLException("Shouldn't be called.");
            });
        }
        catch (RuntimeException | SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public Connection forceConnect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection) throws SQLException {
        try {
            return this.executeWithSubscribedPlugins(FORCE_CONNECT_METHOD, (plugin, func) -> plugin.forceConnect(driverProtocol, hostSpec, props, isInitialConnection, func), () -> {
                throw new SQLException("Shouldn't be called.");
            });
        }
        catch (RuntimeException | SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public boolean acceptsStrategy(HostRole role, String strategy) throws SQLException {
        try {
            for (ConnectionPlugin plugin : this.plugins) {
                Set<String> pluginSubscribedMethods = plugin.getSubscribedMethods();
                boolean isSubscribed = pluginSubscribedMethods.contains(ALL_METHODS) || pluginSubscribedMethods.contains(ACCEPTS_STRATEGY_METHOD);
                if (!isSubscribed || !plugin.acceptsStrategy(role, strategy)) continue;
                return true;
            }
            return false;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public HostSpec getHostSpecByStrategy(HostRole role, String strategy) throws SQLException, UnsupportedOperationException {
        try {
            for (ConnectionPlugin plugin : this.plugins) {
                Set<String> pluginSubscribedMethods = plugin.getSubscribedMethods();
                boolean isSubscribed = pluginSubscribedMethods.contains(ALL_METHODS) || pluginSubscribedMethods.contains(GET_HOST_SPEC_BY_STRATEGY_METHOD);
                if (!isSubscribed) continue;
                try {
                    HostSpec host = plugin.getHostSpecByStrategy(role, strategy);
                    if (host == null) continue;
                    return host;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
            }
            throw new UnsupportedOperationException("The driver does not support the requested host selection strategy: " + strategy);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public void initHostProvider(String driverProtocol, String initialUrl, Properties props, HostListProviderService hostListProviderService) throws SQLException {
        this.executeWithSubscribedPlugins(INIT_HOST_PROVIDER_METHOD, (plugin, func) -> {
            plugin.initHostProvider(driverProtocol, initialUrl, props, hostListProviderService, func);
            return null;
        }, () -> {
            throw new SQLException("Shouldn't be called.");
        });
    }

    public EnumSet<OldConnectionSuggestedAction> notifyConnectionChanged(@NonNull EnumSet<NodeChangeOptions> changes, @Nullable ConnectionPlugin skipNotificationForThisPlugin) {
        EnumSet<OldConnectionSuggestedAction> result = EnumSet.noneOf(OldConnectionSuggestedAction.class);
        this.notifySubscribedPlugins(NOTIFY_CONNECTION_CHANGED_METHOD, (plugin, func) -> {
            OldConnectionSuggestedAction pluginOpinion = plugin.notifyConnectionChanged(changes);
            result.add(pluginOpinion);
            return null;
        }, skipNotificationForThisPlugin);
        return result;
    }

    public void notifyNodeListChanged(@NonNull Map<String, EnumSet<NodeChangeOptions>> changes) {
        this.notifySubscribedPlugins(NOTIFY_NODE_LIST_CHANGED_METHOD, (plugin, func) -> {
            plugin.notifyNodeListChanged(changes);
            return null;
        }, null);
    }

    @Override
    public void releaseResources() {
        LOGGER.fine(() -> Messages.get("ConnectionPluginManager.releaseResources"));
        this.plugins.forEach(plugin -> {
            if (plugin instanceof CanReleaseResources) {
                ((CanReleaseResources)((Object)plugin)).releaseResources();
            }
        });
    }

    private static interface PluginChainJdbcCallable<T, E extends Exception> {
        public T call(@NonNull PluginPipeline<T, E> var1, @NonNull JdbcCallable<T, E> var2) throws E;
    }

    private static interface PluginPipeline<T, E extends Exception> {
        public T call(@NonNull ConnectionPlugin var1, @Nullable JdbcCallable<T, E> var2) throws E;
    }
}

