/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.hostlistprovider;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.hostlistprovider.DynamicHostListProvider;
import software.amazon.jdbc.util.CacheMap;
import software.amazon.jdbc.util.ConnectionUrlParser;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUrlType;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.Utils;

public class AuroraHostListProvider
implements DynamicHostListProvider {
    public static final AwsWrapperProperty CLUSTER_TOPOLOGY_REFRESH_RATE_MS = new AwsWrapperProperty("clusterTopologyRefreshRateMs", "30000", "Cluster topology refresh rate in millis. The cached topology for the cluster will be invalidated after the specified time, after which it will be updated during the next interaction with the connection.");
    public static final AwsWrapperProperty CLUSTER_ID = new AwsWrapperProperty("clusterId", "", "A unique identifier for the cluster. Connections with the same cluster id share a cluster topology cache. If unspecified, a cluster id is automatically created for AWS RDS clusters.");
    public static final AwsWrapperProperty CLUSTER_INSTANCE_HOST_PATTERN = new AwsWrapperProperty("clusterInstanceHostPattern", null, "The cluster instance DNS pattern that will be used to build a complete instance endpoint. A \"?\" character in this pattern should be used as a placeholder for cluster instance names. This pattern is required to be specified for IP address or custom domain connections to AWS RDS clusters. Otherwise, if unspecified, the pattern will be automatically created for AWS RDS clusters.");
    static final String PG_RETRIEVE_TOPOLOGY_SQL = "SELECT SERVER_ID, SESSION_ID FROM aurora_replica_status() WHERE EXTRACT(EPOCH FROM(NOW() - LAST_UPDATE_TIMESTAMP)) <= 300 OR SESSION_ID = 'MASTER_SESSION_ID' ORDER BY LAST_UPDATE_TIMESTAMP";
    static final String MYSQL_RETRIEVE_TOPOLOGY_SQL = "SELECT SERVER_ID, SESSION_ID FROM information_schema.replica_host_status WHERE time_to_sec(timediff(now(), LAST_UPDATE_TIMESTAMP)) <= 300 OR SESSION_ID = 'MASTER_SESSION_ID' ORDER BY LAST_UPDATE_TIMESTAMP";
    static final String WRITER_SESSION_ID = "MASTER_SESSION_ID";
    static final String FIELD_SERVER_ID = "SERVER_ID";
    static final String FIELD_SESSION_ID = "SESSION_ID";
    private final HostListProviderService hostListProviderService;
    private final String originalUrl;
    private RdsUrlType rdsUrlType;
    private final RdsUtils rdsHelper;
    private long refreshRateNano;
    private final long suggestedClusterIdRefreshRateNano;
    private List<HostSpec> hostList;
    private List<HostSpec> lastReturnedHostList;
    private List<HostSpec> initialHostList;
    private HostSpec initialHostSpec;
    public static final CacheMap<String, List<HostSpec>> topologyCache = new CacheMap();
    public static final CacheMap<String, String> suggestedPrimaryClusterIdCache = new CacheMap();
    public static final CacheMap<String, Boolean> primaryClusterIdCache = new CacheMap();
    private static final String PG_DRIVER_PROTOCOL = "postgresql";
    private final String retrieveTopologyQuery;
    private final ReentrantLock lock;
    protected String clusterId;
    protected HostSpec clusterInstanceTemplate;
    protected ConnectionUrlParser connectionUrlParser;
    protected boolean isPrimaryClusterId;
    protected boolean isInitialized;
    private static final Logger LOGGER = Logger.getLogger(AuroraHostListProvider.class.getName());
    Properties properties;

    public AuroraHostListProvider(String driverProtocol, HostListProviderService hostListProviderService, Properties properties, String originalUrl) {
        this(driverProtocol, hostListProviderService, properties, originalUrl, new ConnectionUrlParser());
    }

    public AuroraHostListProvider(String driverProtocol, HostListProviderService hostListProviderService, Properties properties, String originalUrl, ConnectionUrlParser connectionUrlParser) {
        this.refreshRateNano = AuroraHostListProvider.CLUSTER_TOPOLOGY_REFRESH_RATE_MS.defaultValue != null ? TimeUnit.MILLISECONDS.toNanos(Long.parseLong(AuroraHostListProvider.CLUSTER_TOPOLOGY_REFRESH_RATE_MS.defaultValue)) : TimeUnit.MILLISECONDS.toNanos(30000L);
        this.suggestedClusterIdRefreshRateNano = TimeUnit.MINUTES.toNanos(10L);
        this.hostList = new ArrayList<HostSpec>();
        this.initialHostList = new ArrayList<HostSpec>();
        this.lock = new ReentrantLock();
        this.isInitialized = false;
        this.rdsHelper = new RdsUtils();
        this.hostListProviderService = hostListProviderService;
        this.properties = properties;
        this.originalUrl = originalUrl;
        this.connectionUrlParser = connectionUrlParser;
        this.retrieveTopologyQuery = driverProtocol.contains(PG_DRIVER_PROTOCOL) ? PG_RETRIEVE_TOPOLOGY_SQL : MYSQL_RETRIEVE_TOPOLOGY_SQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws SQLException {
        if (this.isInitialized) {
            return;
        }
        this.lock.lock();
        try {
            if (this.isInitialized) {
                return;
            }
            this.initialHostList = this.connectionUrlParser.getHostsFromConnectionUrl(this.originalUrl, false);
            if (this.initialHostList == null || this.initialHostList.isEmpty()) {
                throw new SQLException(Messages.get("AuroraHostListProvider.parsedListEmpty", new Object[]{this.originalUrl}));
            }
            this.initialHostSpec = this.initialHostList.get(0);
            this.hostListProviderService.setInitialConnectionHostSpec(this.initialHostSpec);
            this.clusterId = UUID.randomUUID().toString();
            this.isPrimaryClusterId = false;
            this.refreshRateNano = TimeUnit.MILLISECONDS.toNanos(CLUSTER_TOPOLOGY_REFRESH_RATE_MS.getInteger(this.properties));
            this.clusterInstanceTemplate = CLUSTER_INSTANCE_HOST_PATTERN.getString(this.properties) == null ? new HostSpec(this.rdsHelper.getRdsInstanceHostPattern(this.originalUrl)) : new HostSpec(CLUSTER_INSTANCE_HOST_PATTERN.getString(this.properties));
            this.validateHostPatternSetting(this.clusterInstanceTemplate.getHost());
            this.rdsUrlType = this.rdsHelper.identifyRdsType(this.originalUrl);
            String clusterIdSetting = CLUSTER_ID.getString(this.properties);
            if (!StringUtils.isNullOrEmpty(clusterIdSetting)) {
                this.clusterId = clusterIdSetting;
            } else if (this.rdsUrlType == RdsUrlType.RDS_PROXY) {
                this.clusterId = this.initialHostSpec.getUrl();
            } else if (this.rdsUrlType.isRds()) {
                ClusterSuggestedResult clusterSuggestedResult = this.getSuggestedClusterId(this.initialHostSpec.getUrl());
                if (clusterSuggestedResult != null && !StringUtils.isNullOrEmpty(clusterSuggestedResult.clusterId)) {
                    this.clusterId = clusterSuggestedResult.clusterId;
                    this.isPrimaryClusterId = clusterSuggestedResult.isPrimaryClusterId;
                } else {
                    String clusterRdsHostUrl = this.rdsHelper.getRdsClusterHostUrl(this.initialHostSpec.getUrl());
                    if (!StringUtils.isNullOrEmpty(clusterRdsHostUrl)) {
                        this.clusterId = this.clusterInstanceTemplate.isPortSpecified() ? String.format("%s:%s", clusterRdsHostUrl, this.clusterInstanceTemplate.getPort()) : clusterRdsHostUrl;
                        this.isPrimaryClusterId = true;
                        primaryClusterIdCache.put(this.clusterId, true, this.suggestedClusterIdRefreshRateNano);
                    }
                }
            }
            this.isInitialized = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public FetchTopologyResult getTopology(Connection conn, boolean forceUpdate) throws SQLException {
        List<HostSpec> cachedHosts;
        boolean needToSuggest;
        String suggestedPrimaryClusterId = suggestedPrimaryClusterIdCache.get(this.clusterId);
        if (!StringUtils.isNullOrEmpty(suggestedPrimaryClusterId) && !this.clusterId.equals(suggestedPrimaryClusterId)) {
            this.clusterId = suggestedPrimaryClusterId;
            this.isPrimaryClusterId = true;
        }
        boolean bl = needToSuggest = (cachedHosts = topologyCache.get(this.clusterId)) == null && this.isPrimaryClusterId;
        if (cachedHosts == null || forceUpdate) {
            if (conn == null) {
                return new FetchTopologyResult(false, this.initialHostList);
            }
            List<HostSpec> hosts = this.queryForTopology(conn);
            if (!Utils.isNullOrEmpty(hosts)) {
                topologyCache.put(this.clusterId, hosts, this.refreshRateNano);
                if (needToSuggest) {
                    this.suggestPrimaryCluster(hosts);
                }
                return new FetchTopologyResult(false, hosts);
            }
        }
        if (cachedHosts == null) {
            return new FetchTopologyResult(false, this.initialHostList);
        }
        return new FetchTopologyResult(true, cachedHosts);
    }

    private ClusterSuggestedResult getSuggestedClusterId(String url) {
        for (Map.Entry<String, List<HostSpec>> entry : topologyCache.getEntries().entrySet()) {
            String key = entry.getKey();
            List<HostSpec> hosts = entry.getValue();
            boolean isPrimaryCluster = primaryClusterIdCache.get(key, false, this.suggestedClusterIdRefreshRateNano);
            if (key.equals(url)) {
                return new ClusterSuggestedResult(url, isPrimaryCluster);
            }
            if (hosts == null) continue;
            for (HostSpec host : hosts) {
                if (!host.getUrl().equals(url)) continue;
                LOGGER.finest(() -> Messages.get("AuroraHostListProvider.suggestedClusterId", new Object[]{key, url}));
                return new ClusterSuggestedResult(key, isPrimaryCluster);
            }
        }
        return null;
    }

    protected void suggestPrimaryCluster(@NonNull List<HostSpec> primaryClusterHosts) {
        if (Utils.isNullOrEmpty(primaryClusterHosts)) {
            return;
        }
        HashSet<String> primaryClusterHostUrls = new HashSet<String>();
        for (HostSpec hostSpec : primaryClusterHosts) {
            primaryClusterHostUrls.add(hostSpec.getUrl());
        }
        block1: for (Map.Entry entry : topologyCache.getEntries().entrySet()) {
            String clusterId = (String)entry.getKey();
            List clusterHosts = (List)entry.getValue();
            boolean isPrimaryCluster = primaryClusterIdCache.get(clusterId, false, this.suggestedClusterIdRefreshRateNano);
            String suggestedPrimaryClusterId = suggestedPrimaryClusterIdCache.get(clusterId);
            if (isPrimaryCluster || !StringUtils.isNullOrEmpty(suggestedPrimaryClusterId) || Utils.isNullOrEmpty(clusterHosts)) continue;
            for (HostSpec host : clusterHosts) {
                if (!primaryClusterHostUrls.contains(host.getUrl())) continue;
                suggestedPrimaryClusterIdCache.put(clusterId, this.clusterId, this.suggestedClusterIdRefreshRateNano);
                continue block1;
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected List<HostSpec> queryForTopology(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<HostSpec> processQueryResults(ResultSet resultSet) throws SQLException {
        HashMap<String, HostSpec> hostMap = new HashMap<String, HostSpec>();
        while (resultSet.next()) {
            HostSpec host = this.createHost(resultSet);
            hostMap.put(host.getHost(), host);
        }
        int writerCount = 0;
        ArrayList<HostSpec> hosts = new ArrayList<HostSpec>();
        for (HostSpec host : hostMap.values()) {
            if (host.getRole() == HostRole.WRITER) {
                ++writerCount;
            }
            hosts.add(host);
        }
        if (writerCount == 0) {
            LOGGER.severe(() -> Messages.get("AuroraHostListProvider.invalidTopology"));
            hosts.clear();
        }
        return hosts;
    }

    private HostSpec createHost(ResultSet resultSet) throws SQLException {
        return this.createHost(resultSet, WRITER_SESSION_ID.equals(resultSet.getString(FIELD_SESSION_ID)));
    }

    private HostSpec createHost(ResultSet resultSet, boolean isWriter) throws SQLException {
        String hostName = resultSet.getString(FIELD_SERVER_ID);
        hostName = hostName == null ? "?" : hostName;
        String endpoint = this.getHostEndpoint(hostName);
        int port = this.clusterInstanceTemplate.isPortSpecified() ? this.clusterInstanceTemplate.getPort() : this.initialHostSpec.getPort();
        HostSpec hostSpec = new HostSpec(endpoint, port, isWriter ? HostRole.WRITER : HostRole.READER);
        hostSpec.addAlias(hostName);
        return hostSpec;
    }

    private String getHostEndpoint(String nodeName) {
        String host = this.clusterInstanceTemplate.getHost();
        return host.replace("?", nodeName);
    }

    public @Nullable List<HostSpec> getCachedTopology() {
        return topologyCache.get(this.clusterId);
    }

    public static void clearAll() {
        topologyCache.clear();
        primaryClusterIdCache.clear();
        suggestedPrimaryClusterIdCache.clear();
    }

    public void clear() {
        topologyCache.remove(this.clusterId);
    }

    @Override
    public List<HostSpec> refresh() throws SQLException {
        return this.refresh(null);
    }

    @Override
    public List<HostSpec> refresh(Connection connection) throws SQLException {
        this.init();
        Connection currentConnection = connection != null ? connection : this.hostListProviderService.getCurrentConnection();
        FetchTopologyResult results = this.getTopology(currentConnection, false);
        LOGGER.finest(() -> Utils.logTopology(results.hosts));
        if (results.isCachedData && this.lastReturnedHostList == results.hosts) {
            return null;
        }
        this.hostList = results.hosts;
        this.lastReturnedHostList = this.hostList;
        return Collections.unmodifiableList(this.hostList);
    }

    @Override
    public List<HostSpec> forceRefresh() throws SQLException {
        return this.forceRefresh(null);
    }

    @Override
    public List<HostSpec> forceRefresh(Connection connection) throws SQLException {
        this.init();
        Connection currentConnection = connection != null ? connection : this.hostListProviderService.getCurrentConnection();
        FetchTopologyResult results = this.getTopology(currentConnection, true);
        LOGGER.finest(() -> Utils.logTopology(results.hosts));
        this.hostList = results.hosts;
        this.lastReturnedHostList = this.hostList;
        return Collections.unmodifiableList(this.hostList);
    }

    public RdsUrlType getRdsUrlType() throws SQLException {
        this.init();
        return this.rdsUrlType;
    }

    private void validateHostPatternSetting(String hostPattern) {
        if (!this.rdsHelper.isDnsPatternValid(hostPattern)) {
            String message = Messages.get("AuroraHostListProvider.invalidPattern");
            LOGGER.severe(message);
            throw new RuntimeException(message);
        }
        RdsUrlType rdsUrlType = this.rdsHelper.identifyRdsType(hostPattern);
        if (rdsUrlType == RdsUrlType.RDS_PROXY) {
            String message = Messages.get("AuroraHostListProvider.clusterInstanceHostPatternNotSupportedForRDSProxy");
            LOGGER.severe(message);
            throw new RuntimeException(message);
        }
        if (rdsUrlType == RdsUrlType.RDS_CUSTOM_CLUSTER) {
            String message = Messages.get("AuroraHostListProvider.clusterInstanceHostPatternNotSupportedForRdsCustom");
            LOGGER.severe(message);
            throw new RuntimeException(message);
        }
    }

    public static void logCache() {
        LOGGER.finest(() -> {
            StringBuilder sb = new StringBuilder();
            Set<Map.Entry<String, List<HostSpec>>> cacheEntries = topologyCache.getEntries().entrySet();
            if (cacheEntries.isEmpty()) {
                sb.append("Cache is empty.");
                return sb.toString();
            }
            for (Map.Entry<String, List<HostSpec>> entry : cacheEntries) {
                List<HostSpec> hosts = entry.getValue();
                Boolean isPrimaryCluster = primaryClusterIdCache.get(entry.getKey());
                String suggestedPrimaryClusterId = suggestedPrimaryClusterIdCache.get(entry.getKey());
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append("[").append(entry.getKey()).append("]:\n").append("\tisPrimaryCluster: ").append(isPrimaryCluster == null ? false : isPrimaryCluster).append("\n").append("\tsuggestedPrimaryCluster: ").append(suggestedPrimaryClusterId).append("\n").append("\tHosts: ");
                if (hosts == null) {
                    sb.append("<null>");
                    continue;
                }
                for (HostSpec h : hosts) {
                    sb.append("\n\t").append(h);
                }
            }
            return sb.toString();
        });
    }

    static class ClusterSuggestedResult {
        public String clusterId;
        public boolean isPrimaryClusterId;

        public ClusterSuggestedResult(String clusterId, boolean isPrimaryClusterId) {
            this.clusterId = clusterId;
            this.isPrimaryClusterId = isPrimaryClusterId;
        }
    }

    static class FetchTopologyResult {
        public List<HostSpec> hosts;
        public boolean isCachedData;

        public FetchTopologyResult(boolean isCachedData, List<HostSpec> hosts) {
            this.isCachedData = isCachedData;
            this.hosts = hosts;
        }
    }
}

