/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.exceptions;

import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.exceptions.GenericExceptionHandler;
import software.amazon.jdbc.exceptions.MariaDBExceptionHandler;
import software.amazon.jdbc.exceptions.MySQLExceptionHandler;
import software.amazon.jdbc.exceptions.PgExceptionHandler;

public class ExceptionManager {
    protected static ExceptionHandler customHandler;
    private static GenericExceptionHandler genericExceptionHandler;
    private static MySQLExceptionHandler mySQLExceptionHandler;
    private static PgExceptionHandler pgExceptionHandler;
    private static MariaDBExceptionHandler mariaDBExceptionHandler;

    public static void setCustomHandler(ExceptionHandler exceptionHandler) {
        customHandler = exceptionHandler;
    }

    public static void resetCustomHandler() {
        customHandler = null;
    }

    public boolean isLoginException(String driverProtocol, Throwable throwable) {
        ExceptionHandler handler = this.getHandler(driverProtocol);
        return handler.isLoginException(throwable);
    }

    public boolean isLoginException(String driverProtocol, String sqlState) {
        ExceptionHandler handler = this.getHandler(driverProtocol);
        return handler.isLoginException(sqlState);
    }

    public boolean isNetworkException(String driverProtocol, Throwable throwable) {
        ExceptionHandler handler = this.getHandler(driverProtocol);
        return handler.isNetworkException(throwable);
    }

    public boolean isNetworkException(String driverProtocol, String sqlState) {
        ExceptionHandler handler = this.getHandler(driverProtocol);
        return handler.isNetworkException(sqlState);
    }

    private ExceptionHandler getHandler(String driverProtocol) {
        if (customHandler != null) {
            return customHandler;
        }
        if (driverProtocol == null) {
            return this.getGenericExceptionHandler();
        }
        if (driverProtocol.contains(":mysql:")) {
            return this.getMySQLExceptionHandler();
        }
        if (driverProtocol.contains(":mariadb:")) {
            return this.getMariaDBExceptionHandler();
        }
        if (driverProtocol.contains(":postgresql:")) {
            return this.getPgExceptionHandler();
        }
        return this.getGenericExceptionHandler();
    }

    private GenericExceptionHandler getGenericExceptionHandler() {
        if (genericExceptionHandler == null) {
            genericExceptionHandler = new GenericExceptionHandler();
        }
        return genericExceptionHandler;
    }

    private MySQLExceptionHandler getMySQLExceptionHandler() {
        if (mySQLExceptionHandler == null) {
            mySQLExceptionHandler = new MySQLExceptionHandler();
        }
        return mySQLExceptionHandler;
    }

    private PgExceptionHandler getPgExceptionHandler() {
        if (pgExceptionHandler == null) {
            pgExceptionHandler = new PgExceptionHandler();
        }
        return pgExceptionHandler;
    }

    private MariaDBExceptionHandler getMariaDBExceptionHandler() {
        return mariaDBExceptionHandler;
    }
}

