/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;

public class DriverConnectionProvider
implements ConnectionProvider {
    private static final Logger LOGGER = Logger.getLogger(DriverConnectionProvider.class.getName());
    private final Driver driver;

    public DriverConnectionProvider(Driver driver) {
        this.driver = driver;
    }

    @Override
    public Connection connect(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        String databaseName = PropertyDefinition.DATABASE.getString(props) != null ? PropertyDefinition.DATABASE.getString(props) : "";
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(protocol).append(hostSpec.getUrl()).append(databaseName);
        LOGGER.finest(() -> "Connecting to " + urlBuilder);
        return this.driver.connect(urlBuilder.toString(), props);
    }

    @Override
    public Connection connect(@NonNull String url, @NonNull Properties props) throws SQLException {
        LOGGER.finest(() -> "Connecting to " + url);
        return this.driver.connect(url, props);
    }
}

