/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.serializers.avro;

import com.amazonaws.services.schemaregistry.common.GlueSchemaRegistryDataFormatSerializer;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.serializers.avro.DatumWriterInstance;
import com.amazonaws.services.schemaregistry.utils.AVROUtils;
import com.amazonaws.services.schemaregistry.utils.AvroRecordType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSerializer
implements GlueSchemaRegistryDataFormatSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AvroSerializer.class);
    private AVROUtils avroUtils = AVROUtils.getInstance();
    private static final long MAX_DATUM_WRITER_CACHE_SIZE = 100L;
    @NonNull
    @VisibleForTesting
    protected final LoadingCache<DatumWriterCacheKey, DatumWriter<Object>> datumWriterCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new DatumWriterCache());

    public byte[] serialize(Object data) {
        byte[] bytes = this.serialize(data, this.createDatumWriter(data));
        return bytes;
    }

    private DatumWriter<Object> createDatumWriter(Object object) {
        Schema schema = AVROUtils.getInstance().getSchema(object);
        if (object instanceof SpecificRecord) {
            return this.getSpecificDatumWriter(schema);
        }
        if (object instanceof GenericRecord) {
            return this.getGenericDatumWriter(schema);
        }
        if (object instanceof GenericData.EnumSymbol) {
            return this.getGenericDatumWriter(schema);
        }
        if (object instanceof GenericData.Array) {
            return this.getGenericDatumWriter(schema);
        }
        if (object instanceof GenericData.Fixed) {
            return this.getGenericDatumWriter(schema);
        }
        String message = String.format("Unsupported type passed for serialization: %s", object);
        throw new AWSSchemaRegistryException(message);
    }

    private DatumWriter<Object> getSpecificDatumWriter(Schema schema) {
        DatumWriterCacheKey datumWriterCacheKey = new DatumWriterCacheKey(schema, AvroRecordType.SPECIFIC_RECORD);
        return (DatumWriter)this.datumWriterCache.get((Object)datumWriterCacheKey);
    }

    private DatumWriter<Object> getGenericDatumWriter(Schema schema) {
        DatumWriterCacheKey datumWriterCacheKey = new DatumWriterCacheKey(schema, AvroRecordType.GENERIC_RECORD);
        return (DatumWriter)this.datumWriterCache.get((Object)datumWriterCacheKey);
    }

    private byte[] serialize(Object data, DatumWriter<Object> writer) {
        return this.encodeData(data, writer);
    }

    private byte[] encodeData(Object object, DatumWriter<Object> writer) {
        ByteArrayOutputStream actualDataBytes = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)actualDataBytes, null);
        try {
            writer.write(object, (Encoder)encoder);
            encoder.flush();
        }
        catch (Exception e) {
            throw new AWSSchemaRegistryException(e.getMessage(), (Throwable)e);
        }
        return actualDataBytes.toByteArray();
    }

    public String getSchemaDefinition(@NonNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object is marked non-null but is null");
        }
        return this.avroUtils.getSchemaDefinition(object);
    }

    public void validate(Object data) {
    }

    public void validate(String schemaDefinition, byte[] data) {
    }

    private static class DatumWriterCache
    extends CacheLoader<DatumWriterCacheKey, DatumWriter<Object>> {
        private DatumWriterCache() {
        }

        public DatumWriter<Object> load(DatumWriterCacheKey datumWriterCacheKey) {
            Schema schema = datumWriterCacheKey.getSchema();
            AvroRecordType avroRecordType = datumWriterCacheKey.getAvroRecordType();
            return DatumWriterInstance.get(schema, avroRecordType);
        }
    }

    private static class DatumWriterCacheKey {
        @NonNull
        private final Schema schema;
        @NonNull
        private final AvroRecordType avroRecordType;

        @Generated
        public DatumWriterCacheKey(@NonNull Schema schema, @NonNull AvroRecordType avroRecordType) {
            if (schema == null) {
                throw new IllegalArgumentException("schema is marked non-null but is null");
            }
            if (avroRecordType == null) {
                throw new IllegalArgumentException("avroRecordType is marked non-null but is null");
            }
            this.schema = schema;
            this.avroRecordType = avroRecordType;
        }

        @NonNull
        @Generated
        public Schema getSchema() {
            return this.schema;
        }

        @NonNull
        @Generated
        public AvroRecordType getAvroRecordType() {
            return this.avroRecordType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DatumWriterCacheKey)) {
                return false;
            }
            DatumWriterCacheKey other = (DatumWriterCacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Schema this$schema = this.getSchema();
            Schema other$schema = other.getSchema();
            if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
                return false;
            }
            AvroRecordType this$avroRecordType = this.getAvroRecordType();
            AvroRecordType other$avroRecordType = other.getAvroRecordType();
            return !(this$avroRecordType == null ? other$avroRecordType != null : !this$avroRecordType.equals(other$avroRecordType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DatumWriterCacheKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Schema $schema = this.getSchema();
            result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
            AvroRecordType $avroRecordType = this.getAvroRecordType();
            result = result * 59 + ($avroRecordType == null ? 43 : $avroRecordType.hashCode());
            return result;
        }
    }
}

