/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers;

import com.amazonaws.services.schemaregistry.common.AWSDeserializerInput;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializationFacade;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializerDataParser;
import com.amazonaws.services.schemaregistry.deserializers.SecondaryDeserializer;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import java.nio.ByteBuffer;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;

public class GlueSchemaRegistryKafkaDeserializer
implements Deserializer<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlueSchemaRegistryKafkaDeserializer.class);
    private final AwsCredentialsProvider credentialProvider;
    private GlueSchemaRegistryDeserializationFacade glueSchemaRegistryDeserializationFacade;
    private SecondaryDeserializer secondaryDeserializer = SecondaryDeserializer.newInstance();

    public GlueSchemaRegistryKafkaDeserializer() {
        this((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build(), null);
    }

    public GlueSchemaRegistryKafkaDeserializer(@NonNull Map<String, ?> configs) {
        this((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build(), configs);
        if (configs == null) {
            throw new IllegalArgumentException("configs is marked non-null but is null");
        }
    }

    public GlueSchemaRegistryKafkaDeserializer(AwsCredentialsProvider credentialProvider, Map<String, ?> configs) {
        this.credentialProvider = credentialProvider;
        if (configs != null) {
            this.configure(configs, false);
        }
    }

    public void configure(@NonNull Map<String, ?> configs, boolean isKey) {
        if (configs == null) {
            throw new IllegalArgumentException("configs is marked non-null but is null");
        }
        log.info("Configuring Amazon Glue Schema Registry Service using these properties: {}", (Object)configs.toString());
        if (this.glueSchemaRegistryDeserializationFacade == null) {
            this.glueSchemaRegistryDeserializationFacade = GlueSchemaRegistryDeserializationFacade.builder().credentialProvider(this.credentialProvider).configs(configs).build();
        }
        if (configs.containsKey("secondaryDeserializer")) {
            this.configureSecondaryDeserializer(configs, isKey);
        }
    }

    public Object deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        Byte headerVersionByte = this.getHeaderVersionByte(data);
        Object result = this.deserializeByHeaderVersionByte(topic, data, headerVersionByte);
        return result;
    }

    public void close() {
        this.glueSchemaRegistryDeserializationFacade.close();
    }

    private AWSDeserializerInput prepareInput(byte[] data, String topic) {
        return AWSDeserializerInput.builder().buffer(ByteBuffer.wrap(data)).transportName(topic).build();
    }

    private void configureSecondaryDeserializer(Map<String, ?> configs, boolean isKey) {
        if (!this.secondaryDeserializer.validate(configs)) {
            throw new AWSSchemaRegistryException("The secondary deserializer is not from Kafka");
        }
        this.secondaryDeserializer.configure(configs, isKey);
    }

    private Object deserializeByHeaderVersionByte(String topic, byte[] data, Byte headerVersionByte) {
        return headerVersionByte.equals((byte)3) ? this.glueSchemaRegistryDeserializationFacade.deserialize(this.prepareInput(data, topic)) : this.secondaryDeserializer.deserialize(topic, data);
    }

    private Byte getHeaderVersionByte(byte[] data) {
        GlueSchemaRegistryDeserializerDataParser dataParser = GlueSchemaRegistryDeserializerDataParser.getInstance();
        return dataParser.getHeaderVersionByte(ByteBuffer.wrap(data));
    }

    @Generated
    public AwsCredentialsProvider getCredentialProvider() {
        return this.credentialProvider;
    }

    @Generated
    public GlueSchemaRegistryDeserializationFacade getGlueSchemaRegistryDeserializationFacade() {
        return this.glueSchemaRegistryDeserializationFacade;
    }

    @Generated
    public void setGlueSchemaRegistryDeserializationFacade(GlueSchemaRegistryDeserializationFacade glueSchemaRegistryDeserializationFacade) {
        this.glueSchemaRegistryDeserializationFacade = glueSchemaRegistryDeserializationFacade;
    }
}

