/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers;

import com.amazonaws.services.schemaregistry.caching.GlueSchemaRegistryCache;
import com.amazonaws.services.schemaregistry.caching.GlueSchemaRegistryDeserializerCache;
import com.amazonaws.services.schemaregistry.common.AWSDeserializerInput;
import com.amazonaws.services.schemaregistry.common.AWSSchemaRegistryClient;
import com.amazonaws.services.schemaregistry.common.Schema;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializerDataParser;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializerFactory;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.google.common.cache.CacheStats;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.glue.model.DataFormat;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionResponse;

public class GlueSchemaRegistryDeserializationFacade
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlueSchemaRegistryDeserializationFacade.class);
    private AwsCredentialsProvider credentialsProvider;
    private AWSSchemaRegistryClient schemaRegistryClient;
    private GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration;
    private GlueSchemaRegistryDeserializerFactory deserializerFactory;
    private GlueSchemaRegistryCache<UUID, Schema, CacheStats> cache;

    public GlueSchemaRegistryDeserializationFacade(Map<String, ?> configs, Properties properties, @NonNull AwsCredentialsProvider credentialProvider, AWSSchemaRegistryClient schemaRegistryClient) {
        if (credentialProvider == null) {
            throw new IllegalArgumentException("credentialProvider is marked non-null but is null");
        }
        this.credentialsProvider = credentialProvider;
        if (configs != null) {
            this.glueSchemaRegistryConfiguration = new GlueSchemaRegistryConfiguration(configs);
        } else if (properties != null) {
            this.glueSchemaRegistryConfiguration = new GlueSchemaRegistryConfiguration(properties);
        } else {
            throw new AWSSchemaRegistryException("Either properties or configuration has to be provided");
        }
        this.schemaRegistryClient = schemaRegistryClient != null ? schemaRegistryClient : new AWSSchemaRegistryClient(this.credentialsProvider, this.glueSchemaRegistryConfiguration);
        this.deserializerFactory = new GlueSchemaRegistryDeserializerFactory();
        this.cache = GlueSchemaRegistryDeserializerCache.getInstance((GlueSchemaRegistryConfiguration)this.glueSchemaRegistryConfiguration);
    }

    public GlueSchemaRegistryDeserializationFacade(@NonNull GlueSchemaRegistryConfiguration configuration, @NonNull AwsCredentialsProvider credentialsProvider) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is marked non-null but is null");
        }
        if (credentialsProvider == null) {
            throw new IllegalArgumentException("credentialsProvider is marked non-null but is null");
        }
        this.credentialsProvider = credentialsProvider;
        this.glueSchemaRegistryConfiguration = configuration;
        this.schemaRegistryClient = new AWSSchemaRegistryClient(credentialsProvider, this.glueSchemaRegistryConfiguration);
        this.deserializerFactory = new GlueSchemaRegistryDeserializerFactory();
        this.cache = GlueSchemaRegistryDeserializerCache.getInstance((GlueSchemaRegistryConfiguration)this.glueSchemaRegistryConfiguration);
    }

    public String getSchemaDefinition(@NonNull ByteBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer is marked non-null but is null");
        }
        AwsDeserializerSchema awsDeserializerSchema = this.getAwsDeserializerSchema(buffer);
        return awsDeserializerSchema.getSchema().getSchemaDefinition();
    }

    public byte[] getActualData(byte[] data) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        return GlueSchemaRegistryDeserializerDataParser.getInstance().getPlainData(byteBuffer);
    }

    public Schema getSchema(@NonNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data is marked non-null but is null");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        AwsDeserializerSchema awsDeserializerSchema = this.getAwsDeserializerSchema(byteBuffer);
        return awsDeserializerSchema.getSchema();
    }

    public String getSchemaDefinition(@NonNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data is marked non-null but is null");
        }
        return this.getSchemaDefinition(ByteBuffer.wrap(data));
    }

    public Object deserialize(@NonNull AWSDeserializerInput deserializerInput) throws AWSSchemaRegistryException {
        if (deserializerInput == null) {
            throw new IllegalArgumentException("deserializerInput is marked non-null but is null");
        }
        ByteBuffer buffer = deserializerInput.getBuffer();
        AwsDeserializerSchema awsDeserializerSchema = this.getAwsDeserializerSchema(buffer);
        Schema schema = awsDeserializerSchema.getSchema();
        Object result = this.deserializerFactory.getInstance(DataFormat.valueOf((String)schema.getDataFormat()), this.glueSchemaRegistryConfiguration).deserialize(buffer, schema.getSchemaDefinition());
        return result;
    }

    public boolean canDeserialize(byte[] data) {
        if (data == null) {
            return false;
        }
        GlueSchemaRegistryDeserializerDataParser glueSchemaRegistryDeserializerDataParser = GlueSchemaRegistryDeserializerDataParser.getInstance();
        return glueSchemaRegistryDeserializerDataParser.isDataCompatible(ByteBuffer.wrap(data), new StringBuilder());
    }

    private AwsDeserializerSchema getAwsDeserializerSchema(@NonNull ByteBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer is marked non-null but is null");
        }
        GlueSchemaRegistryDeserializerDataParser dataParser = GlueSchemaRegistryDeserializerDataParser.getInstance();
        UUID schemaVersionId = dataParser.getSchemaVersionId(buffer);
        Schema schema = this.retrieveSchemaRegistrySchema(schemaVersionId);
        return new AwsDeserializerSchema(schemaVersionId, schema);
    }

    private Schema retrieveSchemaRegistrySchema(UUID schemaVersionId) throws AWSSchemaRegistryException {
        Schema schema = (Schema)this.cache.get((Object)schemaVersionId);
        if (schema != null) {
            return schema;
        }
        GetSchemaVersionResponse response = this.schemaRegistryClient.getSchemaVersionResponse(schemaVersionId.toString());
        log.debug("Retrieved writer schema from Amazon Schema Registry for message: schema version id = {}, ", (Object)schemaVersionId);
        schema = new Schema(response.schemaDefinition(), response.dataFormat().name(), this.getSchemaName(response.schemaArn()));
        this.cache.put((Object)schemaVersionId, (Object)schema);
        return schema;
    }

    private String getSchemaName(String schemaArn) {
        Arn arn = Arn.fromString((String)schemaArn);
        String resource = arn.resourceAsString();
        String[] splitArray = resource.split("/");
        return splitArray[splitArray.length - 1];
    }

    @Override
    public void close() {
    }

    @Generated
    public static GlueSchemaRegistryDeserializationFacadeBuilder builder() {
        return new GlueSchemaRegistryDeserializationFacadeBuilder();
    }

    @Generated
    public AwsCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Generated
    public AWSSchemaRegistryClient getSchemaRegistryClient() {
        return this.schemaRegistryClient;
    }

    @Generated
    public GlueSchemaRegistryConfiguration getGlueSchemaRegistryConfiguration() {
        return this.glueSchemaRegistryConfiguration;
    }

    @Generated
    public void setDeserializerFactory(GlueSchemaRegistryDeserializerFactory deserializerFactory) {
        this.deserializerFactory = deserializerFactory;
    }

    @Generated
    public void setCache(GlueSchemaRegistryCache<UUID, Schema, CacheStats> cache) {
        this.cache = cache;
    }

    @Generated
    public static class GlueSchemaRegistryDeserializationFacadeBuilder {
        @Generated
        private Map<String, ?> configs;
        @Generated
        private Properties properties;
        @Generated
        private AwsCredentialsProvider credentialProvider;
        @Generated
        private AWSSchemaRegistryClient schemaRegistryClient;

        @Generated
        GlueSchemaRegistryDeserializationFacadeBuilder() {
        }

        @Generated
        public GlueSchemaRegistryDeserializationFacadeBuilder configs(Map<String, ?> configs) {
            this.configs = configs;
            return this;
        }

        @Generated
        public GlueSchemaRegistryDeserializationFacadeBuilder properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        @Generated
        public GlueSchemaRegistryDeserializationFacadeBuilder credentialProvider(@NonNull AwsCredentialsProvider credentialProvider) {
            if (credentialProvider == null) {
                throw new IllegalArgumentException("credentialProvider is marked non-null but is null");
            }
            this.credentialProvider = credentialProvider;
            return this;
        }

        @Generated
        public GlueSchemaRegistryDeserializationFacadeBuilder schemaRegistryClient(AWSSchemaRegistryClient schemaRegistryClient) {
            this.schemaRegistryClient = schemaRegistryClient;
            return this;
        }

        @Generated
        public GlueSchemaRegistryDeserializationFacade build() {
            return new GlueSchemaRegistryDeserializationFacade(this.configs, this.properties, this.credentialProvider, this.schemaRegistryClient);
        }

        @Generated
        public String toString() {
            return "GlueSchemaRegistryDeserializationFacade.GlueSchemaRegistryDeserializationFacadeBuilder(configs=" + this.configs + ", properties=" + this.properties + ", credentialProvider=" + this.credentialProvider + ", schemaRegistryClient=" + this.schemaRegistryClient + ")";
        }
    }

    private static class AwsDeserializerSchema {
        private final UUID schemaVersionId;
        private final Schema schema;

        AwsDeserializerSchema(UUID schemaVersionId, Schema schema) {
            this.schemaVersionId = schemaVersionId;
            this.schema = schema;
        }

        @Generated
        public UUID getSchemaVersionId() {
            return this.schemaVersionId;
        }

        @Generated
        public Schema getSchema() {
            return this.schema;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AwsDeserializerSchema)) {
                return false;
            }
            AwsDeserializerSchema other = (AwsDeserializerSchema)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$schemaVersionId = this.getSchemaVersionId();
            UUID other$schemaVersionId = other.getSchemaVersionId();
            if (this$schemaVersionId == null ? other$schemaVersionId != null : !((Object)this$schemaVersionId).equals(other$schemaVersionId)) {
                return false;
            }
            Schema this$schema = this.getSchema();
            Schema other$schema = other.getSchema();
            return !(this$schema == null ? other$schema != null : !this$schema.equals(other$schema));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AwsDeserializerSchema;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $schemaVersionId = this.getSchemaVersionId();
            result = result * 59 + ($schemaVersionId == null ? 43 : ((Object)$schemaVersionId).hashCode());
            Schema $schema = this.getSchema();
            result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GlueSchemaRegistryDeserializationFacade.AwsDeserializerSchema(schemaVersionId=" + this.getSchemaVersionId() + ", schema=" + this.getSchema() + ")";
        }
    }
}

