/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.serializers.avro;

import com.amazonaws.services.schemaregistry.common.GlueSchemaRegistryDataFormatSerializer;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.utils.AVROUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSerializer
implements GlueSchemaRegistryDataFormatSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AvroSerializer.class);
    private AVROUtils avroUtils = AVROUtils.getInstance();

    public byte[] serialize(Object data) {
        byte[] bytes = this.serialize(data, this.createDatumWriter(data));
        return bytes;
    }

    private DatumWriter<Object> createDatumWriter(Object object) {
        Schema schema = AVROUtils.getInstance().getSchema(object);
        if (object instanceof SpecificRecord) {
            return new SpecificDatumWriter(schema);
        }
        if (object instanceof GenericRecord) {
            return new GenericDatumWriter(schema);
        }
        if (object instanceof GenericData.EnumSymbol) {
            return new GenericDatumWriter(schema);
        }
        if (object instanceof GenericData.Array) {
            return new GenericDatumWriter(schema);
        }
        if (object instanceof GenericData.Fixed) {
            return new GenericDatumWriter(schema);
        }
        String message = String.format("Unsupported type passed for serialization: %s", object);
        throw new AWSSchemaRegistryException(message);
    }

    private byte[] serialize(Object data, DatumWriter<Object> writer) {
        return this.encodeData(data, writer);
    }

    private byte[] encodeData(Object object, DatumWriter<Object> writer) {
        ByteArrayOutputStream actualDataBytes = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)actualDataBytes, null);
        try {
            writer.write(object, (Encoder)encoder);
            encoder.flush();
        }
        catch (Exception e) {
            throw new AWSSchemaRegistryException(e.getMessage(), (Throwable)e);
        }
        return actualDataBytes.toByteArray();
    }

    public String getSchemaDefinition(@NonNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object is marked non-null but is null");
        }
        return this.avroUtils.getSchemaDefinition(object);
    }

    public void validate(Object data) {
    }

    public void validate(String schemaDefinition, byte[] data) {
    }
}

