/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers.avro;

import com.amazonaws.services.schemaregistry.common.GlueSchemaRegistryDataFormatDeserializer;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializerDataParser;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.utils.AVROUtils;
import com.amazonaws.services.schemaregistry.utils.AvroRecordType;
import java.io.IOException;
import java.nio.ByteBuffer;
import lombok.Generated;
import lombok.NonNull;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroDeserializer
implements GlueSchemaRegistryDataFormatDeserializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AvroDeserializer.class);
    private static final GlueSchemaRegistryDeserializerDataParser DESERIALIZER_DATA_PARSER = GlueSchemaRegistryDeserializerDataParser.getInstance();
    private static final AVROUtils AVRO_UTILS = AVROUtils.getInstance();
    private GlueSchemaRegistryConfiguration schemaRegistrySerDeConfigs;
    private AvroRecordType avroRecordType;

    public AvroDeserializer(GlueSchemaRegistryConfiguration configs) {
        this.schemaRegistrySerDeConfigs = configs;
        this.avroRecordType = configs.getAvroRecordType();
    }

    public Object deserialize(@NonNull ByteBuffer buffer, @NonNull String schema) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer is marked non-null but is null");
        }
        if (schema == null) {
            throw new IllegalArgumentException("schema is marked non-null but is null");
        }
        try {
            byte[] data = DESERIALIZER_DATA_PARSER.getPlainData(buffer);
            log.debug("Length of actual message: {}", (Object)data.length);
            Schema schemaDefinition = AVRO_UTILS.parseSchema(schema);
            DatumReader<Object> datumReader = this.createDatumReader(schemaDefinition);
            BinaryDecoder binaryDecoder = this.getBinaryDecoder(data, 0, data.length);
            Object result = datumReader.read(null, (Decoder)binaryDecoder);
            log.debug("Finished de-serializing Avro message");
            return result;
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            String message = String.format("Exception occurred while de-serializing Avro message", new Object[0]);
            throw new AWSSchemaRegistryException(message, (Throwable)e);
        }
    }

    private BinaryDecoder getBinaryDecoder(byte[] data, int start, int end) {
        return DecoderFactory.get().binaryDecoder(data, start, end, null);
    }

    public DatumReader<Object> createDatumReader(Schema writerSchema) throws InstantiationException, IllegalAccessException {
        switch (this.avroRecordType) {
            case SPECIFIC_RECORD: {
                Class readerClass = SpecificData.get().getClass(writerSchema);
                Schema readerSchema = ((SpecificRecord)readerClass.newInstance()).getSchema();
                log.debug("Using SpecificDatumReader for de-serializing Avro message, schema: {})", (Object)readerSchema.toString());
                return new SpecificDatumReader(writerSchema, readerSchema);
            }
            case GENERIC_RECORD: {
                log.debug("Using GenericDatumReader for de-serializing Avro message, schema: {})", (Object)writerSchema.toString());
                return new GenericDatumReader(writerSchema);
            }
        }
        String message = String.format("Data Format in configuration is not supported, Data Format: %s ", this.avroRecordType.getName());
        throw new UnsupportedOperationException(message);
    }

    @Generated
    public static AvroDeserializerBuilder builder() {
        return new AvroDeserializerBuilder();
    }

    @Generated
    public GlueSchemaRegistryConfiguration getSchemaRegistrySerDeConfigs() {
        return this.schemaRegistrySerDeConfigs;
    }

    @Generated
    public void setSchemaRegistrySerDeConfigs(GlueSchemaRegistryConfiguration schemaRegistrySerDeConfigs) {
        this.schemaRegistrySerDeConfigs = schemaRegistrySerDeConfigs;
    }

    @Generated
    public void setAvroRecordType(AvroRecordType avroRecordType) {
        this.avroRecordType = avroRecordType;
    }

    @Generated
    public static class AvroDeserializerBuilder {
        @Generated
        private GlueSchemaRegistryConfiguration configs;

        @Generated
        AvroDeserializerBuilder() {
        }

        @Generated
        public AvroDeserializerBuilder configs(GlueSchemaRegistryConfiguration configs) {
            this.configs = configs;
            return this;
        }

        @Generated
        public AvroDeserializer build() {
            return new AvroDeserializer(this.configs);
        }

        @Generated
        public String toString() {
            return "AvroDeserializer.AvroDeserializerBuilder(configs=" + this.configs + ")";
        }
    }
}

