/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.flink.avro;

import com.amazonaws.services.schemaregistry.flink.avro.GlueSchemaRegistryInputStreamDeserializer;
import com.amazonaws.services.schemaregistry.flink.avro.GlueSchemaRegistryOutputStreamSerializer;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.flink.formats.avro.SchemaCoder;

public class GlueSchemaRegistryAvroSchemaCoder
implements SchemaCoder {
    private GlueSchemaRegistryInputStreamDeserializer glueSchemaRegistryInputStreamDeserializer;
    private GlueSchemaRegistryOutputStreamSerializer glueSchemaRegistryOutputStreamSerializer;

    public GlueSchemaRegistryAvroSchemaCoder(String transportName, Map<String, Object> configs) {
        this.glueSchemaRegistryInputStreamDeserializer = new GlueSchemaRegistryInputStreamDeserializer(configs);
        this.glueSchemaRegistryOutputStreamSerializer = new GlueSchemaRegistryOutputStreamSerializer(transportName, configs);
    }

    @VisibleForTesting
    protected GlueSchemaRegistryAvroSchemaCoder(GlueSchemaRegistryInputStreamDeserializer glueSchemaRegistryInputStreamDeserializer) {
        this.glueSchemaRegistryInputStreamDeserializer = glueSchemaRegistryInputStreamDeserializer;
    }

    @VisibleForTesting
    protected GlueSchemaRegistryAvroSchemaCoder(GlueSchemaRegistryOutputStreamSerializer glueSchemaRegistryOutputStreamSerializer) {
        this.glueSchemaRegistryOutputStreamSerializer = glueSchemaRegistryOutputStreamSerializer;
    }

    public Schema readSchema(InputStream in) throws IOException {
        return this.glueSchemaRegistryInputStreamDeserializer.getSchemaAndDeserializedStream(in);
    }

    public void writeSchema(Schema schema, OutputStream out) throws IOException {
        byte[] data = ((ByteArrayOutputStream)out).toByteArray();
        ((ByteArrayOutputStream)out).reset();
        this.glueSchemaRegistryOutputStreamSerializer.registerSchemaAndSerializeStream(schema, out, data);
    }
}

