/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.flink.avro;

import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.serializers.GlueSchemaRegistrySerializationFacade;
import com.amazonaws.services.schemaregistry.utils.GlueSchemaRegistryUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avro.Schema;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.services.glue.model.DataFormat;

public class GlueSchemaRegistryOutputStreamSerializer {
    private final String transportName;
    private final Map<String, Object> configs;
    private final GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade;

    public GlueSchemaRegistryOutputStreamSerializer(String transportName, Map<String, Object> configs) {
        this(transportName, configs, null);
    }

    public GlueSchemaRegistryOutputStreamSerializer(String transportName, Map<String, Object> configs, GlueSchemaRegistrySerializationFacade glueSchemaRegistrySerializationFacade) {
        this.transportName = transportName;
        this.configs = configs;
        GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration = new GlueSchemaRegistryConfiguration(configs);
        glueSchemaRegistryConfiguration.setUserAgentApp("flink");
        this.glueSchemaRegistrySerializationFacade = glueSchemaRegistrySerializationFacade != null ? glueSchemaRegistrySerializationFacade : GlueSchemaRegistrySerializationFacade.builder().credentialProvider((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build()).glueSchemaRegistryConfiguration(new GlueSchemaRegistryConfiguration(configs)).build();
    }

    public void registerSchemaAndSerializeStream(Schema schema, OutputStream out, byte[] data) throws IOException {
        byte[] bytes = this.glueSchemaRegistrySerializationFacade.encode(this.transportName, new com.amazonaws.services.schemaregistry.common.Schema(schema.toString(), DataFormat.AVRO.toString(), this.getSchemaName()), data);
        out.write(bytes);
    }

    private String getSchemaName() {
        String schemaName = GlueSchemaRegistryUtils.getInstance().getSchemaName(this.configs);
        return schemaName != null ? schemaName : GlueSchemaRegistryUtils.getInstance().configureSchemaNamingStrategy(this.configs).getSchemaName(this.transportName);
    }
}

