/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.flink.avro;

import com.amazonaws.services.schemaregistry.flink.avro.GlueSchemaRegistryAvroSchemaCoderProvider;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.formats.avro.RegistryAvroSerializationSchema;
import org.apache.flink.formats.avro.SchemaCoder;

public class GlueSchemaRegistryAvroSerializationSchema<T>
extends RegistryAvroSerializationSchema<T> {
    private GlueSchemaRegistryAvroSerializationSchema(Class<T> recordClazz, @Nullable Schema reader, SchemaCoder.SchemaCoderProvider schemaCoderProvider) {
        super(recordClazz, reader, schemaCoderProvider);
    }

    @VisibleForTesting
    protected GlueSchemaRegistryAvroSerializationSchema(Class<T> recordClazz, @Nullable Schema reader, SchemaCoder schemaCoder) {
        super(recordClazz, reader, null);
        this.schemaCoder = schemaCoder;
    }

    public static GlueSchemaRegistryAvroSerializationSchema<GenericRecord> forGeneric(Schema schema, String transportName, Map<String, Object> configs) {
        return new GlueSchemaRegistryAvroSerializationSchema<GenericRecord>(GenericRecord.class, schema, new GlueSchemaRegistryAvroSchemaCoderProvider(transportName, configs));
    }

    public static <T extends SpecificRecord> GlueSchemaRegistryAvroSerializationSchema<T> forSpecific(Class<T> clazz, String transportName, Map<String, Object> configs) {
        return new GlueSchemaRegistryAvroSerializationSchema<T>(clazz, null, new GlueSchemaRegistryAvroSchemaCoderProvider(transportName, configs));
    }

    public byte[] serialize(T object) {
        this.checkAvroInitialized();
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = this.getOutputStream();
        outputStream.reset();
        BinaryEncoder encoder = this.getEncoder();
        this.getDatumWriter().write(object, (Encoder)encoder);
        this.schemaCoder.writeSchema(this.getSchema(), (OutputStream)outputStream);
        encoder.flush();
        return outputStream.toByteArray();
    }
}

