/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.common.configs;

import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.utils.AWSSchemaRegistryConstants;
import com.amazonaws.services.schemaregistry.utils.AvroRecordType;
import com.amazonaws.services.schemaregistry.utils.GlueSchemaRegistryUtils;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.glue.model.Compatibility;

public class GlueSchemaRegistryConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlueSchemaRegistryConfiguration.class);
    private static final String DELIMITER = "-";
    private AWSSchemaRegistryConstants.COMPRESSION compressionType = AWSSchemaRegistryConstants.COMPRESSION.NONE;
    private String endPoint;
    private String region;
    private long timeToLiveMillis = 86400000L;
    private int cacheSize = 200;
    private AvroRecordType avroRecordType;
    private String registryName;
    private Compatibility compatibilitySetting;
    private String description;
    private boolean schemaAutoRegistrationEnabled = false;
    private Map<String, String> tags = new HashMap<String, String>();
    private Map<String, String> metadata;
    private List<SerializationFeature> jacksonSerializationFeatures;
    private List<DeserializationFeature> jacksonDeserializationFeatures;

    public GlueSchemaRegistryConfiguration(String region) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("region", region);
        this.buildConfigs(config);
    }

    public GlueSchemaRegistryConfiguration(Map<String, ?> configs) {
        this.buildConfigs(configs);
    }

    public GlueSchemaRegistryConfiguration(Properties properties) {
        this.buildConfigs(this.getMapFromPropertiesFile(properties));
    }

    private void buildConfigs(Map<String, ?> configs) {
        this.buildSchemaRegistryConfigs(configs);
        this.buildCacheConfigs(configs);
    }

    private void buildSchemaRegistryConfigs(Map<String, ?> configs) {
        this.validateAndSetAWSRegion(configs);
        this.validateAndSetAWSEndpoint(configs);
        this.validateAndSetRegistryName(configs);
        this.validateAndSetDescription(configs);
        this.validateAndSetAvroRecordType(configs);
        this.validateAndSetCompatibility(configs);
        this.validateAndSetCompressionType(configs);
        this.validateAndSetSchemaAutoRegistrationSetting(configs);
        this.validateAndSetJacksonSerializationFeatures(configs);
        this.validateAndSetJacksonDeserializationFeatures(configs);
        this.validateAndSetTags(configs);
        this.validateAndSetMetadata(configs);
    }

    private void buildCacheConfigs(Map<String, ?> configs) {
        this.validateAndSetCacheSize(configs);
        this.validateAndSetCacheTTL(configs);
    }

    private void validateAndSetCompressionType(Map<String, ?> configs) {
        if (this.isPresent(configs, "compression") && this.validateCompressionType((String)configs.get("compression"))) {
            this.compressionType = AWSSchemaRegistryConstants.COMPRESSION.valueOf(((String)configs.get("compression")).toUpperCase());
        }
    }

    private boolean validateCompressionType(String compressionType) {
        if (!EnumUtils.isValidEnum(AWSSchemaRegistryConstants.COMPRESSION.class, (String)compressionType.toUpperCase())) {
            String errorMessage = String.format("Invalid Compression type : %s, Accepted values are : %s", new Object[]{compressionType, AWSSchemaRegistryConstants.COMPRESSION.values()});
            throw new AWSSchemaRegistryException(errorMessage);
        }
        return true;
    }

    private void validateAndSetAWSRegion(Map<String, ?> configs) {
        if (!this.isPresent(configs, "region")) {
            throw new AWSSchemaRegistryException("Region is not defined in the properties");
        }
        this.region = String.valueOf(configs.get("region"));
    }

    private void validateAndSetCompatibility(Map<String, ?> configs) {
        if (this.isPresent(configs, "compatibility")) {
            this.compatibilitySetting = Compatibility.fromValue((String)String.valueOf(configs.get("compatibility")).toUpperCase());
            if (this.compatibilitySetting == null || this.compatibilitySetting == Compatibility.UNKNOWN_TO_SDK_VERSION) {
                String errorMessage = String.format("Invalid compatibility setting : %s, Accepted values are : %s", configs.get("compatibility"), Compatibility.knownValues());
                throw new AWSSchemaRegistryException(errorMessage);
            }
        } else {
            this.compatibilitySetting = AWSSchemaRegistryConstants.DEFAULT_COMPATIBILITY_SETTING;
        }
    }

    private void validateAndSetRegistryName(Map<String, ?> configs) {
        this.registryName = this.isPresent(configs, "registry.name") ? String.valueOf(configs.get("registry.name")) : "default-registry";
    }

    private void validateAndSetAWSEndpoint(Map<String, ?> configs) {
        if (this.isPresent(configs, "endpoint")) {
            this.endPoint = String.valueOf(configs.get("endpoint"));
        }
    }

    private void validateAndSetDescription(Map<String, ?> configs) throws AWSSchemaRegistryException {
        this.description = this.isPresent(configs, "description") ? String.valueOf(configs.get("description")) : this.buildDescriptionFromProperties();
    }

    private void validateAndSetCacheSize(Map<String, ?> configs) {
        if (this.isPresent(configs, "cacheSize")) {
            String value = (String)configs.get("cacheSize");
            try {
                this.cacheSize = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                String message = String.format("Cache size property is not a valid size : %s", value);
                throw new AWSSchemaRegistryException(message, e);
            }
        } else {
            log.info("Cache Size is not found, using default {}", (Object)this.cacheSize);
        }
    }

    private void validateAndSetCacheTTL(Map<String, ?> configs) {
        if (this.isPresent(configs, "timeToLiveMillis")) {
            String value = (String)configs.get("timeToLiveMillis");
            try {
                this.timeToLiveMillis = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                String message = String.format("Time to live cache property is not a valid time : %s", value);
                throw new AWSSchemaRegistryException(message, e);
            }
        } else {
            log.info("Cache Time to live is not found, using default {}", (Object)this.timeToLiveMillis);
        }
    }

    private void validateAndSetAvroRecordType(Map<String, ?> configs) {
        if (this.isPresent(configs, "avroRecordType")) {
            this.avroRecordType = AvroRecordType.valueOf((String)configs.get("avroRecordType"));
        }
    }

    private void validateAndSetSchemaAutoRegistrationSetting(Map<String, ?> configs) {
        if (this.isPresent(configs, "schemaAutoRegistrationEnabled")) {
            this.schemaAutoRegistrationEnabled = Boolean.parseBoolean(configs.get("schemaAutoRegistrationEnabled").toString());
        } else {
            log.info("schemaAutoRegistrationEnabled is not defined in the properties. Using the default value {}", (Object)this.schemaAutoRegistrationEnabled);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateAndSetTags(Map<String, ?> configs) throws AWSSchemaRegistryException {
        if (this.isPresent(configs, "tags")) {
            Map tagsMap;
            if (!(configs.get("tags") instanceof HashMap)) throw new AWSSchemaRegistryException("The tag config is not a instance of HashMap.");
            this.tags = tagsMap = (Map)configs.get("tags");
            return;
        } else {
            log.info("Tags value is not defined in the properties. No tags are assigned");
        }
    }

    private void validateAndSetMetadata(Map<String, ?> configs) {
        if (this.isPresent(configs, "metadata")) {
            if (configs.get("metadata") instanceof HashMap) {
                Map map;
                this.metadata = map = (Map)configs.get("metadata");
            } else {
                throw new AWSSchemaRegistryException("The metadata instance is not a hash map");
            }
        }
    }

    private void validateAndSetJacksonSerializationFeatures(Map<String, ?> configs) {
        if (this.isPresent(configs, "jacksonSerializationFeatures")) {
            if (configs.get("jacksonSerializationFeatures") instanceof List) {
                List serialzationFeatures = (List)configs.get("jacksonSerializationFeatures");
                this.jacksonSerializationFeatures = serialzationFeatures.stream().map(sf -> SerializationFeature.valueOf((String)sf)).collect(Collectors.toList());
            } else {
                throw new AWSSchemaRegistryException("Jackson Serialization features should be a list");
            }
        }
    }

    private void validateAndSetJacksonDeserializationFeatures(Map<String, ?> configs) {
        if (this.isPresent(configs, "jacksonDeserializationFeatures")) {
            if (configs.get("jacksonDeserializationFeatures") instanceof List) {
                List deserialzationFeatures = (List)configs.get("jacksonDeserializationFeatures");
                this.jacksonDeserializationFeatures = deserialzationFeatures.stream().map(dsf -> DeserializationFeature.valueOf((String)dsf)).collect(Collectors.toList());
            } else {
                throw new AWSSchemaRegistryException("Jackson Deserialization features should be a list");
            }
        }
    }

    private boolean isPresent(Map<String, ?> configs, String key) {
        if (!GlueSchemaRegistryUtils.getInstance().checkIfPresentInMap(configs, key)) {
            log.info("{} key is not present in the configs {}", (Object)key, configs);
            return false;
        }
        return true;
    }

    private Map<String, ?> getMapFromPropertiesFile(Properties properties) {
        return new HashMap<String, Object>(properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue())));
    }

    private String buildDescriptionFromProperties() throws AWSSchemaRegistryException {
        StringBuilder message = new StringBuilder();
        message.append("DEFAULT-DESCRIPTION").append(DELIMITER).append(this.region).append(DELIMITER).append(this.registryName);
        return message.toString();
    }

    @Generated
    public AWSSchemaRegistryConstants.COMPRESSION getCompressionType() {
        return this.compressionType;
    }

    @Generated
    public String getEndPoint() {
        return this.endPoint;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public long getTimeToLiveMillis() {
        return this.timeToLiveMillis;
    }

    @Generated
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Generated
    public AvroRecordType getAvroRecordType() {
        return this.avroRecordType;
    }

    @Generated
    public String getRegistryName() {
        return this.registryName;
    }

    @Generated
    public Compatibility getCompatibilitySetting() {
        return this.compatibilitySetting;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isSchemaAutoRegistrationEnabled() {
        return this.schemaAutoRegistrationEnabled;
    }

    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public List<SerializationFeature> getJacksonSerializationFeatures() {
        return this.jacksonSerializationFeatures;
    }

    @Generated
    public List<DeserializationFeature> getJacksonDeserializationFeatures() {
        return this.jacksonDeserializationFeatures;
    }

    @Generated
    public void setCompressionType(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        this.compressionType = compressionType;
    }

    @Generated
    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    @Generated
    public void setRegion(String region) {
        this.region = region;
    }

    @Generated
    public void setTimeToLiveMillis(long timeToLiveMillis) {
        this.timeToLiveMillis = timeToLiveMillis;
    }

    @Generated
    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    @Generated
    public void setAvroRecordType(AvroRecordType avroRecordType) {
        this.avroRecordType = avroRecordType;
    }

    @Generated
    public void setRegistryName(String registryName) {
        this.registryName = registryName;
    }

    @Generated
    public void setCompatibilitySetting(Compatibility compatibilitySetting) {
        this.compatibilitySetting = compatibilitySetting;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setSchemaAutoRegistrationEnabled(boolean schemaAutoRegistrationEnabled) {
        this.schemaAutoRegistrationEnabled = schemaAutoRegistrationEnabled;
    }

    @Generated
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setJacksonSerializationFeatures(List<SerializationFeature> jacksonSerializationFeatures) {
        this.jacksonSerializationFeatures = jacksonSerializationFeatures;
    }

    @Generated
    public void setJacksonDeserializationFeatures(List<DeserializationFeature> jacksonDeserializationFeatures) {
        this.jacksonDeserializationFeatures = jacksonDeserializationFeatures;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlueSchemaRegistryConfiguration)) {
            return false;
        }
        GlueSchemaRegistryConfiguration other = (GlueSchemaRegistryConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeToLiveMillis() != other.getTimeToLiveMillis()) {
            return false;
        }
        if (this.getCacheSize() != other.getCacheSize()) {
            return false;
        }
        if (this.isSchemaAutoRegistrationEnabled() != other.isSchemaAutoRegistrationEnabled()) {
            return false;
        }
        AWSSchemaRegistryConstants.COMPRESSION this$compressionType = this.getCompressionType();
        AWSSchemaRegistryConstants.COMPRESSION other$compressionType = other.getCompressionType();
        if (this$compressionType == null ? other$compressionType != null : !((Object)((Object)this$compressionType)).equals((Object)other$compressionType)) {
            return false;
        }
        String this$endPoint = this.getEndPoint();
        String other$endPoint = other.getEndPoint();
        if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        AvroRecordType this$avroRecordType = this.getAvroRecordType();
        AvroRecordType other$avroRecordType = other.getAvroRecordType();
        if (this$avroRecordType == null ? other$avroRecordType != null : !((Object)((Object)this$avroRecordType)).equals((Object)other$avroRecordType)) {
            return false;
        }
        String this$registryName = this.getRegistryName();
        String other$registryName = other.getRegistryName();
        if (this$registryName == null ? other$registryName != null : !this$registryName.equals(other$registryName)) {
            return false;
        }
        Compatibility this$compatibilitySetting = this.getCompatibilitySetting();
        Compatibility other$compatibilitySetting = other.getCompatibilitySetting();
        if (this$compatibilitySetting == null ? other$compatibilitySetting != null : !this$compatibilitySetting.equals(other$compatibilitySetting)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        List<SerializationFeature> this$jacksonSerializationFeatures = this.getJacksonSerializationFeatures();
        List<SerializationFeature> other$jacksonSerializationFeatures = other.getJacksonSerializationFeatures();
        if (this$jacksonSerializationFeatures == null ? other$jacksonSerializationFeatures != null : !((Object)this$jacksonSerializationFeatures).equals(other$jacksonSerializationFeatures)) {
            return false;
        }
        List<DeserializationFeature> this$jacksonDeserializationFeatures = this.getJacksonDeserializationFeatures();
        List<DeserializationFeature> other$jacksonDeserializationFeatures = other.getJacksonDeserializationFeatures();
        return !(this$jacksonDeserializationFeatures == null ? other$jacksonDeserializationFeatures != null : !((Object)this$jacksonDeserializationFeatures).equals(other$jacksonDeserializationFeatures));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GlueSchemaRegistryConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeToLiveMillis = this.getTimeToLiveMillis();
        result = result * 59 + (int)($timeToLiveMillis >>> 32 ^ $timeToLiveMillis);
        result = result * 59 + this.getCacheSize();
        result = result * 59 + (this.isSchemaAutoRegistrationEnabled() ? 79 : 97);
        AWSSchemaRegistryConstants.COMPRESSION $compressionType = this.getCompressionType();
        result = result * 59 + ($compressionType == null ? 43 : ((Object)((Object)$compressionType)).hashCode());
        String $endPoint = this.getEndPoint();
        result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        AvroRecordType $avroRecordType = this.getAvroRecordType();
        result = result * 59 + ($avroRecordType == null ? 43 : ((Object)((Object)$avroRecordType)).hashCode());
        String $registryName = this.getRegistryName();
        result = result * 59 + ($registryName == null ? 43 : $registryName.hashCode());
        Compatibility $compatibilitySetting = this.getCompatibilitySetting();
        result = result * 59 + ($compatibilitySetting == null ? 43 : $compatibilitySetting.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        List<SerializationFeature> $jacksonSerializationFeatures = this.getJacksonSerializationFeatures();
        result = result * 59 + ($jacksonSerializationFeatures == null ? 43 : ((Object)$jacksonSerializationFeatures).hashCode());
        List<DeserializationFeature> $jacksonDeserializationFeatures = this.getJacksonDeserializationFeatures();
        result = result * 59 + ($jacksonDeserializationFeatures == null ? 43 : ((Object)$jacksonDeserializationFeatures).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GlueSchemaRegistryConfiguration(compressionType=" + (Object)((Object)this.getCompressionType()) + ", endPoint=" + this.getEndPoint() + ", region=" + this.getRegion() + ", timeToLiveMillis=" + this.getTimeToLiveMillis() + ", cacheSize=" + this.getCacheSize() + ", avroRecordType=" + (Object)((Object)this.getAvroRecordType()) + ", registryName=" + this.getRegistryName() + ", compatibilitySetting=" + this.getCompatibilitySetting() + ", description=" + this.getDescription() + ", schemaAutoRegistrationEnabled=" + this.isSchemaAutoRegistrationEnabled() + ", tags=" + this.getTags() + ", metadata=" + this.getMetadata() + ", jacksonSerializationFeatures=" + this.getJacksonSerializationFeatures() + ", jacksonDeserializationFeatures=" + this.getJacksonDeserializationFeatures() + ")";
    }
}

