/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.Cipher;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.services.s3.model.SdkPartType;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;
import software.amazon.encryption.s3.internal.ApiNameVersion;
import software.amazon.encryption.s3.internal.AuthenticatedCipherInputStream;
import software.amazon.encryption.s3.internal.CipherAsyncRequestBody;
import software.amazon.encryption.s3.internal.ContentMetadataEncodingStrategy;
import software.amazon.encryption.s3.internal.InstructionFileConfig;
import software.amazon.encryption.s3.internal.MultipartContentEncryptionStrategy;
import software.amazon.encryption.s3.internal.MultipartEncryptedContent;
import software.amazon.encryption.s3.internal.MultipartUploadMaterials;
import software.amazon.encryption.s3.internal.NoRetriesAsyncRequestBody;
import software.amazon.encryption.s3.internal.StreamingAesGcmContentStrategy;
import software.amazon.encryption.s3.materials.CryptographicMaterialsManager;
import software.amazon.encryption.s3.materials.EncryptionMaterials;
import software.amazon.encryption.s3.materials.EncryptionMaterialsRequest;

public class MultipartUploadObjectPipeline {
    private final S3AsyncClient _s3AsyncClient;
    private final CryptographicMaterialsManager _cryptoMaterialsManager;
    private final MultipartContentEncryptionStrategy _contentEncryptionStrategy;
    private final ContentMetadataEncodingStrategy _contentMetadataEncodingStrategy;
    private final InstructionFileConfig _instructionFileConfig;
    private final Map<String, MultipartUploadMaterials> _multipartUploadMaterials;

    private MultipartUploadObjectPipeline(Builder builder) {
        this._s3AsyncClient = builder._s3AsyncClient;
        this._cryptoMaterialsManager = builder._cryptoMaterialsManager;
        this._contentEncryptionStrategy = builder._contentEncryptionStrategy;
        this._contentMetadataEncodingStrategy = builder._contentMetadataEncodingStrategy;
        this._multipartUploadMaterials = builder._multipartUploadMaterials;
        this._instructionFileConfig = builder._instructionFileConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateMultipartUploadResponse createMultipartUpload(CreateMultipartUploadRequest request) {
        EncryptionMaterialsRequest.Builder requestBuilder = EncryptionMaterialsRequest.builder().s3Request((S3Request)request);
        EncryptionMaterials materials = this._cryptoMaterialsManager.getEncryptionMaterials(requestBuilder.build());
        MultipartEncryptedContent encryptedContent = this._contentEncryptionStrategy.initMultipartEncryption(materials);
        CreateMultipartUploadRequest createMpuRequest = this._contentMetadataEncodingStrategy.encodeMetadata(materials, encryptedContent.getIv(), request);
        request = (CreateMultipartUploadRequest)createMpuRequest.toBuilder().overrideConfiguration(ApiNameVersion.API_NAME_INTERCEPTOR).build();
        CreateMultipartUploadResponse response = (CreateMultipartUploadResponse)this._s3AsyncClient.createMultipartUpload(request).join();
        MultipartUploadMaterials mpuMaterials = MultipartUploadMaterials.builder().fromEncryptionMaterials(materials).cipher(encryptedContent.getCipher()).build();
        this._multipartUploadMaterials.put(response.uploadId(), mpuMaterials);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadPartResponse uploadPart(UploadPartRequest request, RequestBody requestBody) throws AwsServiceException, SdkClientException {
        UploadPartResponse response;
        boolean partSizeMultipleOfCipherBlockSize;
        long partContentLength;
        AlgorithmSuite algorithmSuite = AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF;
        int blockSize = algorithmSuite.cipherBlockSizeBytes();
        if (request.contentLength() != null) {
            if (requestBody.optionalContentLength().isPresent() && !request.contentLength().equals(requestBody.optionalContentLength().get())) {
                throw new S3EncryptionClientException("The contentLength provided in the request object MUST match the contentLength in the request body");
            }
            partContentLength = !requestBody.optionalContentLength().isPresent() ? request.contentLength().longValue() : request.contentLength().longValue();
        } else {
            partContentLength = requestBody.optionalContentLength().orElse(-1L);
        }
        boolean isLastPart = request.sdkPartType() != null && request.sdkPartType().equals((Object)SdkPartType.LAST);
        int cipherTagLength = isLastPart ? algorithmSuite.cipherTagLengthBytes() : 0;
        long ciphertextLength = partContentLength + (long)cipherTagLength;
        boolean bl = partSizeMultipleOfCipherBlockSize = 0L == partContentLength % (long)blockSize;
        if (!isLastPart && !partSizeMultipleOfCipherBlockSize) {
            throw new S3EncryptionClientException("Invalid part size: part sizes for encrypted multipart uploads must be multiples of the cipher block size (" + blockSize + ") with the exception of the last part.");
        }
        UploadPartRequest actualRequest = (UploadPartRequest)request.toBuilder().overrideConfiguration(ApiNameVersion.API_NAME_INTERCEPTOR).contentLength(Long.valueOf(ciphertextLength)).build();
        String uploadId = actualRequest.uploadId();
        MultipartUploadMaterials materials = this._multipartUploadMaterials.get(uploadId);
        if (materials == null) {
            throw new S3EncryptionClientException("No client-side information available on upload ID " + uploadId);
        }
        materials.beginPartUpload(actualRequest.partNumber(), partContentLength);
        Cipher cipher = materials.getCipher(materials.getIv());
        ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
        try {
            CipherAsyncRequestBody cipherAsyncRequestBody = new CipherAsyncRequestBody(AsyncRequestBody.fromInputStream((InputStream)requestBody.contentStreamProvider().newStream(), (Long)partContentLength, (ExecutorService)singleThreadExecutor), ciphertextLength, materials, cipher.getIV(), isLastPart);
            if (isLastPart && materials.hasFinalPartBeenSeen()) {
                throw new S3EncryptionClientException("This part was specified as the last part in a multipart upload, but a previous part was already marked as the last part. Only the last part of the upload should be marked as the last part.");
            }
            NoRetriesAsyncRequestBody noRetryBody = new NoRetriesAsyncRequestBody(cipherAsyncRequestBody);
            response = (UploadPartResponse)this._s3AsyncClient.uploadPart(actualRequest, (AsyncRequestBody)noRetryBody).join();
        }
        finally {
            materials.endPartUpload();
        }
        if (isLastPart) {
            materials.setHasFinalPartBeenSeen(true);
        }
        singleThreadExecutor.shutdown();
        return response;
    }

    public CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest request) throws AwsServiceException, SdkClientException {
        String uploadId = request.uploadId();
        MultipartUploadMaterials uploadContext = this._multipartUploadMaterials.get(uploadId);
        if (uploadContext != null && !uploadContext.hasFinalPartBeenSeen()) {
            throw new S3EncryptionClientException("Unable to complete an encrypted multipart upload without being told which part was the last.  Without knowing which part was the last, the encrypted data in Amazon S3 is incomplete and corrupt.");
        }
        CompleteMultipartUploadRequest actualRequest = (CompleteMultipartUploadRequest)request.toBuilder().overrideConfiguration(ApiNameVersion.API_NAME_INTERCEPTOR).build();
        CompleteMultipartUploadResponse response = (CompleteMultipartUploadResponse)this._s3AsyncClient.completeMultipartUpload(actualRequest).join();
        this._multipartUploadMaterials.remove(uploadId);
        return response;
    }

    public AbortMultipartUploadResponse abortMultipartUpload(AbortMultipartUploadRequest request) {
        this._multipartUploadMaterials.remove(request.uploadId());
        AbortMultipartUploadRequest actualRequest = (AbortMultipartUploadRequest)request.toBuilder().overrideConfiguration(ApiNameVersion.API_NAME_INTERCEPTOR).build();
        return (AbortMultipartUploadResponse)this._s3AsyncClient.abortMultipartUpload(actualRequest).join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLocalObject(RequestBody requestBody, String uploadId, OutputStream os) throws IOException {
        MultipartUploadMaterials materials = this._multipartUploadMaterials.get(uploadId);
        Cipher cipher = materials.getCipher(materials.getIv());
        AuthenticatedCipherInputStream cipherInputStream = new AuthenticatedCipherInputStream(requestBody.contentStreamProvider().newStream(), cipher);
        try {
            IoUtils.copy((InputStream)((Object)cipherInputStream), (OutputStream)os);
            materials.setHasFinalPartBeenSeen(true);
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)os, null);
        }
    }

    public static class Builder {
        private final Map<String, MultipartUploadMaterials> _multipartUploadMaterials = Collections.synchronizedMap(new HashMap());
        private ContentMetadataEncodingStrategy _contentMetadataEncodingStrategy;
        private S3AsyncClient _s3AsyncClient;
        private CryptographicMaterialsManager _cryptoMaterialsManager;
        private SecureRandom _secureRandom;
        private MultipartContentEncryptionStrategy _contentEncryptionStrategy;
        private InstructionFileConfig _instructionFileConfig;

        private Builder() {
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Pass mutability into wrapping client")
        public Builder s3AsyncClient(S3AsyncClient s3AsyncClient) {
            this._s3AsyncClient = s3AsyncClient;
            return this;
        }

        public Builder cryptoMaterialsManager(CryptographicMaterialsManager cryptoMaterialsManager) {
            this._cryptoMaterialsManager = cryptoMaterialsManager;
            return this;
        }

        public Builder secureRandom(SecureRandom secureRandom) {
            this._secureRandom = secureRandom;
            return this;
        }

        public Builder instructionFileConfig(InstructionFileConfig instructionFileConfig) {
            this._instructionFileConfig = instructionFileConfig;
            return this;
        }

        public MultipartUploadObjectPipeline build() {
            if (this._contentEncryptionStrategy == null) {
                this._contentEncryptionStrategy = StreamingAesGcmContentStrategy.builder().secureRandom(this._secureRandom).build();
            }
            if (this._instructionFileConfig == null) {
                this._instructionFileConfig = InstructionFileConfig.builder().build();
            }
            this._contentMetadataEncodingStrategy = new ContentMetadataEncodingStrategy(this._instructionFileConfig);
            return new MultipartUploadObjectPipeline(this);
        }
    }
}

