/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.crypto.SecretKey;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.services.s3.DelegatingS3Client;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.encryption.s3.S3AsyncEncryptionClient;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.S3EncryptionClientUtilities;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;
import software.amazon.encryption.s3.internal.ApiNameVersion;
import software.amazon.encryption.s3.internal.GetEncryptedObjectPipeline;
import software.amazon.encryption.s3.internal.MultiFileOutputStream;
import software.amazon.encryption.s3.internal.MultipartUploadObjectPipeline;
import software.amazon.encryption.s3.internal.PutEncryptedObjectPipeline;
import software.amazon.encryption.s3.internal.UploadObjectObserver;
import software.amazon.encryption.s3.materials.AesKeyring;
import software.amazon.encryption.s3.materials.CryptographicMaterialsManager;
import software.amazon.encryption.s3.materials.DefaultCryptoMaterialsManager;
import software.amazon.encryption.s3.materials.Keyring;
import software.amazon.encryption.s3.materials.KmsKeyring;
import software.amazon.encryption.s3.materials.MultipartConfiguration;
import software.amazon.encryption.s3.materials.PartialRsaKeyPair;
import software.amazon.encryption.s3.materials.RsaKeyring;

public class S3EncryptionClient
extends DelegatingS3Client {
    public static final ExecutionAttribute<Map<String, String>> ENCRYPTION_CONTEXT = new ExecutionAttribute("EncryptionContext");
    public static final ExecutionAttribute<MultipartConfiguration> CONFIGURATION = new ExecutionAttribute("MultipartConfiguration");
    private final S3Client _wrappedClient;
    private final S3AsyncClient _wrappedAsyncClient;
    private final CryptographicMaterialsManager _cryptoMaterialsManager;
    private final SecureRandom _secureRandom;
    private final boolean _enableLegacyUnauthenticatedModes;
    private final boolean _enableDelayedAuthenticationMode;
    private final boolean _enableMultipartPutObject;
    private final MultipartUploadObjectPipeline _multipartPipeline;
    private final long _bufferSize;

    private S3EncryptionClient(Builder builder) {
        super(builder._wrappedClient);
        this._wrappedClient = builder._wrappedClient;
        this._wrappedAsyncClient = builder._wrappedAsyncClient;
        this._cryptoMaterialsManager = builder._cryptoMaterialsManager;
        this._secureRandom = builder._secureRandom;
        this._enableLegacyUnauthenticatedModes = builder._enableLegacyUnauthenticatedModes;
        this._enableDelayedAuthenticationMode = builder._enableDelayedAuthenticationMode;
        this._enableMultipartPutObject = builder._enableMultipartPutObject;
        this._multipartPipeline = builder._multipartPipeline;
        this._bufferSize = builder._bufferSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Consumer<AwsRequestOverrideConfiguration.Builder> withAdditionalConfiguration(Map<String, String> encryptionContext) {
        return builder -> builder.putExecutionAttribute(ENCRYPTION_CONTEXT, (Object)encryptionContext);
    }

    public static Consumer<AwsRequestOverrideConfiguration.Builder> withAdditionalConfiguration(MultipartConfiguration multipartConfiguration) {
        return builder -> builder.putExecutionAttribute(CONFIGURATION, (Object)multipartConfiguration);
    }

    public static Consumer<AwsRequestOverrideConfiguration.Builder> withAdditionalConfiguration(Map<String, String> encryptionContext, MultipartConfiguration multipartConfiguration) {
        return builder -> ((AwsRequestOverrideConfiguration.Builder)builder.putExecutionAttribute(ENCRYPTION_CONTEXT, (Object)encryptionContext)).putExecutionAttribute(CONFIGURATION, (Object)multipartConfiguration);
    }

    public PutObjectResponse putObject(PutObjectRequest putObjectRequest, RequestBody requestBody) throws AwsServiceException, SdkClientException {
        if (this._enableMultipartPutObject) {
            try {
                CompleteMultipartUploadResponse completeResponse = this.multipartPutObject(putObjectRequest, requestBody);
                PutObjectResponse response = (PutObjectResponse)PutObjectResponse.builder().eTag(completeResponse.eTag()).build();
                return response;
            }
            catch (Throwable e) {
                throw new S3EncryptionClientException("Exception while performing Multipart Upload PutObject", e);
            }
        }
        PutEncryptedObjectPipeline pipeline = PutEncryptedObjectPipeline.builder().s3AsyncClient(this._wrappedAsyncClient).cryptoMaterialsManager(this._cryptoMaterialsManager).secureRandom(this._secureRandom).build();
        try {
            CompletableFuture<PutObjectResponse> futurePut = pipeline.putObject(putObjectRequest, AsyncRequestBody.fromInputStream((InputStream)requestBody.contentStreamProvider().newStream(), (Long)requestBody.optionalContentLength().orElse(-1L), (ExecutorService)Executors.newSingleThreadExecutor()));
            return futurePut.join();
        }
        catch (CompletionException completionException) {
            throw new S3EncryptionClientException(completionException.getMessage(), completionException.getCause());
        }
        catch (Exception exception) {
            throw new S3EncryptionClientException(exception.getMessage(), exception);
        }
    }

    public <T> T getObject(GetObjectRequest getObjectRequest, ResponseTransformer<GetObjectResponse, T> responseTransformer) throws AwsServiceException, SdkClientException {
        GetEncryptedObjectPipeline pipeline = GetEncryptedObjectPipeline.builder().s3AsyncClient(this._wrappedAsyncClient).cryptoMaterialsManager(this._cryptoMaterialsManager).enableLegacyUnauthenticatedModes(this._enableLegacyUnauthenticatedModes).enableDelayedAuthentication(this._enableDelayedAuthenticationMode).bufferSize(this._bufferSize).build();
        try {
            ResponseInputStream joinFutureGet = (ResponseInputStream)pipeline.getObject(getObjectRequest, AsyncResponseTransformer.toBlockingInputStream()).join();
            return (T)responseTransformer.transform((Object)((GetObjectResponse)joinFutureGet.response()), AbortableInputStream.create((InputStream)joinFutureGet));
        }
        catch (CompletionException e) {
            throw new S3EncryptionClientException(e.getCause().getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new S3EncryptionClientException("Unable to transform response.", e);
        }
    }

    private CompleteMultipartUploadResponse multipartPutObject(PutObjectRequest request, RequestBody requestBody) throws Throwable {
        boolean defaultExecutorService;
        long contentLength;
        if (request.contentLength() != null) {
            if (requestBody.optionalContentLength().isPresent() && !request.contentLength().equals(requestBody.optionalContentLength().get())) {
                throw new S3EncryptionClientException("The contentLength provided in the request object MUST match the contentLength in the request body");
            }
            contentLength = !requestBody.optionalContentLength().isPresent() ? request.contentLength().longValue() : request.contentLength().longValue();
        } else {
            contentLength = requestBody.optionalContentLength().orElse(-1L);
        }
        if (contentLength > AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF.cipherMaxContentLengthBytes()) {
            throw new S3EncryptionClientException("The contentLength of the object you are attempting to encrypt exceedsthe maximum length allowed for GCM encryption.");
        }
        MultipartConfiguration multipartConfiguration = request.overrideConfiguration().isPresent() ? ((AwsRequestOverrideConfiguration)request.overrideConfiguration().get()).executionAttributes().getOptionalAttribute(CONFIGURATION).orElse(MultipartConfiguration.builder().build()) : MultipartConfiguration.builder().build();
        ExecutorService es = multipartConfiguration.executorService();
        boolean bl = defaultExecutorService = es == null;
        if (es == null) {
            throw new S3EncryptionClientException("ExecutorService should not be null, Please initialize during MultipartConfiguration");
        }
        UploadObjectObserver observer = multipartConfiguration.uploadObjectObserver();
        if (observer == null) {
            throw new S3EncryptionClientException("UploadObjectObserver should not be null, Please initialize during MultipartConfiguration");
        }
        observer.init(request, this._wrappedAsyncClient, this, es);
        String uploadId = observer.onUploadCreation(request);
        ArrayList<CompletedPart> partETags = new ArrayList<CompletedPart>();
        MultiFileOutputStream outputStream = multipartConfiguration.multiFileOutputStream();
        if (outputStream == null) {
            throw new S3EncryptionClientException("MultiFileOutputStream should not be null, Please initialize during MultipartConfiguration");
        }
        try {
            outputStream.init(observer, multipartConfiguration.partSize(), multipartConfiguration.diskLimit());
            this._multipartPipeline.putLocalObject(requestBody, uploadId, outputStream);
            for (Future<Map<Integer, UploadPartResponse>> future : observer.futures()) {
                Map<Integer, UploadPartResponse> partResponseMap = future.get();
                partResponseMap.forEach((partNumber, uploadPartResponse) -> partETags.add((CompletedPart)CompletedPart.builder().partNumber(partNumber).eTag(uploadPartResponse.eTag()).build()));
            }
        }
        catch (IOException | Error | InterruptedException | RuntimeException | ExecutionException ex) {
            throw this.onAbort(observer, ex);
        }
        finally {
            if (defaultExecutorService) {
                es.shutdownNow();
            }
            outputStream.cleanup();
        }
        return observer.onCompletion(partETags);
    }

    private <T extends Throwable> T onAbort(UploadObjectObserver observer, T t) {
        observer.onAbort();
        throw new S3EncryptionClientException(t.getMessage(), t);
    }

    public DeleteObjectResponse deleteObject(DeleteObjectRequest deleteObjectRequest) throws AwsServiceException, SdkClientException {
        DeleteObjectRequest actualRequest = (DeleteObjectRequest)deleteObjectRequest.toBuilder().overrideConfiguration(ApiNameVersion.API_NAME_INTERCEPTOR).build();
        try {
            DeleteObjectResponse deleteObjectResponse = (DeleteObjectResponse)this._wrappedAsyncClient.deleteObject(actualRequest).join();
            String instructionObjectKey = deleteObjectRequest.key() + ".instruction";
            this._wrappedAsyncClient.deleteObject(builder -> builder.overrideConfiguration(ApiNameVersion.API_NAME_INTERCEPTOR).bucket(deleteObjectRequest.bucket()).key(instructionObjectKey)).join();
            return deleteObjectResponse;
        }
        catch (CompletionException e) {
            throw new S3EncryptionClientException(e.getCause().getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new S3EncryptionClientException("Unable to delete object.", e);
        }
    }

    public DeleteObjectsResponse deleteObjects(DeleteObjectsRequest deleteObjectsRequest) throws AwsServiceException, SdkClientException {
        DeleteObjectsRequest actualRequest = (DeleteObjectsRequest)deleteObjectsRequest.toBuilder().overrideConfiguration(ApiNameVersion.API_NAME_INTERCEPTOR).build();
        try {
            DeleteObjectsResponse deleteObjectsResponse = (DeleteObjectsResponse)this._wrappedAsyncClient.deleteObjects(actualRequest).join();
            List<ObjectIdentifier> deleteObjects = S3EncryptionClientUtilities.instructionFileKeysToDelete(deleteObjectsRequest);
            this._wrappedAsyncClient.deleteObjects((DeleteObjectsRequest)DeleteObjectsRequest.builder().overrideConfiguration(ApiNameVersion.API_NAME_INTERCEPTOR).bucket(deleteObjectsRequest.bucket()).delete(builder -> builder.objects((Collection)deleteObjects)).build()).join();
            return deleteObjectsResponse;
        }
        catch (CompletionException e) {
            throw new S3EncryptionClientException(e.getCause().getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new S3EncryptionClientException("Unable to delete objects.", e);
        }
    }

    public CreateMultipartUploadResponse createMultipartUpload(CreateMultipartUploadRequest request) {
        try {
            return this._multipartPipeline.createMultipartUpload(request);
        }
        catch (CompletionException e) {
            throw new S3EncryptionClientException(e.getCause().getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new S3EncryptionClientException("Unable to create Multipart upload.", e);
        }
    }

    public UploadPartResponse uploadPart(UploadPartRequest request, RequestBody requestBody) throws AwsServiceException, SdkClientException {
        try {
            return this._multipartPipeline.uploadPart(request, requestBody);
        }
        catch (CompletionException e) {
            throw new S3EncryptionClientException(e.getCause().getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new S3EncryptionClientException("Unable to upload part.", e);
        }
    }

    public CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest request) throws AwsServiceException, SdkClientException {
        try {
            return this._multipartPipeline.completeMultipartUpload(request);
        }
        catch (CompletionException e) {
            throw new S3EncryptionClientException(e.getCause().getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new S3EncryptionClientException("Unable to complete Multipart upload.", e);
        }
    }

    public AbortMultipartUploadResponse abortMultipartUpload(AbortMultipartUploadRequest request) throws AwsServiceException, SdkClientException {
        try {
            return this._multipartPipeline.abortMultipartUpload(request);
        }
        catch (CompletionException e) {
            throw new S3EncryptionClientException(e.getCause().getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new S3EncryptionClientException("Unable to abort Multipart upload.", e);
        }
    }

    public void close() {
        this._wrappedClient.close();
        this._wrappedAsyncClient.close();
    }

    public static class Builder {
        private S3Client _wrappedClient;
        private S3AsyncClient _wrappedAsyncClient;
        private MultipartUploadObjectPipeline _multipartPipeline;
        private CryptographicMaterialsManager _cryptoMaterialsManager;
        private Keyring _keyring;
        private SecretKey _aesKey;
        private PartialRsaKeyPair _rsaKeyPair;
        private String _kmsKeyId;
        private boolean _enableLegacyWrappingAlgorithms = false;
        private boolean _enableDelayedAuthenticationMode = false;
        private boolean _enableMultipartPutObject = false;
        private Provider _cryptoProvider = null;
        private SecureRandom _secureRandom = new SecureRandom();
        private boolean _enableLegacyUnauthenticatedModes = false;
        private long _bufferSize = -1L;

        private Builder() {
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Pass mutability into wrapping client")
        public Builder wrappedClient(S3Client _wrappedClient) {
            if (_wrappedClient instanceof S3EncryptionClient) {
                throw new S3EncryptionClientException("Cannot use S3EncryptionClient as wrapped client");
            }
            this._wrappedClient = _wrappedClient;
            return this;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Pass mutability into wrapping client")
        public Builder wrappedAsyncClient(S3AsyncClient _wrappedAsyncClient) {
            if (_wrappedAsyncClient instanceof S3AsyncEncryptionClient) {
                throw new S3EncryptionClientException("Cannot use S3AsyncEncryptionClient as wrapped client");
            }
            this._wrappedAsyncClient = _wrappedAsyncClient;
            return this;
        }

        public Builder cryptoMaterialsManager(CryptographicMaterialsManager cryptoMaterialsManager) {
            this._cryptoMaterialsManager = cryptoMaterialsManager;
            this.checkKeyOptions();
            return this;
        }

        public Builder keyring(Keyring keyring) {
            this._keyring = keyring;
            this.checkKeyOptions();
            return this;
        }

        public Builder aesKey(SecretKey aesKey) {
            this._aesKey = aesKey;
            this.checkKeyOptions();
            return this;
        }

        public Builder rsaKeyPair(KeyPair rsaKeyPair) {
            this._rsaKeyPair = new PartialRsaKeyPair(rsaKeyPair);
            this.checkKeyOptions();
            return this;
        }

        public Builder rsaKeyPair(PartialRsaKeyPair partialRsaKeyPair) {
            this._rsaKeyPair = partialRsaKeyPair;
            this.checkKeyOptions();
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this._kmsKeyId = kmsKeyId;
            this.checkKeyOptions();
            return this;
        }

        private void checkKeyOptions() {
            if (this.onlyOneNonNull(this._cryptoMaterialsManager, this._keyring, this._aesKey, this._rsaKeyPair, this._kmsKeyId)) {
                return;
            }
            throw new S3EncryptionClientException("Only one may be set of: crypto materials manager, keyring, AES key, RSA key pair, KMS key id");
        }

        private boolean onlyOneNonNull(Object ... values) {
            boolean haveOneNonNull = false;
            for (Object o : values) {
                if (o == null) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }

        public Builder enableLegacyWrappingAlgorithms(boolean shouldEnableLegacyWrappingAlgorithms) {
            this._enableLegacyWrappingAlgorithms = shouldEnableLegacyWrappingAlgorithms;
            return this;
        }

        public Builder enableLegacyUnauthenticatedModes(boolean shouldEnableLegacyUnauthenticatedModes) {
            this._enableLegacyUnauthenticatedModes = shouldEnableLegacyUnauthenticatedModes;
            return this;
        }

        public Builder enableDelayedAuthenticationMode(boolean shouldEnableDelayedAuthenticationMode) {
            this._enableDelayedAuthenticationMode = shouldEnableDelayedAuthenticationMode;
            return this;
        }

        public Builder enableMultipartPutObject(boolean _enableMultipartPutObject) {
            this._enableMultipartPutObject = _enableMultipartPutObject;
            return this;
        }

        public Builder setBufferSize(long bufferSize) {
            if (bufferSize < S3EncryptionClientUtilities.MIN_ALLOWED_BUFFER_SIZE_BYTES || bufferSize > S3EncryptionClientUtilities.MAX_ALLOWED_BUFFER_SIZE_BYTES) {
                throw new S3EncryptionClientException("Invalid buffer size: " + bufferSize + " Bytes. Buffer size must be between " + S3EncryptionClientUtilities.MIN_ALLOWED_BUFFER_SIZE_BYTES + " and " + S3EncryptionClientUtilities.MAX_ALLOWED_BUFFER_SIZE_BYTES + " Bytes.");
            }
            this._bufferSize = bufferSize;
            return this;
        }

        public Builder cryptoProvider(Provider cryptoProvider) {
            this._cryptoProvider = cryptoProvider;
            return this;
        }

        public Builder secureRandom(SecureRandom secureRandom) {
            if (secureRandom == null) {
                throw new S3EncryptionClientException("SecureRandom provided to S3EncryptionClient cannot be null");
            }
            this._secureRandom = secureRandom;
            return this;
        }

        public S3EncryptionClient build() {
            if (!this.onlyOneNonNull(this._cryptoMaterialsManager, this._keyring, this._aesKey, this._rsaKeyPair, this._kmsKeyId)) {
                throw new S3EncryptionClientException("Exactly one must be set of: crypto materials manager, keyring, AES key, RSA key pair, KMS key id");
            }
            if (this._bufferSize >= 0L) {
                if (this._enableDelayedAuthenticationMode) {
                    throw new S3EncryptionClientException("Buffer size cannot be set when delayed authentication mode is enabled");
                }
            } else {
                this._bufferSize = 0x4000000L;
            }
            if (this._wrappedClient == null) {
                this._wrappedClient = S3Client.create();
            }
            if (this._wrappedAsyncClient == null) {
                this._wrappedAsyncClient = S3AsyncClient.create();
            }
            if (this._keyring == null) {
                if (this._aesKey != null) {
                    this._keyring = ((AesKeyring.Builder)((AesKeyring.Builder)AesKeyring.builder().wrappingKey(this._aesKey).enableLegacyWrappingAlgorithms(this._enableLegacyWrappingAlgorithms)).secureRandom(this._secureRandom)).build();
                } else if (this._rsaKeyPair != null) {
                    this._keyring = ((RsaKeyring.Builder)((RsaKeyring.Builder)RsaKeyring.builder().wrappingKeyPair(this._rsaKeyPair).enableLegacyWrappingAlgorithms(this._enableLegacyWrappingAlgorithms)).secureRandom(this._secureRandom)).build();
                } else if (this._kmsKeyId != null) {
                    this._keyring = ((KmsKeyring.Builder)((KmsKeyring.Builder)KmsKeyring.builder().wrappingKeyId(this._kmsKeyId).enableLegacyWrappingAlgorithms(this._enableLegacyWrappingAlgorithms)).secureRandom(this._secureRandom)).build();
                }
            }
            if (this._cryptoMaterialsManager == null) {
                this._cryptoMaterialsManager = DefaultCryptoMaterialsManager.builder().keyring(this._keyring).cryptoProvider(this._cryptoProvider).build();
            }
            this._multipartPipeline = MultipartUploadObjectPipeline.builder().s3AsyncClient(this._wrappedAsyncClient).cryptoMaterialsManager(this._cryptoMaterialsManager).secureRandom(this._secureRandom).build();
            return new S3EncryptionClient(this);
        }
    }
}

