/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.materials;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.internal.CryptoFactory;
import software.amazon.encryption.s3.materials.DataKeyStrategy;
import software.amazon.encryption.s3.materials.DecryptDataKeyStrategy;
import software.amazon.encryption.s3.materials.DecryptionMaterials;
import software.amazon.encryption.s3.materials.EncryptDataKeyStrategy;
import software.amazon.encryption.s3.materials.EncryptionMaterials;
import software.amazon.encryption.s3.materials.PartialRsaKeyPair;
import software.amazon.encryption.s3.materials.S3Keyring;

public class RsaKeyring
extends S3Keyring {
    private final PartialRsaKeyPair _partialRsaKeyPair;
    private final DecryptDataKeyStrategy _rsaStrategy = new DecryptDataKeyStrategy(){
        private static final String KEY_PROVIDER_INFO = "RSA";
        private static final String CIPHER_ALGORITHM = "RSA";

        @Override
        public boolean isLegacy() {
            return true;
        }

        @Override
        public String keyProviderInfo() {
            return "RSA";
        }

        @Override
        public byte[] decryptDataKey(DecryptionMaterials materials, byte[] encryptedDataKey) throws GeneralSecurityException {
            Cipher cipher = CryptoFactory.createCipher("RSA", materials.cryptoProvider());
            cipher.init(2, RsaKeyring.this._partialRsaKeyPair.getPrivateKey());
            return cipher.doFinal(encryptedDataKey);
        }
    };
    private final DecryptDataKeyStrategy _rsaEcbStrategy = new DecryptDataKeyStrategy(){
        private static final String KEY_PROVIDER_INFO = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
        private static final String CIPHER_ALGORITHM = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";

        @Override
        public boolean isLegacy() {
            return true;
        }

        @Override
        public String keyProviderInfo() {
            return "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
        }

        @Override
        public byte[] decryptDataKey(DecryptionMaterials materials, byte[] encryptedDataKey) throws GeneralSecurityException {
            Cipher cipher = CryptoFactory.createCipher("RSA/ECB/OAEPWithSHA-256AndMGF1Padding", materials.cryptoProvider());
            cipher.init(4, RsaKeyring.this._partialRsaKeyPair.getPrivateKey());
            Key plaintextKey = cipher.unwrap(encryptedDataKey, "RSA/ECB/OAEPWithSHA-256AndMGF1Padding", 3);
            return plaintextKey.getEncoded();
        }
    };
    private final DataKeyStrategy _rsaOaepStrategy = new DataKeyStrategy(){
        private static final String KEY_PROVIDER_INFO = "RSA-OAEP-SHA1";
        private static final String CIPHER_ALGORITHM = "RSA/ECB/OAEPPadding";
        private static final String DIGEST_NAME = "SHA-1";
        private static final String MGF_NAME = "MGF1";
        private final MGF1ParameterSpec MGF_PARAMETER_SPEC = new MGF1ParameterSpec("SHA-1");
        private final OAEPParameterSpec OAEP_PARAMETER_SPEC = new OAEPParameterSpec("SHA-1", "MGF1", this.MGF_PARAMETER_SPEC, PSource.PSpecified.DEFAULT);

        @Override
        public boolean isLegacy() {
            return false;
        }

        @Override
        public String keyProviderInfo() {
            return KEY_PROVIDER_INFO;
        }

        @Override
        public byte[] encryptDataKey(SecureRandom secureRandom, EncryptionMaterials materials) throws GeneralSecurityException {
            Cipher cipher = CryptoFactory.createCipher(CIPHER_ALGORITHM, materials.cryptoProvider());
            cipher.init(3, (Key)RsaKeyring.this._partialRsaKeyPair.getPublicKey(), this.OAEP_PARAMETER_SPEC, secureRandom);
            byte[] dataKey = materials.plaintextDataKey();
            byte[] dataCipherName = materials.algorithmSuite().cipherName().getBytes(StandardCharsets.UTF_8);
            byte[] pseudoDataKey = new byte[1 + dataKey.length + dataCipherName.length];
            pseudoDataKey[0] = (byte)dataKey.length;
            System.arraycopy(dataKey, 0, pseudoDataKey, 1, dataKey.length);
            System.arraycopy(dataCipherName, 0, pseudoDataKey, 1 + dataKey.length, dataCipherName.length);
            byte[] ciphertext = cipher.wrap(new SecretKeySpec(pseudoDataKey, materials.algorithmSuite().dataKeyAlgorithm()));
            return ciphertext;
        }

        @Override
        public byte[] decryptDataKey(DecryptionMaterials materials, byte[] encryptedDataKey) throws GeneralSecurityException {
            Cipher cipher = CryptoFactory.createCipher(CIPHER_ALGORITHM, materials.cryptoProvider());
            cipher.init(4, (Key)RsaKeyring.this._partialRsaKeyPair.getPrivateKey(), this.OAEP_PARAMETER_SPEC);
            String dataKeyAlgorithm = materials.algorithmSuite().dataKeyAlgorithm();
            Key pseudoDataKey = cipher.unwrap(encryptedDataKey, dataKeyAlgorithm, 3);
            return this.parsePseudoDataKey(materials, pseudoDataKey.getEncoded());
        }

        private byte[] parsePseudoDataKey(DecryptionMaterials materials, byte[] pseudoDataKey) {
            byte dataKeyLengthBytes = pseudoDataKey[0];
            if (dataKeyLengthBytes != 16 && dataKeyLengthBytes != 24 && dataKeyLengthBytes != 32) {
                throw new S3EncryptionClientException("Invalid key length (" + dataKeyLengthBytes + ") in encrypted data key");
            }
            int dataCipherNameLength = pseudoDataKey.length - dataKeyLengthBytes - 1;
            if (dataCipherNameLength <= 0) {
                throw new S3EncryptionClientException("Invalid data cipher name length (" + dataCipherNameLength + ") in encrypted data key");
            }
            byte[] dataKey = new byte[dataKeyLengthBytes];
            byte[] dataCipherName = new byte[dataCipherNameLength];
            System.arraycopy(pseudoDataKey, 1, dataKey, 0, dataKeyLengthBytes);
            System.arraycopy(pseudoDataKey, 1 + dataKeyLengthBytes, dataCipherName, 0, dataCipherNameLength);
            byte[] expectedDataCipherName = materials.algorithmSuite().cipherName().getBytes(StandardCharsets.UTF_8);
            if (!Arrays.equals(expectedDataCipherName, dataCipherName)) {
                throw new S3EncryptionClientException("The data cipher does not match the data cipher used for encryption. The object may be altered or corrupted");
            }
            return dataKey;
        }
    };
    private final Map<String, DecryptDataKeyStrategy> decryptStrategies = new HashMap<String, DecryptDataKeyStrategy>();

    private RsaKeyring(Builder builder) {
        super(builder);
        this._partialRsaKeyPair = builder._partialRsaKeyPair;
        this.decryptStrategies.put(this._rsaStrategy.keyProviderInfo(), this._rsaStrategy);
        this.decryptStrategies.put(this._rsaEcbStrategy.keyProviderInfo(), this._rsaEcbStrategy);
        this.decryptStrategies.put(this._rsaOaepStrategy.keyProviderInfo(), this._rsaOaepStrategy);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected EncryptDataKeyStrategy encryptStrategy() {
        return this._rsaOaepStrategy;
    }

    @Override
    protected Map<String, DecryptDataKeyStrategy> decryptStrategies() {
        return this.decryptStrategies;
    }

    public static class Builder
    extends S3Keyring.Builder<S3Keyring, Builder> {
        private PartialRsaKeyPair _partialRsaKeyPair;

        private Builder() {
        }

        @Override
        protected Builder builder() {
            return this;
        }

        public Builder wrappingKeyPair(PartialRsaKeyPair partialRsaKeyPair) {
            this._partialRsaKeyPair = partialRsaKeyPair;
            return this.builder();
        }

        @Override
        public RsaKeyring build() {
            return new RsaKeyring(this);
        }
    }
}

