/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.Cipher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.S3EncryptionClientSecurityException;
import software.amazon.encryption.s3.internal.CipherProvider;
import software.amazon.encryption.s3.materials.CryptographicMaterials;

public class BufferedCipherSubscriber
implements Subscriber<ByteBuffer> {
    private static final long BUFFERED_MAX_CONTENT_LENGTH_MiB = 64L;
    private static final long BUFFERED_MAX_CONTENT_LENGTH_BYTES = 0x4000000L;
    private final AtomicInteger contentRead = new AtomicInteger(0);
    private final AtomicBoolean doneFinal = new AtomicBoolean(false);
    private final Subscriber<? super ByteBuffer> wrappedSubscriber;
    private final int contentLength;
    private Cipher cipher;
    private final CryptographicMaterials materials;
    private final byte[] iv;
    private byte[] outputBuffer;
    private final Queue<ByteBuffer> buffers = new ConcurrentLinkedQueue<ByteBuffer>();

    BufferedCipherSubscriber(Subscriber<? super ByteBuffer> wrappedSubscriber, Long contentLength, CryptographicMaterials materials, byte[] iv) {
        this.wrappedSubscriber = wrappedSubscriber;
        if (contentLength == null) {
            throw new S3EncryptionClientException("contentLength cannot be null in buffered mode. To enable unbounded streaming, reconfigure the S3 Encryption Client with Delayed Authentication mode enabled.");
        }
        if (contentLength > 0x4000000L) {
            throw new S3EncryptionClientException(String.format("The object you are attempting to decrypt exceeds the maximum content length allowed in default mode. Please enable Delayed Authentication mode to decrypt objects largerthan %d", 64L));
        }
        this.contentLength = Math.toIntExact(contentLength);
        this.materials = materials;
        this.iv = iv;
        this.cipher = materials.getCipher(iv);
    }

    public void onSubscribe(Subscription s) {
        this.wrappedSubscriber.onSubscribe(s);
    }

    public void onNext(ByteBuffer byteBuffer) {
        int amountToReadFromByteBuffer = this.getAmountToReadFromByteBuffer(byteBuffer);
        if (amountToReadFromByteBuffer > 0) {
            byte[] buf = BinaryUtils.copyBytesFrom((ByteBuffer)byteBuffer, (int)amountToReadFromByteBuffer);
            try {
                this.outputBuffer = this.cipher.update(buf, 0, amountToReadFromByteBuffer);
            }
            catch (IllegalStateException exception) {
                this.cipher = CipherProvider.createAndInitCipher(this.materials, this.iv);
            }
            if (this.outputBuffer == null && amountToReadFromByteBuffer < this.cipher.getBlockSize()) {
                this.onComplete();
            }
            this.buffers.add(ByteBuffer.wrap(this.outputBuffer));
            if (this.contentRead.get() == this.contentLength) {
                this.onComplete();
            }
            this.wrappedSubscriber.onNext((Object)ByteBuffer.allocate(0));
        }
    }

    private int getAmountToReadFromByteBuffer(ByteBuffer byteBuffer) {
        long amountReadSoFar = this.contentRead.getAndAdd(byteBuffer.remaining());
        long amountRemaining = Math.max(0L, (long)this.contentLength - amountReadSoFar);
        if (amountRemaining > (long)byteBuffer.remaining()) {
            return byteBuffer.remaining();
        }
        return Math.toIntExact(amountRemaining);
    }

    public void onError(Throwable t) {
        this.wrappedSubscriber.onError(t);
    }

    public void onComplete() {
        if (this.doneFinal.get()) {
            return;
        }
        try {
            this.outputBuffer = this.cipher.doFinal();
            this.doneFinal.set(true);
            if (this.contentRead.get() == this.contentLength) {
                while (!this.buffers.isEmpty()) {
                    this.wrappedSubscriber.onNext((Object)this.buffers.remove());
                }
            }
            this.wrappedSubscriber.onNext((Object)ByteBuffer.wrap(this.outputBuffer));
        }
        catch (GeneralSecurityException exception) {
            this.wrappedSubscriber.onError((Throwable)exception);
            throw new S3EncryptionClientSecurityException(exception.getMessage(), exception);
        }
        this.wrappedSubscriber.onComplete();
    }
}

