/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.algorithms;

public enum AlgorithmSuite {
    ALG_AES_256_GCM_IV12_TAG16_NO_KDF(114, false, "AES", 256, "AES/GCM/NoPadding", 128, 96, 128, 0x7FFFFFFF00L),
    ALG_AES_256_CTR_IV16_TAG16_NO_KDF(113, true, "AES", 256, "AES/CTR/NoPadding", 128, 128, 128, -1L),
    ALG_AES_256_CBC_IV16_NO_KDF(112, true, "AES", 256, "AES/CBC/PKCS5Padding", 128, 128, 0, 0x80000000000000L);

    private int _id;
    private boolean _isLegacy;
    private String _dataKeyAlgorithm;
    private int _dataKeyLengthBits;
    private String _cipherName;
    private int _cipherBlockSizeBits;
    private int _cipherIvLengthBits;
    private int _cipherTagLengthBits;
    private long _cipherMaxContentLengthBits;

    private AlgorithmSuite(int id, boolean isLegacy, String dataKeyAlgorithm, int dataKeyLengthBits, String cipherName, int cipherBlockSizeBits, int cipherIvLengthBits, int cipherTagLengthBits, long cipherMaxContentLengthBits) {
        this._id = id;
        this._isLegacy = isLegacy;
        this._dataKeyAlgorithm = dataKeyAlgorithm;
        this._dataKeyLengthBits = dataKeyLengthBits;
        this._cipherName = cipherName;
        this._cipherBlockSizeBits = cipherBlockSizeBits;
        this._cipherIvLengthBits = cipherIvLengthBits;
        this._cipherTagLengthBits = cipherTagLengthBits;
        this._cipherMaxContentLengthBits = cipherMaxContentLengthBits;
    }

    public int id() {
        return this._id;
    }

    public boolean isLegacy() {
        return this._isLegacy;
    }

    public String dataKeyAlgorithm() {
        return this._dataKeyAlgorithm;
    }

    public int dataKeyLengthBits() {
        return this._dataKeyLengthBits;
    }

    public String cipherName() {
        return this._cipherName;
    }

    public int cipherTagLengthBits() {
        return this._cipherTagLengthBits;
    }

    public int cipherTagLengthBytes() {
        return this._cipherTagLengthBits / 8;
    }

    public int iVLengthBytes() {
        return this._cipherIvLengthBits / 8;
    }

    public int cipherBlockSizeBytes() {
        return this._cipherBlockSizeBits / 8;
    }

    public long cipherMaxContentLengthBits() {
        return this._cipherMaxContentLengthBits;
    }

    public long cipherMaxContentLengthBytes() {
        return this._cipherMaxContentLengthBits / 8L;
    }
}

