/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.partiql.processor;

import com.amazonaws.services.dynamodbv2.datamodel.DocPath;
import com.amazonaws.services.dynamodbv2.datamodel.DocPathElement;
import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import com.amazonaws.services.dynamodbv2.datamodel.ExprTreeNode;
import com.amazonaws.services.dynamodbv2.datamodel.ExprTreeOpNode;
import com.amazonaws.services.dynamodbv2.datamodel.ExprTreePathNode;
import com.amazonaws.services.dynamodbv2.datamodel.ExprTreeValueNode;
import com.amazonaws.services.dynamodbv2.datamodel.Expression;
import com.amazonaws.services.dynamodbv2.datamodel.Operator;
import com.amazonaws.services.dynamodbv2.datamodel.ProjectionExpression;
import com.amazonaws.services.dynamodbv2.rr.ExpressionWrapper;
import com.amazonaws.services.dynamodbv2.rr.ProjectionExpressionWrapper;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.partiql.lang.ast.OrderBy;
import org.partiql.lang.ast.Select;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.LocalDBValidatorUtils;
import software.amazon.dynamodb.services.local.shared.access.QueryResponseInfo;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.api.dp.PartiQLStatementFunction;
import software.amazon.dynamodb.services.local.shared.env.LocalPartiQLDbEnv;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.mapper.DynamoDbObjectMapper;
import software.amazon.dynamodb.services.local.shared.model.Condition;
import software.amazon.dynamodb.services.local.shared.partiql.ParsedPartiQLRequest;
import software.amazon.dynamodb.services.local.shared.partiql.model.TranslatedPartiQLOperation;
import software.amazon.dynamodb.services.local.shared.partiql.processor.StatementProcessor;
import software.amazon.dynamodb.services.local.shared.partiql.token.ContinuationTokenSerializer;
import software.amazon.dynamodb.services.local.shared.partiql.translator.SelectStatementTranslator;
import software.amazon.dynamodb.services.local.shared.partiql.util.OrderingStatus;
import software.amazon.dynamodb.services.local.shared.partiql.util.SelectProjectionUnnester;
import software.amazon.dynamodb.services.local.shared.partiql.util.SelectResultsOrderer;

public class SelectStatementProcessor
extends StatementProcessor<Select> {
    private final SelectStatementTranslator translator;
    private final ContinuationTokenSerializer continuationTokenSerializer;
    private final SelectProjectionUnnester selectProjectionUnnester;
    private final SelectResultsOrderer selectResultsOrderer;

    public SelectStatementProcessor(SelectStatementTranslator translator, LocalDBAccess dbAccess, LocalPartiQLDbEnv localPartiQLDbEnv, PartiQLStatementFunction partiQLStatementFunction, DocumentFactory documentFactory) {
        super(dbAccess, localPartiQLDbEnv, partiQLStatementFunction, documentFactory);
        this.translator = translator;
        this.continuationTokenSerializer = new ContinuationTokenSerializer(new DynamoDbObjectMapper(), localPartiQLDbEnv);
        this.selectProjectionUnnester = new SelectProjectionUnnester(localPartiQLDbEnv);
        this.selectResultsOrderer = new SelectResultsOrderer(localPartiQLDbEnv);
    }

    @Override
    public ExecuteStatementResponse execute(ParsedPartiQLRequest<Select> request) {
        TranslatedPartiQLOperation translatedPartiQLOperation = this.translator.translate(request);
        return this.invokePartiqlSelect(request, translatedPartiQLOperation);
    }

    public ExecuteStatementResponse invokePartiqlSelect(ParsedPartiQLRequest<Select> request, TranslatedPartiQLOperation translatedPartiQLOperation) {
        Map<String, software.amazon.dynamodb.services.local.shared.model.AttributeValue> exclusiveStartKey = this.continuationTokenSerializer.deserializeAndConvertContinuationToken(request);
        AbstractMap.SimpleEntry<Map<String, software.amazon.dynamodb.services.local.shared.model.AttributeValue>, List<Map<String, AttributeValue>>> lastKeyAndReturnedItems = this.partiqlSelectStatement(translatedPartiQLOperation.getTableName(), translatedPartiQLOperation.getIndexName(), translatedPartiQLOperation.getKeyConditions(), translatedPartiQLOperation.getProjectionExpressionWrapper(), translatedPartiQLOperation.getConditionExpressionWrapper(), translatedPartiQLOperation.getOrderBy(), translatedPartiQLOperation.isConsistentRead(), translatedPartiQLOperation.getLimit(), exclusiveStartKey);
        return (ExecuteStatementResponse)ExecuteStatementResponse.builder().items((Collection)lastKeyAndReturnedItems.getValue()).nextToken(this.continuationTokenSerializer.createAndSerializeContinuationToken(request, lastKeyAndReturnedItems.getKey())).build();
    }

    public AbstractMap.SimpleEntry<Map<String, software.amazon.dynamodb.services.local.shared.model.AttributeValue>, List<Map<String, AttributeValue>>> partiqlSelectStatement(String tableName, String indexName, Map<String, Condition> keyConditions, ProjectionExpressionWrapper projectionExpressionWrapper, ExpressionWrapper filterExpressionWrapper, OrderBy orderBy, boolean isConsistentRead, Integer limit2, Map<String, software.amazon.dynamodb.services.local.shared.model.AttributeValue> exclusiveStartKey) {
        OrderingStatus orderingStatus;
        boolean isGsiIndex;
        this.partiQLStatementFunction.validateTableName(tableName);
        TableInfo info = this.partiQLStatementFunction.validateTableExists(tableName);
        boolean hasRangeKey = info.hasRangeKey();
        List indexAttributesToGet = null;
        if (indexName != null) {
            if (!info.hasIndex(indexName)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.SECONDARY_INDEXES_NOT_FOUND.getMessage(), indexName));
            }
            Projection indexProjection = info.getProjection(indexName);
            String projectionType = indexProjection.projectionTypeAsString();
            if (ProjectionType.INCLUDE.toString().equals(projectionType) || ProjectionType.KEYS_ONLY.toString().equals(projectionType)) {
                indexAttributesToGet = this.partiQLStatementFunction.getAttributeNames(this.partiQLStatementFunction.getKeyAttributes(info, indexName));
                if (ProjectionType.INCLUDE.toString().equals(projectionType)) {
                    indexAttributesToGet.addAll(indexProjection.nonKeyAttributes());
                }
            }
        }
        boolean bl = isGsiIndex = indexName != null && info.isGSIIndex(indexName);
        if (indexName != null && info.isGSIIndex(indexName) && isConsistentRead) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.CONSISTENT_GSI_SCAN.getMessage());
        }
        Expression filterExpression = filterExpressionWrapper == null ? null : filterExpressionWrapper.getExpression();
        ProjectionExpression projectionExpression = projectionExpressionWrapper == null ? null : projectionExpressionWrapper.getProjection();
        List keyDefs = this.partiQLStatementFunction.getKeyAttributes(info, indexName);
        this.partiQLStatementFunction.validateExclusiveStartKey((Map)exclusiveStartKey, keyDefs);
        this.partiQLStatementFunction.validateExclusiveStartKeyForEmptyAttributeValue((Map)exclusiveStartKey, info, indexName, isGsiIndex);
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(info, filterExpressionWrapper, this.partiQLStatementFunction.awsExceptionFactory);
        HashMap<String, Condition> extractedFilterConditions = new HashMap<String, Condition>();
        ArrayList<Map<String, Condition>> keyConditionList = new ArrayList<Map<String, Condition>>();
        if (filterExpression != null) {
            this.extractConditionsFromExprTreeNode(filterExpression.getExprTree(), extractedFilterConditions);
            this.checkForAndValidatePossibleKeyConditions(keyDefs, extractedFilterConditions, hasRangeKey, indexName);
        }
        if (keyConditions != null) {
            keyConditionList.add(keyConditions);
        }
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(info, projectionExpressionWrapper, this.partiQLStatementFunction.awsExceptionFactory);
        this.partiQLStatementFunction.validateAttributesToGetAndProjExpr((List)null, projectionExpression, indexName, info);
        ArrayList<QueryResponseInfo> results = new ArrayList<QueryResponseInfo>();
        if (keyConditionList.isEmpty()) {
            results.add(this.dbAccess.queryRecords(tableName, indexName, null, exclusiveStartKey, -1L, true, null, null, true, isGsiIndex));
        } else {
            for (Map map2 : keyConditionList) {
                if (map2 == null) continue;
                this.checkForAndValidatePossibleKeyConditions(keyDefs, map2, hasRangeKey, indexName);
                results.add(this.dbAccess.queryRecords(tableName, indexName, map2, exclusiveStartKey, -1L, true, null, null, false, isGsiIndex));
            }
        }
        int scannedItemCount = 0;
        long l = 0L;
        boolean scanLimiter = false;
        List<Map<String, software.amazon.dynamodb.services.local.shared.model.AttributeValue>> dbRecordsAfterFiltering = new ArrayList<Map<String, software.amazon.dynamodb.services.local.shared.model.AttributeValue>>();
        Map<Object, Object> lastKey = new HashMap();
        for (QueryResponseInfo result : results) {
            Map<String, software.amazon.dynamodb.services.local.shared.model.AttributeValue> lastItem;
            List<Map<String, software.amazon.dynamodb.services.local.shared.model.AttributeValue>> dbRecords = result.getReturnedRecords();
            int itemCount = 0;
            for (Map<String, software.amazon.dynamodb.services.local.shared.model.AttributeValue> item : dbRecords) {
                if (this.partiQLStatementFunction.doesItemMatchFilterExpression((Map)item, filterExpression)) {
                    Map<String, software.amazon.dynamodb.services.local.shared.model.AttributeValue> filteredItem;
                    if (projectionExpression == null && indexAttributesToGet != null) {
                        filteredItem = LocalDBUtils.projectAttributes(item, indexAttributesToGet);
                    } else {
                        filteredItem = LocalDBUtils.projectAttributes(item, projectionExpression);
                        filteredItem = this.selectProjectionUnnester.unnestProjection(filteredItem, projectionExpression);
                    }
                    if (filteredItem != null) {
                        dbRecordsAfterFiltering.add(filteredItem);
                    }
                }
                long itemSize = LocalDBUtils.getItemSizeBytes(item);
                ++itemCount;
                if ((l += itemSize) < 0x100000L && (limit2 == null || ++scannedItemCount < limit2 || limit2 < 1)) continue;
                scanLimiter = true;
                break;
            }
            if (scanLimiter) {
                lastItem = result.getReturnedRecords().get(itemCount - 1);
                lastKey = LocalDBUtils.projectAttributes(lastItem, this.partiQLStatementFunction.getAttributeNames(keyDefs));
                break;
            }
            lastItem = result.getLastEvaluatedItem();
            lastKey = LocalDBUtils.projectAttributes(lastItem, this.partiQLStatementFunction.getAttributeNames(keyDefs));
        }
        if ((orderingStatus = this.selectResultsOrderer.getOrderingStatus(orderBy, info, indexName)) != null) {
            dbRecordsAfterFiltering = this.selectResultsOrderer.orderRecords(dbRecordsAfterFiltering, orderingStatus);
        }
        return new AbstractMap.SimpleEntry<Map<String, software.amazon.dynamodb.services.local.shared.model.AttributeValue>, List<Map<String, AttributeValue>>>(lastKey, this.partiQLStatementFunction.localDBOutputConverter.internalToExternalItemList(dbRecordsAfterFiltering));
    }

    private Map<String, Condition> filterToKeyCondition(software.amazon.dynamodb.services.local.shared.model.AttributeValue attributeValue, TableInfo info, String keyName) {
        Condition condition = new Condition();
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        condition.setComparisonOperator(Operator.EQ.toString());
        condition.setAttributeValueList(Collections.singleton(attributeValue));
        if (info.isGSIIndex(keyName)) {
            conditionMap.put(info.getGSIHashKey(keyName).attributeName(), condition);
        } else {
            conditionMap.put(info.getHashKey().attributeName(), condition);
        }
        return conditionMap;
    }

    private void checkForAndValidatePossibleKeyConditions(List<AttributeDefinition> keyDefs, Map<String, Condition> conditions, boolean hasRangeKey, String indexName) {
        boolean isIndexKey = false;
        int index = 0;
        for (AttributeDefinition keyDefinition : keyDefs) {
            Condition keyCondition = conditions.get(keyDefinition.attributeName());
            if (keyCondition == null) continue;
            if (index == 1 && !hasRangeKey || index == 2) {
                isIndexKey = true;
            }
            software.amazon.dynamodb.services.local.shared.model.AttributeValue expectedVal = keyCondition.getAttributeValueList().get(0);
            LocalDBUtils.validateConsistentTypes(keyDefinition, expectedVal, LocalDBClientExceptionMessage.INCONSISTENT_CONDITION_PARAMETER);
            if (ScalarAttributeType.S.equals((Object)keyDefinition.attributeType())) {
                for (software.amazon.dynamodb.services.local.shared.model.AttributeValue attributeValue : keyCondition.getAttributeValueList()) {
                    this.partiQLStatementFunction.validateKeyForEmptyStringValue(attributeValue, keyDefinition.attributeName(), isIndexKey, indexName, null);
                }
            } else if (ScalarAttributeType.B.equals((Object)keyDefinition.attributeType())) {
                for (software.amazon.dynamodb.services.local.shared.model.AttributeValue attributeValue : keyCondition.getAttributeValueList()) {
                    this.partiQLStatementFunction.validateKeyForEmptyBinaryValue(attributeValue, keyDefinition.attributeName(), isIndexKey, indexName, null);
                }
            }
            ++index;
        }
    }

    private void extractConditionsFromExprTreeNode(ExprTreeNode currentNode, Map<String, Condition> extractedConditions) {
        ExprTreeOpNode currentOpNode = (ExprTreeOpNode)currentNode;
        Operator currentOperator = currentOpNode.getOperator();
        if (Operator.AND == currentOperator || Operator.OR == currentOperator || Operator.NOT == currentOperator) {
            for (ExprTreeNode childExprTreeNode : currentOpNode.getChildren()) {
                this.extractConditionsFromExprTreeNode(childExprTreeNode, extractedConditions);
            }
        } else {
            this.getConditionFromOperatorNodeAndAddToExtractedConditions(currentOpNode, extractedConditions);
        }
    }

    private void getConditionFromOperatorNodeAndAddToExtractedConditions(ExprTreeOpNode currentOpNode, Map<String, Condition> extractedConditions) {
        String attrName = null;
        ArrayList<software.amazon.dynamodb.services.local.shared.model.AttributeValue> attrValues = new ArrayList<software.amazon.dynamodb.services.local.shared.model.AttributeValue>();
        for (ExprTreeNode child2 : currentOpNode.getChildren()) {
            if (child2 instanceof ExprTreePathNode) {
                DocPath current = ((ExprTreePathNode)child2).getDocPath();
                DocPathElement element = current.getElements().get(0);
                attrName = element.getFieldName();
                continue;
            }
            if (!(child2 instanceof ExprTreeValueNode)) continue;
            attrValues.add((software.amazon.dynamodb.services.local.shared.model.AttributeValue)((ExprTreeValueNode)child2).getValue());
        }
        if (attrName != null) {
            Condition condition = new Condition();
            condition.setAttributeValueList(attrValues);
            extractedConditions.put(attrName, condition);
        }
    }
}

