/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.mapper;

import com.amazonaws.services.dynamodbv2.dbenv.DbEnv;
import com.amazonaws.services.dynamodbv2.rr.ExpressionsWrapperBase;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchStatementError;
import software.amazon.awssdk.services.dynamodb.model.BatchStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.BillingModeSummary;
import software.amazon.awssdk.services.dynamodb.model.CancellationReason;
import software.amazon.awssdk.services.dynamodb.model.Capacity;
import software.amazon.awssdk.services.dynamodb.model.ConditionCheck;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalSecondaryIndexAction;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.Delete;
import software.amazon.awssdk.services.dynamodb.model.DeleteGlobalSecondaryIndexAction;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse;
import software.amazon.awssdk.services.dynamodb.model.Get;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate;
import software.amazon.awssdk.services.dynamodb.model.Identity;
import software.amazon.awssdk.services.dynamodb.model.IndexStatus;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ItemResponse;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput;
import software.amazon.awssdk.services.dynamodb.model.ParameterizedStatement;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription;
import software.amazon.awssdk.services.dynamodb.model.Put;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.Record;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.SequenceNumberRange;
import software.amazon.awssdk.services.dynamodb.model.Shard;
import software.amazon.awssdk.services.dynamodb.model.ShardIteratorType;
import software.amazon.awssdk.services.dynamodb.model.Stream;
import software.amazon.awssdk.services.dynamodb.model.StreamDescription;
import software.amazon.awssdk.services.dynamodb.model.StreamRecord;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.services.dynamodb.model.StreamStatus;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;
import software.amazon.awssdk.services.dynamodb.model.Tag;
import software.amazon.awssdk.services.dynamodb.model.TagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.TagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.TimeToLiveDescription;
import software.amazon.awssdk.services.dynamodb.model.TimeToLiveSpecification;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItem;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.Update;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalSecondaryIndexAction;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.awssdk.utils.builder.SdkBuilder;
import software.amazon.dynamodb.services.local.shared.mapper.AttributeValueNamingStrategy;
import software.amazon.dynamodb.services.local.shared.mapper.BuilderPatternDeserializer;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;
import software.amazon.dynamodb.services.local.shared.model.AttributeValueUpdate;
import software.amazon.dynamodb.services.local.shared.model.Condition;
import software.amazon.dynamodb.services.local.shared.model.DeleteRequest;
import software.amazon.dynamodb.services.local.shared.model.ExpectedAttributeValue;
import software.amazon.dynamodb.services.local.shared.model.PutRequest;
import software.amazon.dynamodb.services.local.shared.model.WriteRequest;

public class DynamoDbObjectMapper
extends ObjectMapper {
    private final PropertyNamingStrategy ATTRIBUTE_VALUE_NAMING_STRATEGY = new AttributeValueNamingStrategy();
    public static final TypeReference<Map<String, AttributeValue>> ITEM_TYPE = new TypeReference<Map<String, AttributeValue>>(){};

    public DynamoDbObjectMapper() {
        this.registerModule((Module)new JavaTimeModule());
        this.configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true);
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.setPropertyNamingStrategy(this.ATTRIBUTE_VALUE_NAMING_STRATEGY);
        this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.setFilterProvider((FilterProvider)new SimpleFilterProvider().addFilter("sdkAutoConstructFilter", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[0])));
        this.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){

            public Object findFilterId(Annotated a) {
                Object id = super.findFilterId(a);
                return Objects.requireNonNullElse(id, "sdkAutoConstructFilter");
            }

            public JsonInclude.Value findPropertyInclusion(Annotated a) {
                JsonInclude.Value inclusion = super.findPropertyInclusion(a);
                return inclusion.withValueFilter(SdkAutoConstructFilter.class);
            }
        });
        SimpleModule module = new SimpleModule();
        module.addSerializer(Instant.class, (JsonSerializer)new InstantSerializer());
        module.addSerializer(Date.class, (JsonSerializer)new DateSerializer());
        module.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializer());
        module.addSerializer(SdkBytes.class, (JsonSerializer)new JsonSerializer<SdkBytes>(){

            public void serialize(SdkBytes value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString(Base64.getEncoder().encodeToString(value.asByteArray()));
            }
        });
        this.registerMixIns();
        this.registerDeserializers(module);
        this.registerModule((Module)module);
    }

    private void registerDeserializers(SimpleModule module) {
        module.addDeserializer(Instant.class, (JsonDeserializer)new InstantDeserializer());
        this.registerAttributeObjectDeserializers(module);
        this.registerApiObjectDeserializers(module);
    }

    private void registerAttributeObjectDeserializers(SimpleModule module) {
        module.addDeserializer(software.amazon.awssdk.services.dynamodb.model.AttributeValue.class, new BuilderPatternDeserializer<software.amazon.awssdk.services.dynamodb.model.AttributeValue, AttributeValue.Builder>(software.amazon.awssdk.services.dynamodb.model.AttributeValue::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(SdkBytes.class, (JsonDeserializer)new JsonDeserializer<SdkBytes>(){

            public SdkBytes deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String base64 = p.getValueAsString();
                if (base64 == null) {
                    return null;
                }
                byte[] decoded = Base64.getDecoder().decode(base64);
                return SdkBytes.fromByteArray((byte[])decoded);
            }
        });
        module.addDeserializer(AttributeDefinition.class, new BuilderPatternDeserializer<AttributeDefinition, AttributeDefinition.Builder>(AttributeDefinition::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(KeySchemaElement.class, new BuilderPatternDeserializer<KeySchemaElement, KeySchemaElement.Builder>(KeySchemaElement::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(Projection.class, new BuilderPatternDeserializer<Projection, Projection.Builder>(Projection::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(ProvisionedThroughputDescription.class, new BuilderPatternDeserializer<ProvisionedThroughputDescription, ProvisionedThroughputDescription.Builder>(ProvisionedThroughputDescription::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(ProvisionedThroughput.class, new BuilderPatternDeserializer<ProvisionedThroughput, ProvisionedThroughput.Builder>(ProvisionedThroughput::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(OnDemandThroughput.class, new BuilderPatternDeserializer<OnDemandThroughput, OnDemandThroughput.Builder>(OnDemandThroughput::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(LocalSecondaryIndex.class, new BuilderPatternDeserializer<LocalSecondaryIndex, LocalSecondaryIndex.Builder>(LocalSecondaryIndex::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(LocalSecondaryIndexDescription.class, new BuilderPatternDeserializer<LocalSecondaryIndexDescription, LocalSecondaryIndexDescription.Builder>(LocalSecondaryIndexDescription::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(GlobalSecondaryIndex.class, new BuilderPatternDeserializer<GlobalSecondaryIndex, GlobalSecondaryIndex.Builder>(GlobalSecondaryIndex::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(GlobalSecondaryIndexDescription.class, new BuilderPatternDeserializer<GlobalSecondaryIndexDescription, GlobalSecondaryIndexDescription.Builder>(GlobalSecondaryIndexDescription::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(GlobalSecondaryIndexUpdate.class, new BuilderPatternDeserializer<GlobalSecondaryIndexUpdate, GlobalSecondaryIndexUpdate.Builder>(GlobalSecondaryIndexUpdate::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(BillingModeSummary.class, new BuilderPatternDeserializer<BillingModeSummary, BillingModeSummary.Builder>(BillingModeSummary::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(TableDescription.class, new BuilderPatternDeserializer<TableDescription, TableDescription.Builder>(TableDescription::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(ConsumedCapacity.class, new BuilderPatternDeserializer<ConsumedCapacity, ConsumedCapacity.Builder>(ConsumedCapacity::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(ItemCollectionMetrics.class, new BuilderPatternDeserializer<ItemCollectionMetrics, ItemCollectionMetrics.Builder>(ItemCollectionMetrics::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(KeysAndAttributes.class, new BuilderPatternDeserializer<KeysAndAttributes, KeysAndAttributes.Builder>(KeysAndAttributes::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(software.amazon.awssdk.services.dynamodb.model.WriteRequest.class, new BuilderPatternDeserializer<software.amazon.awssdk.services.dynamodb.model.WriteRequest, WriteRequest.Builder>(software.amazon.awssdk.services.dynamodb.model.WriteRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(software.amazon.awssdk.services.dynamodb.model.PutRequest.class, new BuilderPatternDeserializer<software.amazon.awssdk.services.dynamodb.model.PutRequest, PutRequest.Builder>(software.amazon.awssdk.services.dynamodb.model.PutRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(software.amazon.awssdk.services.dynamodb.model.DeleteRequest.class, new BuilderPatternDeserializer<software.amazon.awssdk.services.dynamodb.model.DeleteRequest, DeleteRequest.Builder>(software.amazon.awssdk.services.dynamodb.model.DeleteRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(TransactGetItem.class, new BuilderPatternDeserializer<TransactGetItem, TransactGetItem.Builder>(TransactGetItem::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(TransactWriteItem.class, new BuilderPatternDeserializer<TransactWriteItem, TransactWriteItem.Builder>(TransactWriteItem::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(Put.class, new BuilderPatternDeserializer<Put, Put.Builder>(Put::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(Delete.class, new BuilderPatternDeserializer<Delete, Delete.Builder>(Delete::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(Update.class, new BuilderPatternDeserializer<Update, Update.Builder>(Update::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(ConditionCheck.class, new BuilderPatternDeserializer<ConditionCheck, ConditionCheck.Builder>(ConditionCheck::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(TimeToLiveDescription.class, new BuilderPatternDeserializer<TimeToLiveDescription, TimeToLiveDescription.Builder>(TimeToLiveDescription::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(StreamSpecification.class, new BuilderPatternDeserializer<StreamSpecification, StreamSpecification.Builder>(StreamSpecification::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(TimeToLiveSpecification.class, new BuilderPatternDeserializer<TimeToLiveSpecification, TimeToLiveSpecification.Builder>(TimeToLiveSpecification::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(Capacity.class, new BuilderPatternDeserializer<Capacity, Capacity.Builder>(Capacity::serializableBuilderClass, SdkBuilder::build));
    }

    private void registerApiObjectDeserializers(SimpleModule module) {
        module.addDeserializer(CreateTableRequest.class, new BuilderPatternDeserializer<CreateTableRequest, CreateTableRequest.Builder>(CreateTableRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(CreateTableResponse.class, new BuilderPatternDeserializer<CreateTableResponse, CreateTableResponse.Builder>(CreateTableResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(DescribeTableRequest.class, new BuilderPatternDeserializer<DescribeTableRequest, DescribeTableRequest.Builder>(DescribeTableRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(DescribeTableResponse.class, new BuilderPatternDeserializer<DescribeTableResponse, DescribeTableResponse.Builder>(DescribeTableResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(UpdateTableRequest.class, new BuilderPatternDeserializer<UpdateTableRequest, UpdateTableRequest.Builder>(UpdateTableRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(UpdateTableResponse.class, new BuilderPatternDeserializer<UpdateTableResponse, UpdateTableResponse.Builder>(UpdateTableResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(DeleteTableRequest.class, new BuilderPatternDeserializer<DeleteTableRequest, DeleteTableRequest.Builder>(DeleteTableRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(DeleteTableResponse.class, new BuilderPatternDeserializer<DeleteTableResponse, DeleteTableResponse.Builder>(DeleteTableResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(ListTablesRequest.class, new BuilderPatternDeserializer<ListTablesRequest, ListTablesRequest.Builder>(ListTablesRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(ListTablesResponse.class, new BuilderPatternDeserializer<ListTablesResponse, ListTablesResponse.Builder>(ListTablesResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(DescribeLimitsRequest.class, new BuilderPatternDeserializer<DescribeLimitsRequest, DescribeLimitsRequest.Builder>(DescribeLimitsRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(DescribeLimitsResponse.class, new BuilderPatternDeserializer<DescribeLimitsResponse, DescribeLimitsResponse.Builder>(DescribeLimitsResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(PutItemRequest.class, new BuilderPatternDeserializer<PutItemRequest, PutItemRequest.Builder>(PutItemRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(PutItemResponse.class, new BuilderPatternDeserializer<PutItemResponse, PutItemResponse.Builder>(PutItemResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(GetItemRequest.class, new BuilderPatternDeserializer<GetItemRequest, GetItemRequest.Builder>(GetItemRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(GetItemResponse.class, new BuilderPatternDeserializer<GetItemResponse, GetItemResponse.Builder>(GetItemResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(UpdateItemRequest.class, new BuilderPatternDeserializer<UpdateItemRequest, UpdateItemRequest.Builder>(UpdateItemRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(UpdateItemResponse.class, new BuilderPatternDeserializer<UpdateItemResponse, UpdateItemResponse.Builder>(UpdateItemResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(DeleteItemRequest.class, new BuilderPatternDeserializer<DeleteItemRequest, DeleteItemRequest.Builder>(DeleteItemRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(DeleteItemResponse.class, new BuilderPatternDeserializer<DeleteItemResponse, DeleteItemResponse.Builder>(DeleteItemResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(BatchGetItemRequest.class, new BuilderPatternDeserializer<BatchGetItemRequest, BatchGetItemRequest.Builder>(BatchGetItemRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(BatchGetItemResponse.class, new BuilderPatternDeserializer<BatchGetItemResponse, BatchGetItemResponse.Builder>(BatchGetItemResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(BatchWriteItemRequest.class, new BuilderPatternDeserializer<BatchWriteItemRequest, BatchWriteItemRequest.Builder>(BatchWriteItemRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(BatchWriteItemResponse.class, new BuilderPatternDeserializer<BatchWriteItemResponse, BatchWriteItemResponse.Builder>(BatchWriteItemResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(QueryRequest.class, new BuilderPatternDeserializer<QueryRequest, QueryRequest.Builder>(QueryRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(QueryResponse.class, new BuilderPatternDeserializer<QueryResponse, QueryResponse.Builder>(QueryResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(ScanRequest.class, new BuilderPatternDeserializer<ScanRequest, ScanRequest.Builder>(ScanRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(ScanResponse.class, new BuilderPatternDeserializer<ScanResponse, ScanResponse.Builder>(ScanResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(TransactGetItemsRequest.class, new BuilderPatternDeserializer<TransactGetItemsRequest, TransactGetItemsRequest.Builder>(TransactGetItemsRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(TransactGetItemsResponse.class, new BuilderPatternDeserializer<TransactGetItemsResponse, TransactGetItemsResponse.Builder>(TransactGetItemsResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(TransactWriteItemsRequest.class, new BuilderPatternDeserializer<TransactWriteItemsRequest, TransactWriteItemsRequest.Builder>(TransactWriteItemsRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(TransactWriteItemsResponse.class, new BuilderPatternDeserializer<TransactWriteItemsResponse, TransactWriteItemsResponse.Builder>(TransactWriteItemsResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(ExecuteStatementRequest.class, new BuilderPatternDeserializer<ExecuteStatementRequest, ExecuteStatementRequest.Builder>(ExecuteStatementRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(ExecuteStatementResponse.class, new BuilderPatternDeserializer<ExecuteStatementResponse, ExecuteStatementResponse.Builder>(ExecuteStatementResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(BatchExecuteStatementRequest.class, new BuilderPatternDeserializer<BatchExecuteStatementRequest, BatchExecuteStatementRequest.Builder>(BatchExecuteStatementRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(BatchExecuteStatementResponse.class, new BuilderPatternDeserializer<BatchExecuteStatementResponse, BatchExecuteStatementResponse.Builder>(BatchExecuteStatementResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(ExecuteTransactionRequest.class, new BuilderPatternDeserializer<ExecuteTransactionRequest, ExecuteTransactionRequest.Builder>(ExecuteTransactionRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(ExecuteTransactionResponse.class, new BuilderPatternDeserializer<ExecuteTransactionResponse, ExecuteTransactionResponse.Builder>(ExecuteTransactionResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(DescribeTimeToLiveRequest.class, new BuilderPatternDeserializer<DescribeTimeToLiveRequest, DescribeTimeToLiveRequest.Builder>(DescribeTimeToLiveRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(DescribeTimeToLiveResponse.class, new BuilderPatternDeserializer<DescribeTimeToLiveResponse, DescribeTimeToLiveResponse.Builder>(DescribeTimeToLiveResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(UpdateTimeToLiveRequest.class, new BuilderPatternDeserializer<UpdateTimeToLiveRequest, UpdateTimeToLiveRequest.Builder>(UpdateTimeToLiveRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(UpdateTimeToLiveResponse.class, new BuilderPatternDeserializer<UpdateTimeToLiveResponse, UpdateTimeToLiveResponse.Builder>(UpdateTimeToLiveResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(ListStreamsRequest.class, new BuilderPatternDeserializer<ListStreamsRequest, ListStreamsRequest.Builder>(ListStreamsRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(ListStreamsResponse.class, new BuilderPatternDeserializer<ListStreamsResponse, ListStreamsResponse.Builder>(ListStreamsResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(Stream.class, new BuilderPatternDeserializer<Stream, Stream.Builder>(Stream::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(DescribeStreamRequest.class, new BuilderPatternDeserializer<DescribeStreamRequest, DescribeStreamRequest.Builder>(DescribeStreamRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(DescribeStreamResponse.class, new BuilderPatternDeserializer<DescribeStreamResponse, DescribeStreamResponse.Builder>(DescribeStreamResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(StreamDescription.class, new BuilderPatternDeserializer<StreamDescription, StreamDescription.Builder>(StreamDescription::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(Shard.class, new BuilderPatternDeserializer<Shard, Shard.Builder>(Shard::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(SequenceNumberRange.class, new BuilderPatternDeserializer<SequenceNumberRange, SequenceNumberRange.Builder>(SequenceNumberRange::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(GetShardIteratorRequest.class, new BuilderPatternDeserializer<GetShardIteratorRequest, GetShardIteratorRequest.Builder>(GetShardIteratorRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(GetShardIteratorResponse.class, new BuilderPatternDeserializer<GetShardIteratorResponse, GetShardIteratorResponse.Builder>(GetShardIteratorResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(GetRecordsRequest.class, new BuilderPatternDeserializer<GetRecordsRequest, GetRecordsRequest.Builder>(GetRecordsRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(GetRecordsResponse.class, new BuilderPatternDeserializer<GetRecordsResponse, GetRecordsResponse.Builder>(GetRecordsResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(Record.class, new BuilderPatternDeserializer<Record, Record.Builder>(Record::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(StreamRecord.class, new BuilderPatternDeserializer<StreamRecord, StreamRecord.Builder>(StreamRecord::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(Identity.class, new BuilderPatternDeserializer<Identity, Identity.Builder>(Identity::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(BatchStatementError.class, new BuilderPatternDeserializer<BatchStatementError, BatchStatementError.Builder>(BatchStatementError::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(TagResourceRequest.class, new BuilderPatternDeserializer<TagResourceRequest, TagResourceRequest.Builder>(TagResourceRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(TagResourceResponse.class, new BuilderPatternDeserializer<TagResourceResponse, TagResourceResponse.Builder>(TagResourceResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(UntagResourceRequest.class, new BuilderPatternDeserializer<UntagResourceRequest, UntagResourceRequest.Builder>(UntagResourceRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(UntagResourceResponse.class, new BuilderPatternDeserializer<UntagResourceResponse, UntagResourceResponse.Builder>(UntagResourceResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(ListTagsOfResourceRequest.class, new BuilderPatternDeserializer<ListTagsOfResourceRequest, ListTagsOfResourceRequest.Builder>(ListTagsOfResourceRequest::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(ListTagsOfResourceResponse.class, new BuilderPatternDeserializer<ListTagsOfResourceResponse, ListTagsOfResourceResponse.Builder>(ListTagsOfResourceResponse::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(Tag.class, new BuilderPatternDeserializer<Tag, Tag.Builder>(Tag::serializableBuilderClass, SdkBuilder::build));
        module.addDeserializer(CancellationReason.class, new BuilderPatternDeserializer<CancellationReason, CancellationReason.Builder>(CancellationReason::serializableBuilderClass, SdkBuilder::build));
    }

    private void registerMixIns() {
        this.registerAttributeObjectMixIns();
        this.registerApiObjectMixIns();
    }

    public void registerAttributeObjectMixIns() {
        this.addMixIn(software.amazon.awssdk.services.dynamodb.model.AttributeValue.class, AttributeValueMixIn.class);
        this.addMixIn(AttributeValue.Builder.class, AttributeValueMixIn.class);
        this.addMixIn(software.amazon.awssdk.services.dynamodb.model.AttributeValue.serializableBuilderClass(), AttributeValueMixIn.class);
        this.addMixIn(AttributeDefinition.class, AttributeDefinitionMixIn.class);
        this.addMixIn(KeySchemaElement.class, KeySchemaElementMixIn.class);
        this.addMixIn(Projection.class, ProjectionMixIn.class);
        this.addMixIn(ProvisionedThroughputDescription.class, ProvisionedThroughputDescriptionMixIn.class);
        this.addMixIn(ProvisionedThroughput.class, ProvisionedThroughputMixIn.class);
        this.addMixIn(OnDemandThroughput.class, OnDemandThroughputMixIn.class);
        this.addMixIn(LocalSecondaryIndex.class, LocalSecondaryIndexMixIn.class);
        this.addMixIn(LocalSecondaryIndexDescription.class, LocalSecondaryIndexDescriptionMixIn.class);
        this.addMixIn(GlobalSecondaryIndex.class, GlobalSecondaryIndexMixIn.class);
        this.addMixIn(GlobalSecondaryIndexDescription.class, GlobalSecondaryIndexDescriptionMixIn.class);
        this.addMixIn(GlobalSecondaryIndexUpdate.class, GlobalSecondaryIndexUpdateMixIn.class);
        this.addMixIn(StreamSpecification.class, StreamSpecificationMixIn.class);
        this.addMixIn(TimeToLiveSpecification.class, TimeToLiveSpecificationMixIn.class);
        this.addMixIn(TimeToLiveDescription.class, TimeToLiveDescriptionMixIn.class);
        this.addMixIn(TableDescription.class, TableDescriptionMixIn.class);
        this.addMixIn(BillingModeSummary.class, BillingModeSummaryMixIn.class);
        this.addMixIn(ConsumedCapacity.class, ConsumedCapacityMixIn.class);
        this.addMixIn(ItemCollectionMetrics.class, ItemCollectionMetricsMixIn.class);
        this.addMixIn(KeysAndAttributes.class, KeysAndAttributesMixIn.class);
        this.addMixIn(software.amazon.awssdk.services.dynamodb.model.WriteRequest.class, WriteRequestMixIn.class);
        this.addMixIn(software.amazon.awssdk.services.dynamodb.model.PutRequest.class, PutRequestMixIn.class);
        this.addMixIn(software.amazon.awssdk.services.dynamodb.model.DeleteRequest.class, DeleteRequestMixIn.class);
        this.addMixIn(TransactGetItem.class, TransactGetItemMixIn.class);
        this.addMixIn(TransactWriteItem.class, TransactWriteItemMixIn.class);
        this.addMixIn(Put.class, PutMixIn.class);
        this.addMixIn(Delete.class, DeleteMixIn.class);
        this.addMixIn(Update.class, UpdateMixIn.class);
        this.addMixIn(ConditionCheck.class, ConditionCheckMixIn.class);
        this.addMixIn(Capacity.class, CapacityMixIn.class);
        this.addMixIn(Stream.class, StreamMixIn.class);
        this.addMixIn(BatchStatementError.class, BatchStatementErrorMixIn.class);
        this.addMixIn(BatchStatementError.Builder.class, BatchStatementErrorMixIn.class);
        this.addMixIn(TagResourceRequest.class, TagResourceRequestMixIn.class);
        this.addMixIn(TagResourceRequest.Builder.class, TagResourceRequestMixIn.class);
        this.addMixIn(TagResourceResponse.class, TagResourceResponseMixIn.class);
        this.addMixIn(TagResourceResponse.Builder.class, TagResourceResponseMixIn.class);
        this.addMixIn(UntagResourceRequest.class, UntagResourceRequestMixIn.class);
        this.addMixIn(UntagResourceRequest.Builder.class, UntagResourceRequestMixIn.class);
        this.addMixIn(UntagResourceResponse.class, UntagResourceResponseMixIn.class);
        this.addMixIn(UntagResourceResponse.Builder.class, UntagResourceResponseMixIn.class);
        this.addMixIn(ListTagsOfResourceRequest.class, ListTagsOfResourceRequestMixIn.class);
        this.addMixIn(ListTagsOfResourceRequest.Builder.class, ListTagsOfResourceRequestMixIn.class);
        this.addMixIn(ListTagsOfResourceResponse.class, ListTagsOfResourceResponseMixIn.class);
        this.addMixIn(ListTagsOfResourceResponse.Builder.class, ListTagsOfResourceResponseMixIn.class);
        this.addMixIn(Tag.class, TagMixIn.class);
        this.addMixIn(Tag.Builder.class, TagMixIn.class);
        this.addMixIn(CancellationReason.class, CancellationReasonMixIn.class);
        this.addMixIn(AttributeValue.class, LocalAttributeValueMixIn.class);
        this.addMixIn(AttributeValueUpdate.class, LocalAttributeValueUpdateMixIn.class);
        this.addMixIn(Condition.class, LocalConditionMixIn.class);
        this.addMixIn(DeleteRequest.class, LocalDeleteRequestMixIn.class);
        this.addMixIn(ExpectedAttributeValue.class, LocalExpectedAttributeValueMixIn.class);
        this.addMixIn(software.amazon.dynamodb.services.local.shared.model.KeysAndAttributes.class, LocalKeysAndAttributesMixIn.class);
        this.addMixIn(PutRequest.class, LocalPutRequestMixIn.class);
        this.addMixIn(WriteRequest.class, LocalWriteRequestMixIn.class);
        this.addMixInAnnotations(ExpressionsWrapperBase.class, ExpressionsWrapperBaseMixIn.class);
        this.addMixInAnnotations(ExpressionsWrapperBase.OperatorCounter.class, OperatorCounterMixIn.class);
        this.addMixInAnnotations(ExpressionsWrapperBase.NodeCounter.class, NodeCounterMixIn.class);
        this.addMixInAnnotations(ExpressionsWrapperBase.MaxPathDepthCounter.class, MaxPathDepthCounterMixIn.class);
    }

    private void registerApiObjectMixIns() {
        this.addMixIn(CreateTableRequest.class, CreateTableRequestMixIn.class);
        this.addMixIn(CreateTableRequest.Builder.class, CreateTableRequestMixIn.class);
        this.addMixIn(CreateTableResponse.class, CreateTableResponseMixIn.class);
        this.addMixIn(CreateTableResponse.Builder.class, CreateTableResponseMixIn.class);
        this.addMixIn(DescribeTableRequest.class, DescribeTableRequestMixIn.class);
        this.addMixIn(DescribeTableRequest.Builder.class, DescribeTableRequestMixIn.class);
        this.addMixIn(DescribeTableResponse.class, DescribeTableResponseMixIn.class);
        this.addMixIn(DescribeTableResponse.Builder.class, DescribeTableResponseMixIn.class);
        this.addMixIn(UpdateTableRequest.class, UpdateTableRequestMixIn.class);
        this.addMixIn(UpdateTableRequest.Builder.class, UpdateTableRequestMixIn.class);
        this.addMixIn(UpdateTableResponse.class, UpdateTableResponseMixIn.class);
        this.addMixIn(UpdateTableResponse.Builder.class, UpdateTableResponseMixIn.class);
        this.addMixIn(DeleteTableRequest.class, DeleteTableRequestMixIn.class);
        this.addMixIn(DeleteTableRequest.Builder.class, DeleteTableRequestMixIn.class);
        this.addMixIn(DeleteTableResponse.class, DeleteTableResponseMixIn.class);
        this.addMixIn(DeleteTableResponse.Builder.class, DeleteTableResponseMixIn.class);
        this.addMixIn(ListTablesRequest.class, ListTablesRequestMixIn.class);
        this.addMixIn(ListTablesRequest.Builder.class, ListTablesRequestMixIn.class);
        this.addMixIn(ListTablesResponse.class, ListTablesResponseMixIn.class);
        this.addMixIn(ListTablesResponse.Builder.class, ListTablesResponseMixIn.class);
        this.addMixIn(DescribeLimitsRequest.class, DescribeLimitsRequestMixIn.class);
        this.addMixIn(DescribeLimitsRequest.Builder.class, DescribeLimitsRequestMixIn.class);
        this.addMixIn(DescribeLimitsResponse.class, DescribeLimitsResponseMixIn.class);
        this.addMixIn(DescribeLimitsResponse.Builder.class, DescribeLimitsResponseMixIn.class);
        this.addMixIn(PutItemRequest.class, PutItemRequestMixIn.class);
        this.addMixIn(PutItemRequest.Builder.class, PutItemRequestMixIn.class);
        this.addMixIn(PutItemResponse.class, PutItemResponseMixIn.class);
        this.addMixIn(PutItemResponse.Builder.class, PutItemResponseMixIn.class);
        this.addMixIn(GetItemRequest.class, GetItemRequestMixIn.class);
        this.addMixIn(GetItemRequest.Builder.class, GetItemRequestMixIn.class);
        this.addMixIn(GetItemResponse.class, GetItemResponseMixIn.class);
        this.addMixIn(GetItemResponse.Builder.class, GetItemResponseMixIn.class);
        this.addMixIn(UpdateItemRequest.class, UpdateItemRequestMixIn.class);
        this.addMixIn(UpdateItemRequest.Builder.class, UpdateItemRequestMixIn.class);
        this.addMixIn(UpdateItemResponse.class, UpdateItemResponseMixIn.class);
        this.addMixIn(UpdateItemResponse.Builder.class, UpdateItemResponseMixIn.class);
        this.addMixIn(DeleteItemRequest.class, DeleteItemRequestMixIn.class);
        this.addMixIn(DeleteItemRequest.Builder.class, DeleteItemRequestMixIn.class);
        this.addMixIn(DeleteItemResponse.class, DeleteItemResponseMixIn.class);
        this.addMixIn(DeleteItemResponse.Builder.class, DeleteItemResponseMixIn.class);
        this.addMixIn(BatchGetItemRequest.class, BatchGetItemRequestMixIn.class);
        this.addMixIn(BatchGetItemRequest.Builder.class, BatchGetItemRequestMixIn.class);
        this.addMixIn(BatchGetItemResponse.class, BatchGetItemResponseMixIn.class);
        this.addMixIn(BatchGetItemResponse.Builder.class, BatchGetItemResponseMixIn.class);
        this.addMixIn(BatchWriteItemRequest.class, BatchWriteItemRequestMixIn.class);
        this.addMixIn(BatchWriteItemRequest.Builder.class, BatchWriteItemRequestMixIn.class);
        this.addMixIn(BatchWriteItemResponse.class, BatchWriteItemResponseMixIn.class);
        this.addMixIn(BatchWriteItemResponse.Builder.class, BatchWriteItemResponseMixIn.class);
        this.addMixIn(QueryRequest.class, QueryRequestMixIn.class);
        this.addMixIn(QueryRequest.Builder.class, QueryRequestMixIn.class);
        this.addMixIn(QueryResponse.class, QueryResponseMixIn.class);
        this.addMixIn(QueryResponse.Builder.class, QueryResponseMixIn.class);
        this.addMixIn(ScanRequest.class, ScanRequestMixIn.class);
        this.addMixIn(ScanRequest.Builder.class, ScanRequestMixIn.class);
        this.addMixIn(ScanResponse.class, ScanResponseMixIn.class);
        this.addMixIn(ScanResponse.Builder.class, ScanResponseMixIn.class);
        this.addMixIn(TransactGetItemsRequest.class, TransactGetItemsRequestMixIn.class);
        this.addMixIn(TransactGetItemsRequest.Builder.class, TransactGetItemsRequestMixIn.class);
        this.addMixIn(TransactGetItemsResponse.class, TransactGetItemsResponseMixIn.class);
        this.addMixIn(TransactGetItemsResponse.Builder.class, TransactGetItemsResponseMixIn.class);
        this.addMixIn(TransactWriteItemsRequest.class, TransactWriteItemsRequestMixIn.class);
        this.addMixIn(TransactWriteItemsRequest.Builder.class, TransactWriteItemsRequestMixIn.class);
        this.addMixIn(TransactWriteItemsResponse.class, TransactWriteItemsResponseMixIn.class);
        this.addMixIn(TransactWriteItemsResponse.Builder.class, TransactWriteItemsResponseMixIn.class);
        this.addMixIn(ItemResponse.class, ItemResponseMixIn.class);
        this.addMixIn(ItemResponse.Builder.class, ItemResponseMixIn.class);
        this.addMixIn(ItemResponse.serializableBuilderClass(), ItemResponseMixIn.class);
        this.addMixIn(ExecuteStatementRequest.class, ExecuteStatementRequestMixIn.class);
        this.addMixIn(ExecuteStatementRequest.Builder.class, ExecuteStatementRequestMixIn.class);
        this.addMixIn(ExecuteStatementResponse.class, ExecuteStatementResponseMixIn.class);
        this.addMixIn(ExecuteStatementResponse.Builder.class, ExecuteStatementResponseMixIn.class);
        this.addMixIn(BatchExecuteStatementRequest.class, BatchExecuteStatementRequestMixIn.class);
        this.addMixIn(BatchExecuteStatementRequest.Builder.class, BatchExecuteStatementRequestMixIn.class);
        this.addMixIn(BatchExecuteStatementResponse.class, BatchExecuteStatementResponseMixIn.class);
        this.addMixIn(BatchExecuteStatementResponse.Builder.class, BatchExecuteStatementResponseMixIn.class);
        this.addMixIn(ExecuteTransactionRequest.class, ExecuteTransactionRequestMixIn.class);
        this.addMixIn(ExecuteTransactionRequest.Builder.class, ExecuteTransactionRequestMixIn.class);
        this.addMixIn(ExecuteTransactionResponse.class, ExecuteTransactionResponseMixIn.class);
        this.addMixIn(ExecuteTransactionResponse.Builder.class, ExecuteTransactionResponseMixIn.class);
        this.addMixIn(BatchStatementResponse.class, BatchStatementResponseMixIn.class);
        this.addMixIn(BatchStatementResponse.Builder.class, BatchStatementResponseMixIn.class);
        this.addMixIn(DescribeTimeToLiveRequest.class, DescribeTimeToLiveRequestMixIn.class);
        this.addMixIn(DescribeTimeToLiveRequest.Builder.class, DescribeTimeToLiveRequestMixIn.class);
        this.addMixIn(DescribeTimeToLiveResponse.class, DescribeTimeToLiveResponseMixIn.class);
        this.addMixIn(DescribeTimeToLiveResponse.Builder.class, DescribeTimeToLiveResponseMixIn.class);
        this.addMixIn(UpdateTimeToLiveRequest.class, UpdateTimeToLiveRequestMixIn.class);
        this.addMixIn(UpdateTimeToLiveRequest.Builder.class, UpdateTimeToLiveRequestMixIn.class);
        this.addMixIn(UpdateTimeToLiveResponse.class, UpdateTimeToLiveResponseMixIn.class);
        this.addMixIn(UpdateTimeToLiveResponse.Builder.class, UpdateTimeToLiveResponseMixIn.class);
        this.addMixIn(ListStreamsRequest.class, ListStreamsRequestMixIn.class);
        this.addMixIn(ListStreamsRequest.Builder.class, ListStreamsRequestMixIn.class);
        this.addMixIn(ListStreamsResponse.class, ListStreamsResponseMixIn.class);
        this.addMixIn(ListStreamsResponse.Builder.class, ListStreamsResponseMixIn.class);
        this.addMixIn(DescribeStreamRequest.class, DescribeStreamRequestMixIn.class);
        this.addMixIn(DescribeStreamRequest.Builder.class, DescribeStreamRequestMixIn.class);
        this.addMixIn(DescribeStreamResponse.class, DescribeStreamResponseMixIn.class);
        this.addMixIn(DescribeStreamResponse.Builder.class, DescribeStreamResponseMixIn.class);
        this.addMixIn(StreamDescription.class, StreamDescriptionMixIn.class);
        this.addMixIn(Shard.class, ShardMixIn.class);
        this.addMixIn(SequenceNumberRange.class, SequenceNumberRangeMixIn.class);
        this.addMixIn(GetShardIteratorRequest.class, GetShardIteratorRequestMixIn.class);
        this.addMixIn(GetShardIteratorRequest.Builder.class, GetShardIteratorRequestMixIn.class);
        this.addMixIn(GetShardIteratorResponse.class, GetShardIteratorResponseMixIn.class);
        this.addMixIn(GetShardIteratorResponse.Builder.class, GetShardIteratorResponseMixIn.class);
        this.addMixIn(GetRecordsRequest.class, GetRecordsRequestMixIn.class);
        this.addMixIn(GetRecordsRequest.Builder.class, GetRecordsRequestMixIn.class);
        this.addMixIn(GetRecordsResponse.class, GetRecordsResponseMixIn.class);
        this.addMixIn(GetRecordsResponse.Builder.class, GetRecordsResponseMixIn.class);
        this.addMixIn(Record.class, RecordMixIn.class);
        this.addMixIn(StreamRecord.class, StreamRecordMixIn.class);
        this.addMixIn(Identity.class, IdentityMixIn.class);
    }

    private static class InstantSerializer
    extends JsonSerializer<Instant> {
        private InstantSerializer() {
        }

        public void serialize(Instant value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNumber(BigDecimal.valueOf((double)value.toEpochMilli() / 1000.0).setScale(3, RoundingMode.HALF_UP));
        }
    }

    private static class DateSerializer
    extends JsonSerializer<Date> {
        private DateSerializer() {
        }

        public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNumber(BigDecimal.valueOf((double)value.getTime() / 1000.0).setScale(3, RoundingMode.HALF_UP));
        }
    }

    private static class DateDeserializer
    extends JsonDeserializer<Date> {
        private DateDeserializer() {
        }

        public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(jp.getValueAsLong() * 1000L);
            return calendar.getTime();
        }
    }

    private static class InstantDeserializer
    extends JsonDeserializer<Instant> {
        private InstantDeserializer() {
        }

        public Instant deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            long epochSecond = jp.getValueAsLong();
            return Instant.ofEpochMilli(epochSecond * 1000L);
        }
    }

    public static abstract class AttributeValueMixIn {
        @JsonProperty(value="S")
        abstract String s();

        @JsonProperty(value="N")
        abstract String n();

        @JsonProperty(value="B")
        abstract SdkBytes b();

        @JsonProperty(value="SS")
        abstract List<String> ss();

        @JsonProperty(value="NS")
        abstract List<String> ns();

        @JsonProperty(value="BS")
        abstract List<SdkBytes> bs();

        @JsonProperty(value="M")
        abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> m();

        @JsonProperty(value="L")
        abstract List<software.amazon.awssdk.services.dynamodb.model.AttributeValue> l();

        @JsonProperty(value="NULL")
        abstract Boolean nul();

        @JsonProperty(value="BOOL")
        abstract Boolean bool();
    }

    private static abstract class AttributeDefinitionMixIn {
        private AttributeDefinitionMixIn() {
        }

        @JsonProperty(value="AttributeName")
        public abstract String attributeName();

        @JsonProperty(value="AttributeType")
        public abstract String attributeTypeAsString();
    }

    private static abstract class KeySchemaElementMixIn {
        private KeySchemaElementMixIn() {
        }

        @JsonProperty(value="AttributeName")
        public abstract String attributeName();

        @JsonProperty(value="KeyType")
        public abstract KeyType keyType();
    }

    private static abstract class ProjectionMixIn {
        private ProjectionMixIn() {
        }

        @JsonProperty(value="NonKeyAttributes")
        public abstract List<String> nonKeyAttributes();

        @JsonProperty(value="ProjectionType")
        public abstract Projection projectionType();
    }

    private static abstract class ProvisionedThroughputDescriptionMixIn {
        private ProvisionedThroughputDescriptionMixIn() {
        }

        @JsonProperty(value="LastDecreaseDateTime")
        public abstract Instant lastDecreaseDateTime();

        @JsonProperty(value="LastIncreaseDateTime")
        public abstract Instant lastIncreaseDateTime();

        @JsonProperty(value="NumberOfDecreasesToday")
        public abstract Long numberOfDecreasesToday();

        @JsonProperty(value="ReadCapacityUnits")
        public abstract Long readCapacityUnits();

        @JsonProperty(value="WriteCapacityUnits")
        public abstract Long writeCapacityUnits();
    }

    private static abstract class ProvisionedThroughputMixIn {
        private ProvisionedThroughputMixIn() {
        }

        @JsonProperty(value="ReadCapacityUnits")
        public abstract Long readCapacityUnits();

        @JsonProperty(value="WriteCapacityUnits")
        public abstract Long writeCapacityUnits();
    }

    private static abstract class OnDemandThroughputMixIn {
        private OnDemandThroughputMixIn() {
        }

        @JsonProperty(value="MaxReadRequestUnits")
        public abstract Long maxReadRequestUnits();

        @JsonProperty(value="MaxWriteRequestUnits")
        public abstract Long maxWriteRequestUnits();
    }

    private static abstract class LocalSecondaryIndexMixIn {
        private LocalSecondaryIndexMixIn() {
        }

        @JsonProperty(value="IndexName")
        public abstract String indexName();

        @JsonProperty(value="KeySchema")
        public abstract List<KeySchemaElement> keySchema();

        @JsonProperty(value="Projection")
        public abstract Projection projection();
    }

    private static abstract class LocalSecondaryIndexDescriptionMixIn {
        private LocalSecondaryIndexDescriptionMixIn() {
        }

        @JsonProperty(value="IndexName")
        public abstract String indexName();

        @JsonProperty(value="IndexSizeBytes")
        public abstract Long indexSizeBytes();

        @JsonProperty(value="ItemCount")
        public abstract Long itemCount();

        @JsonProperty(value="KeySchema")
        public abstract List<KeySchemaElement> keySchema();

        @JsonProperty(value="Projection")
        public abstract Projection projection();

        @JsonProperty(value="IndexArn")
        public abstract String indexArn();
    }

    private static abstract class GlobalSecondaryIndexMixIn {
        private GlobalSecondaryIndexMixIn() {
        }

        @JsonProperty(value="IndexName")
        public abstract String indexName();

        @JsonProperty(value="KeySchema")
        public abstract List<KeySchemaElement> keySchema();

        @JsonProperty(value="Projection")
        public abstract Projection projection();

        @JsonProperty(value="ProvisionedThroughput")
        public abstract ProvisionedThroughput provisionedThroughput();

        @JsonProperty(value="OnDemandThroughput")
        public abstract OnDemandThroughput onDemandThroughput();
    }

    private static abstract class GlobalSecondaryIndexDescriptionMixIn {
        private GlobalSecondaryIndexDescriptionMixIn() {
        }

        @JsonProperty(value="IndexName")
        public abstract String indexName();

        @JsonProperty(value="KeySchema")
        public abstract List<KeySchemaElement> keySchema();

        @JsonProperty(value="Projection")
        public abstract Projection projection();

        @JsonProperty(value="IndexStatus")
        public abstract IndexStatus indexStatus();

        @JsonProperty(value="Backfilling")
        public abstract Boolean backfilling();

        @JsonProperty(value="ProvisionedThroughput")
        public abstract ProvisionedThroughput provisionedThroughput();

        @JsonProperty(value="OnDemandThroughput")
        public abstract OnDemandThroughput onDemandThroughput();

        @JsonProperty(value="IndexSizeBytes")
        public abstract Long indexSizeBytes();

        @JsonProperty(value="ItemCount")
        public abstract Long itemCount();

        @JsonProperty(value="IndexArn")
        public abstract String indexArn();
    }

    private static abstract class GlobalSecondaryIndexUpdateMixIn {
        private GlobalSecondaryIndexUpdateMixIn() {
        }

        @JsonProperty(value="Create")
        public abstract CreateGlobalSecondaryIndexAction create();

        @JsonProperty(value="Update")
        public abstract UpdateGlobalSecondaryIndexAction update();

        @JsonProperty(value="Delete")
        public abstract DeleteGlobalSecondaryIndexAction delete();
    }

    private static abstract class StreamSpecificationMixIn {
        private StreamSpecificationMixIn() {
        }

        @JsonProperty(value="StreamEnabled")
        public abstract Boolean streamEnabled();

        @JsonProperty(value="StreamViewType")
        public abstract StreamViewType streamViewType();
    }

    private static abstract class TimeToLiveSpecificationMixIn {
        private TimeToLiveSpecificationMixIn() {
        }

        @JsonProperty(value="Enabled")
        public abstract Boolean enabled();

        @JsonProperty(value="AttributeName")
        public abstract String attributeName();
    }

    private static abstract class TimeToLiveDescriptionMixIn {
        private TimeToLiveDescriptionMixIn() {
        }

        @JsonProperty(value="TimeToLiveStatus")
        public abstract String timeToLiveStatus();

        @JsonProperty(value="AttributeName")
        public abstract String attributeName();
    }

    private static abstract class TableDescriptionMixIn {
        private TableDescriptionMixIn() {
        }

        @JsonProperty(value="AttributeDefinitions")
        public abstract List<AttributeDefinition> attributeDefinitions();

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="KeySchema")
        public abstract List<KeySchemaElement> keySchema();

        @JsonProperty(value="TableStatus")
        public abstract String tableStatus();

        @JsonProperty(value="TableStatus")
        public abstract TableStatus tableStatusAsEnum();

        @JsonProperty(value="CreationDateTime")
        public abstract Instant creationDateTime();

        @JsonProperty(value="ProvisionedThroughput")
        public abstract ProvisionedThroughputDescription provisionedThroughput();

        @JsonProperty(value="OnDemandThroughput")
        public abstract OnDemandThroughput onDemandThroughput();

        @JsonProperty(value="BillingModeSummary")
        public abstract BillingModeSummary billingModeSummary();

        @JsonProperty(value="DeletionProtectionEnabled")
        public abstract Boolean deletionProtectionEnabled();

        @JsonProperty(value="TableSizeBytes")
        public abstract Long tableSizeBytes();

        @JsonProperty(value="ItemCount")
        public abstract Long itemCount();

        @JsonProperty(value="TableArn")
        public abstract String tableArn();

        @JsonProperty(value="LocalSecondaryIndexes")
        public abstract List<LocalSecondaryIndexDescription> localSecondaryIndexes();

        @JsonProperty(value="GlobalSecondaryIndexes")
        public abstract List<GlobalSecondaryIndexDescription> globalSecondaryIndexes();

        @JsonProperty(value="StreamSpecification")
        public abstract StreamSpecification streamSpecification();

        @JsonProperty(value="TimeToLiveSpecification")
        public abstract TimeToLiveSpecification timeToLiveSpecification();

        @JsonProperty(value="LatestStreamLabel")
        public abstract String latestStreamLabel();

        @JsonProperty(value="LatestStreamArn")
        public abstract String latestStreamArn();
    }

    private static abstract class BillingModeSummaryMixIn {
        private BillingModeSummaryMixIn() {
        }

        @JsonProperty(value="BillingMode")
        public abstract String billingMode();

        @JsonProperty(value="BillingMode")
        public abstract BillingMode billingModeAsEnum();

        @JsonProperty(value="LastUpdateToPayPerRequestDateTime")
        public abstract Instant lastUpdateToPayPerRequestDateTime();
    }

    private static abstract class ConsumedCapacityMixIn {
        private ConsumedCapacityMixIn() {
        }

        @JsonProperty(value="CapacityUnits")
        public abstract Double capacityUnits();

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="Table")
        public abstract Capacity table();

        @JsonProperty(value="LocalSecondaryIndexes")
        public abstract Map<String, Capacity> localSecondaryIndexes();

        @JsonProperty(value="GlobalSecondaryIndexes")
        public abstract Map<String, Capacity> globalSecondaryIndexes();
    }

    private static abstract class ItemCollectionMetricsMixIn {
        private ItemCollectionMetricsMixIn() {
        }

        @JsonProperty(value="ItemCollectionKey")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> itemCollectionKey();

        @JsonProperty(value="SizeEstimateRangeGB")
        public abstract List<Double> sizeEstimateRangeGB();
    }

    private static abstract class KeysAndAttributesMixIn {
        private KeysAndAttributesMixIn() {
        }

        @JsonProperty(value="Keys")
        public abstract List<Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>> keys();

        @JsonProperty(value="ConsistentRead")
        public abstract Boolean consistentRead();

        @JsonProperty(value="ProjectionExpression")
        public abstract String projectionExpression();

        @JsonProperty(value="ExpressionAttributeNames")
        public abstract Map<String, String> expressionAttributeNames();
    }

    private static abstract class WriteRequestMixIn {
        private WriteRequestMixIn() {
        }

        @JsonProperty(value="PutRequest")
        public abstract software.amazon.awssdk.services.dynamodb.model.PutRequest putRequest();

        @JsonProperty(value="DeleteRequest")
        public abstract software.amazon.awssdk.services.dynamodb.model.DeleteRequest deleteRequest();
    }

    private static abstract class PutRequestMixIn {
        private PutRequestMixIn() {
        }

        @JsonProperty(value="Item")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> item();
    }

    private static abstract class DeleteRequestMixIn {
        private DeleteRequestMixIn() {
        }

        @JsonProperty(value="Key")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> key();
    }

    private static abstract class TransactGetItemMixIn {
        private TransactGetItemMixIn() {
        }

        @JsonProperty(value="Get")
        public abstract Get get();
    }

    private static abstract class TransactWriteItemMixIn {
        private TransactWriteItemMixIn() {
        }

        @JsonProperty(value="Put")
        public abstract Put put();

        @JsonProperty(value="Delete")
        public abstract Delete delete();

        @JsonProperty(value="Update")
        public abstract Update update();

        @JsonProperty(value="ConditionCheck")
        public abstract ConditionCheck conditionCheck();
    }

    private static abstract class PutMixIn {
        private PutMixIn() {
        }

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="Item")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> item();

        @JsonProperty(value="ConditionExpression")
        public abstract String conditionExpression();

        @JsonProperty(value="ExpressionAttributeNames")
        public abstract Map<String, String> expressionAttributeNames();

        @JsonProperty(value="ExpressionAttributeValues")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> expressionAttributeValues();

        @JsonProperty(value="ReturnValuesOnConditionCheckFailure")
        public abstract String returnValuesOnConditionCheckFailure();
    }

    private static abstract class DeleteMixIn {
        private DeleteMixIn() {
        }

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="Key")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> key();

        @JsonProperty(value="ConditionExpression")
        public abstract String conditionExpression();

        @JsonProperty(value="ExpressionAttributeNames")
        public abstract Map<String, String> expressionAttributeNames();

        @JsonProperty(value="ExpressionAttributeValues")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> expressionAttributeValues();

        @JsonProperty(value="ReturnValuesOnConditionCheckFailure")
        public abstract String returnValuesOnConditionCheckFailure();
    }

    private static abstract class UpdateMixIn {
        private UpdateMixIn() {
        }

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="Key")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> key();

        @JsonProperty(value="UpdateExpression")
        public abstract String updateExpression();

        @JsonProperty(value="ConditionExpression")
        public abstract String conditionExpression();

        @JsonProperty(value="ExpressionAttributeNames")
        public abstract Map<String, String> expressionAttributeNames();

        @JsonProperty(value="ExpressionAttributeValues")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> expressionAttributeValues();

        @JsonProperty(value="ReturnValuesOnConditionCheckFailure")
        public abstract String returnValuesOnConditionCheckFailure();
    }

    private static abstract class ConditionCheckMixIn {
        private ConditionCheckMixIn() {
        }

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="Key")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> key();

        @JsonProperty(value="ConditionExpression")
        public abstract String conditionExpression();

        @JsonProperty(value="ExpressionAttributeNames")
        public abstract Map<String, String> expressionAttributeNames();

        @JsonProperty(value="ExpressionAttributeValues")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> expressionAttributeValues();

        @JsonProperty(value="ReturnValuesOnConditionCheckFailure")
        public abstract String returnValuesOnConditionCheckFailure();
    }

    private static abstract class CapacityMixIn {
        private CapacityMixIn() {
        }

        @JsonProperty(value="CapacityUnits")
        public abstract Double capacityUnits();

        @JsonProperty(value="ReadCapacityUnits")
        public abstract Double readCapacityUnits();

        @JsonProperty(value="WriteCapacityUnits")
        public abstract Double writeCapacityUnits();
    }

    private static abstract class StreamMixIn {
        private StreamMixIn() {
        }

        @JsonProperty(value="StreamArn")
        public abstract String streamArn();

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="StreamLabel")
        public abstract String streamLabel();

        @JsonProperty(value="StreamArn")
        public abstract Stream.Builder streamArn(String var1);

        @JsonProperty(value="TableName")
        public abstract Stream.Builder tableName(String var1);

        @JsonProperty(value="StreamLabel")
        public abstract Stream.Builder streamLabel(String var1);
    }

    private static abstract class BatchStatementErrorMixIn {
        private BatchStatementErrorMixIn() {
        }

        @JsonProperty(value="Code")
        public abstract String codeAsString();

        @JsonProperty(value="Message")
        public abstract String message();

        @JsonProperty(value="Item")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> item();

        @JsonProperty(value="Code")
        public abstract BatchStatementError.Builder codeAsString(String var1);

        @JsonProperty(value="Message")
        public abstract BatchStatementError.Builder message(String var1);

        @JsonProperty(value="Item")
        public abstract BatchStatementError.Builder item(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);
    }

    private static abstract class TagResourceRequestMixIn {
        private TagResourceRequestMixIn() {
        }

        @JsonProperty(value="ResourceArn")
        public abstract String resourceArn();

        @JsonProperty(value="Tags")
        public abstract List<Tag> tags();

        @JsonProperty(value="ResourceArn")
        public abstract TagResourceRequest.Builder resourceArn(String var1);

        @JsonProperty(value="Tags")
        public abstract TagResourceRequest.Builder tags(List<Tag> var1);
    }

    private static abstract class TagResourceResponseMixIn {
        private TagResourceResponseMixIn() {
        }
    }

    private static abstract class UntagResourceRequestMixIn {
        private UntagResourceRequestMixIn() {
        }

        @JsonProperty(value="ResourceArn")
        public abstract String resourceArn();

        @JsonProperty(value="TagKeys")
        public abstract List<String> tagKeys();

        @JsonProperty(value="ResourceArn")
        public abstract UntagResourceRequest.Builder resourceArn(String var1);

        @JsonProperty(value="TagKeys")
        public abstract UntagResourceRequest.Builder tagKeys(List<String> var1);
    }

    private static abstract class UntagResourceResponseMixIn {
        private UntagResourceResponseMixIn() {
        }
    }

    private static abstract class ListTagsOfResourceRequestMixIn {
        private ListTagsOfResourceRequestMixIn() {
        }

        @JsonProperty(value="ResourceArn")
        public abstract String resourceArn();

        @JsonProperty(value="NextToken")
        public abstract String nextToken();

        @JsonProperty(value="ResourceArn")
        public abstract ListTagsOfResourceRequest.Builder resourceArn(String var1);

        @JsonProperty(value="NextToken")
        public abstract ListTagsOfResourceRequest.Builder nextToken(String var1);
    }

    private static abstract class ListTagsOfResourceResponseMixIn {
        private ListTagsOfResourceResponseMixIn() {
        }

        @JsonProperty(value="Tags")
        public abstract List<Tag> tags();

        @JsonProperty(value="NextToken")
        public abstract String nextToken();

        @JsonProperty(value="Tags")
        public abstract ListTagsOfResourceResponse.Builder tags(List<Tag> var1);

        @JsonProperty(value="NextToken")
        public abstract ListTagsOfResourceResponse.Builder nextToken(String var1);
    }

    private static abstract class TagMixIn {
        private TagMixIn() {
        }

        @JsonProperty(value="Key")
        public abstract String key();

        @JsonProperty(value="Value")
        public abstract String value();

        @JsonProperty(value="Key")
        public abstract Tag.Builder key(String var1);

        @JsonProperty(value="Value")
        public abstract Tag.Builder value(String var1);
    }

    private static abstract class CancellationReasonMixIn {
        private CancellationReasonMixIn() {
        }

        @JsonProperty(value="Code")
        public abstract String code();

        @JsonProperty(value="Item")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> item();

        @JsonProperty(value="Message")
        public abstract String message();
    }

    private static abstract class LocalAttributeValueMixIn {
        private LocalAttributeValueMixIn() {
        }

        @JsonProperty(value="S")
        public abstract String getS();

        @JsonProperty(value="S")
        public abstract void setS(String var1);

        @JsonProperty(value="N")
        public abstract String getN();

        @JsonProperty(value="N")
        public abstract void setN(String var1);

        @JsonProperty(value="B")
        public abstract ByteBuffer getB();

        @JsonProperty(value="B")
        public abstract void setB(ByteBuffer var1);

        @JsonProperty(value="NULL")
        public abstract Boolean getNULL();

        @JsonProperty(value="NULL")
        public abstract void setNULL(Boolean var1);

        @JsonProperty(value="BOOL")
        public abstract Boolean getBOOL();

        @JsonProperty(value="BOOL")
        public abstract void setBOOL(Boolean var1);

        @JsonProperty(value="SS")
        public abstract List<String> getSS();

        @JsonProperty(value="SS")
        public abstract void setSS(List<String> var1);

        @JsonProperty(value="NS")
        public abstract List<String> getNS();

        @JsonProperty(value="NS")
        public abstract void setNS(List<String> var1);

        @JsonProperty(value="BS")
        public abstract List<String> getBS();

        @JsonProperty(value="BS")
        public abstract void setBS(List<String> var1);

        @JsonProperty(value="M")
        public abstract Map<String, AttributeValue> getM();

        @JsonProperty(value="M")
        public abstract void setM(Map<String, AttributeValue> var1);

        @JsonProperty(value="L")
        public abstract List<AttributeValue> getL();

        @JsonProperty(value="L")
        public abstract void setL(List<AttributeValue> var1);

        @JsonIgnore
        public abstract String getType();

        @JsonIgnore
        public abstract void setType(String var1);

        @JsonIgnore
        public abstract Boolean isNull();
    }

    private static abstract class LocalAttributeValueUpdateMixIn {
        private LocalAttributeValueUpdateMixIn() {
        }

        @JsonProperty(value="Action")
        public abstract String getAction();

        @JsonProperty(value="Action")
        public abstract void setAction(String var1);

        @JsonProperty(value="Value")
        public abstract AttributeValue getValue();

        @JsonProperty(value="Value")
        public abstract void setValue(AttributeValue var1);
    }

    private static abstract class LocalConditionMixIn {
        private LocalConditionMixIn() {
        }

        @JsonProperty(value="AttributeValueList")
        public abstract List<AttributeValue> getAttributeValueList();

        @JsonProperty(value="AttributeValueList")
        public abstract void setAttributeValueList(List<AttributeValue> var1);

        @JsonProperty(value="ComparisonOperator")
        public abstract String getComparisonOperator();

        @JsonProperty(value="ComparisonOperator")
        public abstract void setComparisonOperator(String var1);
    }

    private static abstract class LocalDeleteRequestMixIn {
        private LocalDeleteRequestMixIn() {
        }

        @JsonProperty(value="Key")
        public abstract Map<String, AttributeValue> getKey();

        @JsonProperty(value="Key")
        public abstract void setKey(Map<String, AttributeValue> var1);
    }

    private static abstract class LocalExpectedAttributeValueMixIn {
        private LocalExpectedAttributeValueMixIn() {
        }

        @JsonProperty(value="Exists")
        public abstract Boolean getExists();

        @JsonProperty(value="Exists")
        public abstract void setExists(Boolean var1);

        @JsonProperty(value="Value")
        public abstract AttributeValue getValue();

        @JsonProperty(value="Value")
        public abstract void setValue(AttributeValue var1);

        @JsonProperty(value="ConditionalOperator")
        public abstract ConditionalOperator getConditionalOperator();

        @JsonProperty(value="ConditionalOperator")
        public abstract void setConditionalOperator(ConditionalOperator var1);

        @JsonProperty(value="ComparisonOperator")
        public abstract String getComparisonOperator();

        @JsonProperty(value="ComparisonOperator")
        public abstract void setComparisonOperator(String var1);

        @JsonProperty(value="AttributeValueList")
        public abstract List<AttributeValue> getAttributeValueList();

        @JsonProperty(value="AttributeValueList")
        public abstract void setAttributeValueList(List<AttributeValue> var1);
    }

    private static abstract class LocalKeysAndAttributesMixIn {
        private LocalKeysAndAttributesMixIn() {
        }

        @JsonProperty(value="AttributesToGet")
        public abstract List<String> getAttributesToGet();

        @JsonProperty(value="AttributesToGet")
        public abstract void setAttributesToGet(List<String> var1);

        @JsonProperty(value="ConsistentRead")
        public abstract Boolean getConsistentRead();

        @JsonProperty(value="ConsistentRead")
        public abstract void setConsistentRead(Boolean var1);

        @JsonProperty(value="Keys")
        public abstract List<Map<String, AttributeValue>> getKeys();

        @JsonProperty(value="Keys")
        public abstract void setKeys(List<Map<String, AttributeValue>> var1);

        @JsonProperty(value="ProjectionExpression")
        public abstract void getProjectionExpression();

        @JsonProperty(value="ProjectionExpression")
        public abstract void setProjectionExpression(String var1);

        @JsonProperty(value="ExpressionAttributeNames")
        public abstract void getExpressionAttributeNames();

        @JsonProperty(value="ExpressionAttributeNames")
        public abstract void setExpressionAttributeNames(Map<String, String> var1);
    }

    private static abstract class LocalPutRequestMixIn {
        private LocalPutRequestMixIn() {
        }

        @JsonProperty(value="Item")
        public abstract Map<String, AttributeValue> getItem();

        @JsonProperty(value="Item")
        public abstract void setItem(Map<String, AttributeValue> var1);
    }

    private static abstract class LocalWriteRequestMixIn {
        private LocalWriteRequestMixIn() {
        }

        @JsonProperty(value="DeleteRequest")
        public abstract DeleteRequest getDeleteRequest();

        @JsonProperty(value="DeleteRequest")
        public abstract void setDeleteRequest(DeleteRequest var1);

        @JsonProperty(value="PutRequest")
        public abstract PutRequest getPutRequest();

        @JsonProperty(value="PutRequest")
        public abstract void setPutRequest(PutRequest var1);
    }

    private static abstract class ExpressionsWrapperBaseMixIn {
        private ExpressionsWrapperBaseMixIn() {
        }

        @JsonProperty(value="NameParameterUsage")
        public abstract Map<String, Integer> getNameParameterUsage();

        @JsonProperty(value="ValueParameterUsage")
        public abstract Map<String, Integer> getValueParameterUsage();

        @JsonProperty(value="ExpressionSize")
        public abstract int validateCombinedExpressionSize(int var1, Map<String, Integer> var2, Map<String, Integer> var3, DbEnv var4);

        @JsonProperty(value="ParameterUsageSize")
        public abstract int getParameterUsageSize(Map<String, Integer> var1, Map<String, Integer> var2, DbEnv var3);

        @JsonProperty(value="TopLevelFields")
        public abstract Set<String> getTopLevelFieldsWithNestedAccess();

        @JsonProperty(value="OperatorCounter")
        public abstract ExpressionsWrapperBase.OperatorCounter getOperatorCounter();

        @JsonProperty(value="NodeCounter")
        public abstract ExpressionsWrapperBase.NodeCounter getNodeCounter();

        @JsonProperty(value="MaxPathDepthCounter")
        public abstract ExpressionsWrapperBase.MaxPathDepthCounter getMaxPathDepthCounter();

        @JsonProperty(value="CumulativeSize")
        public abstract int getCumulativeSize();
    }

    private static abstract class OperatorCounterMixIn {
        private OperatorCounterMixIn() {
        }

        @JsonProperty(value="Count")
        public abstract int value();

        @JsonProperty(value="Count")
        public abstract int set(int var1);

        @JsonProperty(value="IncrementedCounter")
        public abstract int increment();
    }

    private static abstract class NodeCounterMixIn {
        private NodeCounterMixIn() {
        }

        @JsonProperty(value="Count")
        public abstract int value();

        @JsonProperty(value="Count")
        public abstract int set(int var1);

        @JsonProperty(value="IncrementedCounter")
        public abstract int increment();
    }

    private static abstract class MaxPathDepthCounterMixIn {
        private MaxPathDepthCounterMixIn() {
        }

        @JsonProperty(value="Count")
        public abstract int value();

        @JsonProperty(value="Count")
        public abstract int set(int var1);

        @JsonProperty(value="IncrementedCounter")
        public abstract int increment();
    }

    private static abstract class CreateTableRequestMixIn {
        private CreateTableRequestMixIn() {
        }

        @JsonProperty(value="AttributeDefinitions")
        public abstract List<AttributeDefinition> attributeDefinitions();

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="KeySchema")
        public abstract List<KeySchemaElement> keySchema();

        @JsonProperty(value="LocalSecondaryIndexes")
        public abstract List<LocalSecondaryIndex> localSecondaryIndexes();

        @JsonProperty(value="GlobalSecondaryIndexes")
        public abstract List<GlobalSecondaryIndex> globalSecondaryIndexes();

        @JsonProperty(value="ProvisionedThroughput")
        public abstract ProvisionedThroughput provisionedThroughput();

        @JsonProperty(value="OnDemandThroughput")
        public abstract OnDemandThroughput onDemandThroughput();

        @JsonProperty(value="BillingMode")
        public abstract BillingMode billingMode();

        @JsonProperty(value="DeletionProtectionEnabled")
        public abstract Boolean deletionProtectionEnabled();

        @JsonProperty(value="StreamSpecification")
        public abstract StreamSpecification streamSpecification();

        @JsonProperty(value="AttributeDefinitions")
        public abstract CreateTableRequest.Builder attributeDefinitions(List<AttributeDefinition> var1);

        @JsonProperty(value="TableName")
        public abstract CreateTableRequest.Builder tableName(String var1);

        @JsonProperty(value="KeySchema")
        public abstract CreateTableRequest.Builder keySchema(List<KeySchemaElement> var1);

        @JsonProperty(value="LocalSecondaryIndexes")
        public abstract CreateTableRequest.Builder localSecondaryIndexes(List<LocalSecondaryIndex> var1);

        @JsonProperty(value="GlobalSecondaryIndexes")
        public abstract CreateTableRequest.Builder globalSecondaryIndexes(List<GlobalSecondaryIndex> var1);

        @JsonProperty(value="ProvisionedThroughput")
        public abstract CreateTableRequest.Builder provisionedThroughput(ProvisionedThroughput var1);

        @JsonProperty(value="OnDemandThroughput")
        public abstract CreateTableRequest.Builder onDemandThroughput(OnDemandThroughput var1);

        @JsonProperty(value="BillingMode")
        public abstract CreateTableRequest.Builder billingMode(BillingMode var1);

        @JsonProperty(value="DeletionProtectionEnabled")
        public abstract CreateTableRequest.Builder deletionProtectionEnabled(Boolean var1);

        @JsonProperty(value="StreamSpecification")
        public abstract CreateTableRequest.Builder streamSpecification(StreamSpecification var1);
    }

    private static abstract class CreateTableResponseMixIn {
        private CreateTableResponseMixIn() {
        }

        @JsonProperty(value="TableDescription")
        abstract TableDescription tableDescription();

        @JsonProperty(value="TableDescription")
        abstract CreateTableResponse.Builder tableDescription(TableDescription var1);
    }

    private static abstract class DescribeTableRequestMixIn {
        private DescribeTableRequestMixIn() {
        }

        @JsonProperty(value="TableName")
        abstract String tableName();

        @JsonProperty(value="TableName")
        abstract DescribeTableRequest.Builder tableName(String var1);
    }

    private static abstract class DescribeTableResponseMixIn {
        private DescribeTableResponseMixIn() {
        }

        @JsonProperty(value="Table")
        abstract TableDescription table();

        @JsonProperty(value="Table")
        abstract DescribeTableResponse.Builder table(TableDescription var1);
    }

    private static abstract class UpdateTableRequestMixIn {
        private UpdateTableRequestMixIn() {
        }

        @JsonProperty(value="AttributeDefinitions")
        public abstract List<AttributeDefinition> attributeDefinitions();

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="ProvisionedThroughput")
        public abstract ProvisionedThroughput provisionedThroughput();

        @JsonProperty(value="OnDemandThroughput")
        public abstract OnDemandThroughput onDemandThroughput();

        @JsonProperty(value="BillingMode")
        public abstract BillingMode billingMode();

        @JsonProperty(value="DeletionProtectionEnabled")
        public abstract Boolean deletionProtectionEnabled();

        @JsonProperty(value="GlobalSecondaryIndexUpdates")
        public abstract List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates();

        @JsonProperty(value="StreamSpecification")
        public abstract StreamSpecification streamSpecification();

        @JsonProperty(value="AttributeDefinitions")
        public abstract UpdateTableRequest.Builder attributeDefinitions(List<AttributeDefinition> var1);

        @JsonProperty(value="TableName")
        public abstract UpdateTableRequest.Builder tableName(String var1);

        @JsonProperty(value="ProvisionedThroughput")
        public abstract UpdateTableRequest.Builder provisionedThroughput(ProvisionedThroughput var1);

        @JsonProperty(value="OnDemandThroughput")
        public abstract UpdateTableRequest.Builder onDemandThroughput(OnDemandThroughput var1);

        @JsonProperty(value="BillingMode")
        public abstract UpdateTableRequest.Builder billingMode(BillingMode var1);

        @JsonProperty(value="DeletionProtectionEnabled")
        public abstract UpdateTableRequest.Builder deletionProtectionEnabled(Boolean var1);

        @JsonProperty(value="GlobalSecondaryIndexUpdates")
        public abstract UpdateTableRequest.Builder globalSecondaryIndexUpdates(List<GlobalSecondaryIndexUpdate> var1);

        @JsonProperty(value="StreamSpecification")
        public abstract UpdateTableRequest.Builder streamSpecification(StreamSpecification var1);
    }

    private static abstract class UpdateTableResponseMixIn {
        private UpdateTableResponseMixIn() {
        }

        @JsonProperty(value="TableDescription")
        abstract TableDescription tableDescription();

        @JsonProperty(value="TableDescription")
        abstract UpdateTableResponse.Builder tableDescription(TableDescription var1);
    }

    private static abstract class DeleteTableRequestMixIn {
        private DeleteTableRequestMixIn() {
        }

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="TableName")
        public abstract DeleteTableRequest.Builder tableName(String var1);
    }

    private static abstract class DeleteTableResponseMixIn {
        private DeleteTableResponseMixIn() {
        }

        @JsonProperty(value="TableDescription")
        public abstract TableDescription tableDescription();

        @JsonProperty(value="TableDescription")
        public abstract DeleteTableResponse.Builder tableDescription(TableDescription var1);
    }

    private static abstract class ListTablesRequestMixIn {
        private ListTablesRequestMixIn() {
        }

        @JsonProperty(value="Limit")
        public abstract Integer limit();

        @JsonProperty(value="ExclusiveStartTableName")
        public abstract String exclusiveStartTableName();

        @JsonProperty(value="Limit")
        public abstract ListTablesRequest.Builder limit(Integer var1);

        @JsonProperty(value="ExclusiveStartTableName")
        public abstract ListTablesRequest.Builder exclusiveStartTableName(String var1);
    }

    private static abstract class ListTablesResponseMixIn {
        private ListTablesResponseMixIn() {
        }

        @JsonProperty(value="LastEvaluatedTableName")
        public abstract String lastEvaluatedTableName();

        @JsonProperty(value="TableNames")
        public abstract List<String> tableNames();

        @JsonProperty(value="LastEvaluatedTableName")
        public abstract ListTablesResponse.Builder lastEvaluatedTableName(String var1);

        @JsonProperty(value="TableNames")
        public abstract ListTablesResponse.Builder tableNames(List<String> var1);
    }

    private static abstract class DescribeLimitsRequestMixIn {
        private DescribeLimitsRequestMixIn() {
        }
    }

    private static abstract class DescribeLimitsResponseMixIn {
        private DescribeLimitsResponseMixIn() {
        }

        @JsonProperty(value="TableMaxReadCapacityUnits")
        public abstract Long tableMaxReadCapacityUnits();

        @JsonProperty(value="TableMaxWriteCapacityUnits")
        public abstract Long tableMaxWriteCapacityUnits();

        @JsonProperty(value="AccountMaxReadCapacityUnits")
        public abstract Long accountMaxReadCapacityUnits();

        @JsonProperty(value="AccountMaxWriteCapacityUnits")
        public abstract Long accountMaxWriteCapacityUnits();

        @JsonProperty(value="TableMaxReadCapacityUnits")
        public abstract DescribeLimitsResponse.Builder tableMaxReadCapacityUnits(Long var1);

        @JsonProperty(value="TableMaxWriteCapacityUnits")
        public abstract DescribeLimitsResponse.Builder tableMaxWriteCapacityUnits(Long var1);

        @JsonProperty(value="AccountMaxReadCapacityUnits")
        public abstract DescribeLimitsResponse.Builder accountMaxReadCapacityUnits(Long var1);

        @JsonProperty(value="AccountMaxWriteCapacityUnits")
        public abstract DescribeLimitsResponse.Builder accountMaxWriteCapacityUnits(Long var1);
    }

    private static abstract class PutItemRequestMixIn {
        private PutItemRequestMixIn() {
        }

        @JsonProperty(value="TableName")
        abstract String tableName();

        @JsonProperty(value="Item")
        abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> item();

        @JsonProperty(value="ConditionExpression")
        abstract String conditionExpression();

        @JsonProperty(value="ExpressionAttributeNames")
        abstract Map<String, String> expressionAttributeNames();

        @JsonProperty(value="ExpressionAttributeValues")
        abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> expressionAttributeValues();

        @JsonProperty(value="ReturnValues")
        abstract String returnValues();

        @JsonProperty(value="ReturnConsumedCapacity")
        abstract String returnConsumedCapacity();

        @JsonProperty(value="ReturnItemCollectionMetrics")
        abstract String returnItemCollectionMetrics();

        @JsonProperty(value="TableName")
        abstract PutItemRequest.Builder tableName(String var1);

        @JsonProperty(value="Item")
        abstract PutItemRequest.Builder item(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="ConditionExpression")
        abstract PutItemRequest.Builder conditionExpression(String var1);

        @JsonProperty(value="ExpressionAttributeNames")
        abstract PutItemRequest.Builder expressionAttributeNames(Map<String, String> var1);

        @JsonProperty(value="ExpressionAttributeValues")
        abstract PutItemRequest.Builder expressionAttributeValues(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="ReturnValues")
        abstract PutItemRequest.Builder returnValues(String var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        abstract PutItemRequest.Builder returnConsumedCapacity(String var1);

        @JsonProperty(value="ReturnItemCollectionMetrics")
        abstract PutItemRequest.Builder returnItemCollectionMetrics(String var1);
    }

    private static abstract class PutItemResponseMixIn {
        private PutItemResponseMixIn() {
        }

        @JsonProperty(value="Attributes")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> attributes();

        @JsonProperty(value="ConsumedCapacity")
        public abstract ConsumedCapacity consumedCapacity();

        @JsonProperty(value="ItemCollectionMetrics")
        public abstract ItemCollectionMetrics itemCollectionMetrics();

        @JsonProperty(value="Attributes")
        public abstract PutItemResponse.Builder attributes(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="ConsumedCapacity")
        public abstract PutItemResponse.Builder consumedCapacity(ConsumedCapacity var1);

        @JsonProperty(value="ItemCollectionMetrics")
        public abstract PutItemResponse.Builder itemCollectionMetrics(ItemCollectionMetrics var1);
    }

    private static abstract class GetItemRequestMixIn {
        private GetItemRequestMixIn() {
        }

        @JsonProperty(value="TableName")
        abstract String tableName();

        @JsonProperty(value="Key")
        abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> key();

        @JsonProperty(value="ConsistentRead")
        abstract Boolean consistentRead();

        @JsonProperty(value="ProjectionExpression")
        abstract String projectionExpression();

        @JsonProperty(value="ExpressionAttributeNames")
        abstract Map<String, String> expressionAttributeNames();

        @JsonProperty(value="ReturnConsumedCapacity")
        abstract String returnConsumedCapacity();

        @JsonProperty(value="TableName")
        abstract GetItemRequest.Builder tableName(String var1);

        @JsonProperty(value="Key")
        abstract GetItemRequest.Builder key(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="ConsistentRead")
        abstract GetItemRequest.Builder consistentRead(Boolean var1);

        @JsonProperty(value="ProjectionExpression")
        abstract GetItemRequest.Builder projectionExpression(String var1);

        @JsonProperty(value="ExpressionAttributeNames")
        abstract GetItemRequest.Builder expressionAttributeNames(Map<String, String> var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        abstract GetItemRequest.Builder returnConsumedCapacity(String var1);
    }

    private static abstract class GetItemResponseMixIn {
        private GetItemResponseMixIn() {
        }

        @JsonProperty(value="Item")
        abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> item();

        @JsonProperty(value="ConsumedCapacity")
        abstract ConsumedCapacity consumedCapacity();

        @JsonProperty(value="Item")
        abstract GetItemResponse.Builder item(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="ConsumedCapacity")
        abstract GetItemResponse.Builder consumedCapacity(ConsumedCapacity var1);
    }

    private static abstract class UpdateItemRequestMixIn {
        private UpdateItemRequestMixIn() {
        }

        @JsonProperty(value="TableName")
        abstract String tableName();

        @JsonProperty(value="Key")
        abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> key();

        @JsonProperty(value="UpdateExpression")
        abstract String updateExpression();

        @JsonProperty(value="ConditionExpression")
        abstract String conditionExpression();

        @JsonProperty(value="ExpressionAttributeNames")
        abstract Map<String, String> expressionAttributeNames();

        @JsonProperty(value="ExpressionAttributeValues")
        abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> expressionAttributeValues();

        @JsonProperty(value="ReturnValues")
        abstract String returnValues();

        @JsonProperty(value="ReturnConsumedCapacity")
        abstract String returnConsumedCapacity();

        @JsonProperty(value="ReturnItemCollectionMetrics")
        abstract String returnItemCollectionMetrics();

        @JsonProperty(value="TableName")
        abstract UpdateItemRequest.Builder tableName(String var1);

        @JsonProperty(value="Key")
        abstract UpdateItemRequest.Builder key(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="UpdateExpression")
        abstract UpdateItemRequest.Builder updateExpression(String var1);

        @JsonProperty(value="ConditionExpression")
        abstract UpdateItemRequest.Builder conditionExpression(String var1);

        @JsonProperty(value="ExpressionAttributeNames")
        abstract UpdateItemRequest.Builder expressionAttributeNames(Map<String, String> var1);

        @JsonProperty(value="ExpressionAttributeValues")
        abstract UpdateItemRequest.Builder expressionAttributeValues(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="ReturnValues")
        abstract UpdateItemRequest.Builder returnValues(String var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        abstract UpdateItemRequest.Builder returnConsumedCapacity(String var1);

        @JsonProperty(value="ReturnItemCollectionMetrics")
        abstract UpdateItemRequest.Builder returnItemCollectionMetrics(String var1);
    }

    private static abstract class UpdateItemResponseMixIn {
        private UpdateItemResponseMixIn() {
        }

        @JsonProperty(value="Attributes")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> attributes();

        @JsonProperty(value="ConsumedCapacity")
        public abstract ConsumedCapacity consumedCapacity();

        @JsonProperty(value="ItemCollectionMetrics")
        public abstract ItemCollectionMetrics itemCollectionMetrics();
    }

    private static abstract class DeleteItemRequestMixIn {
        private DeleteItemRequestMixIn() {
        }

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="Key")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> key();

        @JsonProperty(value="ConditionExpression")
        public abstract String conditionExpression();

        @JsonProperty(value="ExpressionAttributeNames")
        public abstract Map<String, String> expressionAttributeNames();

        @JsonProperty(value="ExpressionAttributeValues")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> expressionAttributeValues();

        @JsonProperty(value="ReturnValues")
        public abstract String returnValues();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String returnConsumedCapacity();

        @JsonProperty(value="ReturnItemCollectionMetrics")
        public abstract String returnItemCollectionMetrics();

        @JsonProperty(value="TableName")
        public abstract DeleteItemRequest.Builder tableName(String var1);

        @JsonProperty(value="Key")
        public abstract DeleteItemRequest.Builder key(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="ConditionExpression")
        public abstract DeleteItemRequest.Builder conditionExpression(String var1);

        @JsonProperty(value="ExpressionAttributeNames")
        public abstract DeleteItemRequest.Builder expressionAttributeNames(Map<String, String> var1);

        @JsonProperty(value="ExpressionAttributeValues")
        public abstract DeleteItemRequest.Builder expressionAttributeValues(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="ReturnValues")
        public abstract DeleteItemRequest.Builder returnValues(String var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract DeleteItemRequest.Builder returnConsumedCapacity(String var1);

        @JsonProperty(value="ReturnItemCollectionMetrics")
        public abstract DeleteItemRequest.Builder returnItemCollectionMetrics(String var1);
    }

    private static abstract class DeleteItemResponseMixIn {
        private DeleteItemResponseMixIn() {
        }

        @JsonProperty(value="Attributes")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> attributes();

        @JsonProperty(value="ConsumedCapacity")
        public abstract ConsumedCapacity consumedCapacity();

        @JsonProperty(value="ItemCollectionMetrics")
        public abstract ItemCollectionMetrics itemCollectionMetrics();

        @JsonProperty(value="Attributes")
        public abstract DeleteItemResponse.Builder attributes(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="ConsumedCapacity")
        public abstract DeleteItemResponse.Builder consumedCapacity(ConsumedCapacity var1);

        @JsonProperty(value="ItemCollectionMetrics")
        public abstract DeleteItemResponse.Builder itemCollectionMetrics(ItemCollectionMetrics var1);
    }

    private static abstract class BatchGetItemRequestMixIn {
        private BatchGetItemRequestMixIn() {
        }

        @JsonProperty(value="RequestItems")
        public abstract Map<String, KeysAndAttributes> requestItems();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String returnConsumedCapacity();

        @JsonProperty(value="RequestItems")
        public abstract BatchGetItemRequest.Builder requestItems(Map<String, KeysAndAttributes> var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract BatchGetItemRequest.Builder returnConsumedCapacity(String var1);
    }

    private static abstract class BatchGetItemResponseMixIn {
        private BatchGetItemResponseMixIn() {
        }

        @JsonProperty(value="Responses")
        public abstract Map<String, List<Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>>> responses();

        @JsonProperty(value="UnprocessedKeys")
        public abstract Map<String, KeysAndAttributes> unprocessedKeys();

        @JsonProperty(value="ConsumedCapacity")
        public abstract List<ConsumedCapacity> consumedCapacity();

        @JsonProperty(value="Responses")
        public abstract BatchGetItemResponse.Builder responses(Map<String, List<Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>>> var1);

        @JsonProperty(value="UnprocessedKeys")
        public abstract BatchGetItemResponse.Builder unprocessedKeys(Map<String, KeysAndAttributes> var1);

        @JsonProperty(value="ConsumedCapacity")
        public abstract BatchGetItemResponse.Builder consumedCapacity(List<ConsumedCapacity> var1);
    }

    private static abstract class BatchWriteItemRequestMixIn {
        private BatchWriteItemRequestMixIn() {
        }

        @JsonProperty(value="RequestItems")
        public abstract Map<String, List<software.amazon.awssdk.services.dynamodb.model.WriteRequest>> requestItems();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String returnConsumedCapacity();

        @JsonProperty(value="ReturnItemCollectionMetrics")
        public abstract String returnItemCollectionMetrics();

        @JsonProperty(value="RequestItems")
        public abstract BatchWriteItemRequest.Builder requestItems(Map<String, List<software.amazon.awssdk.services.dynamodb.model.WriteRequest>> var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract BatchWriteItemRequest.Builder returnConsumedCapacity(String var1);

        @JsonProperty(value="ReturnItemCollectionMetrics")
        public abstract BatchWriteItemRequest.Builder returnItemCollectionMetrics(String var1);
    }

    private static abstract class BatchWriteItemResponseMixIn {
        private BatchWriteItemResponseMixIn() {
        }

        @JsonProperty(value="UnprocessedItems")
        public abstract Map<String, List<software.amazon.awssdk.services.dynamodb.model.WriteRequest>> unprocessedItems();

        @JsonProperty(value="ConsumedCapacity")
        public abstract List<ConsumedCapacity> consumedCapacity();

        @JsonProperty(value="ItemCollectionMetrics")
        public abstract Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics();

        @JsonProperty(value="UnprocessedItems")
        public abstract BatchWriteItemResponse.Builder unprocessedItems(Map<String, List<software.amazon.awssdk.services.dynamodb.model.WriteRequest>> var1);

        @JsonProperty(value="ConsumedCapacity")
        public abstract BatchWriteItemResponse.Builder consumedCapacity(List<ConsumedCapacity> var1);

        @JsonProperty(value="ItemCollectionMetrics")
        public abstract BatchWriteItemResponse.Builder itemCollectionMetrics(Map<String, List<ItemCollectionMetrics>> var1);
    }

    private static abstract class QueryRequestMixIn {
        private QueryRequestMixIn() {
        }

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="IndexName")
        public abstract String indexName();

        @JsonProperty(value="Select")
        public abstract String select();

        @JsonProperty(value="Limit")
        public abstract Integer limit();

        @JsonProperty(value="ConsistentRead")
        public abstract Boolean consistentRead();

        @JsonProperty(value="KeyConditionExpression")
        public abstract String keyConditionExpression();

        @JsonProperty(value="FilterExpression")
        public abstract String filterExpression();

        @JsonProperty(value="ExpressionAttributeNames")
        public abstract Map<String, String> expressionAttributeNames();

        @JsonProperty(value="ExpressionAttributeValues")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> expressionAttributeValues();

        @JsonProperty(value="ExclusiveStartKey")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> exclusiveStartKey();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String returnConsumedCapacity();

        @JsonProperty(value="ProjectionExpression")
        public abstract String projectionExpression();

        @JsonProperty(value="ScanIndexForward")
        public abstract Boolean scanIndexForward();

        @JsonProperty(value="TableName")
        public abstract QueryRequest.Builder tableName(String var1);

        @JsonProperty(value="IndexName")
        public abstract QueryRequest.Builder indexName(String var1);

        @JsonProperty(value="Select")
        public abstract QueryRequest.Builder select(String var1);

        @JsonProperty(value="Limit")
        public abstract QueryRequest.Builder limit(Integer var1);

        @JsonProperty(value="ConsistentRead")
        public abstract QueryRequest.Builder consistentRead(Boolean var1);

        @JsonProperty(value="KeyConditionExpression")
        public abstract QueryRequest.Builder keyConditionExpression(String var1);

        @JsonProperty(value="FilterExpression")
        public abstract QueryRequest.Builder filterExpression(String var1);

        @JsonProperty(value="ExpressionAttributeNames")
        public abstract QueryRequest.Builder expressionAttributeNames(Map<String, String> var1);

        @JsonProperty(value="ExpressionAttributeValues")
        public abstract QueryRequest.Builder expressionAttributeValues(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="ExclusiveStartKey")
        public abstract QueryRequest.Builder exclusiveStartKey(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract QueryRequest.Builder returnConsumedCapacity(String var1);

        @JsonProperty(value="ProjectionExpression")
        public abstract QueryRequest.Builder projectionExpression(String var1);

        @JsonProperty(value="ScanIndexForward")
        public abstract QueryRequest.Builder scanIndexForward(Boolean var1);
    }

    private static abstract class QueryResponseMixIn {
        private QueryResponseMixIn() {
        }

        @JsonProperty(value="Items")
        public abstract List<Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>> items();

        @JsonProperty(value="Count")
        public abstract Integer count();

        @JsonProperty(value="ScannedCount")
        public abstract Integer scannedCount();

        @JsonProperty(value="LastEvaluatedKey")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> lastEvaluatedKey();

        @JsonProperty(value="ConsumedCapacity")
        public abstract ConsumedCapacity consumedCapacity();

        @JsonProperty(value="Items")
        public abstract QueryResponse.Builder items(List<Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>> var1);

        @JsonProperty(value="Count")
        public abstract QueryResponse.Builder count(Integer var1);

        @JsonProperty(value="ScannedCount")
        public abstract QueryResponse.Builder scannedCount(Integer var1);

        @JsonProperty(value="LastEvaluatedKey")
        public abstract QueryResponse.Builder lastEvaluatedKey(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="ConsumedCapacity")
        public abstract QueryResponse.Builder consumedCapacity(ConsumedCapacity var1);
    }

    private static abstract class ScanRequestMixIn {
        private ScanRequestMixIn() {
        }

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="IndexName")
        public abstract String indexName();

        @JsonProperty(value="Select")
        public abstract String select();

        @JsonProperty(value="Limit")
        public abstract Integer limit();

        @JsonProperty(value="ConsistentRead")
        public abstract Boolean consistentRead();

        @JsonProperty(value="FilterExpression")
        public abstract String filterExpression();

        @JsonProperty(value="ExpressionAttributeNames")
        public abstract Map<String, String> expressionAttributeNames();

        @JsonProperty(value="ExpressionAttributeValues")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> expressionAttributeValues();

        @JsonProperty(value="ExclusiveStartKey")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> exclusiveStartKey();

        @JsonProperty(value="ProjectionExpression")
        public abstract String projectionExpression();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String returnConsumedCapacity();

        @JsonProperty(value="Segment")
        public abstract Integer segment();

        @JsonProperty(value="TotalSegments")
        public abstract Integer totalSegments();

        @JsonProperty(value="TableName")
        public abstract ScanRequest.Builder tableName(String var1);

        @JsonProperty(value="IndexName")
        public abstract ScanRequest.Builder indexName(String var1);

        @JsonProperty(value="Select")
        public abstract ScanRequest.Builder select(String var1);

        @JsonProperty(value="Limit")
        public abstract ScanRequest.Builder limit(Integer var1);

        @JsonProperty(value="ConsistentRead")
        public abstract ScanRequest.Builder consistentRead(Boolean var1);

        @JsonProperty(value="FilterExpression")
        public abstract ScanRequest.Builder filterExpression(String var1);

        @JsonProperty(value="ExpressionAttributeNames")
        public abstract ScanRequest.Builder expressionAttributeNames(Map<String, String> var1);

        @JsonProperty(value="ExpressionAttributeValues")
        public abstract ScanRequest.Builder expressionAttributeValues(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="ExclusiveStartKey")
        public abstract ScanRequest.Builder exclusiveStartKey(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="ProjectionExpression")
        public abstract ScanRequest.Builder projectionExpression(String var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract ScanRequest.Builder returnConsumedCapacity(String var1);

        @JsonProperty(value="Segment")
        public abstract ScanRequest.Builder segment(Integer var1);

        @JsonProperty(value="TotalSegments")
        public abstract ScanRequest.Builder totalSegments(Integer var1);
    }

    private static abstract class ScanResponseMixIn {
        private ScanResponseMixIn() {
        }

        @JsonProperty(value="Items")
        public abstract List<Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>> items();

        @JsonProperty(value="Count")
        public abstract Integer count();

        @JsonProperty(value="ScannedCount")
        public abstract Integer scannedCount();

        @JsonProperty(value="LastEvaluatedKey")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> lastEvaluatedKey();

        @JsonProperty(value="ConsumedCapacity")
        public abstract ConsumedCapacity consumedCapacity();

        @JsonProperty(value="Items")
        public abstract ScanResponse.Builder items(List<Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>> var1);

        @JsonProperty(value="Count")
        public abstract ScanResponse.Builder count(Integer var1);

        @JsonProperty(value="ScannedCount")
        public abstract ScanResponse.Builder scannedCount(Integer var1);

        @JsonProperty(value="LastEvaluatedKey")
        public abstract ScanResponse.Builder lastEvaluatedKey(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="ConsumedCapacity")
        public abstract ScanResponse.Builder consumedCapacity(ConsumedCapacity var1);
    }

    private static abstract class TransactGetItemsRequestMixIn {
        private TransactGetItemsRequestMixIn() {
        }

        @JsonProperty(value="TransactItems")
        public abstract List<TransactGetItem> transactItems();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String returnConsumedCapacity();

        @JsonProperty(value="TransactItems")
        public abstract TransactGetItemsRequest.Builder transactItems(List<TransactGetItem> var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract TransactGetItemsRequest.Builder returnConsumedCapacity(String var1);
    }

    private static abstract class TransactGetItemsResponseMixIn {
        private TransactGetItemsResponseMixIn() {
        }

        @JsonProperty(value="Responses")
        public abstract List<ItemResponse> responses();

        @JsonProperty(value="ConsumedCapacity")
        public abstract List<ConsumedCapacity> consumedCapacity();

        @JsonProperty(value="Responses")
        public abstract TransactGetItemsResponse.Builder responses(List<ItemResponse> var1);

        @JsonProperty(value="ConsumedCapacity")
        public abstract TransactGetItemsResponse.Builder consumedCapacity(List<ConsumedCapacity> var1);
    }

    private static abstract class TransactWriteItemsRequestMixIn {
        private TransactWriteItemsRequestMixIn() {
        }

        @JsonProperty(value="TransactItems")
        public abstract List<TransactWriteItem> transactItems();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String returnConsumedCapacity();

        @JsonProperty(value="ReturnItemCollectionMetrics")
        public abstract String returnItemCollectionMetrics();

        @JsonProperty(value="ClientRequestToken")
        public abstract String clientRequestToken();

        @JsonProperty(value="TransactItems")
        public abstract TransactWriteItemsRequest.Builder transactItems(List<TransactWriteItem> var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract TransactWriteItemsRequest.Builder returnConsumedCapacity(String var1);

        @JsonProperty(value="ReturnItemCollectionMetrics")
        public abstract TransactWriteItemsRequest.Builder returnItemCollectionMetrics(String var1);

        @JsonProperty(value="ClientRequestToken")
        public abstract TransactWriteItemsRequest.Builder clientRequestToken(String var1);
    }

    private static abstract class TransactWriteItemsResponseMixIn {
        private TransactWriteItemsResponseMixIn() {
        }

        @JsonProperty(value="ConsumedCapacity")
        public abstract List<ConsumedCapacity> consumedCapacity();

        @JsonProperty(value="ItemCollectionMetrics")
        public abstract Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics();

        @JsonProperty(value="ConsumedCapacity")
        public abstract TransactWriteItemsResponse.Builder consumedCapacity(List<ConsumedCapacity> var1);

        @JsonProperty(value="ItemCollectionMetrics")
        public abstract TransactWriteItemsResponse.Builder itemCollectionMetrics(Map<String, List<ItemCollectionMetrics>> var1);
    }

    private static abstract class ItemResponseMixIn {
        private ItemResponseMixIn() {
        }

        @JsonProperty(value="Item")
        abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> item();

        @JsonProperty(value="Item")
        abstract ItemResponse.Builder item(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);
    }

    private static abstract class ExecuteStatementRequestMixIn {
        private ExecuteStatementRequestMixIn() {
        }

        @JsonProperty(value="Statement")
        public abstract String statement();

        @JsonProperty(value="Parameters")
        public abstract List<software.amazon.awssdk.services.dynamodb.model.AttributeValue> parameters();

        @JsonProperty(value="ConsistentRead")
        public abstract Boolean consistentRead();

        @JsonProperty(value="NextToken")
        public abstract String nextToken();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String returnConsumedCapacity();

        @JsonProperty(value="Statement")
        public abstract ExecuteStatementRequest.Builder statement(String var1);

        @JsonProperty(value="Parameters")
        public abstract ExecuteStatementRequest.Builder parameters(List<software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="ConsistentRead")
        public abstract ExecuteStatementRequest.Builder consistentRead(Boolean var1);

        @JsonProperty(value="NextToken")
        public abstract ExecuteStatementRequest.Builder nextToken(String var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract ExecuteStatementRequest.Builder returnConsumedCapacity(String var1);
    }

    private static abstract class ExecuteStatementResponseMixIn {
        private ExecuteStatementResponseMixIn() {
        }

        @JsonProperty(value="Items")
        public abstract List<Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>> items();

        @JsonProperty(value="NextToken")
        public abstract String nextToken();

        @JsonProperty(value="ConsumedCapacity")
        public abstract ConsumedCapacity consumedCapacity();

        @JsonProperty(value="Items")
        public abstract ExecuteStatementResponse.Builder items(List<Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>> var1);

        @JsonProperty(value="NextToken")
        public abstract ExecuteStatementResponse.Builder nextToken(String var1);

        @JsonProperty(value="ConsumedCapacity")
        public abstract ExecuteStatementResponse.Builder consumedCapacity(ConsumedCapacity var1);
    }

    private static abstract class BatchExecuteStatementRequestMixIn {
        private BatchExecuteStatementRequestMixIn() {
        }

        @JsonProperty(value="Statements")
        public abstract List<BatchStatementRequest> statements();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String returnConsumedCapacity();

        @JsonProperty(value="Statements")
        public abstract BatchExecuteStatementRequest.Builder statements(List<BatchStatementRequest> var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract BatchExecuteStatementRequest.Builder returnConsumedCapacity(String var1);
    }

    private static abstract class BatchExecuteStatementResponseMixIn {
        private BatchExecuteStatementResponseMixIn() {
        }

        @JsonProperty(value="Responses")
        public abstract List<BatchStatementResponse> responses();

        @JsonProperty(value="ConsumedCapacity")
        public abstract List<ConsumedCapacity> consumedCapacity();

        @JsonProperty(value="Responses")
        public abstract BatchExecuteStatementResponse.Builder responses(List<BatchStatementResponse> var1);

        @JsonProperty(value="ConsumedCapacity")
        public abstract BatchExecuteStatementResponse.Builder consumedCapacity(List<ConsumedCapacity> var1);
    }

    private static abstract class ExecuteTransactionRequestMixIn {
        private ExecuteTransactionRequestMixIn() {
        }

        @JsonProperty(value="TransactStatements")
        public abstract List<ParameterizedStatement> transactStatements();

        @JsonProperty(value="ClientRequestToken")
        public abstract String clientRequestToken();

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract String returnConsumedCapacity();

        @JsonProperty(value="TransactStatements")
        public abstract ExecuteTransactionRequest.Builder transactStatements(List<ParameterizedStatement> var1);

        @JsonProperty(value="ClientRequestToken")
        public abstract ExecuteTransactionRequest.Builder clientRequestToken(String var1);

        @JsonProperty(value="ReturnConsumedCapacity")
        public abstract ExecuteTransactionRequest.Builder returnConsumedCapacity(String var1);
    }

    private static abstract class ExecuteTransactionResponseMixIn {
        private ExecuteTransactionResponseMixIn() {
        }

        @JsonProperty(value="Responses")
        public abstract List<ItemResponse> responses();

        @JsonProperty(value="ConsumedCapacity")
        public abstract List<ConsumedCapacity> consumedCapacity();

        @JsonProperty(value="Responses")
        public abstract ExecuteTransactionResponse.Builder responses(List<ItemResponse> var1);

        @JsonProperty(value="ConsumedCapacity")
        public abstract ExecuteTransactionResponse.Builder consumedCapacity(List<ConsumedCapacity> var1);
    }

    private static abstract class BatchStatementResponseMixIn {
        private BatchStatementResponseMixIn() {
        }

        @JsonProperty(value="Item")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> item();

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="Error")
        public abstract BatchStatementError error();

        @JsonProperty(value="Item")
        public abstract BatchStatementResponse.Builder item(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> var1);

        @JsonProperty(value="TableName")
        public abstract BatchStatementResponse.Builder tableName(String var1);

        @JsonProperty(value="Error")
        public abstract BatchStatementResponse.Builder error(BatchStatementError var1);
    }

    private static abstract class DescribeTimeToLiveRequestMixIn {
        private DescribeTimeToLiveRequestMixIn() {
        }

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="TableName")
        public abstract DescribeTimeToLiveRequest.Builder tableName(String var1);
    }

    private static abstract class DescribeTimeToLiveResponseMixIn {
        private DescribeTimeToLiveResponseMixIn() {
        }

        @JsonProperty(value="TimeToLiveDescription")
        public abstract TimeToLiveDescription timeToLiveDescription();

        @JsonProperty(value="TimeToLiveDescription")
        public abstract DescribeTimeToLiveResponse.Builder timeToLiveDescription(TimeToLiveDescription var1);
    }

    private static abstract class UpdateTimeToLiveRequestMixIn {
        private UpdateTimeToLiveRequestMixIn() {
        }

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="TimeToLiveSpecification")
        public abstract TimeToLiveSpecification timeToLiveSpecification();

        @JsonProperty(value="TableName")
        public abstract UpdateTimeToLiveRequest.Builder tableName(String var1);

        @JsonProperty(value="TimeToLiveSpecification")
        public abstract UpdateTimeToLiveRequest.Builder timeToLiveSpecification(TimeToLiveSpecification var1);
    }

    private static abstract class UpdateTimeToLiveResponseMixIn {
        private UpdateTimeToLiveResponseMixIn() {
        }

        @JsonProperty(value="TimeToLiveSpecification")
        public abstract TimeToLiveSpecification timeToLiveSpecification();

        @JsonProperty(value="TimeToLiveSpecification")
        public abstract UpdateTimeToLiveResponse.Builder timeToLiveSpecification(TimeToLiveSpecification var1);
    }

    private static abstract class ListStreamsRequestMixIn {
        private ListStreamsRequestMixIn() {
        }

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="Limit")
        public abstract Integer limit();

        @JsonProperty(value="ExclusiveStartStreamArn")
        public abstract String exclusiveStartStreamArn();

        @JsonProperty(value="TableName")
        public abstract ListStreamsRequest.Builder tableName(String var1);

        @JsonProperty(value="Limit")
        public abstract ListStreamsRequest.Builder limit(Integer var1);

        @JsonProperty(value="ExclusiveStartStreamArn")
        public abstract ListStreamsRequest.Builder exclusiveStartStreamArn(String var1);
    }

    private static abstract class ListStreamsResponseMixIn {
        private ListStreamsResponseMixIn() {
        }

        @JsonProperty(value="Streams")
        public abstract Stream streams();

        @JsonProperty(value="LastEvaluatedStreamArn")
        public abstract String lastEvaluatedStreamArn();

        @JsonProperty(value="Streams")
        public abstract ListStreamsResponse.Builder streams(String var1);

        @JsonProperty(value="LastEvaluatedStreamArn")
        public abstract ListStreamsResponse.Builder lastEvaluatedStreamArn(String var1);
    }

    private static abstract class DescribeStreamRequestMixIn {
        private DescribeStreamRequestMixIn() {
        }

        @JsonProperty(value="StreamArn")
        public abstract String streamArn();

        @JsonProperty(value="Limit")
        public abstract Integer limit();

        @JsonProperty(value="ExclusiveStartShardId")
        public abstract String exclusiveStartShardId();

        @JsonProperty(value="StreamArn")
        public abstract DescribeStreamRequest.Builder streamArn(String var1);

        @JsonProperty(value="Limit")
        public abstract DescribeStreamRequest.Builder limit(Integer var1);

        @JsonProperty(value="ExclusiveStartShardId")
        public abstract DescribeStreamRequest.Builder exclusiveStartShardId(String var1);
    }

    private static abstract class DescribeStreamResponseMixIn {
        private DescribeStreamResponseMixIn() {
        }

        @JsonProperty(value="StreamDescription")
        public abstract StreamDescription streamDescription();

        @JsonProperty(value="StreamDescription")
        public abstract DescribeStreamResponse.Builder streamDescription(StreamDescription var1);
    }

    private static abstract class StreamDescriptionMixIn {
        private StreamDescriptionMixIn() {
        }

        @JsonProperty(value="StreamArn")
        public abstract String streamArn();

        @JsonProperty(value="StreamLabel")
        public abstract String streamLabel();

        @JsonProperty(value="StreamStatus")
        public abstract StreamStatus streamStatus();

        @JsonProperty(value="StreamViewType")
        public abstract StreamViewType streamViewType();

        @JsonProperty(value="CreationRequestDateTime")
        public abstract Instant creationRequestDateTime();

        @JsonProperty(value="TableName")
        public abstract String tableName();

        @JsonProperty(value="KeySchema")
        public abstract List<KeySchemaElement> keySchema();

        @JsonProperty(value="Shards")
        public abstract List<Shard> shards();

        @JsonProperty(value="LastEvaluatedShardId")
        public abstract String lastEvaluatedShardId();
    }

    private static abstract class ShardMixIn {
        private ShardMixIn() {
        }

        @JsonProperty(value="ShardId")
        public abstract String shardId();

        @JsonProperty(value="SequenceNumberRange")
        public abstract SequenceNumberRange sequenceNumberRange();

        @JsonProperty(value="ParentShardId")
        public abstract String parentShardId();
    }

    private static abstract class SequenceNumberRangeMixIn {
        private SequenceNumberRangeMixIn() {
        }

        @JsonProperty(value="StartingSequenceNumber")
        public abstract String startingSequenceNumber();

        @JsonProperty(value="EndingSequenceNumber")
        public abstract String endingSequenceNumber();
    }

    private static abstract class GetShardIteratorRequestMixIn {
        private GetShardIteratorRequestMixIn() {
        }

        @JsonProperty(value="StreamArn")
        public abstract String streamArn();

        @JsonProperty(value="ShardId")
        public abstract String shardId();

        @JsonProperty(value="ShardIteratorType")
        public abstract ShardIteratorType shardIteratorType();

        @JsonProperty(value="SequenceNumber")
        public abstract String sequenceNumber();

        @JsonProperty(value="StreamArn")
        public abstract GetShardIteratorRequest.Builder streamArn(String var1);

        @JsonProperty(value="ShardId")
        public abstract GetShardIteratorRequest.Builder shardId(String var1);

        @JsonProperty(value="ShardIteratorType")
        public abstract GetShardIteratorRequest.Builder shardIteratorType(ShardIteratorType var1);

        @JsonProperty(value="SequenceNumber")
        public abstract GetShardIteratorRequest.Builder sequenceNumber(String var1);
    }

    private static abstract class GetShardIteratorResponseMixIn {
        private GetShardIteratorResponseMixIn() {
        }

        @JsonProperty(value="ShardIterator")
        public abstract String shardIterator();

        @JsonProperty(value="ShardIterator")
        public abstract GetShardIteratorResponse.Builder shardIterator(String var1);
    }

    private static abstract class GetRecordsRequestMixIn {
        private GetRecordsRequestMixIn() {
        }

        @JsonProperty(value="ShardIterator")
        public abstract String shardIterator();

        @JsonProperty(value="Limit")
        public abstract Integer limit();

        @JsonProperty(value="ShardIterator")
        public abstract GetRecordsRequest.Builder shardIterator(String var1);

        @JsonProperty(value="Limit")
        public abstract GetRecordsRequest.Builder limit(Integer var1);
    }

    private static abstract class GetRecordsResponseMixIn {
        private GetRecordsResponseMixIn() {
        }

        @JsonProperty(value="Records")
        public abstract List<Record> records();

        @JsonProperty(value="NextShardIterator")
        public abstract String nextShardIterator();

        @JsonProperty(value="Records")
        public abstract GetRecordsResponse.Builder records(List<Record> var1);

        @JsonProperty(value="NextShardIterator")
        public abstract GetRecordsResponse.Builder nextShardIterator(String var1);
    }

    private static abstract class RecordMixIn {
        private RecordMixIn() {
        }

        @JsonProperty(value="eventID")
        public abstract String eventID();

        @JsonProperty(value="eventName")
        public abstract String eventName();

        @JsonProperty(value="eventVersion")
        public abstract String eventVersion();

        @JsonProperty(value="eventSource")
        public abstract String eventSource();

        @JsonProperty(value="awsRegion")
        public abstract String awsRegion();

        @JsonProperty(value="dynamodb")
        public abstract StreamRecord dynamodb();

        @JsonProperty(value="userIdentity")
        public abstract Identity userIdentity();
    }

    private static abstract class StreamRecordMixIn {
        private StreamRecordMixIn() {
        }

        @JsonProperty(value="ApproximateCreationDateTime")
        public abstract Instant approximateCreationDateTime();

        @JsonProperty(value="Keys")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> keys();

        @JsonProperty(value="NewImage")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> newImage();

        @JsonProperty(value="OldImage")
        public abstract Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> oldImage();

        @JsonProperty(value="SequenceNumber")
        public abstract String sequenceNumber();

        @JsonProperty(value="SizeBytes")
        public abstract Long sizeBytes();

        @JsonProperty(value="StreamViewType")
        public abstract StreamViewType streamViewType();
    }

    private static abstract class IdentityMixIn {
        private IdentityMixIn() {
        }

        @JsonProperty(value="PrincipalId")
        public abstract String principalId();

        @JsonProperty(value="Type")
        public abstract String type();
    }

    public static class SdkAutoConstructFilter {
        public boolean equals(Object obj) {
            return obj == null || obj instanceof SdkAutoConstructList || obj instanceof SdkAutoConstructMap;
        }
    }
}

