/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.jobs;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import software.amazon.dynamodb.services.local.shared.access.ListTablesResponseInfo;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.jobs.JobsRegister;
import software.amazon.dynamodb.services.local.shared.jobs.NamedJob;
import software.amazon.dynamodb.services.local.shared.logging.LogManager;

public class ShardRolloverJob
extends NamedJob {
    private static final Logger LOGGER = LogManager.getLogger(ShardRolloverJob.class);
    private static final String JOB_NAME = "SHARD-ROLLOVER-JOB";
    private final LocalDBAccess dbAccess;
    private final AtomicBoolean workInProgress = new AtomicBoolean();
    private final long shardAgeToRollover;

    public ShardRolloverJob(LocalDBAccess dbAccess, JobsRegister jobs, long shardAgeToRollover) {
        super(jobs);
        this.dbAccess = dbAccess;
        this.shardAgeToRollover = shardAgeToRollover;
    }

    @Override
    protected void doJob() {
        ListTablesResponseInfo initResults = this.dbAccess.listTables(null, 100L);
        for (final String tableName : initResults.getTableNames()) {
            TableInfo tableInfo = this.dbAccess.getTableInfo(tableName);
            if (tableInfo == null || !tableInfo.getStreamSpecification().streamEnabled().booleanValue()) continue;
            new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

                @Override
                public void criticalSection() {
                    LOGGER.debug("Performing findAndRolloverActiveShards for table {}", (Object)tableName);
                    ShardRolloverJob.this.dbAccess.findAndRolloverActiveShards(tableName, ShardRolloverJob.this.shardAgeToRollover);
                }
            }.execute();
        }
    }

    @Override
    public String name() {
        return JOB_NAME;
    }

    @Override
    public void cancel() {
        while (this.workInProgress.get()) {
            this.sleepFor(LocalDBUtils.DELAY_BEFORE_SCHEDULING_JOBS_AGAIN);
        }
    }
}

