/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.api.ttl;

import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.model.TimeToLiveDescription;
import software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.api.DynamoDbApiFunction;

public class DescribeTimeToLiveFunction
extends DynamoDbApiFunction<DescribeTimeToLiveRequest, DescribeTimeToLiveResponse> {
    public DescribeTimeToLiveFunction(LocalDBAccess dbAccess) {
        super(dbAccess);
    }

    @Override
    public DescribeTimeToLiveResponse apply(DescribeTimeToLiveRequest describeTimeToLiveRequest) {
        String tableName = this.getTableNameFromPossibleArn(describeTimeToLiveRequest.tableName());
        this.validateTableName(tableName);
        TableInfo tableInfo = this.validateTableExists(tableName);
        TimeToLiveDescription timeToLiveDescription = (TimeToLiveDescription)TimeToLiveDescription.builder().attributeName(tableInfo.getTimeToLiveSpecification().attributeName()).timeToLiveStatus(tableInfo.getTimeToLiveSpecification().enabled() != false ? TimeToLiveStatus.ENABLED : TimeToLiveStatus.DISABLED).build();
        return (DescribeTimeToLiveResponse)DescribeTimeToLiveResponse.builder().timeToLiveDescription(timeToLiveDescription).build();
    }
}

