/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.api.dp;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import com.amazonaws.services.dynamodbv2.datamodel.Expression;
import com.amazonaws.services.dynamodbv2.dbenv.DbEnv;
import com.amazonaws.services.dynamodbv2.rr.ExpressionWrapper;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.Capacity;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.ReturnValuesOnConditionCheckFailure;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBInputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBOutputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBValidatorUtils;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.api.dp.WriteDataPlaneFunction;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.helpers.TransactionsEnabledMode;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;
import software.amazon.dynamodb.services.local.shared.model.Condition;
import software.amazon.dynamodb.services.local.shared.model.ExpectedAttributeValue;

public class DeleteItemFunction
extends WriteDataPlaneFunction<DeleteItemRequest, DeleteItemResponse> {
    public DeleteItemFunction(LocalDBAccess dbAccess, DbEnv localDBEnv, LocalDBInputConverter inputConverter, LocalDBOutputConverter localDBOutputConverter, AWSExceptionFactory awsExceptionFactory, DocumentFactory documentFactory, TransactionsEnabledMode transactionsEnabledMode) {
        super(dbAccess, localDBEnv, inputConverter, localDBOutputConverter, awsExceptionFactory, documentFactory, transactionsEnabledMode);
    }

    @Override
    public DeleteItemResponse apply(DeleteItemRequest deleteItemRequest) {
        String tableName = deleteItemRequest.tableName();
        tableName = this.getTableNameFromPossibleArn(tableName);
        deleteItemRequest = (DeleteItemRequest)deleteItemRequest.toBuilder().tableName(tableName).build();
        this.validateTableName(tableName);
        TableInfo tableInfo = this.validateTableExists(tableName);
        Map<String, ExpectedAttributeValue> expected = this.inputConverter.externalToInternalExpectedAttributes(deleteItemRequest.expected(), 409600);
        ReturnValue returnVals = this.validateReturnType(deleteItemRequest.returnValuesAsString(), false);
        LocalDBValidatorUtils.validateExpressions(deleteItemRequest, this.inputConverter);
        String returnValuesOnConditionCheckFailure = LocalDBValidatorUtils.validateReturnValuesOnConditionCheckFailure(deleteItemRequest.returnValuesOnConditionCheckFailureAsString());
        if (!deleteItemRequest.hasKey()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.MISSING_KEY.getMessage());
        }
        Map primaryKey = (Map)this.inputConverter.externalToInternalAttributes(deleteItemRequest.key());
        this.validateGetKey(primaryKey, tableInfo);
        this.validateExpecations(expected, deleteItemRequest.conditionalOperatorAsString());
        ReturnConsumedCapacity returnConsumedCapacity = this.convertReturnConsumedCapacity(deleteItemRequest.returnConsumedCapacityAsString());
        if (deleteItemRequest.conditionExpression() == null && expected.isEmpty()) {
            return this.itemDeleteNoCondition(tableName, primaryKey, returnVals, returnConsumedCapacity);
        }
        if (deleteItemRequest.conditionExpression() != null) {
            ExpressionWrapper conditionExpressionWrapper = this.inputConverter.externalToInternalConditionExpression(deleteItemRequest.conditionExpression(), deleteItemRequest.expressionAttributeNames(), deleteItemRequest.expressionAttributeValues());
            LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(this.dbAccess.getTableInfo(tableName), conditionExpressionWrapper, this.awsExceptionFactory);
            Expression conditionExpression = conditionExpressionWrapper == null ? null : conditionExpressionWrapper.getExpression();
            return this.itemDeleteWithConditionExpression(tableName, returnVals, returnConsumedCapacity, primaryKey, conditionExpression, returnValuesOnConditionCheckFailure);
        }
        return this.itemDeleteConditionalOperator(tableName, expected, returnVals, returnConsumedCapacity, primaryKey, deleteItemRequest.conditionalOperatorAsString(), returnValuesOnConditionCheckFailure);
    }

    private void validateExpecations(Map<String, ExpectedAttributeValue> expected, String conditionalOperatorAsString) {
        if (expected.isEmpty() && conditionalOperatorAsString != null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.COND_OP_WITHOUT_FILTER_OR_EXPECTED.getMessage());
        }
        for (Map.Entry<String, ExpectedAttributeValue> entry : expected.entrySet()) {
            this.validateExpectedAttribute(entry.getKey(), entry.getValue());
        }
    }

    private DeleteItemResponse itemDeleteNoCondition(final String tableName, final Map<String, AttributeValue> primaryKey, final ReturnValue returnVals, final ReturnConsumedCapacity returnConsumedCapacity) {
        final DeleteItemResponse.Builder deleteItemResponse = DeleteItemResponse.builder();
        new LocalDBAccess.ReadLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

            @Override
            public void criticalSection() {
                Map<String, AttributeValue> oldItem = DeleteItemFunction.this.dbAccess.getRecord(tableName, primaryKey);
                if (oldItem != null) {
                    deleteItemResponse.consumedCapacity(DeleteItemFunction.this.computeWriteCapacity(tableName, DeleteItemFunction.this.createDeleteMutation(oldItem), returnConsumedCapacity, DeleteItemFunction.this.transactionsMode));
                    if (returnVals == ReturnValue.ALL_OLD || returnVals == ReturnValue.UPDATED_OLD) {
                        deleteItemResponse.attributes(DeleteItemFunction.this.localDBOutputConverter.internalToExternalAttributes(oldItem));
                    }
                } else {
                    DeleteItemFunction.this.singletonCapacity(deleteItemResponse, tableName, returnConsumedCapacity);
                }
                DeleteItemFunction.this.dbAccess.deleteRecord(tableName, primaryKey, false);
            }
        }.execute();
        return (DeleteItemResponse)deleteItemResponse.build();
    }

    private void computeAndPopulateCapacity(Map<String, AttributeValue> oldItem, String tableName, Map<String, AttributeValue> primaryKey, DeleteItemResponse.Builder deleteResponse, ReturnConsumedCapacity returnConsumedCapacity, ReturnValue returnVals) {
        this.dbAccess.deleteRecord(tableName, primaryKey, false);
        if (oldItem != null) {
            deleteResponse.consumedCapacity(this.computeWriteCapacity(tableName, this.createDeleteMutation(oldItem), returnConsumedCapacity, this.transactionsMode));
            if (returnVals == ReturnValue.ALL_OLD) {
                deleteResponse.attributes(this.localDBOutputConverter.internalToExternalAttributes(oldItem));
            }
        } else {
            this.singletonCapacity(deleteResponse, tableName, returnConsumedCapacity);
        }
    }

    private DeleteItemResponse itemDeleteWithConditionExpression(final String tableName, final ReturnValue returnVals, final ReturnConsumedCapacity returnConsumedCapacity, final Map<String, AttributeValue> primaryKey, final Expression conditionExpression, final String returnValuesOnConditionCheckFailure) {
        final DeleteItemResponse.Builder deleteResponse = DeleteItemResponse.builder();
        new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

            @Override
            public void criticalSection() {
                Map<String, AttributeValue> oldItem = DeleteItemFunction.this.dbAccess.getRecord(tableName, primaryKey);
                if (!DeleteItemFunction.this.doesItemMatchConditionExpression((Map)oldItem, conditionExpression)) {
                    if (DeleteItemFunction.this.getReturnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure).equals((Object)ReturnValuesOnConditionCheckFailure.ALL_OLD)) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CONDITIONAL_CHECK_FAILED.getMessage(), oldItem);
                    }
                    DeleteItemFunction.this.awsExceptionFactory.CONDITIONAL_CHECK_FAILED.throwAsException();
                }
                DeleteItemFunction.this.computeAndPopulateCapacity(oldItem, tableName, primaryKey, deleteResponse, returnConsumedCapacity, returnVals);
            }
        }.execute();
        return (DeleteItemResponse)deleteResponse.build();
    }

    private void singletonCapacity(DeleteItemResponse.Builder deleteResponse, String tableName, ReturnConsumedCapacity returnConsumedCapacity) {
        ConsumedCapacity.Builder consumedCapacityBuilder = ConsumedCapacity.builder().capacityUnits(Double.valueOf(1.0)).tableName(tableName);
        if (ReturnConsumedCapacity.INDEXES == returnConsumedCapacity) {
            consumedCapacityBuilder.table((Capacity)Capacity.builder().capacityUnits(Double.valueOf(1.0)).build());
        }
        deleteResponse.consumedCapacity((ConsumedCapacity)consumedCapacityBuilder.build());
    }

    private DeleteItemResponse itemDeleteConditionalOperator(final String tableName, final Map<String, ExpectedAttributeValue> expected, final ReturnValue returnVals, final ReturnConsumedCapacity returnConsumedCapacity, final Map<String, AttributeValue> primaryKey, final String conditionalOperatorAsString, final String returnValuesOnConditionCheckFailure) {
        final DeleteItemResponse.Builder deleteResponse = DeleteItemResponse.builder();
        new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

            @Override
            public void criticalSection() {
                Map<String, AttributeValue> oldItem = DeleteItemFunction.this.dbAccess.getRecord(tableName, primaryKey);
                Map<String, Condition> conditions = DeleteItemFunction.this.convertToConditions(expected);
                DeleteItemFunction.this.validateConditions(conditions, conditionalOperatorAsString);
                if (!DeleteItemFunction.this.doesItemMatchConditionalOperator(oldItem, conditions, DeleteItemFunction.this.conditionalOperatorFrom(conditionalOperatorAsString))) {
                    if (DeleteItemFunction.this.getReturnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure).equals((Object)ReturnValuesOnConditionCheckFailure.ALL_OLD)) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CONDITIONAL_CHECK_FAILED.getMessage(), oldItem);
                    }
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CONDITIONAL_CHECK_FAILED.getMessage());
                }
                DeleteItemFunction.this.computeAndPopulateCapacity(oldItem, tableName, primaryKey, deleteResponse, returnConsumedCapacity, returnVals);
            }
        }.execute();
        return (DeleteItemResponse)deleteResponse.build();
    }
}

