/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodel;

import com.amazonaws.services.dynamodbv2.datamodel.DocPath;
import com.amazonaws.services.dynamodbv2.datamodel.DocPathElement;
import com.amazonaws.services.dynamodbv2.datamodel.DocPathMapElement;
import com.amazonaws.services.dynamodbv2.datamodel.ExprTreeNode;
import com.amazonaws.services.dynamodbv2.datamodel.ExprTreeOpNode;
import com.amazonaws.services.dynamodbv2.datamodel.ExprTreePathNode;
import com.amazonaws.services.dynamodbv2.datamodel.ExprTreeValueNode;
import com.amazonaws.services.dynamodbv2.datamodel.Operator;
import com.amazonaws.services.dynamodbv2.dbenv.DbEnv;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExprTreeNodeUtils {
    private ExprTreeNodeUtils() {
    }

    public static String exprTreeNodeToReadableString(ExprTreeNode node, DbEnv dbEnv) {
        return ExprTreeNodeUtils.exprTreeNodeToReadableString(node, dbEnv, null);
    }

    public static String exprTreeNodeToReadableString(ExprTreeNode node, DbEnv dbEnv, Map<String, String> docPathStringSubstitutionMap) {
        if (node == null) {
            return null;
        }
        if (node instanceof ExprTreeValueNode) {
            ExprTreeValueNode valueNode = (ExprTreeValueNode)node;
            dbEnv.dbAssert(valueNode.getLiteralSub() != null, "exprTreeNodeToReadableString", "value node for DQL V1 must has literal sub", node);
            return valueNode.getLiteralSub();
        }
        if (node instanceof ExprTreePathNode) {
            ExprTreePathNode pathNode = (ExprTreePathNode)node;
            return ExprTreeNodeUtils.docPathToReadableString(pathNode.getDocPath(), dbEnv, docPathStringSubstitutionMap);
        }
        StringBuilder builder = new StringBuilder();
        ExprTreeOpNode opNode = (ExprTreeOpNode)node;
        Operator operator = opNode.getOperator();
        List<ExprTreeNode> children = opNode.getChildren();
        switch (operator) {
            case EQ: 
            case LT: 
            case GT: 
            case LE: 
            case GE: 
            case NE: {
                builder.append(ExprTreeNodeUtils.exprTreeNodeToReadableString(children.get(0), dbEnv, docPathStringSubstitutionMap)).append(" ").append(operator.getOperatorName()).append(" ").append(ExprTreeNodeUtils.exprTreeNodeToReadableString(children.get(1), dbEnv, docPathStringSubstitutionMap));
                break;
            }
            case NOT: {
                dbEnv.dbAssert(children.size() == 1, "exprTreeNodeToReadableString", "invalid AND/OR operator", opNode);
                boolean needParathesis = ExprTreeNodeUtils.isParenthesesRequired(children.get(0));
                builder.append("NOT ");
                if (needParathesis) {
                    builder.append("(");
                }
                builder.append(ExprTreeNodeUtils.exprTreeNodeToReadableString(children.get(0), dbEnv, docPathStringSubstitutionMap));
                if (!needParathesis) break;
                builder.append(")");
                break;
            }
            case AND: 
            case OR: {
                dbEnv.dbAssert(children.size() > 1, "exprTreeNodeToReadableString", "invalid AND/OR operator", opNode);
                boolean needParens = ExprTreeNodeUtils.isParenthesesRequired(children.get(0));
                if (needParens) {
                    builder.append("(");
                }
                builder.append(ExprTreeNodeUtils.exprTreeNodeToReadableString(children.get(0), dbEnv, docPathStringSubstitutionMap));
                for (int i = 1; i < children.size(); ++i) {
                    if (needParens) {
                        builder.append(")");
                    }
                    builder.append(" ").append(operator.getOperatorName()).append(" ");
                    needParens = ExprTreeNodeUtils.isParenthesesRequired(children.get(i));
                    if (needParens) {
                        builder.append("(");
                    }
                    builder.append(ExprTreeNodeUtils.exprTreeNodeToReadableString(children.get(i), dbEnv, docPathStringSubstitutionMap));
                }
                if (!needParens) break;
                builder.append(")");
                break;
            }
            case IN: {
                dbEnv.dbAssert(children.size() > 1, "exprTreeNodeToReadableString", "invalid IN operator", opNode);
                builder.append(ExprTreeNodeUtils.exprTreeNodeToReadableString(children.get(0), dbEnv, docPathStringSubstitutionMap)).append(" IN (").append(ExprTreeNodeUtils.exprTreeNodeToReadableString(children.get(1), dbEnv, docPathStringSubstitutionMap));
                for (int i = 2; i < children.size(); ++i) {
                    builder.append(", ").append(ExprTreeNodeUtils.exprTreeNodeToReadableString(children.get(i), dbEnv, docPathStringSubstitutionMap));
                }
                builder.append(")");
                break;
            }
            case BETWEEN: {
                dbEnv.dbAssert(children.size() == 3, "exprTreeNodeToReadableString", "invalid BETWEEN operator", opNode);
                builder.append(ExprTreeNodeUtils.exprTreeNodeToReadableString(children.get(0), dbEnv, docPathStringSubstitutionMap)).append(" BETWEEN ").append(ExprTreeNodeUtils.exprTreeNodeToReadableString(children.get(1), dbEnv, docPathStringSubstitutionMap)).append(" AND ").append(ExprTreeNodeUtils.exprTreeNodeToReadableString(children.get(2), dbEnv, docPathStringSubstitutionMap));
                break;
            }
            case attribute_exists: 
            case attribute_not_exists: 
            case attribute_type: 
            case contains: 
            case begins_with: 
            case size: {
                dbEnv.dbAssert(children.size() > 0, "exprTreeNodeToReadableString", "invalid function operator", opNode);
                builder.append(operator.getOperatorName()).append("(").append(ExprTreeNodeUtils.exprTreeNodeToReadableString(children.get(0), dbEnv, docPathStringSubstitutionMap));
                for (int i = 1; i < children.size(); ++i) {
                    builder.append(", ").append(ExprTreeNodeUtils.exprTreeNodeToReadableString(children.get(i), dbEnv, docPathStringSubstitutionMap));
                }
                builder.append(")");
                break;
            }
            default: {
                dbEnv.dbAssert(false, "exprTreeNodeToReadableString", "unsupported operator", opNode);
                return null;
            }
        }
        return builder.toString();
    }

    private static boolean isParenthesesRequired(ExprTreeNode node) {
        if (!(node instanceof ExprTreeOpNode)) {
            return false;
        }
        ExprTreeOpNode opNode = (ExprTreeOpNode)node;
        return opNode.getOperator() == Operator.AND || opNode.getOperator() == Operator.OR || opNode.getOperator() == Operator.BETWEEN;
    }

    public static String docPathToReadableString(DocPath docPath, DbEnv dbEnv) {
        return ExprTreeNodeUtils.docPathToReadableString(docPath, dbEnv, null);
    }

    public static String docPathToReadableString(DocPath docPath, DbEnv dbEnv, Map<String, String> docPathStringSubstitutionMap) {
        StringBuilder builder = new StringBuilder();
        List<DocPathElement> pathElements = docPath.getElements();
        dbEnv.dbAssert(pathElements != null && !pathElements.isEmpty() && pathElements.get(0) instanceof DocPathMapElement, "docPathToReadableString", "Invalid docPath", docPath);
        builder.append(Objects.requireNonNull(pathElements).get(0));
        for (int i = 1; i < pathElements.size(); ++i) {
            if (pathElements.get(i) instanceof DocPathMapElement) {
                builder.append(".");
            }
            builder.append(pathElements.get(i).toString());
        }
        if (Objects.nonNull(docPathStringSubstitutionMap) && docPathStringSubstitutionMap.containsKey(builder.toString())) {
            return docPathStringSubstitutionMap.get(builder.toString());
        }
        return builder.toString();
    }

    public static ExprTreeNode flattenAndOr(ExprTreeNode root) {
        if (root == null) {
            return null;
        }
        if (!(root instanceof ExprTreeOpNode)) {
            return root;
        }
        ExprTreeOpNode opRoot = (ExprTreeOpNode)root;
        Operator rootOperator = opRoot.getOperator();
        if (rootOperator != Operator.AND && rootOperator != Operator.OR) {
            return root;
        }
        List<ExprTreeNode> children = root.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            children.set(i, ExprTreeNodeUtils.flattenAndOr(children.get(i)));
        }
        ArrayList<ExprTreeNode> removedChildren = new ArrayList<ExprTreeNode>();
        ArrayList<ExprTreeNode> addedChildren = new ArrayList<ExprTreeNode>();
        for (ExprTreeNode child2 : children) {
            ExprTreeOpNode opChild;
            if (!(child2 instanceof ExprTreeOpNode) || rootOperator != (opChild = (ExprTreeOpNode)child2).getOperator()) continue;
            removedChildren.add(child2);
            for (ExprTreeNode childChild : child2.getChildren()) {
                addedChildren.add(childChild);
            }
        }
        ArrayList<ExprTreeNode> newChildren = new ArrayList<ExprTreeNode>(children);
        newChildren.removeAll(removedChildren);
        newChildren.addAll(addedChildren);
        if (!newChildren.equals(children)) {
            return new ExprTreeOpNode(newChildren, opRoot.getOperator());
        }
        return root;
    }
}

