/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.partiql.processor;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import com.amazonaws.services.dynamodbv2.datamodel.Expression;
import com.amazonaws.services.dynamodbv2.rr.ExpressionWrapper;
import ddb.partiql.shared.exceptions.ExceptionMessageBuilder;
import java.util.Collections;
import java.util.Map;
import org.partiql.lang.ast.DataManipulation;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.ReturnValuesOnConditionCheckFailure;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.LocalDBValidatorUtils;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.api.dp.PartiQLStatementFunction;
import software.amazon.dynamodb.services.local.shared.env.LocalPartiQLDbEnv;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;
import software.amazon.dynamodb.services.local.shared.partiql.ParsedPartiQLRequest;
import software.amazon.dynamodb.services.local.shared.partiql.model.TranslatedPartiQLOperation;
import software.amazon.dynamodb.services.local.shared.partiql.processor.StatementProcessor;
import software.amazon.dynamodb.services.local.shared.partiql.translator.InsertStatementTranslator;

public class InsertStatementProcessor
extends StatementProcessor<DataManipulation> {
    private final InsertStatementTranslator translator;

    public InsertStatementProcessor(InsertStatementTranslator translator, LocalDBAccess dbAccess, LocalPartiQLDbEnv localPartiQLDbEnv, PartiQLStatementFunction partiQLStatementFunction, DocumentFactory documentFactory) {
        super(dbAccess, localPartiQLDbEnv, partiQLStatementFunction, documentFactory);
        this.translator = translator;
    }

    @Override
    public ExecuteStatementResponse execute(ParsedPartiQLRequest<DataManipulation> request) {
        TranslatedPartiQLOperation translatedPartiQLOperation = this.translator.translate(request);
        return this.invokePartiqlInsertItem(translatedPartiQLOperation);
    }

    public ExecuteStatementResponse invokePartiqlInsertItem(TranslatedPartiQLOperation translatedPartiQLOperation) {
        try {
            this.partiqlInsertItem(translatedPartiQLOperation.getTableName(), translatedPartiQLOperation.getReturnValue(), translatedPartiQLOperation.getItem(), translatedPartiQLOperation.getConditionExpressionWrapper(), translatedPartiQLOperation.getReturnValuesOnConditionCheckFailure());
        }
        catch (ConditionalCheckFailedException e) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.DUPLICATE_ITEM_EXCEPTION, new ExceptionMessageBuilder("Duplicate primary key exists in table").build(new Object[0]));
        }
        return (ExecuteStatementResponse)ExecuteStatementResponse.builder().items(Collections.emptyList()).build();
    }

    private void partiqlInsertItem(final String tableName, ReturnValue returnVals, final Map<String, AttributeValue> record, ExpressionWrapper conditionExpressionWrapper, ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
        this.partiQLStatementFunction.validateTableName(tableName);
        final TableInfo tableInfo = this.partiQLStatementFunction.validateTableExists(tableName);
        final Map key = this.partiQLStatementFunction.validatePutItem((Map)record, tableInfo);
        final Expression conditionExpression = conditionExpressionWrapper.getExpression();
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(tableInfo, conditionExpressionWrapper, this.partiQLStatementFunction.awsExceptionFactory);
        new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

            @Override
            public void criticalSection() {
                Map<String, AttributeValue> oldItem = InsertStatementProcessor.this.dbAccess.getRecord(tableName, key);
                if (!LocalDBUtils.doesItemMatchCondition(oldItem, conditionExpression, InsertStatementProcessor.this.localPartiQLDbEnv, InsertStatementProcessor.this.documentFactory)) {
                    throw (ConditionalCheckFailedException)ConditionalCheckFailedException.builder().message("The conditional request failed").build();
                }
                AttributeValue rangeKey = null;
                if (tableInfo.hasRangeKey()) {
                    rangeKey = (AttributeValue)key.get(tableInfo.getRangeKey().attributeName());
                }
                InsertStatementProcessor.this.dbAccess.putRecord(tableName, record, (AttributeValue)key.get(tableInfo.getHashKey().attributeName()), rangeKey, false);
            }
        }.execute();
    }
}

