/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.mapper;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;

public class AttributeValueNamingStrategy
extends PropertyNamingStrategy {
    private static final PropertyNamingStrategy UPPER_CAMEL_CASE = PropertyNamingStrategies.UPPER_CAMEL_CASE;

    public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
        return this.translateName(defaultName);
    }

    public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
        return this.translateName(defaultName);
    }

    public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
        return this.translateName(defaultName);
    }

    public String nameForConstructorParameter(MapperConfig<?> config, AnnotatedParameter ctorParam, String defaultName) {
        return this.translateName(defaultName);
    }

    private String translateName(String propertyName) {
        switch (propertyName) {
            case "s": {
                return "S";
            }
            case "n": {
                return "N";
            }
            case "b": {
                return "B";
            }
            case "ss": {
                return "SS";
            }
            case "ns": {
                return "NS";
            }
            case "bs": {
                return "BS";
            }
            case "m": {
                return "M";
            }
            case "l": {
                return "L";
            }
            case "bool": {
                return "BOOL";
            }
            case "nul": {
                return "NULL";
            }
        }
        if (UPPER_CAMEL_CASE != null) {
            try {
                return UPPER_CAMEL_CASE.nameForField(null, null, propertyName);
            }
            catch (Exception e) {
                return Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
            }
        }
        return Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }
}

