/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.jobs;

import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.jobs.JobsRegister;

abstract class NamedJob
implements Runnable {
    protected final JobsRegister jobs;

    NamedJob(JobsRegister jobs) {
        this.jobs = jobs;
    }

    protected abstract void doJob();

    public abstract String name();

    public abstract void cancel();

    @Override
    public void run() {
        this.doJob();
        this.jobs.remove(this.name());
    }

    void sleepFor(long millis) {
        if (millis == 0L) {
            return;
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INTERNAL_SERVER_ERROR, LocalDBClientExceptionMessage.INTERRUPTED_EXCEPTION_DURING_BACKGROUND_JOB.getMessage());
        }
    }
}

