/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.dynamodb.model.Identity;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.Record;
import software.amazon.awssdk.services.dynamodb.model.Shard;
import software.amazon.awssdk.services.dynamodb.model.ShardIteratorType;
import software.amazon.awssdk.services.dynamodb.model.Stream;
import software.amazon.awssdk.services.dynamodb.model.StreamDescription;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBClient;
import software.amazon.dynamodb.services.local.shared.access.LocalDBValidatorUtils;
import software.amazon.dynamodb.services.local.shared.access.ShardIterator;
import software.amazon.dynamodb.services.local.shared.dataaccess.OperationType;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.jobs.JobsRegister;
import software.amazon.dynamodb.services.local.shared.jobs.ShardRolloverJob;

public class LocalDynamoDbStreamsClient
implements DynamoDbStreamsClient {
    public static final int GET_RECORD_MIN_LIMIT = 1;
    public static final int GET_RECORD_MAX_LIMIT = 1000;
    public static final long STREAM_SURVIVAL_DURATION = TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS);
    public static final long SHARD_SURVIVAL_DURATION = TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS);
    public static final long RECORD_SURVIVAL_DURATION = TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS);
    public static final long SHARD_ROLLOVER_TIME = TimeUnit.MILLISECONDS.convert(4L, TimeUnit.HOURS);
    public static final long SAFETY_SURVIVAL_PADDING = TimeUnit.MILLISECONDS.convert(6L, TimeUnit.HOURS);
    public static final String STREAMS_EVENT_VERSION = "1.1";
    public static final String DEFAULT_ACCOUNT_NUMBER = "000000000000";
    public static final String DEFAULT_REGION = "ddblocal";
    public static final String DEFAULT_EVENT_SOURCE = "aws:dynamodb";
    private static final long SHARDITERATOR_EXPIRATION_TIME = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MINUTES);
    private static final String DDB_PRINCIPAL_SERVICE_NAME = "dynamodb.amazonaws.com";
    private static final String IDENTIY_SERVICE_TYPE_NAME = "Service";
    private static final Comparator<StreamDescription> STREAM_DESCRIPTION_CREATION_TIME_COMPARATOR = new Comparator<StreamDescription>(){

        @Override
        public int compare(StreamDescription arg0, StreamDescription arg1) {
            return arg1.creationRequestDateTime().compareTo(arg0.creationRequestDateTime());
        }
    };
    private final LocalDBAccess dbAccess;
    private final JobsRegister jobs;
    private final AWSExceptionFactory awsExceptionFactory;
    private volatile long lastDilationRequestTime = 0L;

    public LocalDynamoDbStreamsClient(LocalDBAccess dbAccess, JobsRegister jobs) {
        this.dbAccess = dbAccess;
        this.jobs = jobs;
        this.awsExceptionFactory = new AWSExceptionFactory();
    }

    public ListStreamsResponse listStreams(ListStreamsRequest listStreamsRequest) throws AwsServiceException {
        int limit2 = LocalDBValidatorUtils.validateLimitValueListStreams(listStreamsRequest.limit(), this.awsExceptionFactory);
        List<StreamDescription> streamInfoList = this.dbAccess.getStreamInfo(listStreamsRequest.tableName(), null, limit2 + 1, listStreamsRequest.exclusiveStartStreamArn(), null);
        String lastEvaluatedStreamArn = streamInfoList.size() > limit2 ? streamInfoList.get(limit2 - 1).streamArn() : null;
        ArrayList<Stream> streams = new ArrayList<Stream>();
        if (streamInfoList.size() > limit2) {
            streamInfoList = streamInfoList.subList(0, limit2);
        }
        streamInfoList.sort(STREAM_DESCRIPTION_CREATION_TIME_COMPARATOR);
        for (StreamDescription description : streamInfoList) {
            streams.add((Stream)Stream.builder().streamArn(description.streamArn()).streamLabel(description.streamLabel()).tableName(description.tableName()).build());
        }
        return (ListStreamsResponse)ListStreamsResponse.builder().streams(streams).lastEvaluatedStreamArn(lastEvaluatedStreamArn).build();
    }

    public DescribeStreamResponse describeStream(DescribeStreamRequest describeStreamRequest) {
        String streamArn;
        Integer limit2 = LocalDBValidatorUtils.validateDescribeStreamLimit(describeStreamRequest.limit(), this.awsExceptionFactory);
        String exclusiveStartShardId = describeStreamRequest.exclusiveStartShardId();
        if (exclusiveStartShardId != null) {
            if (exclusiveStartShardId.length() < 28) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "1 validation error detected: Value '" + exclusiveStartShardId + "' at 'exclusiveStartShardId' failed to satisfy constraint: Member must have length greater than or equal to 28");
            }
            if (exclusiveStartShardId.length() > 65) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "1 validation error detected: Value '" + exclusiveStartShardId + "' at 'exclusiveStartShardId' failed to satisfy constraint: Member must have length less than or equal to 65");
            }
        }
        if ((streamArn = describeStreamRequest.streamArn()) == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_STREAM_ARN.getMessage());
        }
        List<Object> streamDescs = this.dbAccess.getStreamInfo(null, streamArn, 1, null, describeStreamRequest.exclusiveStartShardId());
        if (streamDescs.size() == 0 && StringUtils.isNotEmpty((CharSequence)describeStreamRequest.exclusiveStartShardId())) {
            streamDescs = this.dbAccess.getStreamInfo(null, streamArn, 1, null, null);
            streamDescs = streamDescs.stream().map(streamDescription -> (StreamDescription)streamDescription.toBuilder().shards(Collections.emptyList()).build()).collect(Collectors.toList());
        }
        if (streamDescs.size() == 0) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_NOT_FOUND_EXCEPTION, "Requested resource not found: Stream: " + streamArn + " not found");
        }
        StreamDescription streamDesc = streamDescs.get(0);
        String nextExclusiveStartShardId = null;
        List shards = streamDesc.shards();
        if (limit2 < shards.size()) {
            nextExclusiveStartShardId = ((Shard)shards.get(limit2 - 1)).shardId();
        }
        List shardsToReturn = shards.subList(0, Math.min(limit2, shards.size()));
        return (DescribeStreamResponse)DescribeStreamResponse.builder().streamDescription((StreamDescription)streamDesc.toBuilder().lastEvaluatedShardId(nextExclusiveStartShardId).shards(shardsToReturn).build()).build();
    }

    public GetRecordsResponse getRecords(GetRecordsRequest getRecordsRequest) throws AwsServiceException {
        boolean shardIsSealed;
        Long earliestNonExpiredSequenceNumber;
        String shardIteratorStr = getRecordsRequest.shardIterator();
        ShardIterator iter = null;
        try {
            iter = ShardIterator.fromString(shardIteratorStr);
        }
        catch (Throwable t) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "Invalid ShardIterator");
        }
        if (Math.abs(System.currentTimeMillis() - iter.creationTime) > SHARDITERATOR_EXPIRATION_TIME || this.lastDilationRequestTime > iter.creationTime) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.EXPIRED_SHARD_ITERATOR);
        }
        Integer limit2 = getRecordsRequest.limit();
        if (limit2 == null) {
            limit2 = 1000;
        }
        if (limit2 > 1000) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "One or more parameter values were invalid: Limit should be less than or equal to 1000");
        }
        if (limit2 < 1) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "1 validation error detected: Value '" + limit2 + "' at 'limit' failed to satisfy constraint: Member must have value greater than or equal to 1");
        }
        if (!this.dbAccess.shardIsNotExpired(iter.shardId)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_NOT_FOUND_EXCEPTION, "Invalid ShardId in ShardIterator");
        }
        if (this.dbAccess.getLatestSequenceNumberForShard(iter.shardId) != null && ((earliestNonExpiredSequenceNumber = this.dbAccess.getEarliestNonExpiredSequenceNumberForShard(iter.shardId)) == null || iter.shardSequenceNumber < earliestNonExpiredSequenceNumber)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.TRIMMED_DATA_ACCESS_EXCEPTION);
        }
        List<Record> records = this.dbAccess.getStreamRecords(limit2 + 1, iter);
        boolean hasMoreRecords = records.size() > limit2;
        boolean bl = shardIsSealed = this.dbAccess.getDeletionDateTimeForShard(iter.shardId) != 0L;
        if (hasMoreRecords) {
            records.remove(records.size() - 1);
        }
        long nextSequenceNumber = iter.shardSequenceNumber;
        if (records.size() > 0) {
            nextSequenceNumber = Long.parseLong(records.get(records.size() - 1).dynamodb().sequenceNumber()) + 1L;
            for (Record r : records) {
                Record updatedRecord = (Record)r.toBuilder().awsRegion(DEFAULT_REGION).eventSource(DEFAULT_EVENT_SOURCE).build();
                if (r.eventName().equals((Object)OperationType.EXPIRE.toString())) {
                    updatedRecord = (Record)updatedRecord.toBuilder().eventName(software.amazon.awssdk.services.dynamodb.model.OperationType.REMOVE.toString()).userIdentity((Identity)Identity.builder().principalId(DDB_PRINCIPAL_SERVICE_NAME).type(IDENTIY_SERVICE_TYPE_NAME).build()).build();
                }
                records.set(records.indexOf(r), updatedRecord);
            }
        }
        String nextShardIterator = null;
        if (hasMoreRecords || !shardIsSealed) {
            nextShardIterator = new ShardIterator(iter.streamId, iter.shardId, nextSequenceNumber).toString();
        }
        return (GetRecordsResponse)GetRecordsResponse.builder().nextShardIterator(nextShardIterator).records(records).build();
    }

    public GetShardIteratorResponse getShardIterator(GetShardIteratorRequest getShardIteratorRequest) throws AwsServiceException {
        List<StreamDescription> descs;
        if (getShardIteratorRequest.shardId() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "No ShardId specified.");
        }
        ShardIteratorType iterType = null;
        try {
            iterType = getShardIteratorRequest.shardIteratorType();
        }
        catch (IllegalArgumentException e) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "Invalid ShardIteratorType.");
        }
        String sequenceNumber = getShardIteratorRequest.sequenceNumber();
        if (sequenceNumber == null && (ShardIteratorType.AFTER_SEQUENCE_NUMBER == iterType || ShardIteratorType.AT_SEQUENCE_NUMBER == iterType)) {
            this.awsExceptionFactory.INVALID_PARAMETER_VALUE.throwAsException(LocalDBClientExceptionMessage.INVALID_STREAM_SEQUENCE_NUMBER);
        } else if (sequenceNumber != null) {
            if (ShardIteratorType.TRIM_HORIZON == iterType || ShardIteratorType.LATEST == iterType) {
                this.awsExceptionFactory.INVALID_PARAMETER_VALUE.throwAsException(LocalDBClientExceptionMessage.STREAM_SEQUENCE_NUMBER_NOT_ALLOWED);
            }
            if (sequenceNumber.length() < 21) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "1 validation error detected: Value '" + sequenceNumber + "' at 'sequenceNumber' failed to satisfy constraint: Member must have length greater than or equal to 21");
            }
            if (sequenceNumber.length() > 40) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "1 validation error detected: Value '" + sequenceNumber + "' at 'sequenceNumber' failed to satisfy constraint: Member must have length less than or equal to 40");
            }
        }
        if (getShardIteratorRequest.streamArn() == null) {
            this.awsExceptionFactory.INVALID_PARAMETER_VALUE.throwAsException(LocalDBClientExceptionMessage.MISSING_STREAM_ARN);
        }
        if ((descs = this.dbAccess.getStreamInfo(null, getShardIteratorRequest.streamArn(), 1, null, null)).isEmpty()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_NOT_FOUND_EXCEPTION, LocalDBClientExceptionMessage.STREAM_NOT_FOUND.getMessage());
        }
        StreamDescription desc = descs.get(0);
        for (Shard shard : desc.shards()) {
            if (!getShardIteratorRequest.shardId().equals(shard.shardId())) continue;
            String iterString = this.getShardIterator(getShardIteratorRequest.streamArn(), getShardIteratorRequest.shardId(), getShardIteratorRequest.shardIteratorType(), sequenceNumber, shard);
            return (GetShardIteratorResponse)GetShardIteratorResponse.builder().shardIterator(iterString).build();
        }
        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_NOT_FOUND_EXCEPTION, LocalDBClientExceptionMessage.SHARD_NOT_FOUND.getMessage());
    }

    private String getShardIterator(String streamId, String shardId, ShardIteratorType shardIteratorType, String startingSequenceNumber, Shard shardDescription) {
        Long seqNum = null;
        if (shardIteratorType == ShardIteratorType.TRIM_HORIZON) {
            Long earliest = this.dbAccess.getEarliestNonExpiredSequenceNumberForShard(shardId);
            seqNum = earliest != null ? earliest : Long.parseLong(shardDescription.sequenceNumberRange().startingSequenceNumber());
        } else if (shardIteratorType == ShardIteratorType.LATEST) {
            Long latestSeqNum;
            String endingSequenceNumber = shardDescription.sequenceNumberRange().endingSequenceNumber();
            seqNum = endingSequenceNumber == null ? ((latestSeqNum = this.dbAccess.getLatestSequenceNumberForShard(shardId)) == null ? this.dbAccess.getSequenceNumberStartForShard(shardId) : Long.valueOf(latestSeqNum + 1L)) : Long.valueOf(Long.parseLong(endingSequenceNumber) + 1L);
        } else if (shardIteratorType == ShardIteratorType.AFTER_SEQUENCE_NUMBER || shardIteratorType == ShardIteratorType.AT_SEQUENCE_NUMBER) {
            long requestSequenceNumber = Long.parseLong(startingSequenceNumber);
            String shardEndingSequenceNumber = shardDescription.sequenceNumberRange().endingSequenceNumber();
            if (requestSequenceNumber < Long.parseLong(shardDescription.sequenceNumberRange().startingSequenceNumber()) || shardEndingSequenceNumber != null && Long.parseLong(shardEndingSequenceNumber) < requestSequenceNumber) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "Invalid SequenceNumber for the shard");
            }
            seqNum = shardIteratorType == ShardIteratorType.AFTER_SEQUENCE_NUMBER ? Long.valueOf(Long.parseLong(startingSequenceNumber) + 1L) : Long.valueOf(Long.parseLong(startingSequenceNumber));
        }
        return new ShardIterator(streamId, shardId, seqNum).toString();
    }

    public void dilateEventTimes(long ms) {
        if (ms <= 0L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_DILATE_TIME_MESSAGE.getMessage());
        }
        this.dbAccess.dilateEventTimes(-1L * ms);
        this.lastDilationRequestTime = System.currentTimeMillis();
        try {
            this.jobs.schedule(new ShardRolloverJob(this.dbAccess, this.jobs, LocalDBClient.SHARD_ROLLOVER_TIME)).get();
        }
        catch (InterruptedException e) {
            throw AWSExceptionFactory.buildInternalServerException(LocalDBClientExceptionMessage.ROLLOVER_INTERRUPTED_ERROR_MESSAGE.getMessage());
        }
        catch (ExecutionException e) {
            throw AWSExceptionFactory.buildInternalServerException(LocalDBClientExceptionMessage.ROLLOVER_EXECUTION_EXCEPTION_MESSAGE.getMessage());
        }
    }

    public void triggerShardRollovers() {
        try {
            this.jobs.schedule(new ShardRolloverJob(this.dbAccess, this.jobs, 0L)).get();
        }
        catch (InterruptedException e) {
            throw AWSExceptionFactory.buildInternalServerException(LocalDBClientExceptionMessage.ROLLOVER_INTERRUPTED_ERROR_MESSAGE.getMessage());
        }
        catch (ExecutionException e) {
            throw AWSExceptionFactory.buildInternalServerException(LocalDBClientExceptionMessage.ROLLOVER_EXECUTION_EXCEPTION_MESSAGE.getMessage());
        }
    }

    public String serviceName() {
        return "dynamodb";
    }

    public void close() {
    }
}

