/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.api.cp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalSecondaryIndexAction;
import software.amazon.awssdk.services.dynamodb.model.DeleteGlobalSecondaryIndexAction;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate;
import software.amazon.awssdk.services.dynamodb.model.IndexStatus;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalSecondaryIndexAction;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableResponse;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.api.cp.ControlPlaneFunction;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;

public class UpdateTableFunction
extends ControlPlaneFunction<UpdateTableRequest, UpdateTableResponse> {
    public UpdateTableFunction(LocalDBAccess dbAccess) {
        super(dbAccess);
    }

    @Override
    public UpdateTableResponse apply(UpdateTableRequest updateTableRequest) {
        String unparsedTableName = updateTableRequest.tableName();
        final String tableName = this.getTableNameFromPossibleArn(unparsedTableName);
        final UpdateTableRequest updatedRequest = (UpdateTableRequest)updateTableRequest.toBuilder().tableName(tableName).build();
        this.validateTableName(tableName);
        final TableInfo info = this.validateTableExists(tableName);
        final StreamSpecification newSpec = updatedRequest.streamSpecification();
        new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

            @Override
            public void criticalSection() {
                boolean changeToPayPerUse;
                boolean changeToProvisioned;
                boolean doesRequestUpdateBillingMode;
                ProvisionedThroughput newThroughput = updatedRequest.provisionedThroughput();
                OnDemandThroughput newOnDemandThroughput = updatedRequest.onDemandThroughput();
                List gsiUpdates = updatedRequest.globalSecondaryIndexUpdates();
                boolean doesRequestUpdateBaseTableIOPS = newThroughput != null;
                boolean doesRequestUpdateBaseTableOnDemandMaxIOPS = newOnDemandThroughput != null;
                boolean doesRequestHaveOnlineGSIRequests = gsiUpdates != null && !gsiUpdates.isEmpty();
                boolean bl = doesRequestUpdateBillingMode = updatedRequest.billingMode() != null;
                if (!(doesRequestUpdateBaseTableIOPS || doesRequestUpdateBaseTableOnDemandMaxIOPS || doesRequestUpdateBillingMode || doesRequestHaveOnlineGSIRequests || newSpec != null || updatedRequest.deletionProtectionEnabled() != null)) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NOTHING_TO_UPDATE.getMessage());
                }
                boolean deleteProtectionEnabled = false;
                if (updatedRequest.deletionProtectionEnabled() != null) {
                    deleteProtectionEnabled = updatedRequest.deletionProtectionEnabled();
                }
                ArrayList<String> indicesCurrentlyCreatingNotBackfilling = new ArrayList<String>();
                ArrayList<String> indicesCurrentlyCreatingBackfilling = new ArrayList<String>();
                ArrayList<String> indicesCurrentlyUpdating = new ArrayList<String>();
                ArrayList<String> indicesCurrentlyDeleting = new ArrayList<String>();
                if (info.hasGSIs()) {
                    for (GlobalSecondaryIndexDescription existingGSI : info.getGSIDescriptions()) {
                        switch (IndexStatus.fromValue((String)existingGSI.indexStatusAsString())) {
                            case CREATING: {
                                if (existingGSI.backfilling().booleanValue()) {
                                    indicesCurrentlyCreatingBackfilling.add(existingGSI.indexName());
                                    break;
                                }
                                indicesCurrentlyCreatingNotBackfilling.add(existingGSI.indexName());
                                break;
                            }
                            case UPDATING: {
                                indicesCurrentlyUpdating.add(existingGSI.indexName());
                                break;
                            }
                            case DELETING: {
                                indicesCurrentlyDeleting.add(existingGSI.indexName());
                                break;
                            }
                        }
                    }
                }
                if (doesRequestUpdateBaseTableIOPS || doesRequestUpdateBaseTableOnDemandMaxIOPS) {
                    String indexName;
                    Iterator<Object> iterator2 = indicesCurrentlyCreatingNotBackfilling.iterator();
                    if (iterator2.hasNext()) {
                        indexName = (String)iterator2.next();
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, String.format(LocalDBClientExceptionMessage.CANT_UPDATE_TABLE_WHEN_INDEX_IS_CREATING_BACKFILLING_FALSE.getMessage(), tableName, indexName));
                    }
                    iterator2 = indicesCurrentlyDeleting.iterator();
                    if (iterator2.hasNext()) {
                        indexName = (String)iterator2.next();
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, String.format(LocalDBClientExceptionMessage.CANT_UPDATE_TABLE_WHEN_INDEX_IS_DELETING.getMessage(), tableName, indexName));
                    }
                }
                List<AttributeDefinition> updatedAllAttributesList = info.getAttributeDefinitions();
                ArrayList<GlobalSecondaryIndexDescription> updatedGSIDescList = info.hasGSIs() ? new ArrayList<GlobalSecondaryIndexDescription>(info.getGSIDescriptions()) : new ArrayList();
                String billingModeString = updatedRequest.billingMode() != null ? updatedRequest.billingMode().toString() : null;
                BillingMode calculatedBillingMode = StringUtils.isNotBlank((CharSequence)billingModeString) ? BillingMode.fromValue((String)billingModeString) : info.getBillingMode();
                if (doesRequestHaveOnlineGSIRequests) {
                    boolean doesRequestHaveDeleteGSI;
                    int numberOfCreateGSIRequests = 0;
                    int numberOfUpdateGSIRequests = 0;
                    int numberOfDeleteGSIRequests = 0;
                    for (Object update : gsiUpdates) {
                        if (update == null) continue;
                        if (update.create() != null) {
                            ++numberOfCreateGSIRequests;
                        }
                        if (update.update() != null) {
                            ++numberOfUpdateGSIRequests;
                        }
                        if (update.delete() == null) continue;
                        ++numberOfDeleteGSIRequests;
                    }
                    if (UpdateTableFunction.this.dbAccess.numberOfSubscriberWideInflightOnlineCreateIndexesOperations() + numberOfCreateGSIRequests > 5) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.LIMIT_EXCEEDED_EXCEPTION, LocalDBClientExceptionMessage.SUBSCRIBER_WIDE_MAX_INFLIGHT_CREATE_ONLINE_GSI_LIMIT_REACHED.getMessage());
                    }
                    if (UpdateTableFunction.this.areThereMoreThanOneUpdateToSameIndex(gsiUpdates)) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.ONLY_ONE_GSI_UPDATE_PER_REQUEST_FOR_AN_INDEX.getMessage());
                    }
                    UpdateTableFunction.this.throwResourceInUseIfIndexIsInFlight(gsiUpdates, indicesCurrentlyCreatingNotBackfilling, indicesCurrentlyCreatingBackfilling, indicesCurrentlyUpdating, indicesCurrentlyDeleting, info);
                    UpdateTableFunction.this.throwLimitExceededExceptionIfThereAreTooManyIndexUpdates(numberOfCreateGSIRequests, numberOfDeleteGSIRequests, indicesCurrentlyCreatingNotBackfilling, indicesCurrentlyCreatingBackfilling, indicesCurrentlyDeleting);
                    ArrayList<String> indicesToDelete = new ArrayList<String>();
                    block7: for (GlobalSecondaryIndexUpdate gsiUpdate : gsiUpdates) {
                        GlobalSecondaryIndexDescription gsi;
                        ProvisionedThroughputDescription ptDesc;
                        if (gsiUpdate == null) {
                            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NULL_GSI_UPDATE.getMessage());
                        }
                        CreateGlobalSecondaryIndexAction createAction = gsiUpdate.create();
                        UpdateGlobalSecondaryIndexAction updateAction = gsiUpdate.update();
                        DeleteGlobalSecondaryIndexAction deleteAction = gsiUpdate.delete();
                        if (updateAction == null && createAction == null && deleteAction == null) {
                            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NULL_GSI_UPDATE_ACTION.getMessage());
                        }
                        if (createAction != null) {
                            UpdateTableFunction.this.validateCreateGSI(info, createAction);
                            GlobalSecondaryIndexDescription gsiDesc = (GlobalSecondaryIndexDescription)GlobalSecondaryIndexDescription.builder().indexName(createAction.indexName()).indexStatus(IndexStatus.CREATING).backfilling(Boolean.valueOf(false)).keySchema((Collection)createAction.keySchema()).projection(createAction.projection()).build();
                            if (BillingMode.PAY_PER_REQUEST == calculatedBillingMode) {
                                Long maxReadRequestUnits = createAction.onDemandThroughput() != null && createAction.onDemandThroughput().maxReadRequestUnits() != null ? createAction.onDemandThroughput().maxReadRequestUnits() : -1L;
                                Long maxWriteRequestUnits = createAction.onDemandThroughput() != null && createAction.onDemandThroughput().maxWriteRequestUnits() != null ? createAction.onDemandThroughput().maxWriteRequestUnits() : -1L;
                                OnDemandThroughput onDemandThroughput = (OnDemandThroughput)OnDemandThroughput.builder().maxReadRequestUnits(maxReadRequestUnits).maxWriteRequestUnits(maxWriteRequestUnits).build();
                                gsiDesc = (GlobalSecondaryIndexDescription)gsiDesc.toBuilder().onDemandThroughput(onDemandThroughput).build();
                            } else {
                                ptDesc = (ProvisionedThroughputDescription)ProvisionedThroughputDescription.builder().readCapacityUnits(createAction.provisionedThroughput().readCapacityUnits()).writeCapacityUnits(createAction.provisionedThroughput().writeCapacityUnits()).build();
                                gsiDesc = (GlobalSecondaryIndexDescription)gsiDesc.toBuilder().provisionedThroughput(ptDesc).build();
                            }
                            updatedGSIDescList.add(gsiDesc);
                        }
                        if (updateAction != null) {
                            gsi = info.getGSIDescWithName(updateAction.indexName());
                            if (BillingMode.PAY_PER_REQUEST == calculatedBillingMode) {
                                OnDemandThroughput onDemandThroughput = (OnDemandThroughput)OnDemandThroughput.builder().maxReadRequestUnits(updateAction.onDemandThroughput().maxReadRequestUnits()).maxWriteRequestUnits(updateAction.onDemandThroughput().maxWriteRequestUnits()).build();
                                gsi = (GlobalSecondaryIndexDescription)gsi.toBuilder().onDemandThroughput(onDemandThroughput).build();
                                info.updateGSIDesc(updateAction.indexName(), gsi);
                            } else {
                                UpdateTableFunction.this.validateUpdateGSI(info, updateAction);
                                ptDesc = (ProvisionedThroughputDescription)ProvisionedThroughputDescription.builder().readCapacityUnits(updateAction.provisionedThroughput().readCapacityUnits()).writeCapacityUnits(updateAction.provisionedThroughput().writeCapacityUnits()).build();
                                gsi = (GlobalSecondaryIndexDescription)gsi.toBuilder().provisionedThroughput(ptDesc).build();
                                info.updateGSIDesc(updateAction.indexName(), gsi);
                                updatedGSIDescList.removeIf(existingGsi -> existingGsi.indexName().equals(updateAction.indexName()));
                                updatedGSIDescList.add(gsi);
                            }
                        }
                        if (deleteAction == null) continue;
                        UpdateTableFunction.this.validateDeleteGSI(info, deleteAction);
                        indicesToDelete.add(deleteAction.indexName());
                        gsi = info.getGSIDescWithName(deleteAction.indexName());
                        gsi = (GlobalSecondaryIndexDescription)gsi.toBuilder().indexStatus(IndexStatus.DELETING).backfilling((Boolean)null).build();
                        info.updateGSIDesc(deleteAction.indexName(), gsi);
                        for (int i = 0; i < updatedGSIDescList.size(); ++i) {
                            if (!((GlobalSecondaryIndexDescription)updatedGSIDescList.get(i)).indexName().equals(deleteAction.indexName())) continue;
                            updatedGSIDescList.set(i, gsi);
                            continue block7;
                        }
                    }
                    List attrDefnsFromNewGSIs = updatedRequest.attributeDefinitions();
                    if (attrDefnsFromNewGSIs != null && !attrDefnsFromNewGSIs.isEmpty()) {
                        UpdateTableFunction.this.validateNewAttributes(attrDefnsFromNewGSIs, info);
                    }
                    boolean doesRequestHaveCreateGSI = numberOfCreateGSIRequests > 0;
                    boolean doesRequestHaveUpdateGSI = numberOfUpdateGSIRequests > 0;
                    boolean bl2 = doesRequestHaveDeleteGSI = numberOfDeleteGSIRequests > 0;
                    if (doesRequestHaveCreateGSI && (attrDefnsFromNewGSIs == null || attrDefnsFromNewGSIs.isEmpty())) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_ATTRIBUTE_SCHEMA.getMessage());
                    }
                    updatedAllAttributesList = UpdateTableFunction.this.updateAttributesList(info, attrDefnsFromNewGSIs, indicesToDelete);
                    UpdateTableFunction.this.validateAttributeDefinitions(updatedAllAttributesList);
                    if (doesRequestHaveCreateGSI || doesRequestHaveUpdateGSI || doesRequestHaveDeleteGSI) {
                        if (updatedGSIDescList.size() > 20) {
                            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.LIMIT_EXCEEDED_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_GSI_LIMIT_EXCEEDED_EXCEPTION.getMessage());
                        }
                        UpdateTableFunction.this.validateGSISchemas(updatedGSIDescList, LocalDBUtils.getBaseTableHashKeyDefinition(info), LocalDBUtils.getBaseTableRangeKeyDefinition(info), updatedAllAttributesList, info.getLSINames(), info.getNumberOfLSIProjectedAttributes(), calculatedBillingMode);
                    }
                }
                ProvisionedThroughput curThroughput = info.getThroughput();
                ProvisionedThroughput updatedThroughput = doesRequestUpdateBaseTableIOPS ? newThroughput : curThroughput;
                OnDemandThroughput updatedOndemandThroughput = ControlPlaneFunction.EMPTY_ONDEMAND_THROUGHPUT;
                if (BillingMode.PAY_PER_REQUEST.equals((Object)calculatedBillingMode)) {
                    updatedThroughput = null;
                    updatedOndemandThroughput = doesRequestUpdateBaseTableOnDemandMaxIOPS ? newOnDemandThroughput : ControlPlaneFunction.EMPTY_ONDEMAND_THROUGHPUT;
                }
                boolean bl3 = changeToProvisioned = info.getBillingMode().equals((Object)BillingMode.PAY_PER_REQUEST) && calculatedBillingMode.equals((Object)BillingMode.PROVISIONED);
                if (changeToProvisioned && newThroughput == null) {
                    updatedThroughput = null;
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_NULL.getMessage());
                }
                boolean bl4 = changeToPayPerUse = info.getBillingMode().equals((Object)BillingMode.PROVISIONED) && calculatedBillingMode.equals((Object)BillingMode.PAY_PER_REQUEST);
                if (doesRequestUpdateBaseTableIOPS) {
                    UpdateTableFunction.this.validateProvisionedThroughputIncrease(newThroughput, curThroughput);
                }
                if (updatedThroughput != null) {
                    UpdateTableFunction.this.validateProvisionedThroughputWithGSIs(tableName, updatedThroughput, updatedGSIDescList);
                }
                if (updatedRequest.provisionedThroughput() != null && updatedRequest.streamSpecification() != null) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.SIMULTANEOUS_PT_AND_STREAM_SPEC_UPDATE_TABLE.getMessage());
                }
                UpdateTableFunction.this.validateStreamSpecification(newSpec, info.getStreamSpecification(), false);
                UpdateTableFunction.this.dbAccess.updateTable(tableName, updatedThroughput, updatedOndemandThroughput, calculatedBillingMode, changeToPayPerUse ? System.currentTimeMillis() : info.getLastUpdateToPayPerRequestDateTime(), updatedAllAttributesList, updatedGSIDescList, deleteProtectionEnabled, newSpec);
            }
        }.execute();
        TableDescription description = this.getTableDescriptionHelper(tableName);
        description = this.fillDescriptionHelper(description);
        return (UpdateTableResponse)UpdateTableResponse.builder().tableDescription(description).build();
    }

    private boolean areThereMoreThanOneUpdateToSameIndex(List<GlobalSecondaryIndexUpdate> gsiUpdates) {
        HashSet<String> indexNamesFromUpdate = new HashSet<String>();
        for (GlobalSecondaryIndexUpdate update : gsiUpdates) {
            String indexName = null;
            if (update.create() != null) {
                indexName = update.create().indexName();
            } else if (update.update() != null) {
                indexName = update.update().indexName();
            } else if (update.delete() != null) {
                indexName = update.delete().indexName();
            }
            if (indexName == null) continue;
            if (indexNamesFromUpdate.contains(indexName)) {
                return true;
            }
            indexNamesFromUpdate.add(indexName);
        }
        return false;
    }

    private void throwResourceInUseIfIndexIsInFlight(List<GlobalSecondaryIndexUpdate> gsiUpdates, List<String> indicesCurrentlyCreatingNotBackfilling, List<String> indicesCurrentlyCreatingBackfilling, List<String> indicesCurrentlyUpdating, List<String> indicesCurrentlyDeleting, TableInfo info) {
        for (GlobalSecondaryIndexUpdate update : gsiUpdates) {
            if (update.create() != null) {
                this.checkForResourceInUse(update.create().indexName(), "Create", indicesCurrentlyCreatingNotBackfilling, indicesCurrentlyCreatingBackfilling, indicesCurrentlyUpdating, indicesCurrentlyDeleting, info);
            }
            if (update.update() != null) {
                this.checkForResourceInUse(update.update().indexName(), "Update", indicesCurrentlyCreatingNotBackfilling, indicesCurrentlyCreatingBackfilling, indicesCurrentlyUpdating, indicesCurrentlyDeleting, info);
            }
            if (update.delete() == null) continue;
            this.checkForResourceInUse(update.delete().indexName(), "Delete", indicesCurrentlyCreatingNotBackfilling, indicesCurrentlyCreatingBackfilling, indicesCurrentlyUpdating, indicesCurrentlyDeleting, info);
        }
    }

    private void checkForResourceInUse(String indexName, String updateType, List<String> indicesCurrentlyCreatingNotBackfilling, List<String> indicesCurrentlyCreatingBackfilling, List<String> indicesCurrentlyUpdating, List<String> indicesCurrentlyDeleting, TableInfo tableInfo) {
        if (indicesCurrentlyDeleting.contains(indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.INDEX_IS_BEING_DELETED.getMessage());
        }
        if (indicesCurrentlyUpdating.contains(indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.INDEX_IS_BEING_UPDATED.getMessage());
        }
        if (indicesCurrentlyCreatingNotBackfilling.contains(indexName) || indicesCurrentlyCreatingBackfilling.contains(indexName)) {
            switch (updateType) {
                case "Create": 
                case "Delete": {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.INDEX_IS_BEING_CREATED.getMessage());
                }
                case "Update": {
                    GlobalSecondaryIndexDescription desc = tableInfo.getGSIDescWithName(indexName);
                    if (desc.backfilling() != null && desc.backfilling().booleanValue()) break;
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.INDEX_IS_BEING_CREATED_BUT_NOT_BACKFILLING.getMessage());
                }
            }
        }
    }

    private void throwLimitExceededExceptionIfThereAreTooManyIndexUpdates(int numberOfCreateGSIRequests, int numberOfDeleteGSIRequests, List<String> indicesCurrentlyCreatingNotBackfilling, List<String> indicesCurrentlyCreatingBackfilling, List<String> indicesCurrentlyDeleting) {
        if (numberOfCreateGSIRequests + numberOfDeleteGSIRequests + indicesCurrentlyCreatingNotBackfilling.size() + indicesCurrentlyCreatingBackfilling.size() + indicesCurrentlyDeleting.size() > 1) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.LIMIT_EXCEEDED_EXCEPTION, LocalDBClientExceptionMessage.INFLIGHT_INDEX_LIMIT_EXCEEDED_EXCEPTION.getMessage());
        }
    }

    private void validateCreateGSI(TableInfo info, CreateGlobalSecondaryIndexAction createAction) {
        String indexName = createAction.indexName();
        if (StringUtils.isEmpty((CharSequence)indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_GSI_NAME.getMessage());
        }
        if (info.isLSIIndex(indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.CANNOT_CREATE_GSI_WITH_SAME_NAME_AS_ANOTHER_INDEX.getMessage());
        }
        if (info.isGSIIndex(indexName)) {
            GlobalSecondaryIndexDescription anotherGSIWithSameName = info.getGSIDescWithName(createAction.indexName());
            switch (IndexStatus.fromValue((String)anotherGSIWithSameName.indexStatusAsString())) {
                case ACTIVE: {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.CANNOT_CREATE_GSI_WITH_SAME_NAME_AS_ANOTHER_INDEX.getMessage());
                }
                case CREATING: 
                case UPDATING: 
                case DELETING: {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.ONLY_ONE_GSI_UPDATE_PER_REQUEST_FOR_AN_INDEX.getMessage());
                }
            }
        }
    }

    private void validateUpdateGSI(TableInfo info, UpdateGlobalSecondaryIndexAction updateAction) {
        String indexName = updateAction.indexName();
        if (StringUtils.isEmpty((CharSequence)indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_GSI_NAME.getMessage());
        }
        if (!info.isGSIIndex(indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_GSI_NAME.getMessage());
        }
        GlobalSecondaryIndexDescription oldGSIDesc = info.getGSIDescWithName(updateAction.indexName());
        switch (IndexStatus.fromValue((String)oldGSIDesc.indexStatusAsString())) {
            case ACTIVE: {
                break;
            }
            case CREATING: {
                if (oldGSIDesc.backfilling().booleanValue()) break;
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.ONLY_ONE_GSI_UPDATE_PER_REQUEST_FOR_AN_INDEX.getMessage());
            }
            case UPDATING: {
                break;
            }
            case DELETING: {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INDEX_IS_BEING_DELETED.getMessage());
            }
        }
        ProvisionedThroughput newIndexThroughput = updateAction.provisionedThroughput();
        ProvisionedThroughput currentIndexThroughput = LocalDBUtils.getPTfromPTDescription(info.getGSIDescWithName(indexName).provisionedThroughput());
        this.validateGSIProvisionedThroughput(newIndexThroughput);
        this.validateProvisionedThroughputIncrease(newIndexThroughput, currentIndexThroughput);
    }

    private void validateDeleteGSI(TableInfo info, DeleteGlobalSecondaryIndexAction deleteAction) {
        String indexName = deleteAction.indexName();
        if (StringUtils.isEmpty((CharSequence)indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_GSI_NAME.getMessage());
        }
        if (info.isLSIIndex(indexName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.CANNOT_DELETE_LSI_VIA_DELETE_GSI_API.getMessage());
        }
        if (info.isGSIIndex(indexName)) {
            GlobalSecondaryIndexDescription oldGSIDesc = info.getGSIDescWithName(indexName);
            switch (IndexStatus.fromValue((String)oldGSIDesc.indexStatusAsString())) {
                case CREATING: {
                    if (oldGSIDesc.backfilling().booleanValue()) break;
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.ONLY_ONE_GSI_UPDATE_PER_REQUEST_FOR_AN_INDEX.getMessage());
                }
                case UPDATING: {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.ONLY_ONE_GSI_UPDATE_PER_REQUEST_FOR_AN_INDEX.getMessage());
                }
                case DELETING: {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.INDEX_IS_BEING_DELETED.getMessage());
                }
            }
        } else {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_NOT_FOUND_EXCEPTION, LocalDBClientExceptionMessage.REQUESTED_RESOURCE_NOT_FOUND.getMessage());
        }
    }

    private void validateNewAttributes(List<AttributeDefinition> newAttributes, TableInfo info) {
        HashMap<String, AttributeDefinition> existingDataTypes = new HashMap<String, AttributeDefinition>();
        List<AttributeDefinition> curAttributes = info.getAttributeDefinitions();
        if (curAttributes != null) {
            for (AttributeDefinition curAttr : curAttributes) {
                existingDataTypes.put(curAttr.attributeName(), curAttr);
            }
        }
        for (AttributeDefinition newAttr : newAttributes) {
            if (!existingDataTypes.containsKey(newAttr.attributeName())) continue;
            AttributeDefinition matchingAttrDef = (AttributeDefinition)existingDataTypes.get(newAttr.attributeName());
            if (!newAttr.attributeType().equals((Object)matchingAttrDef.attributeType())) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_ATTRIBUTE_REDEFINITION.getMessage());
            }
            LocalDBUtils.getDataTypeOfAttributeDefinition(newAttr);
        }
    }

    private List<AttributeDefinition> updateAttributesList(TableInfo tableInfo, List<AttributeDefinition> attrDefnsFromNewGSIs, List<String> indicesToBeDeleted) {
        AttributeDefinition rangeKeyDef;
        AttributeDefinition hashKeyDef;
        HashMap<String, AttributeDefinition> newAttrNameToDefnMap = new HashMap<String, AttributeDefinition>();
        newAttrNameToDefnMap.put(tableInfo.getHashKey().attributeName(), tableInfo.getHashKey());
        if (tableInfo.getRangeKey() != null) {
            newAttrNameToDefnMap.put(tableInfo.getRangeKey().attributeName(), tableInfo.getRangeKey());
        }
        if (tableInfo.getLSIIndexes() != null) {
            for (LocalSecondaryIndex lsi : tableInfo.getLSIIndexes()) {
                hashKeyDef = LocalDBUtils.getLSIHashKeyDefinition(lsi, tableInfo);
                newAttrNameToDefnMap.put(hashKeyDef.attributeName(), tableInfo.getHashKey());
                rangeKeyDef = LocalDBUtils.getLSIRangeKeyDefinition(lsi, tableInfo);
                if (rangeKeyDef == null) continue;
                newAttrNameToDefnMap.put(rangeKeyDef.attributeName(), rangeKeyDef);
            }
        }
        if (tableInfo.hasGSIs()) {
            for (GlobalSecondaryIndexDescription gsi : tableInfo.getGSIDescriptions()) {
                if (this.isThisIndexGoingToBeDeletedOrIsBeingDeleted(indicesToBeDeleted, gsi)) continue;
                hashKeyDef = LocalDBUtils.getGSIHashKeyDefinition(gsi, tableInfo);
                newAttrNameToDefnMap.put(hashKeyDef.attributeName(), hashKeyDef);
                rangeKeyDef = LocalDBUtils.getGSIRangeKeyDefinition(gsi, tableInfo);
                if (rangeKeyDef == null) continue;
                newAttrNameToDefnMap.put(rangeKeyDef.attributeName(), rangeKeyDef);
            }
        }
        if (attrDefnsFromNewGSIs != null) {
            for (AttributeDefinition newAttrDef : attrDefnsFromNewGSIs) {
                newAttrNameToDefnMap.put(newAttrDef.attributeName(), newAttrDef);
            }
        }
        return new ArrayList<AttributeDefinition>(newAttrNameToDefnMap.values());
    }

    private boolean isThisIndexGoingToBeDeletedOrIsBeingDeleted(List<String> indicesToBeDeleted, GlobalSecondaryIndexDescription gsi) {
        if (indicesToBeDeleted.contains(gsi.indexName())) {
            return true;
        }
        return IndexStatus.DELETING.equals((Object)gsi.indexStatus());
    }
}

