/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access;

import java.util.List;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.Logger;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsAsyncClient;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;
import software.amazon.dynamodb.services.local.shared.access.AmazonDynamoDBLocal;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.client.LocalDynamoDbAsyncClient;
import software.amazon.dynamodb.services.local.shared.access.client.LocalDynamoDbClient;
import software.amazon.dynamodb.services.local.shared.access.client.LocalDynamoDbStreamsAsyncClient;
import software.amazon.dynamodb.services.local.shared.access.client.LocalDynamoDbStreamsClient;
import software.amazon.dynamodb.services.local.shared.jobs.JobsRegister;
import software.amazon.dynamodb.services.local.shared.logging.LogManager;

public class LocalDBClient
implements AmazonDynamoDBLocal {
    private static final Logger logger = LogManager.getLogger(LocalDBClient.class);
    private final LocalDBAccess dbAccess;
    private final JobsRegister jobs;
    private final LocalDynamoDbStreamsClient dynamoDbStreamsClient;
    private final LocalDynamoDbStreamsAsyncClient dynamoDbStreamsAsyncClient;
    private final LocalDynamoDbClient dynamoDbClient;
    private final LocalDynamoDbAsyncClient dynamoDbAsyncClient;

    @Deprecated
    public LocalDBClient(LocalDBAccess dbAccess) {
        this(dbAccess, new JobsRegister(Executors.newFixedThreadPool(10), false));
    }

    public LocalDBClient(LocalDBAccess dbAccess, JobsRegister jobs) {
        this.dbAccess = dbAccess;
        this.jobs = jobs;
        this.dynamoDbStreamsClient = new LocalDynamoDbStreamsClient(dbAccess, jobs);
        this.dynamoDbStreamsAsyncClient = new LocalDynamoDbStreamsAsyncClient(this.dynamoDbStreamsClient);
        this.dynamoDbClient = new LocalDynamoDbClient(dbAccess, jobs);
        this.dynamoDbAsyncClient = new LocalDynamoDbAsyncClient(this.dynamoDbClient);
    }

    @Override
    public void dilateEventTimes(long ms) {
        this.dynamoDbStreamsClient.dilateEventTimes(ms);
    }

    @Override
    public void triggerShardRollovers() {
        this.dynamoDbStreamsClient.triggerShardRollovers();
    }

    @Override
    public DynamoDbClient dynamoDbClient() {
        return this.dynamoDbClient;
    }

    @Override
    public LocalDynamoDbAsyncClient dynamoDbAsyncClient() {
        return this.dynamoDbAsyncClient;
    }

    @Override
    public DynamoDbStreamsClient dynamoDbStreamsClient() {
        return this.dynamoDbStreamsClient;
    }

    @Override
    public DynamoDbStreamsAsyncClient dynamoDbStreamsAsyncClient() {
        return this.dynamoDbStreamsAsyncClient;
    }

    @Override
    public void shutdown() {
        logger.info("Shutting down");
        this.jobs.shutdown();
        this.dbAccess.close();
    }

    @Override
    public List<Runnable> shutdownNow() {
        logger.info("Shutting down now  ");
        List<Runnable> runnables = this.jobs.shutdownNow();
        this.dbAccess.close();
        return runnables;
    }
}

