/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.sshtunnel;

import com.google.common.annotations.VisibleForTesting;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperties;
import software.amazon.documentdb.jdbc.sshtunnel.DocumentDbSshTunnelServer;

public class DocumentDbSshTunnelClient
implements AutoCloseable {
    private final DocumentDbSshTunnelServer sshTunnelServer;
    private final AtomicBoolean closed;
    private final Object lock = new Object();

    public DocumentDbSshTunnelClient(@NonNull DocumentDbConnectionProperties properties) throws SQLException {
        DocumentDbSshTunnelClient.validateSshTunnelProperties(properties);
        this.sshTunnelServer = DocumentDbSshTunnelServer.builder(properties.getSshUser(), properties.getSshHostname(), properties.getSshPrivateKeyFile(), properties.getHostname()).sshPrivateKeyPassphrase(properties.getSshPrivateKeyPassphrase()).sshStrictHostKeyChecking(properties.getSshStrictHostKeyChecking()).sshKnownHostsFile(properties.getSshKnownHostsFile()).build();
        this.sshTunnelServer.addClient();
        this.closed = new AtomicBoolean(false);
    }

    private static void validateSshTunnelProperties(DocumentDbConnectionProperties properties) throws SQLException {
        if (DocumentDbConnectionProperties.isNullOrWhitespace(properties.getSshUser()) || DocumentDbConnectionProperties.isNullOrWhitespace(properties.getSshHostname()) || DocumentDbConnectionProperties.isNullOrWhitespace(properties.getSshPrivateKeyFile()) || DocumentDbConnectionProperties.isNullOrWhitespace(properties.getHostname())) {
            throw new IllegalArgumentException();
        }
        DocumentDbSshTunnelServer.validateSshPrivateKeyFile(properties);
        DocumentDbSshTunnelServer.getSshKnownHostsFilename(properties);
    }

    public int getServiceListeningPort() {
        return this.sshTunnelServer.getServiceListeningPort();
    }

    public boolean isServerAlive() {
        return this.getSshTunnelServer().isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed.get()) {
                return;
            }
            this.sshTunnelServer.removeClient();
            this.closed.set(true);
        }
    }

    @VisibleForTesting
    @NonNull DocumentDbSshTunnelServer getSshTunnelServer() {
        return this.sshTunnelServer;
    }
}

