/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.persist;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperties;
import software.amazon.documentdb.jdbc.metadata.DocumentDbMetadataColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchema;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaTable;
import software.amazon.documentdb.jdbc.persist.DocumentDbSchemaWriter;

public class DocumentDbSchemaReader
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentDbSchemaReader.class);
    private final DocumentDbConnectionProperties properties;
    private final MongoClient client;
    private final boolean closeClient;
    public static final String DEFAULT_SCHEMA_NAME = "_default";
    public static final String SCHEMA_COLLECTION = "_sqlSchemas";
    public static final String TABLE_SCHEMA_COLLECTION = "_sqlTableSchemas";
    static final CodecRegistry POJO_CODEC_REGISTRY = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().register(new Class[]{DocumentDbSchema.class, DocumentDbSchemaTable.class, DocumentDbSchemaColumn.class, DocumentDbMetadataColumn.class}).build()})});

    public DocumentDbSchemaReader(@NonNull DocumentDbConnectionProperties properties, MongoClient client) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.properties = properties;
        this.client = client != null ? client : properties.createMongoClient();
        this.closeClient = client == null;
    }

    public DocumentDbSchema read() {
        return this.read(DEFAULT_SCHEMA_NAME);
    }

    public List<DocumentDbSchema> list() throws SQLException {
        MongoDatabase database = this.client.getDatabase(this.properties.getDatabase());
        return DocumentDbSchemaReader.getAllSchema(database);
    }

    @Nullable
    public DocumentDbSchema read(@NonNull String schemaName) {
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        return this.read(schemaName, 0);
    }

    @Nullable
    public DocumentDbSchema read(@NonNull String schemaName, int schemaVersion) {
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        MongoDatabase database = DocumentDbSchemaWriter.getDatabase(this.client, this.properties.getDatabase());
        return DocumentDbSchemaReader.getSchema(schemaName, schemaVersion, database);
    }

    static DocumentDbSchema getSchema(String schemaName, int schemaVersion, MongoDatabase database) {
        MongoCollection schemasCollection = database.getCollection(SCHEMA_COLLECTION, DocumentDbSchema.class);
        try {
            return (DocumentDbSchema)schemasCollection.find(DocumentDbSchemaWriter.getSchemaFilter(schemaName, schemaVersion)).sort(Sorts.descending((String[])new String[]{"schemaVersion"})).first();
        }
        catch (MongoException e) {
            if (DocumentDbSchemaWriter.isAuthorizationFailure(e)) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                return null;
            }
            throw e;
        }
    }

    public DocumentDbSchemaTable readTable(@NonNull String schemaName, int schemaVersion, @NonNull String tableId) {
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        if (tableId == null) {
            throw new NullPointerException("tableId is marked non-null but is null");
        }
        MongoDatabase database = DocumentDbSchemaWriter.getDatabase(this.client, this.properties.getDatabase());
        MongoCollection tableSchemasCollection = database.getCollection(TABLE_SCHEMA_COLLECTION, DocumentDbSchemaTable.class);
        return (DocumentDbSchemaTable)tableSchemasCollection.find(DocumentDbSchemaWriter.getTableSchemaFilter(tableId)).first();
    }

    public Collection<DocumentDbSchemaTable> readTables(String schemaName, int schemaVersion, Set<String> tableIds) {
        MongoDatabase database = DocumentDbSchemaWriter.getDatabase(this.client, this.properties.getDatabase());
        MongoCollection tableSchemasCollection = database.getCollection(TABLE_SCHEMA_COLLECTION, DocumentDbSchemaTable.class).withCodecRegistry(POJO_CODEC_REGISTRY);
        List tableFilters = tableIds.stream().map(DocumentDbSchemaWriter::getTableSchemaFilter).collect(Collectors.toList());
        return StreamSupport.stream(tableSchemasCollection.find(Filters.or(tableFilters)).spliterator(), false).collect(Collectors.toList());
    }

    static List<DocumentDbSchema> getAllSchema(MongoDatabase database) {
        MongoCollection schemasCollection = database.getCollection(SCHEMA_COLLECTION, DocumentDbSchema.class).withCodecRegistry(POJO_CODEC_REGISTRY);
        try {
            ArrayList<DocumentDbSchema> schemas = new ArrayList<DocumentDbSchema>();
            schemasCollection.find().sort(Sorts.orderBy((Bson[])new Bson[]{Sorts.ascending((String[])new String[]{"schemaName"}), Sorts.ascending((String[])new String[]{"schemaVersion"})})).forEach(schemas::add);
            return schemas;
        }
        catch (MongoException e) {
            if (DocumentDbSchemaWriter.isAuthorizationFailure(e)) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                return new ArrayList<DocumentDbSchema>();
            }
            throw e;
        }
    }

    @Override
    public void close() {
        if (this.closeClient && this.client != null) {
            this.client.close();
        }
    }
}

