/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.BsonType;
import software.amazon.documentdb.jdbc.common.utilities.JdbcType;
import software.amazon.documentdb.jdbc.metadata.DocumentDbMetadataColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaTable;

public class DocumentDbTableSchemaGeneratorHelper {
    static final String EMPTY_STRING = "";
    static final int KEY_COLUMN_NONE = 0;
    private static final String PATH_SEPARATOR = ".";
    private static final String ID_FIELD_NAME = "_id";
    private static final int ID_PRIMARY_KEY_COLUMN = 1;
    private static final ImmutableMap<Map.Entry<JdbcType, BsonType>, JdbcType> PROMOTION_MAP = new ImmutableMap.Builder().put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.NULL, BsonType.BOOLEAN), (Object)JdbcType.BOOLEAN).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.NULL, BsonType.BINARY), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.NULL, BsonType.DATE_TIME), (Object)JdbcType.TIMESTAMP).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.NULL, BsonType.DECIMAL128), (Object)JdbcType.DECIMAL).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.NULL, BsonType.DOUBLE), (Object)JdbcType.DOUBLE).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.NULL, BsonType.INT32), (Object)JdbcType.INTEGER).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.NULL, BsonType.INT64), (Object)JdbcType.BIGINT).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.NULL, BsonType.TIMESTAMP), (Object)JdbcType.TIMESTAMP).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.NULL, BsonType.MAX_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.NULL, BsonType.MIN_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.NULL, BsonType.NULL), (Object)JdbcType.NULL).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.NULL, BsonType.OBJECT_ID), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.NULL, BsonType.STRING), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.NULL, BsonType.ARRAY), (Object)JdbcType.ARRAY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.NULL, BsonType.DOCUMENT), (Object)JdbcType.JAVA_OBJECT).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.ARRAY, BsonType.BOOLEAN), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.ARRAY, BsonType.BINARY), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.ARRAY, BsonType.DATE_TIME), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.ARRAY, BsonType.DECIMAL128), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.ARRAY, BsonType.DOUBLE), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.ARRAY, BsonType.INT32), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.ARRAY, BsonType.INT64), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.ARRAY, BsonType.TIMESTAMP), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.ARRAY, BsonType.MAX_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.ARRAY, BsonType.MIN_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.ARRAY, BsonType.NULL), (Object)JdbcType.ARRAY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.ARRAY, BsonType.OBJECT_ID), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.ARRAY, BsonType.STRING), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.ARRAY, BsonType.ARRAY), (Object)JdbcType.ARRAY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.ARRAY, BsonType.DOCUMENT), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.JAVA_OBJECT, BsonType.BOOLEAN), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.JAVA_OBJECT, BsonType.BINARY), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.JAVA_OBJECT, BsonType.DATE_TIME), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.JAVA_OBJECT, BsonType.DECIMAL128), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.JAVA_OBJECT, BsonType.DOUBLE), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.JAVA_OBJECT, BsonType.INT32), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.JAVA_OBJECT, BsonType.INT64), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.JAVA_OBJECT, BsonType.TIMESTAMP), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.JAVA_OBJECT, BsonType.MAX_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.JAVA_OBJECT, BsonType.MIN_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.JAVA_OBJECT, BsonType.NULL), (Object)JdbcType.JAVA_OBJECT).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.JAVA_OBJECT, BsonType.OBJECT_ID), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.JAVA_OBJECT, BsonType.STRING), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.JAVA_OBJECT, BsonType.ARRAY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.JAVA_OBJECT, BsonType.DOCUMENT), (Object)JdbcType.JAVA_OBJECT).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BOOLEAN, BsonType.BOOLEAN), (Object)JdbcType.BOOLEAN).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BOOLEAN, BsonType.BINARY), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BOOLEAN, BsonType.DATE_TIME), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BOOLEAN, BsonType.DECIMAL128), (Object)JdbcType.DECIMAL).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BOOLEAN, BsonType.DOUBLE), (Object)JdbcType.DOUBLE).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BOOLEAN, BsonType.INT32), (Object)JdbcType.INTEGER).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BOOLEAN, BsonType.INT64), (Object)JdbcType.BIGINT).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BOOLEAN, BsonType.TIMESTAMP), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BOOLEAN, BsonType.MAX_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BOOLEAN, BsonType.MIN_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BOOLEAN, BsonType.NULL), (Object)JdbcType.BOOLEAN).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BOOLEAN, BsonType.OBJECT_ID), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BOOLEAN, BsonType.STRING), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BOOLEAN, BsonType.ARRAY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BOOLEAN, BsonType.DOCUMENT), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BIGINT, BsonType.BOOLEAN), (Object)JdbcType.BIGINT).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BIGINT, BsonType.BINARY), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BIGINT, BsonType.DATE_TIME), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BIGINT, BsonType.DECIMAL128), (Object)JdbcType.DECIMAL).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BIGINT, BsonType.DOUBLE), (Object)JdbcType.DECIMAL).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BIGINT, BsonType.INT32), (Object)JdbcType.BIGINT).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BIGINT, BsonType.INT64), (Object)JdbcType.BIGINT).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BIGINT, BsonType.TIMESTAMP), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BIGINT, BsonType.MAX_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BIGINT, BsonType.MIN_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BIGINT, BsonType.NULL), (Object)JdbcType.BIGINT).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BIGINT, BsonType.OBJECT_ID), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BIGINT, BsonType.STRING), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BIGINT, BsonType.ARRAY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.BIGINT, BsonType.DOCUMENT), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DECIMAL, BsonType.BOOLEAN), (Object)JdbcType.DECIMAL).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DECIMAL, BsonType.BINARY), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DECIMAL, BsonType.DATE_TIME), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DECIMAL, BsonType.DECIMAL128), (Object)JdbcType.DECIMAL).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DECIMAL, BsonType.DOUBLE), (Object)JdbcType.DECIMAL).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DECIMAL, BsonType.INT32), (Object)JdbcType.DECIMAL).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DECIMAL, BsonType.INT64), (Object)JdbcType.DECIMAL).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DECIMAL, BsonType.TIMESTAMP), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DECIMAL, BsonType.MAX_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DECIMAL, BsonType.MIN_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DECIMAL, BsonType.NULL), (Object)JdbcType.DECIMAL).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DECIMAL, BsonType.OBJECT_ID), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DECIMAL, BsonType.STRING), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DECIMAL, BsonType.ARRAY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DECIMAL, BsonType.DOCUMENT), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DOUBLE, BsonType.BOOLEAN), (Object)JdbcType.DOUBLE).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DOUBLE, BsonType.BINARY), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DOUBLE, BsonType.DATE_TIME), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DOUBLE, BsonType.DECIMAL128), (Object)JdbcType.DECIMAL).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DOUBLE, BsonType.DOUBLE), (Object)JdbcType.DOUBLE).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DOUBLE, BsonType.INT32), (Object)JdbcType.DOUBLE).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DOUBLE, BsonType.INT64), (Object)JdbcType.DECIMAL).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DOUBLE, BsonType.TIMESTAMP), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DOUBLE, BsonType.MAX_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DOUBLE, BsonType.MIN_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DOUBLE, BsonType.NULL), (Object)JdbcType.DOUBLE).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DOUBLE, BsonType.OBJECT_ID), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DOUBLE, BsonType.STRING), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DOUBLE, BsonType.ARRAY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.DOUBLE, BsonType.DOCUMENT), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.INTEGER, BsonType.BOOLEAN), (Object)JdbcType.INTEGER).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.INTEGER, BsonType.BINARY), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.INTEGER, BsonType.DATE_TIME), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.INTEGER, BsonType.DECIMAL128), (Object)JdbcType.DECIMAL).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.INTEGER, BsonType.DOUBLE), (Object)JdbcType.DOUBLE).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.INTEGER, BsonType.INT32), (Object)JdbcType.INTEGER).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.INTEGER, BsonType.INT64), (Object)JdbcType.BIGINT).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.INTEGER, BsonType.TIMESTAMP), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.INTEGER, BsonType.MAX_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.INTEGER, BsonType.MIN_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.INTEGER, BsonType.NULL), (Object)JdbcType.INTEGER).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.INTEGER, BsonType.OBJECT_ID), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.INTEGER, BsonType.STRING), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.INTEGER, BsonType.ARRAY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.INTEGER, BsonType.DOCUMENT), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.TIMESTAMP, BsonType.BOOLEAN), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.TIMESTAMP, BsonType.BINARY), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.TIMESTAMP, BsonType.DATE_TIME), (Object)JdbcType.TIMESTAMP).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.TIMESTAMP, BsonType.DECIMAL128), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.TIMESTAMP, BsonType.DOUBLE), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.TIMESTAMP, BsonType.INT32), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.TIMESTAMP, BsonType.INT64), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.TIMESTAMP, BsonType.TIMESTAMP), (Object)JdbcType.TIMESTAMP).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.TIMESTAMP, BsonType.MAX_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.TIMESTAMP, BsonType.MIN_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.TIMESTAMP, BsonType.NULL), (Object)JdbcType.TIMESTAMP).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.TIMESTAMP, BsonType.OBJECT_ID), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.TIMESTAMP, BsonType.STRING), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.TIMESTAMP, BsonType.ARRAY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.TIMESTAMP, BsonType.DOCUMENT), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARBINARY, BsonType.BOOLEAN), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARBINARY, BsonType.BINARY), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARBINARY, BsonType.DATE_TIME), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARBINARY, BsonType.DECIMAL128), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARBINARY, BsonType.DOUBLE), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARBINARY, BsonType.INT32), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARBINARY, BsonType.INT64), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARBINARY, BsonType.TIMESTAMP), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARBINARY, BsonType.MAX_KEY), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARBINARY, BsonType.MIN_KEY), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARBINARY, BsonType.NULL), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARBINARY, BsonType.OBJECT_ID), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARBINARY, BsonType.STRING), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARBINARY, BsonType.ARRAY), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARBINARY, BsonType.DOCUMENT), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARCHAR, BsonType.BOOLEAN), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARCHAR, BsonType.BINARY), (Object)JdbcType.VARBINARY).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARCHAR, BsonType.DATE_TIME), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARCHAR, BsonType.DECIMAL128), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARCHAR, BsonType.DOUBLE), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARCHAR, BsonType.INT32), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARCHAR, BsonType.INT64), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARCHAR, BsonType.TIMESTAMP), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARCHAR, BsonType.MAX_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARCHAR, BsonType.MIN_KEY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARCHAR, BsonType.NULL), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARCHAR, BsonType.OBJECT_ID), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARCHAR, BsonType.STRING), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARCHAR, BsonType.ARRAY), (Object)JdbcType.VARCHAR).put(new AbstractMap.SimpleEntry<JdbcType, BsonType>(JdbcType.VARCHAR, BsonType.DOCUMENT), (Object)JdbcType.VARCHAR).build();

    public static String combinePath(String path, String fieldName) {
        boolean isPathEmpty = Strings.isNullOrEmpty((String)path);
        boolean isFieldNameEmpty = Strings.isNullOrEmpty((String)fieldName);
        String pathSeparator = !isPathEmpty && !isFieldNameEmpty ? PATH_SEPARATOR : EMPTY_STRING;
        String newPath = !isPathEmpty ? path : EMPTY_STRING;
        String newFieldName = !isFieldNameEmpty ? fieldName : EMPTY_STRING;
        return String.format("%s%s%s", newPath, pathSeparator, newFieldName);
    }

    @VisibleForTesting
    static JdbcType getPromotedSqlType(BsonType bsonType, JdbcType prevSqlType) {
        AbstractMap.SimpleEntry<JdbcType, BsonType> key = new AbstractMap.SimpleEntry<JdbcType, BsonType>(prevSqlType, bsonType);
        return (JdbcType)((Object)PROMOTION_MAP.getOrDefault(key, (Object)JdbcType.VARCHAR));
    }

    static boolean isIdField(String fieldName) {
        return ID_FIELD_NAME.equals(fieldName);
    }

    static void handleComplexScalarConflict(Map<String, DocumentDbSchemaTable> tableMap, String path, Map<String, DocumentDbSchemaColumn> columnMap) {
        tableMap.remove(path);
        columnMap.clear();
    }

    static JdbcType handleArrayLevelConflict(Map<String, DocumentDbSchemaColumn> columnMap, int level, JdbcType sqlType) {
        JdbcType newSqlType = sqlType;
        LinkedHashMap<String, DocumentDbSchemaColumn> origColumns = new LinkedHashMap<String, DocumentDbSchemaColumn>(columnMap);
        for (Map.Entry entry : origColumns.entrySet()) {
            DocumentDbMetadataColumn column = (DocumentDbMetadataColumn)entry.getValue();
            if (column.getArrayIndexLevel() == null || column.getArrayIndexLevel() <= level) continue;
            columnMap.remove(entry.getKey());
            newSqlType = DocumentDbTableSchemaGeneratorHelper.getPromotedSqlType(BsonType.STRING, newSqlType);
        }
        return newSqlType;
    }

    static int getPrimaryKeyColumn(boolean isPrimaryKey) {
        return isPrimaryKey ? 1 : 0;
    }

    static String getFieldNameIfIsPrimaryKey(String path, String fieldName, boolean isPrimaryKey, Map<String, String> columnNameMap) {
        return isPrimaryKey ? DocumentDbTableSchemaGeneratorHelper.toName(DocumentDbTableSchemaGeneratorHelper.combinePath(DocumentDbTableSchemaGeneratorHelper.getParentName(path), fieldName), columnNameMap) : fieldName;
    }

    static String getVirtualTableNameIfIsPrimaryKey(String fieldPath, JdbcType nextSqlType, boolean isPrimaryKey, String collectionName, Map<String, String> tableNameMap) {
        return !isPrimaryKey && (nextSqlType == JdbcType.ARRAY || nextSqlType == JdbcType.JAVA_OBJECT) ? DocumentDbTableSchemaGeneratorHelper.toName(DocumentDbTableSchemaGeneratorHelper.combinePath(collectionName, fieldPath), tableNameMap) : null;
    }

    static JdbcType getSqlTypeIfIsPrimaryKey(BsonType bsonType, JdbcType prevSqlType, boolean isPrimaryKey) {
        return isPrimaryKey && bsonType == BsonType.DOCUMENT ? JdbcType.VARCHAR : DocumentDbTableSchemaGeneratorHelper.getPromotedSqlType(bsonType, prevSqlType);
    }

    static JdbcType getPrevSqlTypeOrDefault(DocumentDbMetadataColumn prevMetadataColumn) {
        return prevMetadataColumn != null ? prevMetadataColumn.getSqlType() : JdbcType.NULL;
    }

    static boolean isComplexType(JdbcType sqlType) {
        return sqlType == JdbcType.JAVA_OBJECT || sqlType == JdbcType.ARRAY;
    }

    static void addToForeignKeysIfIsPrimary(List<DocumentDbMetadataColumn> foreignKeys, boolean isPrimaryKey, DocumentDbMetadataColumn metadataColumn) {
        if (isPrimaryKey) {
            foreignKeys.add(metadataColumn);
        }
    }

    static int getPrevIndexOrDefault(DocumentDbMetadataColumn prevMetadataColumn, int defaultValue) {
        return prevMetadataColumn != null ? prevMetadataColumn.getIndex() : defaultValue;
    }

    static void checkVirtualTablePrimaryKeys(Map<String, DocumentDbSchemaTable> tableMap, String path, LinkedHashMap<String, DocumentDbSchemaColumn> columnMap, Map<String, String> columnNameMap) {
        String primaryKeyColumnName = DocumentDbTableSchemaGeneratorHelper.toName(DocumentDbTableSchemaGeneratorHelper.combinePath(path, ID_FIELD_NAME), columnNameMap);
        DocumentDbMetadataColumn primaryKeyColumn = (DocumentDbMetadataColumn)columnMap.get(primaryKeyColumnName);
        for (DocumentDbSchemaTable table : tableMap.values()) {
            DocumentDbMetadataColumn column = (DocumentDbMetadataColumn)table.getColumnMap().get((Object)primaryKeyColumnName);
            if (column == null || column.getSqlType().equals((Object)primaryKeyColumn.getSqlType())) continue;
            column.setSqlType(primaryKeyColumn.getSqlType());
        }
    }

    @VisibleForTesting
    static String toName(String path, Map<String, String> uniqueNameMap) {
        return DocumentDbTableSchemaGeneratorHelper.toName(path, uniqueNameMap, 128);
    }

    @VisibleForTesting
    static String toName(String path, Map<String, String> uniqueNameMap, int identifierMaxLength) {
        String fullPathName = path.replaceAll("\\.", "_");
        if (uniqueNameMap.containsKey(path)) {
            return uniqueNameMap.get(path);
        }
        if (path.length() <= identifierMaxLength) {
            return fullPathName;
        }
        StringBuilder shortenedName = new StringBuilder(fullPathName);
        List<MatchResult> matches = DocumentDbTableSchemaGeneratorHelper.getSeparatorMatches(path);
        if (matches.isEmpty()) {
            DocumentDbTableSchemaGeneratorHelper.shortenBaseName(path, uniqueNameMap, identifierMaxLength, shortenedName);
        } else if (matches.get(0).start() < identifierMaxLength) {
            DocumentDbTableSchemaGeneratorHelper.shortenWithBaseNameLessThanMaxLength(path, uniqueNameMap, identifierMaxLength, shortenedName, matches);
        } else {
            DocumentDbTableSchemaGeneratorHelper.shortenWithBaseNameLongerThanMaxLength(path, uniqueNameMap, identifierMaxLength, shortenedName, matches);
        }
        return shortenedName.toString();
    }

    private static void shortenWithBaseNameLongerThanMaxLength(String path, Map<String, String> uniqueNameMap, int identifierMaxLength, StringBuilder shortenedName, List<MatchResult> matches) {
        int lastMatchIndex = 0;
        int matchIndex = matches.size() - 1;
        while (matchIndex > 0 && path.length() - matches.get(matchIndex).start() < identifierMaxLength) {
            lastMatchIndex = matchIndex--;
        }
        if (lastMatchIndex > 0) {
            shortenedName.delete(0, matches.get(lastMatchIndex).start());
        } else {
            shortenedName.delete(0, shortenedName.length() - identifierMaxLength);
        }
        DocumentDbTableSchemaGeneratorHelper.ensureUniqueName(uniqueNameMap, shortenedName, path);
    }

    private static void shortenWithBaseNameLessThanMaxLength(String path, Map<String, String> uniqueNameMap, int identifierMaxLength, StringBuilder shortenedName, List<MatchResult> matches) {
        int lastMatchIndex = 0;
        int matchIndex = matches.size() - 1;
        while (matchIndex > 0 && path.length() - matches.get(matchIndex).start() + matches.get(0).start() < identifierMaxLength) {
            lastMatchIndex = matchIndex--;
        }
        int deleteChars = lastMatchIndex > 0 ? matches.get(lastMatchIndex).start() - matches.get(0).start() : path.length() - identifierMaxLength;
        shortenedName.delete(matches.get(0).start(), matches.get(0).start() + deleteChars);
        DocumentDbTableSchemaGeneratorHelper.ensureUniqueName(uniqueNameMap, shortenedName, path);
    }

    private static void shortenBaseName(String path, Map<String, String> uniqueNameMap, int identifierMaxLength, StringBuilder shortenedName) {
        shortenedName.delete(identifierMaxLength, shortenedName.length());
        DocumentDbTableSchemaGeneratorHelper.ensureUniqueName(uniqueNameMap, shortenedName, path);
    }

    private static void ensureUniqueName(Map<String, String> uniqueNameMap, StringBuilder shortenedName, String path) {
        int counter = 0;
        StringBuilder tempName = new StringBuilder(shortenedName);
        while (uniqueNameMap.values().stream().anyMatch(s -> tempName.toString().equals(s))) {
            String counterString = String.valueOf(++counter);
            tempName.setLength(0);
            tempName.append(shortenedName.substring(0, shortenedName.length() - counterString.length())).append(counterString);
        }
        shortenedName.setLength(0);
        shortenedName.append((CharSequence)tempName);
        uniqueNameMap.put(path, shortenedName.toString());
    }

    private static List<MatchResult> getSeparatorMatches(String path) {
        ArrayList<MatchResult> matches = new ArrayList<MatchResult>();
        Pattern separatorPattern = Pattern.compile("\\.");
        Matcher separatorMatcher = separatorPattern.matcher(path);
        separatorMatcher.reset();
        while (separatorMatcher.find()) {
            matches.add(separatorMatcher.toMatchResult());
        }
        return matches;
    }

    private static String getParentName(String path) {
        return path.substring(path.lastIndexOf(46) + 1);
    }
}

