/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.common;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PooledConnection
implements javax.sql.PooledConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(PooledConnection.class);
    private final List<ConnectionEventListener> connectionEventListeners = new LinkedList<ConnectionEventListener>();
    private final Connection connection;

    public PooledConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public void close() {
        LOGGER.debug("Notify all connection listeners this PooledConnection object is closed.");
        ConnectionEvent event = new ConnectionEvent(this, null);
        this.connectionEventListeners.forEach(l -> l.connectionClosed(event));
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        LOGGER.debug("Add a ConnectionEventListener to this PooledConnection.");
        this.connectionEventListeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        LOGGER.debug("Remove the ConnectionEventListener attached to this PooledConnection.");
        this.connectionEventListeners.remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        LOGGER.debug("addStatementEventListener is called on the current PooledConnection object.");
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        LOGGER.debug("removeStatementEventListener is called on the current PooledConnection object.");
    }
}

