/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.calcite.adapter;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.util.Pair;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbTable;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaTable;

public interface DocumentDbRel
extends RelNode {
    public static final Convention CONVENTION = new Convention.Impl("MONGO", DocumentDbRel.class);

    public void implement(Implementor var1);

    public static class Implementor {
        private List<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        private final RexBuilder rexBuilder;
        private RelOptTable table;
        private DocumentDbSchemaTable metadataTable;
        private DocumentDbTable documentDbTable;
        private final List<String> unwinds = new ArrayList<String>();
        private final List<String> collisionResolutions = new ArrayList<String>();
        private String virtualTableFilter;
        private boolean nullFiltered = false;
        private boolean join = false;
        private boolean resolutionNeedsUnwind = false;
        private final Instant currentTime = Instant.now();

        public List<Pair<String, String>> getList() {
            return this.list;
        }

        public void setList(List<Pair<String, String>> list) {
            this.list = list;
        }

        public RexBuilder getRexBuilder() {
            return this.rexBuilder;
        }

        public RelOptTable getTable() {
            return this.table;
        }

        public void setTable(RelOptTable table) {
            this.table = table;
        }

        public void setDocumentDbTable(DocumentDbTable table) {
            this.documentDbTable = table;
        }

        public DocumentDbTable getDocumentDbTable() {
            return this.documentDbTable;
        }

        public DocumentDbSchemaTable getMetadataTable() {
            return this.metadataTable;
        }

        public void setMetadataTable(DocumentDbSchemaTable metadataTable) {
            this.metadataTable = metadataTable;
        }

        public Implementor(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public void add(String findOp, String aggOp) {
            this.list.add((Pair<String, String>)Pair.of((Object)findOp, (Object)aggOp));
        }

        public void add(int index, String findOp, String aggOp) {
            this.list.add(index, (Pair<String, String>)Pair.of((Object)findOp, (Object)aggOp));
        }

        public void addUnwind(String op) {
            this.unwinds.add(op);
        }

        public List<String> getUnwinds() {
            return this.unwinds;
        }

        public void setVirtualTableFilter(String op) {
            this.virtualTableFilter = op;
        }

        public String getVirtualTableFilter() {
            return this.virtualTableFilter;
        }

        public void addCollisionResolution(String op) {
            this.collisionResolutions.add(op);
        }

        public List<String> getCollisionResolutions() {
            return this.collisionResolutions;
        }

        public void setResolutionNeedsUnwind(boolean resolutionNeedsUnwind) {
            this.resolutionNeedsUnwind = resolutionNeedsUnwind;
        }

        public boolean isResolutionNeedsUnwind() {
            return this.resolutionNeedsUnwind;
        }

        public boolean isNullFiltered() {
            return this.nullFiltered;
        }

        public void setNullFiltered(boolean nullFiltered) {
            this.nullFiltered = nullFiltered;
        }

        public boolean isJoin() {
            return this.join;
        }

        public void setJoin(boolean join) {
            this.join = join;
        }

        public void visitChild(int ordinal, RelNode input) {
            assert (ordinal == 0);
            boolean isJoin = this.isJoin();
            ((DocumentDbRel)input).implement(this);
            this.setJoin(isJoin);
        }

        public Instant getCurrentTime() {
            return this.currentTime;
        }
    }
}

