/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.DocumentDbConnection;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperties;
import software.amazon.documentdb.jdbc.DocumentDbDatabaseMetaDataResultSets;
import software.amazon.documentdb.jdbc.DocumentDbDriver;
import software.amazon.documentdb.jdbc.DocumentDbListResultSet;
import software.amazon.documentdb.jdbc.common.DatabaseMetaData;
import software.amazon.documentdb.jdbc.common.utilities.JdbcType;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;
import software.amazon.documentdb.jdbc.metadata.DocumentDbDatabaseSchemaMetadata;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaTable;

public class DocumentDbDatabaseMetaData
extends DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private static final Map<JdbcType, Integer> TYPE_COLUMN_SIZE_MAP;
    private static final Logger LOGGER;
    private static final char ESCAPE_CHAR = '\\';
    private final DocumentDbDatabaseSchemaMetadata databaseMetadata;
    private final DocumentDbConnectionProperties properties;

    DocumentDbDatabaseMetaData(DocumentDbConnection connection, DocumentDbDatabaseSchemaMetadata databaseMetadata, DocumentDbConnectionProperties properties) {
        super(connection);
        this.databaseMetadata = databaseMetadata;
        this.properties = properties;
    }

    @Override
    public String getURL() {
        return "jdbc:documentdb:" + this.properties.buildSanitizedConnectionString();
    }

    @Override
    public String getUserName() {
        return this.properties.getUser();
    }

    @Override
    public String getDatabaseProductName() {
        return "DocumentDB";
    }

    @Override
    public String getDatabaseProductVersion() {
        return "4.0";
    }

    @Override
    public String getDriverName() {
        return "DocumentDB JDBC Driver";
    }

    @Override
    public int getDriverMajorVersion() {
        return DocumentDbDriver.DRIVER_MAJOR_VERSION;
    }

    @Override
    public int getDriverMinorVersion() {
        return DocumentDbDriver.DRIVER_MINOR_VERSION;
    }

    @Override
    public String getDriverVersion() {
        return DocumentDbDriver.DRIVER_VERSION;
    }

    @Override
    public String getSQLKeywords() {
        return "";
    }

    @Override
    public String getNumericFunctions() {
        return "";
    }

    @Override
    public String getStringFunctions() {
        return "";
    }

    @Override
    public String getSystemFunctions() {
        return "";
    }

    @Override
    public String getTimeDateFunctions() {
        return "";
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public String getCatalogTerm() {
        return "catalog";
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) {
        ArrayList<List<Object>> metaData = new ArrayList<List<Object>>();
        return new DocumentDbListResultSet(null, DocumentDbDatabaseMetaDataResultSets.buildProceduresColumnMetaData(this.properties.getDatabase()), metaData);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) {
        ArrayList<List<Object>> metaData = new ArrayList<List<Object>>();
        if (DocumentDbConnectionProperties.isNullOrWhitespace(catalog) && (types == null || types.length == 0 || Arrays.stream(types).anyMatch(s -> DocumentDbConnectionProperties.isNullOrWhitespace(s) || s.equals("TABLE"))) && (schemaPattern == null || this.properties.getDatabase().matches(DocumentDbDatabaseMetaData.convertPatternToRegex(schemaPattern)))) {
            this.addTablesForSchema(tableNamePattern, metaData);
        }
        return new DocumentDbListResultSet(null, DocumentDbDatabaseMetaDataResultSets.buildTablesColumnMetaData(this.properties.getDatabase()), metaData);
    }

    private void addTablesForSchema(String tableNamePattern, List<List<Object>> metaData) {
        String regexTableNamePattern = DocumentDbDatabaseMetaData.convertPatternToRegex(tableNamePattern);
        for (String tableName : this.databaseMetadata.getTableSchemaMap().keySet()) {
            if (!tableName.matches(regexTableNamePattern)) continue;
            this.addTableEntry(metaData, tableName);
        }
    }

    private void addTableEntry(List<List<Object>> metaData, String tableName) {
        ArrayList<String> row = new ArrayList<String>(Arrays.asList(null, this.properties.getDatabase(), tableName, "TABLE", null, null, null, null, null, null));
        metaData.add(row);
    }

    @Override
    public ResultSet getSchemas() {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() {
        ArrayList<List<Object>> metaData = new ArrayList<List<Object>>();
        return new DocumentDbListResultSet(null, DocumentDbDatabaseMetaDataResultSets.buildCatalogsColumnMetaData(this.properties.getDatabase()), metaData);
    }

    @Override
    public ResultSet getTableTypes() {
        ArrayList<List<Object>> metaData = new ArrayList<List<Object>>();
        for (String tableType : Arrays.asList("TABLE")) {
            metaData.add(Collections.singletonList(tableType));
        }
        return new DocumentDbListResultSet(null, DocumentDbDatabaseMetaDataResultSets.buildTableTypesColumnMetaData(this.properties.getDatabase()), metaData);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ArrayList<List<Object>> metaData = new ArrayList<List<Object>>();
        if (DocumentDbConnectionProperties.isNullOrWhitespace(catalog) && (schemaPattern == null || this.properties.getDatabase().matches(DocumentDbDatabaseMetaData.convertPatternToRegex(schemaPattern)))) {
            this.addColumnsForSchema(tableNamePattern, columnNamePattern, metaData);
        }
        return new DocumentDbListResultSet(null, DocumentDbDatabaseMetaDataResultSets.buildColumnsColumnMetaData(this.properties.getDatabase()), metaData);
    }

    private void addColumnsForSchema(String tableNamePattern, String columnNamePattern, List<List<Object>> metaData) throws SQLException {
        if ("%".equals(tableNamePattern)) {
            for (DocumentDbSchemaTable table : this.databaseMetadata.getTableSchemaMap().values()) {
                this.addColumnsForTable(columnNamePattern, metaData, table);
            }
        } else {
            String regexTableNamePattern = DocumentDbDatabaseMetaData.convertPatternToRegex(tableNamePattern);
            for (String tableName : this.databaseMetadata.getTableSchemaMap().keySet()) {
                if (!tableName.matches(regexTableNamePattern)) continue;
                DocumentDbSchemaTable table = this.databaseMetadata.getTableSchemaMap().get(tableName);
                if (table == null) {
                    throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.INCONSISTENT_SCHEMA, tableName);
                }
                this.addColumnsForTable(columnNamePattern, metaData, table);
            }
        }
    }

    private void addColumnsForTable(String columnNamePattern, List<List<Object>> metaData, DocumentDbSchemaTable table) {
        String regexColumnPattern = DocumentDbDatabaseMetaData.convertPatternToRegex(columnNamePattern);
        for (DocumentDbSchemaColumn column : table.getColumnMap().values()) {
            if (!column.getSqlName().matches(regexColumnPattern)) continue;
            this.addColumnEntry(metaData, table, column);
        }
    }

    private void addColumnEntry(List<List<Object>> metaData, DocumentDbSchemaTable table, DocumentDbSchemaColumn column) {
        if (column.getSqlType() == JdbcType.JAVA_OBJECT || column.getSqlType() == JdbcType.ARRAY) {
            return;
        }
        ArrayList<Serializable> row = new ArrayList<Serializable>(Arrays.asList(null, this.properties.getDatabase(), table.getSqlName(), column.getSqlName(), column.getSqlType().getJdbcType(), column.getSqlType().name(), TYPE_COLUMN_SIZE_MAP.get((Object)column.getSqlType()), null, null, null, column.isPrimaryKey() ? 0 : 1, null, null, null, null, DocumentDbDatabaseMetaData.getCharOctetLength(column), column.getIndex(table).orElse(null), column.isPrimaryKey() ? "NO" : "YES", null, null, null, null, "NO", column.isIndex() ? "YES" : "NO"));
        metaData.add(row);
    }

    private static Integer getCharOctetLength(DocumentDbSchemaColumn column) {
        switch (column.getSqlType()) {
            case VARCHAR: 
            case CHAR: 
            case NCHAR: 
            case NVARCHAR: 
            case LONGVARCHAR: 
            case LONGNVARCHAR: {
                return TYPE_COLUMN_SIZE_MAP.get((Object)column.getSqlType()) * 4;
            }
            case VARBINARY: 
            case BINARY: 
            case LONGVARBINARY: {
                return TYPE_COLUMN_SIZE_MAP.get((Object)column.getSqlType());
            }
        }
        return null;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) {
        ArrayList<List<Object>> metaData = new ArrayList<List<Object>>();
        return new DocumentDbListResultSet(null, DocumentDbDatabaseMetaDataResultSets.buildColumnPrivilegesColumnMetaData(this.properties.getDatabase()), metaData);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        ArrayList<List<Object>> metaData = new ArrayList<List<Object>>();
        if (schema == null || this.properties.getDatabase().equals(schema)) {
            for (String tableName : this.databaseMetadata.getTableSchemaMap().keySet()) {
                if (!tableName.equals(table)) continue;
                DocumentDbSchemaTable metadataTable = this.databaseMetadata.getTableSchemaMap().get(tableName);
                if (metadataTable == null) {
                    throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.INCONSISTENT_SCHEMA, tableName);
                }
                for (DocumentDbSchemaColumn column : metadataTable.getColumnMap().values()) {
                    if (!column.isPrimaryKey()) continue;
                    ArrayList<Serializable> row = new ArrayList<Serializable>(Arrays.asList(null, this.properties.getDatabase(), metadataTable.getSqlName(), column.getSqlName(), column.getPrimaryKeyIndex(metadataTable).orElse(0), null));
                    metaData.add(row);
                }
            }
        }
        return new DocumentDbListResultSet(null, DocumentDbDatabaseMetaDataResultSets.buildPrimaryKeysColumnMetaData(this.properties.getDatabase()), metaData);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        ArrayList<List<Object>> metaData = new ArrayList<List<Object>>();
        if (DocumentDbConnectionProperties.isNullOrWhitespace(catalog) && (schema == null || this.properties.getDatabase().equals(schema))) {
            this.addImportedKeysForSchema(table, metaData);
        }
        return new DocumentDbListResultSet(null, DocumentDbDatabaseMetaDataResultSets.buildImportedKeysColumnMetaData(this.properties.getDatabase()), metaData);
    }

    private void addImportedKeysForSchema(String table, List<List<Object>> metaData) throws SQLException {
        String regexTablePattern = DocumentDbDatabaseMetaData.convertPatternToRegex(table);
        for (String tableName : this.databaseMetadata.getTableSchemaMap().keySet()) {
            if (!tableName.matches(regexTablePattern)) continue;
            DocumentDbSchemaTable schemaTable = this.databaseMetadata.getTableSchemaMap().get(tableName);
            if (schemaTable == null) {
                throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.INCONSISTENT_SCHEMA, tableName);
            }
            this.addImportedKeysForTable(metaData, schemaTable, schemaTable);
        }
    }

    private void addImportedKeysForTable(List<List<Object>> metaData, DocumentDbSchemaTable schemaTable, DocumentDbSchemaTable metadataTable) {
        for (DocumentDbSchemaColumn column : metadataTable.getColumnMap().values()) {
            this.addImportedKey(metaData, schemaTable, column);
        }
    }

    private void addImportedKey(List<List<Object>> metaData, DocumentDbSchemaTable schemaTable, DocumentDbSchemaColumn column) {
        if (column.getForeignKeyTableName() != null && schemaTable != null) {
            ArrayList<Serializable> row = new ArrayList<Serializable>(Arrays.asList(null, this.properties.getDatabase(), column.getForeignKeyTableName(), column.getForeignKeyColumnName(), null, this.properties.getDatabase(), schemaTable.getSqlName(), column.getSqlName(), metaData.size() + 1, 3, 3, null, null, 5));
            metaData.add(row);
        }
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) {
        ArrayList<List<Object>> metaData = new ArrayList<List<Object>>();
        return new DocumentDbListResultSet(null, DocumentDbDatabaseMetaDataResultSets.buildAttributesColumnMetaData(this.properties.getDatabase()), metaData);
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 2;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) {
        ArrayList<List<Object>> metaData = new ArrayList<List<Object>>();
        if (DocumentDbConnectionProperties.isNullOrWhitespace(catalog) && (DocumentDbConnectionProperties.isNullOrWhitespace(schemaPattern) || this.properties.getDatabase().matches(DocumentDbDatabaseMetaData.convertPatternToRegex(schemaPattern)))) {
            ArrayList<String> row = new ArrayList<String>(Arrays.asList(this.properties.getDatabase(), null));
            metaData.add(row);
        }
        return new DocumentDbListResultSet(null, DocumentDbDatabaseMetaDataResultSets.buildSchemasColumnMetaData(this.properties.getDatabase()), metaData);
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return true;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @VisibleForTesting
    static String convertPatternToRegex(String pattern) {
        if (DocumentDbConnectionProperties.isNullOrWhitespace(pattern)) {
            return "";
        }
        StringBuilder converted = new StringBuilder();
        boolean escapeFound = false;
        int start = 0;
        for (int index = 0; index < pattern.length(); ++index) {
            char currChar = pattern.charAt(index);
            if (currChar == '\\') {
                if (escapeFound) {
                    start = DocumentDbDatabaseMetaData.updateRegexExpression(index - 1, start, pattern, "[\\]", converted) + 1;
                }
                escapeFound = !escapeFound;
                continue;
            }
            if (escapeFound) {
                start = DocumentDbDatabaseMetaData.updateRegexExpression(index - 1, start, pattern, "[" + currChar + "]", converted) + 1;
                escapeFound = false;
                continue;
            }
            if (currChar == '_') {
                start = DocumentDbDatabaseMetaData.updateRegexExpression(index, start, pattern, ".", converted);
                continue;
            }
            if (currChar != '%') continue;
            start = DocumentDbDatabaseMetaData.updateRegexExpression(index, start, pattern, ".*", converted);
        }
        if (pattern.length() - start > 0) {
            converted.append(Pattern.quote(pattern.substring(start)));
        }
        return converted.toString();
    }

    private static int updateRegexExpression(int index, int start, String pattern, String str, StringBuilder converted) {
        if (index - start > 0) {
            converted.append(Pattern.quote(pattern.substring(start, index)));
        }
        converted.append(str);
        int newStart = index + 1;
        return newStart;
    }

    static {
        LOGGER = LoggerFactory.getLogger(DocumentDbDatabaseMetaData.class);
        TYPE_COLUMN_SIZE_MAP = new HashMap<JdbcType, Integer>();
        block9: for (JdbcType jdbcType : JdbcType.values()) {
            switch (jdbcType) {
                case DECIMAL: 
                case NUMERIC: {
                    TYPE_COLUMN_SIZE_MAP.put(jdbcType, 646456995);
                    continue block9;
                }
                case FLOAT: 
                case REAL: 
                case DOUBLE: {
                    TYPE_COLUMN_SIZE_MAP.put(jdbcType, 23);
                    continue block9;
                }
                case BIGINT: {
                    TYPE_COLUMN_SIZE_MAP.put(jdbcType, 20);
                    continue block9;
                }
                case INTEGER: {
                    TYPE_COLUMN_SIZE_MAP.put(jdbcType, 11);
                    continue block9;
                }
                case SMALLINT: {
                    TYPE_COLUMN_SIZE_MAP.put(jdbcType, 6);
                    continue block9;
                }
                case TINYINT: {
                    TYPE_COLUMN_SIZE_MAP.put(jdbcType, 4);
                    continue block9;
                }
                case VARBINARY: 
                case VARCHAR: {
                    TYPE_COLUMN_SIZE_MAP.put(jdbcType, 65536);
                    continue block9;
                }
                default: {
                    TYPE_COLUMN_SIZE_MAP.put(jdbcType, 0);
                }
            }
        }
    }
}

