/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.metadata;

import com.mongodb.client.MongoClient;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperties;
import software.amazon.documentdb.jdbc.metadata.DocumentDbMetadataService;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchema;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaTable;
import software.amazon.documentdb.jdbc.persist.DocumentDbSchemaSecurityException;

public final class DocumentDbDatabaseSchemaMetadata {
    public static final int VERSION_LATEST_OR_NEW = 0;
    public static final int VERSION_NEW = -1;
    public static final int VERSION_LATEST_OR_NONE = -2;
    private final DocumentDbSchema schema;

    public String getSchemaName() {
        return this.schema.getSchemaName();
    }

    public int getSchemaVersion() {
        return this.schema.getSchemaVersion();
    }

    public Map<String, DocumentDbSchemaTable> getTableSchemaMap() {
        return this.schema.getTableMap();
    }

    protected DocumentDbDatabaseSchemaMetadata(DocumentDbSchema schema) {
        this.schema = schema;
    }

    public static DocumentDbDatabaseSchemaMetadata get(DocumentDbConnectionProperties properties, String schemaName, MongoClient client) throws SQLException {
        return DocumentDbDatabaseSchemaMetadata.get(properties, schemaName, 0, client);
    }

    public static DocumentDbDatabaseSchemaMetadata get(DocumentDbConnectionProperties properties, String schemaName, int schemaVersion, MongoClient client) throws SQLException {
        DocumentDbDatabaseSchemaMetadata databaseMetadata;
        DocumentDbSchema schema = DocumentDbMetadataService.get(properties, schemaName, schemaVersion, client);
        if (schema != null) {
            DocumentDbDatabaseSchemaMetadata.setSchemaGetTableFunction(properties, schemaName, schemaVersion, schema, client);
            databaseMetadata = new DocumentDbDatabaseSchemaMetadata(schema);
        } else {
            databaseMetadata = null;
        }
        return databaseMetadata;
    }

    public static void remove(DocumentDbConnectionProperties properties, String schemaName, MongoClient client) throws SQLException {
        DocumentDbMetadataService.remove(properties, schemaName, client);
    }

    public static void remove(DocumentDbConnectionProperties properties, String schemaName, int schemaVersion, MongoClient client) throws SQLException {
        DocumentDbMetadataService.remove(properties, schemaName, schemaVersion, client);
    }

    public static List<DocumentDbSchema> getSchemaList(DocumentDbConnectionProperties properties, MongoClient client) throws SQLException {
        List<DocumentDbSchema> schemas = DocumentDbMetadataService.getSchemaList(properties, client);
        schemas.forEach(schema -> DocumentDbDatabaseSchemaMetadata.setSchemaGetTableFunction(properties, schema.getSchemaName(), schema.getSchemaVersion(), schema, client));
        return schemas;
    }

    public static void update(DocumentDbConnectionProperties properties, String schemaName, Collection<DocumentDbSchemaTable> schemaTables, MongoClient client) throws SQLException, DocumentDbSchemaSecurityException {
        DocumentDbMetadataService.update(properties, schemaName, schemaTables, client);
    }

    private static void setSchemaGetTableFunction(DocumentDbConnectionProperties properties, String schemaName, int schemaVersion, DocumentDbSchema schema, MongoClient client) {
        schema.setGetTableFunction(tableId -> DocumentDbMetadataService.getTable(properties, schemaName, schemaVersion, tableId, client), remainingTableIds -> DocumentDbMetadataService.getTables(properties, schemaName, schemaVersion, remainingTableIds, client));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentDbDatabaseSchemaMetadata)) {
            return false;
        }
        DocumentDbDatabaseSchemaMetadata metadata = (DocumentDbDatabaseSchemaMetadata)o;
        return this.schema.equals(metadata.schema);
    }

    public int hashCode() {
        return Objects.hash(this.schema);
    }
}

