/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.interception;

import java.util.concurrent.atomic.AtomicInteger;

public class MethodInterceptionCounter {
    private final ThreadLocal<AtomicInteger> localReferenceCounter = ThreadLocal.withInitial(() -> new AtomicInteger(0));

    public void increment() {
        if (this.getReferenceCounter() == null) {
            this.clear();
        }
        this.getReferenceCounter().getAndIncrement();
    }

    public void decrement() {
        if (this.getReferenceCounter() == null) {
            this.clear();
        } else if (this.getReferenceCounter().decrementAndGet() <= 0) {
            this.clear();
        }
    }

    public boolean hasIntercepted() {
        if (this.getReferenceCounter() == null) {
            this.clear();
            return false;
        }
        return this.getReferenceCounter().get() > 0;
    }

    AtomicInteger getReferenceCounter() {
        return this.localReferenceCounter.get();
    }

    private void clear() {
        this.localReferenceCounter.remove();
    }
}

