/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.interception.templates;

import java.lang.reflect.Method;
import java.util.Deque;
import java.util.LinkedList;
import java.util.StringTokenizer;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.interception.annotations.DataAccessPath;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.AgentBuilder;
import software.amazon.disco.agent.jar.bytebuddy.asm.Advice;
import software.amazon.disco.agent.jar.bytebuddy.description.method.MethodDescription;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.dynamic.DynamicType;
import software.amazon.disco.agent.jar.bytebuddy.implementation.MethodCall;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatcher;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatchers;

public class DataAccessor
implements Installable {
    final ElementMatcher<TypeDescription> typeImplementingAccessor;
    final ElementMatcher<TypeDescription> typesImplementingAccessMethods;
    final Class<?> accessor;

    protected DataAccessor(ElementMatcher<TypeDescription> typeImplementingAccessor, ElementMatcher<TypeDescription> typesImplementingAccessMethods, Class<?> accessor) {
        if (!accessor.isInterface()) {
            throw new IllegalArgumentException();
        }
        this.typeImplementingAccessor = typeImplementingAccessor;
        this.typesImplementingAccessMethods = typesImplementingAccessMethods;
        this.accessor = accessor;
    }

    public static DataAccessor forClassNamed(String className, Class<?> accessor) {
        ElementMatcher.Junction<TypeDescription> typeMatcher = ElementMatchers.named(className);
        return new DataAccessor(typeMatcher, typeMatcher, accessor);
    }

    public static DataAccessor forConcreteSubclassesOfInterface(String interfaceName, Class<?> accessor) {
        ElementMatcher.Junction<TypeDescription> typeMatcher = ElementMatchers.named(interfaceName).and(ElementMatchers.isInterface());
        return new DataAccessor(typeMatcher, ElementMatchers.hasSuperType(typeMatcher).and(ElementMatchers.not(ElementMatchers.isAbstract())), accessor);
    }

    @Override
    public AgentBuilder install(AgentBuilder agentBuilder) {
        agentBuilder = agentBuilder.type(this.typeImplementingAccessor).transform((builder, typeDescription, classLoader, module) -> builder.implement(this.accessor));
        agentBuilder = agentBuilder.type(this.typesImplementingAccessMethods).transform((builder, typeDescription, classLoader, module) -> {
            for (Method method : this.accessor.getDeclaredMethods()) {
                builder = DataAccessor.processAccessorMethod(builder, method);
            }
            return builder;
        });
        return agentBuilder;
    }

    static DynamicType.Builder<?> processAccessorMethod(DynamicType.Builder<?> builder, Method method) {
        if (method.isAnnotationPresent(DataAccessPath.class)) {
            DataAccessPath dap = method.getAnnotation(DataAccessPath.class);
            builder = builder.define(method).intercept(Advice.to(ExceptionSafety.class).wrap(DataAccessor.chainMethodCall(method, DataAccessor.produceCallChain(dap.value()))));
        }
        return builder;
    }

    static Deque<String> produceCallChain(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        LinkedList<String> callChain = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            String call = tokenizer.nextToken();
            callChain.push(call);
        }
        return callChain;
    }

    static MethodCall chainMethodCall(Method accessorMethod, Deque<String> callChain) {
        String callString = callChain.removeLast();
        MethodCall next = DataAccessor.produceNextMethodCall(null, accessorMethod, callString);
        while (!callChain.isEmpty()) {
            callString = callChain.removeLast();
            next = DataAccessor.produceNextMethodCall(next, accessorMethod, callString);
        }
        return next;
    }

    static MethodCall produceNextMethodCall(MethodCall previous, Method accessorMethod, String callString) {
        String call = callString.substring(0, callString.indexOf(40));
        StringTokenizer tokenizer = new StringTokenizer(callString.substring(callString.indexOf(40)), "(),");
        int[] params = new int[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            params[index++] = Integer.parseInt(token);
        }
        MethodCall.WithoutSpecifiedTarget methodCallWithout = MethodCall.invoke(DataAccessor.createParameterizedAccessMethodMatcher(call, accessorMethod, params));
        MethodCall methodCall = methodCallWithout;
        if (previous != null) {
            methodCall = methodCallWithout.onMethodCall(previous);
        }
        if (params.length > 0) {
            methodCall = methodCall.withArgument(params);
        }
        return methodCall;
    }

    static ElementMatcher<? super MethodDescription> createParameterizedAccessMethodMatcher(String methodName, Method accessorMethod, int[] params) {
        ElementMatcher.Junction methodDescriptionElementMatcher = ElementMatchers.named(methodName).and(ElementMatchers.takesArguments(params.length));
        int index = 0;
        for (int param : params) {
            methodDescriptionElementMatcher = methodDescriptionElementMatcher.and(ElementMatchers.takesArgument(index++, accessorMethod.getParameterTypes()[param]));
        }
        return methodDescriptionElementMatcher;
    }

    public static class ExceptionSafety {
        @Advice.OnMethodExit(onThrowable=Throwable.class)
        public static void onMethodExit(@Advice.Thrown(readOnly=false) Throwable thrown) {
            thrown = null;
        }
    }
}

