/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.web.apache.httpclient;

import java.util.concurrent.Callable;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import software.amazon.disco.agent.event.Event;
import software.amazon.disco.agent.event.EventBus;
import software.amazon.disco.agent.event.HttpServiceDownstreamRequestEvent;
import software.amazon.disco.agent.event.ServiceDownstreamRequestEvent;
import software.amazon.disco.agent.event.ServiceDownstreamResponseEvent;
import software.amazon.disco.agent.interception.MethodInterceptionCounter;
import software.amazon.disco.agent.jar.bytebuddy.implementation.bind.annotation.AllArguments;
import software.amazon.disco.agent.jar.bytebuddy.implementation.bind.annotation.Origin;
import software.amazon.disco.agent.jar.bytebuddy.implementation.bind.annotation.RuntimeType;
import software.amazon.disco.agent.jar.bytebuddy.implementation.bind.annotation.SuperCall;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.agent.web.apache.event.ApacheEventFactory;
import software.amazon.disco.agent.web.apache.httpclient.ApacheHttpClientInterceptor;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApacheHttpClientMethodDelegation {
    private static final Logger log = LogManager.getLogger(ApacheHttpClientInterceptor.class);
    private static final MethodInterceptionCounter METHOD_INTERCEPTION_COUNTER = new MethodInterceptionCounter();
    static final String APACHE_HTTP_CLIENT_ORIGIN = "ApacheHttpClient";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RuntimeType
    public static Object intercept(@AllArguments Object[] args, @Origin String origin, @SuperCall Callable<Object> zuper) throws Throwable {
        if (LogManager.isDebugEnabled()) {
            log.debug("DiSCo(Web) interception of " + origin);
        }
        if (METHOD_INTERCEPTION_COUNTER.hasIntercepted()) {
            return ApacheHttpClientMethodDelegation.call(zuper);
        }
        HttpRequest httpRequest = ApacheHttpClientMethodDelegation.findRequestObject((Object[])args);
        HttpServiceDownstreamRequestEvent requestEvent = ApacheHttpClientMethodDelegation.publishRequestEvent((HttpRequest)httpRequest);
        Throwable throwable = null;
        Object response = null;
        try {
            response = ApacheHttpClientMethodDelegation.call(zuper);
            return response;
        }
        catch (Throwable t) {
            throwable = t;
            return throwable;
        }
        finally {
            HttpResponse httpResponse = null;
            if (response instanceof HttpResponse) {
                httpResponse = (HttpResponse)response;
            }
            ApacheHttpClientMethodDelegation.publishResponseEvent((HttpResponse)httpResponse, (ServiceDownstreamRequestEvent)requestEvent, (Throwable)throwable);
            if (throwable != null) {
                throw throwable;
            }
            return response;
        }
    }

    private static HttpRequest findRequestObject(Object[] args) {
        for (Object arg : args) {
            if (!HttpRequest.class.isAssignableFrom(arg.getClass())) continue;
            return (HttpRequest)arg;
        }
        return null;
    }

    private static Object call(Callable<Object> zuper) throws Throwable {
        try {
            METHOD_INTERCEPTION_COUNTER.increment();
            Object object = zuper.call();
            return object;
        }
        finally {
            METHOD_INTERCEPTION_COUNTER.decrement();
        }
    }

    private static HttpServiceDownstreamRequestEvent publishRequestEvent(HttpRequest request) {
        HttpServiceDownstreamRequestEvent requestEvent = ApacheEventFactory.createDownstreamRequestEvent((String)"ApacheHttpClient", (HttpRequest)request);
        EventBus.publish((Event)requestEvent);
        return requestEvent;
    }

    private static void publishResponseEvent(HttpResponse response, ServiceDownstreamRequestEvent requestEvent, Throwable throwable) {
        ServiceDownstreamResponseEvent responseEvent = ApacheEventFactory.createServiceResponseEvent((HttpResponse)response, (ServiceDownstreamRequestEvent)requestEvent, (Throwable)throwable);
        EventBus.publish((Event)responseEvent);
    }
}

