/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.coroutines;

import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.ThreadContextElement;
import kotlinx.coroutines.ThreadContextElementKt;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.concurrent.TransactionContext;
import software.amazon.disco.agent.interception.Installable;

public class BuildersKtCoroutineInterceptor
implements Installable {
    public AgentBuilder install(AgentBuilder agentBuilder) {
        return agentBuilder.type(BuildersKtCoroutineInterceptor.buildBuilderKtClassTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.method(this.createAsyncMethodMatcher()).intercept((Implementation)Advice.to(AsyncAdvice.class)).method(this.createRunBlockingMethodMatcher()).intercept((Implementation)Advice.to(RunBlockingAdvice.class)).method(this.createLaunchMethodMatcher()).intercept((Implementation)Advice.to(LaunchAdvice.class)));
    }

    static ElementMatcher<TypeDescription> buildBuilderKtClassTypeMatcher() {
        return ElementMatchers.named((String)"kotlinx.coroutines.BuildersKt");
    }

    public ElementMatcher.Junction<? super MethodDescription> createAsyncMethodMatcher() {
        return ElementMatchers.named((String)"async").or((ElementMatcher)ElementMatchers.named((String)"async$default")).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"kotlin.coroutines.CoroutineContext")));
    }

    public ElementMatcher.Junction<? super MethodDescription> createRunBlockingMethodMatcher() {
        return ElementMatchers.named((String)"runBlocking").or((ElementMatcher)ElementMatchers.named((String)"runBlocking$default")).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"kotlin.coroutines.CoroutineContext")));
    }

    public ElementMatcher.Junction<? super MethodDescription> createLaunchMethodMatcher() {
        return ElementMatchers.named((String)"launch").or((ElementMatcher)ElementMatchers.named((String)"launch$default")).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"kotlin.coroutines.CoroutineContext")));
    }

    public static class LaunchAdvice {
        @Advice.OnMethodEnter
        public static void enter(@Advice.Argument(value=1, readOnly=false) CoroutineContext coroutineContext) {
            ThreadContextElement txContextElement = ThreadContextElementKt.asContextElement((ThreadLocal)TransactionContext.getPrivateMetadataThreadLocal(), (Object)TransactionContext.getPrivateMetadata());
            coroutineContext = coroutineContext.plus((CoroutineContext)txContextElement);
        }
    }

    public static class RunBlockingAdvice {
        @Advice.OnMethodEnter
        public static void enter(@Advice.Argument(value=0, readOnly=false) CoroutineContext coroutineContext) {
            ThreadContextElement txContextElement = ThreadContextElementKt.asContextElement((ThreadLocal)TransactionContext.getPrivateMetadataThreadLocal(), (Object)TransactionContext.getPrivateMetadata());
            coroutineContext = coroutineContext.plus((CoroutineContext)txContextElement);
        }
    }

    public static class AsyncAdvice {
        @Advice.OnMethodEnter
        public static void enter(@Advice.Argument(value=1, readOnly=false) CoroutineContext coroutineContext) {
            ThreadContextElement txContextElement = ThreadContextElementKt.asContextElement((ThreadLocal)TransactionContext.getPrivateMetadataThreadLocal(), (Object)TransactionContext.getPrivateMetadata());
            coroutineContext = coroutineContext.plus((CoroutineContext)txContextElement);
        }
    }
}

