/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.multipreprocessor;

import java.util.Arrays;

public class PreprocessorOutcome {
    private int exitCode;
    private String preprocessorOutput;
    private String[] commandlineArgs;

    PreprocessorOutcome(int exitCode, String preprocessorOutput, String[] commandlineArgs) {
        this.exitCode = exitCode;
        this.preprocessorOutput = preprocessorOutput;
        this.commandlineArgs = commandlineArgs;
    }

    public static PreprocessorOutcomeBuilder builder() {
        return new PreprocessorOutcomeBuilder();
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getPreprocessorOutput() {
        return this.preprocessorOutput;
    }

    public String[] getCommandlineArgs() {
        return this.commandlineArgs;
    }

    public static class PreprocessorOutcomeBuilder {
        private int exitCode;
        private String preprocessorOutput;
        private String[] commandlineArgs;

        PreprocessorOutcomeBuilder() {
        }

        public PreprocessorOutcomeBuilder exitCode(int exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public PreprocessorOutcomeBuilder preprocessorOutput(String preprocessorOutput) {
            this.preprocessorOutput = preprocessorOutput;
            return this;
        }

        public PreprocessorOutcomeBuilder commandlineArgs(String[] commandlineArgs) {
            this.commandlineArgs = commandlineArgs;
            return this;
        }

        public PreprocessorOutcome build() {
            return new PreprocessorOutcome(this.exitCode, this.preprocessorOutput, this.commandlineArgs);
        }

        public String toString() {
            return "PreprocessorOutcome.PreprocessorOutcomeBuilder(exitCode=" + this.exitCode + ", preprocessorOutput=" + this.preprocessorOutput + ", commandlineArgs=" + Arrays.deepToString(this.commandlineArgs) + ")";
        }
    }
}

