/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.loaders.classfiles;

import java.io.File;
import java.util.Map;
import software.amazon.disco.instrumentation.preprocess.export.ExportStrategy;
import software.amazon.disco.instrumentation.preprocess.util.JarSigningVerificationOutcome;

public class SourceInfo {
    private final File sourceFile;
    private final ExportStrategy exportStrategy;
    private final Map<String, byte[]> classByteCodeMap;
    private final JarSigningVerificationOutcome jarSigningVerificationOutcome;

    public SourceInfo(File sourceFile, ExportStrategy exportStrategy, Map<String, byte[]> classByteCodeMap) {
        this.sourceFile = sourceFile;
        this.exportStrategy = exportStrategy;
        this.classByteCodeMap = classByteCodeMap;
        this.jarSigningVerificationOutcome = null;
    }

    public boolean isJarSigned() {
        return this.jarSigningVerificationOutcome != null && this.jarSigningVerificationOutcome.equals((Object)JarSigningVerificationOutcome.SIGNED);
    }

    public SourceInfo(File sourceFile, ExportStrategy exportStrategy, Map<String, byte[]> classByteCodeMap, JarSigningVerificationOutcome jarSigningVerificationOutcome) {
        this.sourceFile = sourceFile;
        this.exportStrategy = exportStrategy;
        this.classByteCodeMap = classByteCodeMap;
        this.jarSigningVerificationOutcome = jarSigningVerificationOutcome;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public ExportStrategy getExportStrategy() {
        return this.exportStrategy;
    }

    public Map<String, byte[]> getClassByteCodeMap() {
        return this.classByteCodeMap;
    }

    public JarSigningVerificationOutcome getJarSigningVerificationOutcome() {
        return this.jarSigningVerificationOutcome;
    }
}

